/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.ast;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ASNode {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public ASNode(Type type) {
        this.setLineOfCode(0);
        this.setType(type);
    }

    public final void setType(Type type) {
        this.properties.put("type", (Object)type);
    }

    public final Type getType() {
        return (Type)((Object)this.properties.get("type"));
    }

    public final void setLineOfCode(int line) {
        this.properties.put("line", line);
    }

    public final int getLineOfCode() {
        return (Integer)this.properties.get("line");
    }

    public final void setCode(String code) {
        this.properties.put("code", code);
    }

    public final String getCode() {
        return (String)this.properties.get("code");
    }

    public final void setNormalizedCode(String normal) {
        if (normal != null) {
            this.properties.put("normalized", normal);
        }
    }

    public final String getNormalizedCode() {
        String normalized = (String)this.properties.get("normalized");
        if (normalized != null && !normalized.isEmpty()) {
            return normalized;
        }
        return (String)this.properties.get("code");
    }

    public final void setProperty(String key, Object value) {
        this.properties.put(key.toLowerCase(), value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key.toLowerCase());
    }

    public Set<String> getAllProperties() {
        return this.properties.keySet();
    }

    public String toString() {
        String code = this.getCode();
        if (code == null || code.isEmpty()) {
            return this.getType().label;
        }
        if (this.getType().label.isEmpty()) {
            return this.getLineOfCode() + ":  " + code;
        }
        return this.getType().label + ": " + code;
    }

    public static enum Type {
        ROOT("ROOT"),
        IMPORTS("IMPORTS"),
        IMPORT("IMPORT"),
        PACKAGE("PACKAGE"),
        NAME("NAME"),
        MODIFIER("MODIFIER"),
        CLASS("CLASS"),
        EXTENDS("EXTENDS"),
        IMPLEMENTS("IMPLEMENTS"),
        INTERFACE("INTERFACE"),
        STATIC_BLOCK("STATIC-BLOCK"),
        CONSTRUCTOR("CONSTRUCTOR"),
        FIELD("FIELD"),
        TYPE("TYPE"),
        METHOD("METHOD"),
        RETURN("RETURN"),
        PARAMS("PARAMS"),
        BLOCK("BLOCK"),
        IF("IF"),
        CONDITION("COND"),
        THEN("THEN"),
        ELSE("ELSE"),
        VARIABLE("VAR"),
        INIT_VALUE("INIT"),
        STATEMENT(""),
        FOR("FOR"),
        FOR_INIT("INIT"),
        FOR_UPDATE("UPDATE"),
        FOR_EACH("FOR-EACH"),
        IN("IN"),
        WHILE("WHILE"),
        DO_WHILE("DO-WHILE"),
        TRY("TRY"),
        RESOURCES("RESOURCES"),
        CATCH("CATCH"),
        FINALLY("FINALLY"),
        SWITCH("SWITCH"),
        CASE("CASE"),
        DEFAULT("DEFAULT"),
        LABELED("LABELED"),
        SYNC("SYNCHRONIZED");

        public final String label;

        private Type(String lbl) {
            this.label = lbl;
        }

        public String toString() {
            return this.label;
        }
    }
}

