/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.antlrparser;

import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;

public class TreePrinter {
    public static final String Eol = System.lineSeparator();
    public static final String Indents = "  ";
    private static int level;

    public static String printSyntaxTree(Parser parser, ParseTree root) {
        StringBuilder buf = new StringBuilder();
        TreePrinter.recursive(root, buf, 0, Arrays.asList(parser.getRuleNames()));
        return buf.toString();
    }

    private static void recursive(ParseTree aRoot, StringBuilder buf, int offset, List<String> ruleNames) {
        for (int i = 0; i < offset; ++i) {
            buf.append(Indents);
        }
        buf.append(Trees.getNodeText((Tree)aRoot, ruleNames)).append("\n");
        if (aRoot instanceof ParserRuleContext) {
            ParserRuleContext prc = (ParserRuleContext)aRoot;
            if (prc.children != null) {
                for (ParseTree child : prc.children) {
                    TreePrinter.recursive(child, buf, offset + 1, ruleNames);
                }
            }
        }
    }

    public static String prettyPrint(Tree t, List<String> ruleNames) {
        level = 0;
        return TreePrinter.process(t, ruleNames).replaceAll("(?m)^\\s+$", "").replaceAll("\\r?\\n\\r?\\n", Eol);
    }

    private static String process(Tree t, List<String> ruleNames) {
        if (t.getChildCount() == 0) {
            return Utils.escapeWhitespace(Trees.getNodeText(t, ruleNames), false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TreePrinter.lead(level));
        ++level;
        String s = Utils.escapeWhitespace(Trees.getNodeText(t, ruleNames), false);
        sb.append(s + " ");
        for (int i = 0; i < t.getChildCount(); ++i) {
            sb.append(TreePrinter.process(t.getChild(i), ruleNames));
        }
        sb.append(TreePrinter.lead(--level));
        return sb.toString();
    }

    private static String lead(int level) {
        StringBuilder sb = new StringBuilder();
        if (level > 0) {
            sb.append(Eol);
            for (int cnt = 0; cnt < level; ++cnt) {
                sb.append(Indents);
            }
        }
        return sb.toString();
    }
}

