"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStreamsToKinesisFirehoseToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kdfToS3 = require("@aws-solutions-constructs/aws-kinesisfirehose-s3");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("@aws-cdk/aws-iam");
const core_2 = require("@aws-solutions-constructs/core");
class KinesisStreamsToKinesisFirehoseToS3 extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the KinesisStreamsToKinesisFirehoseToS3 class.
     * @since 1.68.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if (props.existingBucketObj && props.bucketProps) {
            throw new Error('Cannot specify both bucket properties and an existing bucket');
        }
        // Setup the Kinesis Stream
        this.kinesisStream = defaults.buildKinesisStream(this, {
            existingStreamObj: props.existingStreamObj,
            kinesisStreamProps: props.kinesisStreamProps
        });
        this.kinesisStreamRole = new iam.Role(scope, 'KinesisStreamsRole', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
            inlinePolicies: {
                KinesisStreamsRoleRolePolicy: new iam.PolicyDocument({
                    statements: [new iam.PolicyStatement({
                            actions: [
                                "kinesis:DescribeStream",
                                "kinesis:GetShardIterator",
                                "kinesis:GetRecords",
                                "kinesis:ListShards"
                            ],
                            resources: [this.kinesisStream.streamArn]
                        })]
                })
            }
        });
        // This Construct requires that the deliveryStreamType be overriden regardless of what is specified in the user props
        if (props.kinesisFirehoseProps) {
            if (props.kinesisFirehoseProps.deliveryStreamType !== undefined) {
                defaults.printWarning('Overriding deliveryStreamType type to be KinesisStreamAsSource');
            }
            if (props.kinesisFirehoseProps.kinesisStreamSourceConfiguration !== undefined) {
                defaults.printWarning('Overriding kinesisStreamSourceConfiguration');
            }
        }
        const _kinesisFirehoseProps = {
            deliveryStreamType: 'KinesisStreamAsSource',
            kinesisStreamSourceConfiguration: {
                kinesisStreamArn: this.kinesisStream.streamArn,
                roleArn: this.kinesisStreamRole.roleArn
            }
        };
        const kdfToS3Construct = new kdfToS3.KinesisFirehoseToS3(this, 'KinesisFirehoseToS3', {
            kinesisFirehoseProps: core_2.overrideProps(props.kinesisFirehoseProps, _kinesisFirehoseProps),
            existingBucketObj: props.existingBucketObj,
            existingLoggingBucketObj: props.existingLoggingBucketObj,
            bucketProps: props.bucketProps,
            logGroupProps: props.logGroupProps
        });
        this.kinesisFirehose = kdfToS3Construct.kinesisFirehose;
        this.kinesisFirehoseRole = kdfToS3Construct.kinesisFirehoseRole;
        this.kinesisFirehoseLogGroup = kdfToS3Construct.kinesisFirehoseLogGroup;
        this.s3Bucket = kdfToS3Construct.s3Bucket;
        this.s3LoggingBucket = kdfToS3Construct.s3LoggingBucket;
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for Kinesis Stream
            this.cloudwatchAlarms = defaults.buildKinesisStreamCWAlarms(this);
        }
    }
}
exports.KinesisStreamsToKinesisFirehoseToS3 = KinesisStreamsToKinesisFirehoseToS3;
_a = JSII_RTTI_SYMBOL_1;
KinesisStreamsToKinesisFirehoseToS3[_a] = { fqn: "@aws-solutions-constructs/aws-kinesisstreams-kinesisfirehose-s3.KinesisStreamsToKinesisFirehoseToS3", version: "1.103.0" };
//# sourceMappingURL=data:application/json;base64,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