# Documentation

This directory contains all documentation for AceFlow MCP Server.

## Directory Structure

### `user-guide/`
Documentation for end users:
- `QUICK_START_GUIDE.md` - 5-minute quick start guide
- `TOOL_USAGE_GUIDE.md` - Comprehensive tool usage documentation

### `developer-guide/`
Documentation for developers and contributors:
- `PROMPT_BEST_PRACTICES.md` - Best practices for designing tool prompts
- `TOOL_PROMPTS_REVIEW.md` - Detailed review of tool prompt design

### `project/`
Project-related documentation:
- `COMPLETION_REPORT.md` - Project completion report
- `PYPI_PUBLISH_GUIDE.md` - Guide for publishing to PyPI

## Quick Navigation

### For Users
- New to AceFlow? Start with the [Quick Start Guide](user-guide/QUICK_START_GUIDE.md)
- Need detailed tool information? See the [Tool Usage Guide](user-guide/TOOL_USAGE_GUIDE.md)

### For Developers
- Contributing to the project? Read the [Prompt Best Practices](developer-guide/PROMPT_BEST_PRACTICES.md)
- Understanding the design? Check the [Tool Prompts Review](developer-guide/TOOL_PROMPTS_REVIEW.md)

### For Maintainers
- Project status? See the [Completion Report](project/COMPLETION_REPORT.md)
- Publishing updates? Follow the [PyPI Publish Guide](project/PYPI_PUBLISH_GUIDE.md)

## Contributing to Documentation

When adding new documentation:
1. Place user-facing docs in `user-guide/`
2. Place technical/developer docs in `developer-guide/`
3. Place project management docs in `project/`
4. Update this README with links to new documents
5. Follow the existing markdown style and formatting