# Generated by Django 3.0.2 on 2020-02-03 07:11

from decimal import Decimal
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import salesman.core.models
import salesman.orders.models
import secrets


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ref', models.SlugField(help_text='A unique order reference.', max_length=128, unique=True, verbose_name='Reference')),
                ('status', models.CharField(default='NEW', help_text='Changing order status might trigger a notification to customer.', max_length=128, verbose_name='Status')),
                ('token', models.CharField(default=secrets.token_urlsafe, help_text="Allow non-authenticated customer to access the order with token. To access order suply a '?token={token}' in url querystring.", max_length=128, unique=True, verbose_name='Token')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='Email')),
                ('shipping_address', models.TextField(blank=True, verbose_name='Shipping address')),
                ('billing_address', models.TextField(blank=True, verbose_name='Billing address')),
                ('subtotal', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=18, verbose_name='Subtotal')),
                ('total', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=18, verbose_name='Total')),
                ('_extra', salesman.core.models.JSONField(blank=True, default={}, verbose_name='Extra')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date updated')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Order',
                'verbose_name_plural': 'Orders',
                'ordering': ['-date_created'],
            },
        ),
        migrations.CreateModel(
            name='OrderNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField(verbose_name='Message')),
                ('public', models.BooleanField(default=False, help_text='Is accessible to the customer?', verbose_name='Public')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('order', salesman.orders.models.ParentalForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notes', to='salesmanorders.Order', verbose_name='Order')),
            ],
            options={
                'verbose_name': 'Note',
                'verbose_name_plural': 'Notes',
            },
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_type', models.CharField(max_length=128, verbose_name='Product type')),
                ('product_id', models.PositiveIntegerField(null=True, verbose_name='Product id')),
                ('product_data', salesman.core.models.JSONField(blank=True, default={}, verbose_name='Product data')),
                ('unit_price', models.DecimalField(decimal_places=2, max_digits=18, verbose_name='Unit price')),
                ('subtotal', models.DecimalField(decimal_places=2, max_digits=18, verbose_name='Subtotal')),
                ('total', models.DecimalField(decimal_places=2, max_digits=18, verbose_name='Total')),
                ('quantity', models.PositiveIntegerField(verbose_name='Quantity')),
                ('_extra', salesman.core.models.JSONField(blank=True, default={}, verbose_name='Extra')),
                ('order', salesman.orders.models.ParentalForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='salesmanorders.Order', verbose_name='Order')),
                ('product_content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'Item',
                'verbose_name_plural': 'Items',
            },
        ),
        migrations.CreateModel(
            name='OrderPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=18, verbose_name='Amount')),
                ('transaction_id', models.CharField(max_length=128, verbose_name='Transaction ID')),
                ('payment_method', models.CharField(blank=True, max_length=128, verbose_name='Payment method')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('order', salesman.orders.models.ParentalForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payments', to='salesmanorders.Order', verbose_name='Order')),
            ],
            options={
                'verbose_name': 'Payment',
                'verbose_name_plural': 'Payments',
                'unique_together': {('order', 'transaction_id')},
            },
        ),
    ]
