#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.resources',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20210420',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Resource management classes and functions.',
  long_description =
    ('Resource management classes and functions.\n'    
 '\n'    
 '*Latest release 20210420*:\n'    
 'MultiOpenMixin: run startup/shutdown entirely via the new default method '    
 '@contextmanager(startup_shutdown), paving the way for subclasses to just '    
 'define their own startup_shutdown context manager methods instead of '    
 'distinct startup/shutdown methods.\n'    
 '\n'    
 '## Class `ClosedError(builtins.Exception,builtins.BaseException)`\n'    
 '\n'    
 'Exception for operations invalid when something is closed.\n'    
 '\n'    
 '## Class `MultiOpen(MultiOpenMixin)`\n'    
 '\n'    
 'Context manager class that manages a single open/close object\n'    
 'using a MultiOpenMixin.\n'    
 '\n'    
 '### Method `MultiOpen.__init__(self, openable, finalise_later=False)`\n'    
 '\n'    
 'Initialise: save the `openable` and call the MultiOpenMixin initialiser.\n'    
 '\n'    
 '### Method `MultiOpen.shutdown(self)`\n'    
 '\n'    
 'Close the associated openable object.\n'    
 '\n'    
 '### Method `MultiOpen.startup(self)`\n'    
 '\n'    
 'Open the associated openable object.\n'    
 '\n'    
 '## Class `MultiOpenMixin`\n'    
 '\n'    
 'A multithread safe mixin to count open and close calls,\n'    
 'and to call `.startup` on the first `.open`\n'    
 'and to call `.shutdown` on the last `.close`.\n'    
 '\n'    
 'If used as a context manager this mixin calls `open()`/`close()` from\n'    
 '`__enter__()` and `__exit__()`.\n'    
 '\n'    
 'Recommended subclass implementations do as little as possible\n'    
 'during `__init__`, and do almost all setup during startup so\n'    
 'that the class may perform multiple startup/shutdown iterations.\n'    
 '\n'    
 'Classes using this mixin need to _either_:\n'    
 '* _either_ define a context manager method `.startup_shutdown`\n'    
 '  which does the startup actions before yeilding\n'    
 '  and then does the shutdown actions\n'    
 '* _or_ define separate `.startup` and `.shutdown` methods.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    class DatabaseThing(MultiOpenMixin):\n'    
 '        @contextmanager\n'    
 '        def startup_shutdown(self):\n'    
 '            self._db = open_the_database()\n'    
 '            yield\n'    
 '            self._db.close()\n'    
 '    ...\n'    
 '    with DatabaseThing(...) as db_thing:\n'    
 '        ... use db_thing ...\n'    
 '\n'    
 'Why not a plain context manager? Because in multithreaded\n'    
 'code one wants to keep the instance "open" while any thread\n'    
 'is still using it.\n'    
 'This mixin lets threads use an instance in overlapping fashion:\n'    
 '\n'    
 '    db_thing = DatabaseThing(...)\n'    
 '    with db_thing:\n'    
 '        ... kick off threads with access to the db ...\n'    
 '    ...\n'    
 '    thread 1:\n'    
 '    with db_thing:\n'    
 '       ... use db_thing ...\n'    
 '    thread 2:\n'    
 '    with db_thing:\n'    
 '       ... use db_thing ...\n'    
 '\n'    
 'TODO:\n'    
 '* `subopens`: if true (default false) then `.open` will return\n'    
 '  a proxy object with its own `.closed` attribute set by the\n'    
 "  proxy's `.close`.\n"    
 '\n'    
 '### Method `MultiOpenMixin.close(self, enforce_final_close=False, '    
 'caller_frame=None, unopened_ok=False)`\n'    
 '\n'    
 'Decrement the open count.\n'    
 'If the count goes to zero, call `self.shutdown()` and return its value.\n'    
 '\n'    
 'Parameters:\n'    
 '* `enforce_final_close`: if true, the caller expects this to\n'    
 '  be the final close for the object and a `RuntimeError` is\n'    
 '  raised if this is not actually the case.\n'    
 '* `caller_frame`: used for debugging; the caller may specify\n'    
 '  this if necessary, otherwise it is computed from\n'    
 '  `cs.py.stack.caller` when needed. Presently the caller of the\n'    
 '  final close is recorded to help debugging extra close calls.\n'    
 '* `unopened_ok`: if true, it is not an error if this is not open.\n'    
 '  This is intended for closing callbacks which might get called\n'    
 '  even if the original open never happened.\n'    
 "  (I'm looking at you, `cs.resources.RunState`.)\n"    
 '\n'    
 '### Property `MultiOpenMixin.closed`\n'    
 '\n'    
 'Whether this object has been closed.\n'    
 'Note: False if never opened.\n'    
 '\n'    
 '### Method `MultiOpenMixin.finalise(self)`\n'    
 '\n'    
 'Finalise the object, releasing all callers of `.join()`.\n'    
 'Normally this is called automatically after `.shutdown` unless\n'    
 '`finalise_later` was set to true during initialisation.\n'    
 '\n'    
 '### Method `MultiOpenMixin.is_opened(func)`\n'    
 '\n'    
 'Decorator to wrap `MultiOpenMixin` proxy object methods which\n'    
 'should raise if the object is not yet open.\n'    
 '\n'    
 '### Method `MultiOpenMixin.join(self)`\n'    
 '\n'    
 'Join this object.\n'    
 '\n'    
 'Wait for the internal _finalise `Condition` (if still not `None`).\n'    
 'Normally this is notified at the end of the shutdown procedure\n'    
 "unless the object's `finalise_later` parameter was true.\n"    
 '\n'    
 '### Method `MultiOpenMixin.open(self, caller_frame=None)`\n'    
 '\n'    
 'Increment the open count.\n'    
 'On the first `.open` call `self.startup()`.\n'    
 '\n'    
 '### Method `MultiOpenMixin.startup_shutdown(self)`\n'    
 '\n'    
 'Default context manager form of startup/shutdown - just calls them.\n'    
 '\n'    
 '### Method `MultiOpenMixin.tcm_get_state(self)`\n'    
 '\n'    
 'Support method for `TrackedClassMixin`.\n'    
 '\n'    
 '## Function `not_closed(func)`\n'    
 '\n'    
 'Decorator to wrap methods of objects with a .closed property\n'    
 'which should raise when self.closed.\n'    
 '\n'    
 '## Class `Pool`\n'    
 '\n'    
 'A generic pool of objects on the premise that reuse is cheaper than '    
 'recreation.\n'    
 '\n'    
 'All the pool objects must be suitable for use, so the\n'    
 '`new_object` callable will typically be a closure.\n'    
 'For example, here is the __init__ for a per-thread AWS Bucket using a\n'    
 'distinct Session:\n'    
 '\n'    
 '    def __init__(self, bucket_name):\n'    
 '        Pool.__init__(self, lambda: '    
 "boto3.session.Session().resource('s3').Bucket(bucket_name)\n"    
 '\n'    
 '### Method `Pool.__init__(self, new_object, max_size=None, lock=None)`\n'    
 '\n'    
 'Initialise the Pool with creator `new_object` and maximum size `max_size`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `new_object` is a callable which returns a new object for the Pool.\n'    
 '* `max_size`: The maximum size of the pool of available objects saved for '    
 'reuse.\n'    
 '    If omitted or `None`, defaults to 4.\n'    
 '    If 0, no upper limit is applied.\n'    
 '* `lock`: optional shared Lock; if omitted or `None` a new Lock is '    
 'allocated\n'    
 '\n'    
 '### Method `Pool.instance(self)`\n'    
 '\n'    
 'Context manager returning an object for use, which is returned to the pool '    
 'afterwards.\n'    
 '\n'    
 '## Class `RunState`\n'    
 '\n'    
 'A class to track a running task whose cancellation may be requested.\n'    
 '\n'    
 'Its purpose is twofold, to provide easily queriable state\n'    
 'around tasks which can start and stop, and to provide control\n'    
 'methods to pronounce that a task has started (`.start`),\n'    
 'should stop (`.cancel`)\n'    
 'and has stopped (`.stop`).\n'    
 '\n'    
 'A `RunState` can be used as a context manager, with the enter\n'    
 'and exit methods calling `.start` and `.stop` respectively.\n'    
 'Note that if the suite raises an exception\n'    
 'then the exit method also calls `.cancel` before the call to `.stop`.\n'    
 '\n'    
 'Monitor or daemon processes can poll the `RunState` to see when\n'    
 'they should terminate, and may also manage the overall state\n'    
 'easily using a context manager.\n'    
 'Example:\n'    
 '\n'    
 '    def monitor(self):\n'    
 '        with self.runstate:\n'    
 '            while not self.runstate.cancelled:\n'    
 '                ... main loop body here ...\n'    
 '\n'    
 'A `RunState` has three main methods:\n'    
 '* `.start()`: set `.running` and clear `.cancelled`\n'    
 '* `.cancel()`: set `.cancelled`\n'    
 '* `.stop()`: clear `.running`\n'    
 '\n'    
 'A `RunState` has the following properties:\n'    
 '* `cancelled`: true if `.cancel` has been called.\n'    
 '* `running`: true if the task is running.\n'    
 '  Further, assigning a true value to it also sets `.start_time` to now.\n'    
 '  Assigning a false value to it also sets `.stop_time` to now.\n'    
 '* `start_time`: the time `.running` was last set to true.\n'    
 '* `stop_time`: the time `.running` was last set to false.\n'    
 '* `run_time`: `max(0,.stop_time-.start_time)`\n'    
 '* `stopped`: true if the task is not running.\n'    
 '* `stopping`: true if the task is running but has been cancelled.\n'    
 '* `notify_start`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.running` becomes true.\n'    
 '* `notify_end`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.running` becomes false.\n'    
 '* `notify_cancel`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.cancel` is called.\n'    
 '\n'    
 '### Method `RunState.__bool__(self)`\n'    
 '\n'    
 'Return true if the task is running.\n'    
 '\n'    
 '### Method `RunState.__nonzero__(self)`\n'    
 '\n'    
 'Return true if the task is running.\n'    
 '\n'    
 '### Method `RunState.cancel(self)`\n'    
 '\n'    
 'Set the cancelled flag; the associated process should notice and stop.\n'    
 '\n'    
 '### Method `RunState.end(self)`\n'    
 '\n'    
 'Stop: adjust state, set `stop_time` to now.\n'    
 'Sets sets `.running` to `False`.\n'    
 '\n'    
 '### Property `RunState.run_time`\n'    
 '\n'    
 'Property returning most recent run time (`stop_time-start_time`).\n'    
 'If still running, use now as the stop time.\n'    
 'If not started, return `0.0`.\n'    
 '\n'    
 '### Property `RunState.running`\n'    
 '\n'    
 'Property expressing whether the task is running.\n'    
 '\n'    
 '### Method `RunState.start(self)`\n'    
 '\n'    
 'Start: adjust state, set `start_time` to now.\n'    
 'Sets `.cancelled` to `False` and sets `.running` to `True`.\n'    
 '\n'    
 '### Method `RunState.stop(self)`\n'    
 '\n'    
 'Stop: adjust state, set `stop_time` to now.\n'    
 'Sets sets `.running` to `False`.\n'    
 '\n'    
 '### Property `RunState.stopped`\n'    
 '\n'    
 'Was the process stopped? Running is false and cancelled is true.\n'    
 '\n'    
 '### Property `RunState.stopping`\n'    
 '\n'    
 'Is the process stopping? Running is true and cancelled is true.\n'    
 '\n'    
 '## Class `RunStateMixin`\n'    
 '\n'    
 'Mixin to provide convenient access to a `RunState`.\n'    
 '\n'    
 'Provides: `.runstate`, `.cancelled`, `.running`, `.stopping`, `.stopped`.\n'    
 '\n'    
 '### Method `RunStateMixin.__init__(self, runstate=None)`\n'    
 '\n'    
 'Initialise the `RunStateMixin`; sets the `.runstate` attribute.\n'    
 '\n'    
 'Parameters:\n'    
 '* `runstate`: optional `RunState` instance or name.\n'    
 '  If a `str`, a new `RunState` with that name is allocated.\n'    
 '\n'    
 '### Method `RunStateMixin.cancel(self)`\n'    
 '\n'    
 'Call .runstate.cancel().\n'    
 '\n'    
 '### Property `RunStateMixin.cancelled`\n'    
 '\n'    
 'Test .runstate.cancelled.\n'    
 '\n'    
 '### Property `RunStateMixin.running`\n'    
 '\n'    
 'Test .runstate.running.\n'    
 '\n'    
 '### Property `RunStateMixin.stopped`\n'    
 '\n'    
 'Test .runstate.stopped.\n'    
 '\n'    
 '### Property `RunStateMixin.stopping`\n'    
 '\n'    
 'Test .runstate.stopping.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20210420*:\n'    
 'MultiOpenMixin: run startup/shutdown entirely via the new default method '    
 '@contextmanager(startup_shutdown), paving the way for subclasses to just '    
 'define their own startup_shutdown context manager methods instead of '    
 'distinct startup/shutdown methods.\n'    
 '\n'    
 '*Release 20201025*:\n'    
 'MultiOpenMixin.__mo_getstate: dereference self.__dict__ because using '    
 'AttributeError was pulling a state object from another instance, utterly '    
 'weird.\n'    
 '\n'    
 '*Release 20200718*:\n'    
 'MultiOpenMixin: as a hack to avoid having an __init__, move state into an on '    
 'demand object accesses by a private method.\n'    
 '\n'    
 '*Release 20200521*:\n'    
 'Sweeping removal of cs.obj.O, universally supplanted by '    
 'types.SimpleNamespace.\n'    
 '\n'    
 '*Release 20190812*:\n'    
 '* MultiOpenMixin: no longer subclass cs.obj.O.\n'    
 '* MultiOpenMixin: remove `lock` param support, the mixin has its own lock.\n'    
 '* MultiOpen: drop `lock` param support, no longer used by MultiOpenMixin.\n'    
 '* MultiOpenMixin: do finalise inside the lock for the same reason as '    
 'shutdown (competition with open/startup).\n'    
 '* MultiOpenMixin.close: new `unopened_ok=False` parameter intended for '    
 'callback closes which might fire even if the initial open does not occur.\n'    
 '\n'    
 '*Release 20190617*:\n'    
 'RunState.__exit__: if an exception was raised call .canel() before calling '    
 '.stop().\n'    
 '\n'    
 '*Release 20190103*:\n'    
 '* Bugfixes for context managers.\n'    
 '* MultiOpenMixin fixes and changes.\n'    
 '* RunState improvements.\n'    
 '\n'    
 '*Release 20171024*:\n'    
 '* bugfix MultiOpenMixin finalise logic and other small logic fixes and '    
 'checs\n'    
 '* new class RunState for tracking or controlling a running task\n'    
 '\n'    
 '*Release 20160828*:\n'    
 'Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '\n'    
 '*Release 20160827*:\n'    
 '* BREAKING CHANGE: rename NestingOpenCloseMixin to MultiOpenMixin.\n'    
 '* New Pool class for generic object reuse.\n'    
 '* Assorted minor improvements.\n'    
 '\n'    
 '*Release 20150115*:\n'    
 'First PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.context', 'cs.logutils', 'cs.obj', 'cs.py.func', 'cs.py.stack'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.resources'],
)
