from ._version import __version__
import re
from .cedarscript_editor import CEDARScriptEditor
from text_manipulation import IndentationInfo, IdentifierBoundaries, RangeSpec, read_file, write_file, bow_to_search_range

__all__ = [
    "__version__", "find_commands", "CEDARScriptEditor", "IndentationInfo", "IdentifierBoundaries", "RangeSpec",
    "read_file", "write_file", "bow_to_search_range"
]

def find_commands(content: str):
    # Regex pattern to match CEDARScript blocks
    pattern = r'```CEDARScript\n(.*?)```'
    cedar_script_blocks = re.findall(pattern, content, re.DOTALL)
    print(f'[find_cedar_commands] Script block count: {len(cedar_script_blocks)}')
    if len(cedar_script_blocks) == 0:
        raise ValueError(
            "No CEDARScript block detected. "
            "Perhaps you forgot to enclose the block using ```CEDARScript and ``` ? "
            "Or was that intentional? If so, just write tag <NOSCRIPT/> and nothing else."
        )
    cedarscript_parser = CEDARScriptASTParser()
    for cedar_script in cedar_script_blocks:
        parsed_commands, parse_errors = cedarscript_parser.parse_script(cedar_script)
        if parse_errors:
            raise ValueError(f"CEDARScript parsing errors: {[str(pe) for pe in parse_errors]}")
        for cedar_command in parsed_commands:
            yield cedar_command
