def getCodeFor(string):
    codes = ['dfs','bfs','dijkstra','bellmanFord',
             'knapsackTabulation','knapsackSet','travellingSalesman','availableCodes', 'inlineString', 'numInputs']
    n = len(string)
    scores = [0]*len(codes)
    for i in range(len(codes)):
        scores[i] = lcs(string, codes[i], n, len(codes[i]))
        if scores[i] == len(codes[i]):
            scores[i] = n
    idx = scores.index(max(scores))
    funcs = [dfs, bfs, dijkstra, bellmanFord, 
         knapsackTabulation, knapsackSet, travellingSalesman, availableCodes, inlineString, numInputs]
    funcs[idx]()
    
def availableCodes():
    codes = ['dfs','bfs','dijkstra','bellmanFord',
             'knapsackTabulation','knapsackSet','travellingSalesman','inlineString', 'numInputs']
    print(*codes)

def inlineString():
    print('import sys ')
    print('from io import StringIO')
    print("sys.stdin = StringIO('''''')")
    print('input = sys.stdin.readline')
    print('')
    print('t = int(input())')
    print('for idx in range(t):')
    print('    n, m = map(int, input().split())')
    print('    l = list(map(int, input().split()))')
    
def numInputs():
    print('t = int(input())')
    print('for idx in range(t):')
    print('    n, m = map(int, input().split())')
    print('    l = list(map(int, input().split()))')   

def lcs(X, Y, m, n):
 
    if m == 0 or n == 0:
        return 0
    elif X[m-1] == Y[n-1]:
        return 1 + lcs(X, Y, m-1, n-1)
    else:
        return max(lcs(X, Y, m, n-1), lcs(X, Y, m-1, n))

def dfs():
    print('# '*10)
    print('# Code for DFS')
    print('from collections import defaultdict')
    print('  ')
    print('class Graph:')
    print('  ')
    print('    def __init__(self):')
    print('        self.graph = defaultdict(list)')
    print('')
    print('    def newEdge(self, u, v):')
    print('        self.graph[u].append(v)')
    print('  ')
    print('    def DFSUtil(self, v, visited):')
    print('')
    print('        visited.add(v)')
    print('        print(v, end=' ')')
    print('')
    print('        for neighbour in self.graph[v]:')
    print('            if neighbour not in visited:')
    print('                self.DFSUtil(neighbour, visited)')
    print('')
    print('    def DFS(self, v):')
    print('          visited = set()')
    print('')
    print('        self.DFSUtil(v, visited)')
    print('# '*10)
    print('# Driver code')
    print('')
    print('g = Graph()')
    print('g.newEdge(0, 1)')
    print('g.newEdge(0, 2)')
    print('g.newEdge(1, 2)')
    print('g.newEdge(2, 0)')
    print('g.newEdge(2, 3)')
    print('g.newEdge(3, 3)')
    print('  ')
    print('print("Following is DFS from (starting from vertex 2)")')
    print('g.DFS(2)')

def bfs():
    print('# '*10)
    print('# CODE for BFS')
    print('from collections import defaultdict')
    print(' ')
    print('class Graph:')
    print(' ')
    print('    def __init__(self):')
    print(' ')
    print('        self.graph = defaultdict(list)')
    print(' ')
    print('    def newEdge(self,u,v):')
    print('        self.graph[u].append(v)')
    print(' ')
    print('    def BFS(self, s):')
    print(' ')
    print('        visited = [False] * (max(self.graph) + 1)')
    print('        queue = []')
    print(' ')
    print('        queue.append(s)')
    print('        visited[s] = True')
    print(' ')
    print('        while queue:')
    print('')
    print('            s = queue.pop(0)')
    print('            print (s, end = " ")')
    print('')
    print('            for i in self.graph[s]:')
    print('                if visited[i] == False:')
    print('                    queue.append(i)')
    print('                    visited[i] = True')
    print('')
    print('# '*10)
    print('# Create a graph given in')
    print('# the above diagram')
    print('g = Graph()')
    print('g.newEdge(0, 1)')
    print('g.newEdge(0, 2)')
    print('g.newEdge(1, 2)')
    print('g.newEdge(2, 0)')
    print('g.newEdge(2, 3)')
    print('g.newEdge(3, 3)')
    print(' ')
    
    print('g.BFS(2)')
    

def dijkstra():
    print('# '*10)
    print("# CODE for Dijkstra's")
    print("maxint = float('inf')")
    print(' ')
    print('class Graph():')
    print(' ')
    print('    def __init__(self, vertices):')
    print('        self.V = vertices')
    print('        self.graph = [[0 for column in range(vertices)]')
    print('                    for row in range(vertices)]')
    print(' ')
    print('    def printSolution(self, dist):')
    print('        print("Vertex \tDistance from Source")')
    print('        for node in range(self.V):')
    print('            print(node, "\t", dist[node])')
    print(' ')
    print('')
    print('    def minDistance(self, dist, sptSet):')
    print('')
    print('        min = maxint')
    print('')
    print('        for v in range(self.V):')
    print('            if dist[v] < min and sptSet[v] == False:')
    print('                min = dist[v]')
    print('                min_index = v')
    print(' ')
    print('        return min_index')
    print('')
    print('    def dijkstra(self, src):')
    print(' ')
    print('        dist = [maxint] * self.V')
    print('        dist[src] = 0')
    print('        sptSet = [False] * self.V')
    print(' ')
    print('        for cout in range(self.V):')
    print(' ')
    print('            u = self.minDistance(dist, sptSet)')
    print('')
    print('            sptSet[u] = True')
    print('')
    print('            for v in range(self.V):')
    print('                if self.graph[u][v] > 0 and sptSet[v] == False and \ ')
    print('                dist[v] > dist[u] + self.graph[u][v]:')
    print('                        dist[v] = dist[u] + self.graph[u][v]')
    print(' ')
    print('        self.printSolution(dist)')
    print('# '*10)
    print('# Driver program')
    print('g = Graph(9)')
    print('g.graph = [[0, 4, 0, 0, 0, 0, 0, 8, 0],')
    print('        [4, 0, 8, 0, 0, 0, 0, 11, 0],')
    print('        [0, 8, 0, 7, 0, 4, 0, 0, 2],')
    print('        [0, 0, 7, 0, 9, 14, 0, 0, 0],')
    print('        [0, 0, 0, 9, 0, 10, 0, 0, 0],')
    print('        [0, 0, 4, 14, 10, 0, 2, 0, 0],')
    print('        [0, 0, 0, 0, 0, 2, 0, 1, 6],')
    print('        [8, 11, 0, 0, 0, 0, 1, 0, 7],')
    print('        [0, 0, 2, 0, 0, 0, 6, 7, 0]')
    print('        ]')
    print(' ')
    
    print('g.dijkstra(0)')


def bellmanFord():
    print('# '*10)
    print('# CODE for Bellman Ford')
    print('class graph:')
    print('    ')
    print('    def __init__(self, v):')
    print('        self.V = v')
    print('        self.edges = []')
    print('        ')
    print('    def newEdge(self, u, v, w):')
    print('        self.edges.append((u, v, w))')
    print('        ')
    print('    def travelling(self, src):')
    print('')
    print('        dist = [999]*self.V')
    print('        ')
    print('        dist[src] = 0')
    print('        ')
    print('        for i in range(self.V - 1):')
    print('            for u, v, w in self.edges:')
    print('                if dist[v] > dist[u] + w:')
    print('                    dist[v] = dist[u] + w')
    print('        print(dist)')
    print('        ')
    print('# '*10)
    print('g = graph(6)')
    print('g.newEdge(0, 1,  5)')
    print('g.newEdge(0, 3, 18)')
    print('g.newEdge(1, 2,  7)')
    print('g.newEdge(2, 3,  2)')
    print('g.newEdge(2, 4, 15)')
    print('g.newEdge(3, 4,  1)')
    print('g.newEdge(4, 5,  3)')
    print('')
    
    print('g.travelling(0)')

def knapsackTabulation():
    print('# '*10)
    print('# CODE for Knapsack Tabulation Method')
    print('def knapSack(W, wt, val, n):')
    print('    K = [[0 for x in range(W + 1)] for x in range(n + 1)]')
    print(' ')
    print('    # Build table K[][] in bottom up manner')
    print('    for i in range(n + 1):')
    print('        for w in range(W + 1):')
    print('            if i == 0 or w == 0:')
    print('                K[i][w] = 0')
    print('            elif wt[i-1] <= w:')
    print('                K[i][w] = max(val[i-1]')
    print('                          + K[i-1][w-wt[i-1]], ')
    print('                              K[i-1][w])')
    print('            else:')
    print('                K[i][w] = K[i-1][w]')
    print(' ')
    print('    return K[n][W]')
    print(' ')
    print('# '*10)
    print('# Driver code')
    print('val = [60, 100, 120]')
    print('wt = [10, 20, 30]')
    print('W = 50')
    print('n = len(val)')
    
    print('print(knapSack(W, wt, val, n))')
    

def knapsackSet():
    print('# '*10)
    print('# CODE for Knapsack Set Method')
    print('n = 7')
    print('p = [10, 5, 15, 7, 6, 18, 3]')
    print('w = [2,  3,  5, 7, 1,  4, 1]')
    print('')
    print('cap = 15')
    print('')
    print('bag = {(0, 0)}')
    print('d = {i:0 for i in range(1, cap + 1)}')
    print('')
    print('# def check(d, p, w):')
    print('#     return False')
    print('prevP = 0')
    print('prevW = 0')
    print('for i in range(n):')
    print('    newS = set()')
    print('    newW = w[i]')
    print('    newP = p[i]')
    print('    for p1, w1  in bag:')
    print('        ')
    print('        tup = (p1 + newP, w1 + newW)')
    print('        if w1 + newW > cap:')
    print('            continue')
    print('#         if i > 0 and prevP >= p1 and prevW <= w1:')
    print('#             continue')
    print('        if d[tup[1]] < tup[0]:    ')
    print('            d[tup[1]] = tup[0]')
    print('            newS.add((tup))')
    print('            prevP = tup[0]')
    print('            prevW = tup[1]')
    print('#         print(newS)')
    print('')
    print('    bag.update(newS)')
    print('print(bag)')
    print('# '*10)

def travellingSalesman():
    print('# '*10)
    print('# CODE for Travelling Salesman')
    print('graph = [[0, 10, 15, 20],')
    print('         [5,  0,  9, 10],')
    print('         [6, 13,  0, 12],')
    print('         [8,  8,  9, 0]]')
    print('src = 0')
    print('def g(rem, idx):')
    print('    total = []')
    print('    if len(rem) == 1:')
    print('        return graph[idx][rem[0]] + graph[rem[0]][src]')
    print('    for i in range(len(rem)):')
    print('        new = rem[i]')
    print('        ')
    print('        total += [graph[idx][rem[i]] + g(rem[:i] + rem[i+1:], new)]')
    print('        # print(idx, i, total[-1], rem[:i] + rem[i+1:], rem)')
    print('    return min(total)')
    print('')
    print('g([1, 2, 3], 0')
    print('# '*10)