"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EntrypointStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const entrypoint_1 = require("../constructs/entrypoint");
const monitoring_facade_1 = require("../constructs/monitoring/monitoring-facade");
/**
 * The EntrypointStack creates an [Entrypoint](#@condensetech/cdk-constructs.Entrypoint) construct and optionally defines the monitoring configuration.
 * It implements the IEntrypoint interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
class EntrypointStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.construct = new entrypoint_1.Entrypoint(this, 'Entrypoint', props);
        if (props.monitoring) {
            new monitoring_facade_1.MonitoringFacade(this, props.monitoring);
        }
    }
    allocateListenerRule(scope, id, props) {
        return this.construct.allocateListenerRule(scope, id, props);
    }
    get alb() {
        return this.construct.alb;
    }
    get domainName() {
        return this.construct.domainName;
    }
    get priorityAllocator() {
        return this.construct.priorityAllocator;
    }
    referenceListener(scope, id) {
        return this.construct.referenceListener(scope, id);
    }
}
exports.EntrypointStack = EntrypointStack;
_a = JSII_RTTI_SYMBOL_1;
EntrypointStack[_a] = { fqn: "@condensetech/cdk-constructs.EntrypointStack", version: "0.5.2" };
//# sourceMappingURL=data:application/json;base64,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