"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstanceStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("../constructs");
const monitoring_facade_1 = require("../constructs/monitoring/monitoring-facade");
/**
 * The DatabaseInstanceStack creates a [DatabaseInstance](#@condensetech/cdk-constructs.DatabaseInstance) construct and optionally defines the monitoring configuration.
 * It implements the IDatabase interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
class DatabaseInstanceStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.resource = new constructs_1.DatabaseInstance(this, 'Database', props);
        if (props.monitoring) {
            new monitoring_facade_1.MonitoringFacade(this, props.monitoring);
        }
    }
    get endpoint() {
        return this.resource.endpoint;
    }
    get connections() {
        return this.resource.connections;
    }
    fetchSecret(scope, id) {
        return this.resource.fetchSecret(scope, id);
    }
}
exports.DatabaseInstanceStack = DatabaseInstanceStack;
_a = JSII_RTTI_SYMBOL_1;
DatabaseInstanceStack[_a] = { fqn: "@condensetech/cdk-constructs.DatabaseInstanceStack", version: "0.5.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YWJhc2UtaW5zdGFuY2Utc3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc3RhY2tzL2RhdGFiYXNlLWluc3RhbmNlLXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsbUNBQW1DO0FBR25DLDhDQUF3RTtBQUN4RSxrRkFBcUc7QUFjckc7OztHQUdHO0FBQ0gsTUFBYSxxQkFBc0IsU0FBUSxHQUFHLENBQUMsS0FBSztJQU1sRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSw2QkFBZ0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQzlELElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDO1lBQ3JCLElBQUksb0NBQWdCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUMvQyxDQUFDO0lBQ0gsQ0FBQztJQUVELElBQUksUUFBUTtRQUNWLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUM7SUFDaEMsQ0FBQztJQUVELElBQUksV0FBVztRQUNiLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7SUFDbkMsQ0FBQztJQUVNLFdBQVcsQ0FBQyxLQUFnQixFQUFFLEVBQXVCO1FBQzFELE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQzlDLENBQUM7O0FBeEJILHNEQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBhd3NfZWMyIGFzIGVjMiwgYXdzX3NlY3JldHNtYW5hZ2VyIGFzIHNtLCBhd3NfcmRzIGFzIHJkcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRGF0YWJhc2VJbnN0YW5jZSwgRGF0YWJhc2VJbnN0YW5jZVByb3BzIH0gZnJvbSAnLi4vY29uc3RydWN0cyc7XG5pbXBvcnQgeyBNb25pdG9yaW5nRmFjYWRlLCBNb25pdG9yaW5nRmFjYWRlUHJvcHMgfSBmcm9tICcuLi9jb25zdHJ1Y3RzL21vbml0b3JpbmcvbW9uaXRvcmluZy1mYWNhZGUnO1xuaW1wb3J0IHsgSURhdGFiYXNlIH0gZnJvbSAnLi4vaW50ZXJmYWNlcyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgdGhlIERhdGFiYXNlSW5zdGFuY2VTdGFjay5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEYXRhYmFzZUluc3RhbmNlU3RhY2tQcm9wcyBleHRlbmRzIERhdGFiYXNlSW5zdGFuY2VQcm9wcywgY2RrLlN0YWNrUHJvcHMge1xuICAvKipcbiAgICogVGhlIG1vbml0b3JpbmcgY29uZmlndXJhdGlvbiB0byBhcHBseSB0byB0aGlzIHN0YWNrLlxuICAgKiBAZGVmYXVsdCAtIE5vIG1vbml0b3JpbmcuXG4gICAqL1xuICByZWFkb25seSBtb25pdG9yaW5nPzogTW9uaXRvcmluZ0ZhY2FkZVByb3BzO1xufVxuXG4vKipcbiAqIFRoZSBEYXRhYmFzZUluc3RhbmNlU3RhY2sgY3JlYXRlcyBhIFtEYXRhYmFzZUluc3RhbmNlXSgjQGNvbmRlbnNldGVjaC9jZGstY29uc3RydWN0cy5EYXRhYmFzZUluc3RhbmNlKSBjb25zdHJ1Y3QgYW5kIG9wdGlvbmFsbHkgZGVmaW5lcyB0aGUgbW9uaXRvcmluZyBjb25maWd1cmF0aW9uLlxuICogSXQgaW1wbGVtZW50cyB0aGUgSURhdGFiYXNlIGludGVyZmFjZSBzbyB0aGF0IGl0IGNhbiBiZSB1c2VkIGluIG90aGVyIGNvbnN0cnVjdHMgYW5kIHN0YWNrcyB3aXRob3V0IHJlcXVpcmluZyB0byBhY2Nlc3MgdG8gdGhlIHVuZGVybHlpbmcgY29uc3RydWN0LlxuICovXG5leHBvcnQgY2xhc3MgRGF0YWJhc2VJbnN0YW5jZVN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIGltcGxlbWVudHMgSURhdGFiYXNlIHtcbiAgLyoqXG4gICAqIFVuZGVybHlpbmcgRGF0YWJhc2VJbnN0YW5jZSBjb25zdHJ1Y3QuXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZTogRGF0YWJhc2VJbnN0YW5jZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGF0YWJhc2VJbnN0YW5jZVN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLnJlc291cmNlID0gbmV3IERhdGFiYXNlSW5zdGFuY2UodGhpcywgJ0RhdGFiYXNlJywgcHJvcHMpO1xuICAgIGlmIChwcm9wcy5tb25pdG9yaW5nKSB7XG4gICAgICBuZXcgTW9uaXRvcmluZ0ZhY2FkZSh0aGlzLCBwcm9wcy5tb25pdG9yaW5nKTtcbiAgICB9XG4gIH1cblxuICBnZXQgZW5kcG9pbnQoKTogcmRzLkVuZHBvaW50IHtcbiAgICByZXR1cm4gdGhpcy5yZXNvdXJjZS5lbmRwb2ludDtcbiAgfVxuXG4gIGdldCBjb25uZWN0aW9ucygpOiBlYzIuQ29ubmVjdGlvbnMge1xuICAgIHJldHVybiB0aGlzLnJlc291cmNlLmNvbm5lY3Rpb25zO1xuICB9XG5cbiAgcHVibGljIGZldGNoU2VjcmV0KHNjb3BlOiBDb25zdHJ1Y3QsIGlkPzogc3RyaW5nIHwgdW5kZWZpbmVkKTogc20uSVNlY3JldCB7XG4gICAgcmV0dXJuIHRoaXMucmVzb3VyY2UuZmV0Y2hTZWNyZXQoc2NvcGUsIGlkKTtcbiAgfVxufVxuIl19