"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudwatchAlarmsTopicStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The CloudwatchAlarmsTopicStack creates an SNS topic for Cloudwatch alarms.
 *
 * The stack  and optionally sends the alarms to Discord or Jira.
 */
class CloudwatchAlarmsTopicStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        if (!props?.discord && !props?.jiraSubscriptionWebhook) {
            throw new Error('At least one of discord or jiraSubscriptionWebhook must be provided');
        }
        const topic = (this.alarmsTopic = new aws_cdk_lib_1.aws_sns.Topic(this, 'AlarmsTopic', {
            topicName: props.topicName,
            displayName: 'Cloudwatch Alarms Topic',
        }));
        if (props.jiraSubscriptionWebhook) {
            topic.addSubscription(new aws_cdk_lib_1.aws_sns_subscriptions.UrlSubscription(props.jiraSubscriptionWebhook));
        }
        if (props.urlSubscriptionWebhooks) {
            props.urlSubscriptionWebhooks.forEach((url) => topic.addSubscription(new aws_cdk_lib_1.aws_sns_subscriptions.UrlSubscription(url)));
        }
        if (props.discord) {
            const fn = new aws_cdk_lib_1.aws_lambda_nodejs.NodejsFunction(this, 'AlarmDispatcher', {
                environment: {
                    ...(props.discord.username && { DISCORD_USERNAME: props.discord.username }),
                    DISCORD_WEBHOOK: props.discord.webhook,
                },
                timeout: cdk.Duration.seconds(10),
            });
            fn.addEventSource(new aws_cdk_lib_1.aws_lambda_event_sources.SnsEventSource(topic));
        }
    }
}
exports.CloudwatchAlarmsTopicStack = CloudwatchAlarmsTopicStack;
_a = JSII_RTTI_SYMBOL_1;
CloudwatchAlarmsTopicStack[_a] = { fqn: "@condensetech/cdk-constructs.CloudwatchAlarmsTopicStack", version: "0.5.2" };
//# sourceMappingURL=data:application/json;base64,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