"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerRulePriorityAlreadyTakenError = exports.ListenerRuleAlreadyExistsError = exports.ListenerRuleNotFoundError = exports.PriorityAlreadySetError = void 0;
class PriorityAlreadySetError extends Error {
    constructor() {
        super(`Priority has been already set at least once for listener.`);
    }
}
exports.PriorityAlreadySetError = PriorityAlreadySetError;
class ListenerRuleNotFoundError extends Error {
    constructor(listenerRuleId) {
        super(`Listener rule '${listenerRuleId.rulePath}' not found for listener.`);
        this.listenerRuleId = listenerRuleId;
    }
}
exports.ListenerRuleNotFoundError = ListenerRuleNotFoundError;
class ListenerRuleAlreadyExistsError extends Error {
    constructor(listenerRuleId) {
        super(`Listener rule '${listenerRuleId.rulePath}' already exists for listener.`);
        this.listenerRuleId = listenerRuleId;
    }
}
exports.ListenerRuleAlreadyExistsError = ListenerRuleAlreadyExistsError;
class ListenerRulePriorityAlreadyTakenError extends Error {
    constructor(listenerRuleId, priority) {
        super(`Priority '${priority}' for listener rule '${listenerRuleId.rulePath}' already taken for listener.`);
        this.listenerRuleId = listenerRuleId;
        this.priority = priority;
    }
}
exports.ListenerRulePriorityAlreadyTakenError = ListenerRulePriorityAlreadyTakenError;
//# sourceMappingURL=data:application/json;base64,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