import * as cdk from 'aws-cdk-lib';
import { aws_elasticloadbalancingv2 as elbv2 } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The TargetGroupMonitoringConfig defines the thresholds for the target group monitoring.
 */
export interface TargetGroupMonitoringConfig {
    /**
     * The Response Time threshold.
     * @default - No threshold.
     */
    readonly responseTimeThreshold?: cdk.Duration;
    /**
     * The Min Healthy Hosts threshold.
     * @default 1
     */
    readonly minHealthyHostsThreshold?: number;
}
/**
 * The TargetGroupMonitoringAspect iterates over the target groups and adds monitoring widgets and alarms.
 */
export declare class TargetGroupMonitoringAspect implements cdk.IAspect {
    readonly monitoringFacade: ICondenseMonitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for a specific target group.
     * @param node The target group to monitor.
     * @param config The configuration to apply.
     */
    overrideConfig(node: elbv2.ApplicationTargetGroup, config: TargetGroupMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
}
