import * as cdk from 'aws-cdk-lib';
import { aws_rds as rds } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The RdsClusterMonitoringConfig defines the thresholds for the RDS cluster monitoring.
 */
export interface RdsClusterMonitoringConfig {
    /**
     * The CPU Utilization (%) threshold.
     * @default 90
     */
    readonly cpuUtilizationThreshold?: number;
    /**
     * The Max Connections threshold.
     * @default 50
     */
    readonly maxConnectionsThreshold?: number;
    /**
     * The EBS Byte Balance (%) threshold.
     * @default 10
     */
    readonly ebsByteBalanceThreshold?: number;
    /**
     * The EBS IO Balance (%) threshold.
     * @default 10
     */
    readonly ebsIoBalanceThreshold?: number;
    /**
     * The Freeable Memory threshold.
     * @default 100 MiB
     */
    readonly freeableMemoryThreshold?: cdk.Size;
    /**
     * The Read Latency threshold.
     * @default 20
     */
    readonly readLatencyThreshold?: number;
}
/**
 * The RdsClusterMonitoringAspect iterates over the RDS clusters and adds monitoring widgets and alarms.
 */
export declare class RdsClusterMonitoringAspect implements cdk.IAspect {
    private readonly monitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for a specific RDS cluster.
     * @param node The RDS cluster to monitor.
     * @param config The configuration to apply.
     */
    overrideConfig(node: rds.DatabaseCluster, config: RdsClusterMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
}
