import * as cdk from 'aws-cdk-lib';
import { aws_elasticache as elasticache } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The CacheClusterMonitoringConfig defines the thresholds for the cache cluster monitoring.
 */
export interface CacheClusterMonitoringConfig {
    /**
     * The CPU Utilization (%) threshold.
     * @default 90
     */
    readonly cpuUtilizationThreshold?: number;
    /**
     * The Max Connections threshold.
     * @default 60,000
     */
    readonly maxConnectionsThreshold?: number;
    /**
     * The Memory Usage (%) threshold.
     * @default 90
     */
    readonly memoryUsageThreshold?: number;
    /**
     * The Engine CPU Utilization (%) threshold.
     * @default 95
     */
    readonly engineCpuUtilizationThreshold?: number;
    /**
     * The Replication Lag threshold.
     * @default - No threshold.
     */
    readonly replicationLagThreshold?: cdk.Duration;
}
/**
 * The CacheClusterMonitoringAspect iterates over the Elasticache clusters and adds monitoring widgets and alarms.
 */
export declare class CacheClusterMonitoringAspect implements cdk.IAspect {
    readonly monitoringFacade: ICondenseMonitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for a specific Elasticache cluster.
     * @param node The elasticache cluster to monitor
     * @param config The configuration to apply
     */
    overrideConfig(node: elasticache.CfnCacheCluster, config: CacheClusterMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
    private getCacheNodeId;
    private getCacheNodeIds;
}
