import * as cdk from 'aws-cdk-lib';
import { aws_elasticloadbalancingv2 as elbv2 } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The ApplicationLoadBalancerMonitoringConfig defines the thresholds for the Application Load Balancer monitoring.
 */
export interface ApplicationLoadBalancerMonitoringConfig {
    /**
     * The Response Time threshold.
     * @default - No threshold.
     */
    readonly responseTimeThreshold?: cdk.Duration;
    /**
     * The Redirect URL Limit Exceeded threshold.
     * @default 0
     */
    readonly redirectUrlLimitExceededThreshold?: number;
    /**
     * The Rejected Connections threshold.
     * @default 0
     */
    readonly rejectedConnectionsThreshold?: number;
    /**
     * The Target Connection Errors threshold.
     * @default 0
     */
    readonly targetConnectionErrorsThreshold?: number;
    /**
     * The 5xx Errors threshold.
     * @default 0
     */
    readonly target5xxErrorsThreshold?: number;
}
/**
 * The ApplicationLoadBalancerMonitoringAspect iterates over the Application Load Balancers and adds monitoring widgets and alarms.
 */
export declare class ApplicationLoadBalancerMonitoringAspect implements cdk.IAspect {
    private readonly monitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for a specific Application Load Balancer.
     * @param node The Application Load Balancer to monitor.
     * @param config The configuration to apply.
     */
    overrideConfig(node: elbv2.ApplicationLoadBalancer, config: ApplicationLoadBalancerMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
}
