import * as cdk from 'aws-cdk-lib';
import { aws_elasticloadbalancingv2 as elbv2 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { AllocatePriorityProps, IApplicationListenerPriorityAllocator } from '../interfaces';
/**
 * Overridden config for the ApplicationListenerPriorityAllocator construct.
 */
export interface ApplicationListenerPriorityAllocatorConfig {
    /**
     * The initial priority value to start from.
     * @default 1
     */
    readonly priorityInitialValue?: number;
    /**
     * The removal policy to apply to the DynamoDB table.
     * @default - `RemovalPolicy.DESTROY`
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * Properties for the ApplicationListenerPriorityAllocator construct.
 */
export interface ApplicationListenerPriorityAllocatorProps extends ApplicationListenerPriorityAllocatorConfig {
    /**
     * Priority Allocator name.
     * @default Generated by the listener unique name.
     */
    readonly priorityAllocatorName?: string;
    /**
     * Application Load Balancer Listener to allocate priorities for.
     */
    readonly listener: elbv2.IApplicationListener;
}
declare abstract class ApplicationListenerPriorityAllocatorBase extends Construct implements IApplicationListenerPriorityAllocator {
    abstract readonly serviceToken: string;
    /**
     * Allocates the priority of an application listener rule
     * @param scope The scope of the construct.
     * @param id The ID of the listener rule to allocate the priority to.
     * @param props
     * @returns The allocated priority.
     */
    allocatePriority(scope: Construct, id: string, props: AllocatePriorityProps): number;
}
/**
 * This custom resource allows to generate unique priorities for application listener rules.
 *
 * Consumers can allocate a priority to a listener rule by calling the `allocatePriority` method, ensuring that:
 * - if no priority is set, one will be generated
 * - if a priority is set, an error will be thrown if the priority is already taken
 */
export declare class ApplicationListenerPriorityAllocator extends ApplicationListenerPriorityAllocatorBase {
    static fromPriorityAllocatorName(scope: Construct, id: string, priorityAllocatorName: string): IApplicationListenerPriorityAllocator;
    static fromServiceToken(scope: Construct, id: string, serviceToken: string): IApplicationListenerPriorityAllocator;
    /**
     * The service token to use to reference the custom resource.
     */
    readonly serviceToken: string;
    constructor(scope: Construct, id: string, props: ApplicationListenerPriorityAllocatorProps);
}
export {};
