# serialized traditional Ethereum transaction, as an RLP encoded list
LEGACY_TRANSACTION_HASH = "ffd59870844e5411f9e4043e654146b054bdcabe726a4bc4bd716049bfa54a69"
LEGACY_TRANSACTION = bytes.fromhex(
    "f86b01847735940082520894a2f6090c0483d6e6ac90a9c23d42e461fee2ac5188016147191f13b0008025a0784537"
    "f9801331b707ceedd5388d318d86b0bb43c6f5b32b30c9df960f596b05a042fe22aa47f2ae80cbb2c9272df2f8975c"
    "96a8a99020d8ac19d4d4b0e0b58219"
)
# EIP-2718 form of the serialized traditional Ethereum transaction
LEGACY_TRANSACTION_EIP_2718 = bytes.fromhex(
    "00f86b01847735940082520894a2f6090c0483d6e6ac90a9c23d42e461fee2ac5188016147191f13b0008025a07845"
    "37f9801331b707ceedd5388d318d86b0bb43c6f5b32b30c9df960f596b05a042fe22aa47f2ae80cbb2c9272df2f897"
    "5c96a8a99020d8ac19d4d4b0e0b58219"
)

# see https://etherscan.io/tx/0x00278cf7120dbbbee72eb7bdaaa2eac8ec41ef931c30fd6d218bdad1b2b2324e
# serialized Ethereum transaction with EIP-155 replay protection (similar to LEGACY_TRANSACTION)
TRANSACTION_EIP_155_HASH = "00278cf7120dbbbee72eb7bdaaa2eac8ec41ef931c30fd6d218bdad1b2b2324e"
TRANSACTION_EIP_155 = bytes.fromhex(
    "f90155820126850c570bd20083028851947a250d5630b4cf539739df2c5dacb4c659f2488d8901158e460913d00000"
    "b8e47ff36ab50000000000000000000000000000000000000000000000f63ad7b170466de7d8000000000000000000"
    "0000000000000000000000000000000000000000000080000000000000000000000000622961e7f76b5e573df44afd"
    "eb712749bbee398d000000000000000000000000000000000000000000000000000000005ee26a7900000000000000"
    "00000000000000000000000000000000000000000000000002000000000000000000000000c02aaa39b223fe8d0a0e"
    "5c4f27ead9083c756cc20000000000000000000000006b175474e89094c44da98b954eedeac495271d0f25a0cf5e77"
    "17042a53b761dad24b9e6873f2da6bb381ab0bec1a1ba7e15bc924b0b2a05a6d627f0345f84ac6fbf708d30a3ddac8"
    "e12105d4430ab6768d81a7a8db7191"
)
TRANSACTION_EIP_155_GAS_PRICE = 53_000_000_000

# serialized Ethereum transaction without EIP-155 replay protection
TRANSACTION_PRE_EIP_155_HASH = "f4996a6631c6c685b6c34a30d129917b8d502988feb1d7e930035e207e9761dc"
TRANSACTION_PRE_EIP_155 = bytes.fromhex(
    "f8ac8301888c850737be760082ea6094a1b19bcd50a24be0cb399c1ec0f7ca546b94a2b080b844a9059cbb00000000"
    "00000000000000000f302271d0dfbd66c5f78a32162eebf0a8b3512e00000000000000000000000000000000000000"
    "000000000075491cca15133c001ba0190466ba930f7cd8f4f0e0fc564bfb75cb2b55d0807fe0a743e586c22757518e"
    "a06bb11a089946493e4aa7559d578da39862d8d144f2b3c49afe9fa3591bab052d"
)

# EIP-2718 serialized access list transaction, as it would appear RLP encoded
# in a transaction message, or as tx_message.tx_val()
ACL_TRANSACTION_HASH = "9310dc4f07748222d37f43c7296826cf4bf6693fa207968bd7500659ee2cc04d"
ACL_TRANSACTION = bytes.fromhex(
    "b9022501f9022101829237853486ced000830285ee94653911da49db4cdb0b7c3e4d929cfb56024cd4e680b8a48201"
    "aa3f000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc200000000000000000000000000"
    "000000000000000000000083a297567e20f8000000000000000000000000000d8775f648430679a709e98d2b0cb625"
    "0d2887ef000000000000000000000000000000000000000000000358c5ee87d374000000ffffffffffffffffffffff"
    "fffffffffffffffffffffffffffffffffffffffffff90111f859940d8775f648430679a709e98d2b0cb6250d2887ef"
    "f842a01d76467e21923adb4ee07bcae017030c6208bbccde21ff0a61518956ad9b152aa0ec5bfdd140da829800c64d"
    "740e802727fca06fadec8b5d82a7b406c811851b55f85994653911da49db4cdb0b7c3e4d929cfb56024cd4e6f842a0"
    "2a9a57a342e03a2b55a8bef24e9c777df22a7442475b1641875a66dba65855f0a0d0bcf4df132c65dad73803c5e5e1"
    "c826f151a3342680034a8a4c8e5f8eb0c13ff85994c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2f842a01fc85b"
    "67921559ce4fef22a331ff00c886678cf8b163d395e45fe0543f8750bda047a365b3ae9dbfa1c60a2cd30347765e91"
    "4a89b7dac828db3ac3bd3e775b1a9980a0a340fc367050387a1b295514210a48de3836ee7923d9739bf0104e6d79c3"
    "7997a06e63c7801da3c72f1a53f9b809ae04a45637da673c2a9c47065a1b1cdeafef7d"
)

DYNAMIC_FEE_TRANSACTION_HASH = "5421534dccf306cd34755e51d65e32fb0e179f76f467dbf3e94c8e809708788f"
DYNAMIC_FEE_TRANSACTION = bytes.fromhex(
    "b86302f86080800f1f649400000000000000000000000000000000000000006480c001a0c9519f4f2b303358845819"
    "71573fadf60c6204f59a911df35ee8a540456b2660a032f1e8e2c5dd761f9e4f88f41c8310aeaba26a8bfcdacfedfa"
    "12ec3862d37521"
)
DYNAMIC_FEE_FROM_ADDRESS = "0x4fbbf0b8a9b8753ffab30fb60af5860104071b8e"

# JSON serialized transaction info, not the same LEGACY_TRANSACTION as above
LEGACY_TRANSACTION_JSON = {
    "from": "0xbd4e113ee68bcbbf768ba1d6c7a14e003362979a",
    "gas": 39866,
    "gasPrice": 17679998398,
    "hash": "0x0d96b711bdcc89b59f0fdfa963158394cea99cedce52d0e4f4a56839145a814a",
    "input": "0xea1790b9000000000000000000000000000000000000000000000000000000000000006000000000000"
             "0000000000000000000000000000000000000000000005ee3f95400000000000000000000000000000000"
             "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
             "00000000041d880a37ae74a2593900da75b3cae6335b5f58997c6f426e98e42f55d3d5cd6487369ec0250"
             "a923cf1f45a39aa551b68420ec04582d1a68bcab9a70240ae39f261b00000000000000000000000000000"
             "000000000000000000000000000000000",
    "nonce": 488,
    "r": "0x561fc2c4428e8d3ff1e48ce07322a98ea6c8c5836bc79e7d60a6ed5d37a124a2",
    "s": "0x7ab1477ccb14143ba9afeb2f98099c85dd4175f09767f03d47f0733467eadde2",
    "to": "0xd7bec4d6bf6fc371eb51611a50540f0b59b5f896",
    "v": "0x25",
    "value": 0,
}
LEGACY_TRANSACTION_JSON_FROM_WS = {
    "from": "0xbd4e113ee68bcbbf768ba1d6c7a14e003362979a",
    "gas": "0x9bba",
    "gasPrice": "0x41dcf5dbe",
    "hash": "0x0d96b711bdcc89b59f0fdfa963158394cea99cedce52d0e4f4a56839145a814a",
    "input": "0xea1790b9000000000000000000000000000000000000000000000000000000000000006000000000000"
             "0000000000000000000000000000000000000000000005ee3f95400000000000000000000000000000000"
             "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
             "00000000041d880a37ae74a2593900da75b3cae6335b5f58997c6f426e98e42f55d3d5cd6487369ec0250"
             "a923cf1f45a39aa551b68420ec04582d1a68bcab9a70240ae39f261b00000000000000000000000000000"
             "000000000000000000000000000000000",
    "nonce": "0x1e8",
    "r": "0x561fc2c4428e8d3ff1e48ce07322a98ea6c8c5836bc79e7d60a6ed5d37a124a2",
    "s": "0x7ab1477ccb14143ba9afeb2f98099c85dd4175f09767f03d47f0733467eadde2",
    "to": "0xd7bec4d6bf6fc371eb51611a50540f0b59b5f896",
    "v": "0x25",
    "value": "0x0",
}

# JSON serialized transaction info, same as the ACL_TRANSACTION above
ACL_TRANSACTION_JSON = {
    "accessList": [
        {
            "address": "0x0d8775f648430679a709e98d2b0cb6250d2887ef",
            "storageKeys": [
                "0x1d76467e21923adb4ee07bcae017030c6208bbccde21ff0a61518956ad9b152a",
                "0xec5bfdd140da829800c64d740e802727fca06fadec8b5d82a7b406c811851b55",
            ],
        },
        {
            "address": "0x653911da49db4cdb0b7c3e4d929cfb56024cd4e6",
            "storageKeys": [
                "0x2a9a57a342e03a2b55a8bef24e9c777df22a7442475b1641875a66dba65855f0",
                "0xd0bcf4df132c65dad73803c5e5e1c826f151a3342680034a8a4c8e5f8eb0c13f",
            ],
        },
        {
            "address": "0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",
            "storageKeys": [
                "0x1fc85b67921559ce4fef22a331ff00c886678cf8b163d395e45fe0543f8750bd",
                "0x47a365b3ae9dbfa1c60a2cd30347765e914a89b7dac828db3ac3bd3e775b1a99",
            ],
        },
    ],
    "chainId": "0x1",
    "from": "0x0087c5900b9bbc051b5f6299f5bce92383273b28",
    "gas": "0x285ee",
    "gasPrice": "0x3486ced000",
    "hash": "0x9310dc4f07748222d37f43c7296826cf4bf6693fa207968bd7500659ee2cc04d",
    "input": "0x8201aa3f000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc200000000000"
             "000000000000000000000000000000000000083a297567e20f8000000000000000000000000000d8775f6"
             "48430679a709e98d2b0cb6250d2887ef000000000000000000000000000000000000000000000358c5ee8"
             "7d374000000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    "nonce": "0x9237",
    "r": "0xa340fc367050387a1b295514210a48de3836ee7923d9739bf0104e6d79c37997",
    "s": "0x6e63c7801da3c72f1a53f9b809ae04a45637da673c2a9c47065a1b1cdeafef7d",
    "to": "0x653911da49db4cdb0b7c3e4d929cfb56024cd4e6",
    "type": "0x1",
    "v": "0x0",
    "value": "0x0",
}

# RLP encoded block; contains 1 LEGACY_TRANSACTION and 1 ACL_TRANSACTION
# pylint: disable=line-too-long
BERLIN_BLOCK = bytes.fromhex(
    "f90319f90211a00000000000000000000000000000000000000000000000000000000000000000a01dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347948888f1f195afa192cfee860698584c030f4c9db1a0ef1552a40b7165c3cd773806b9e0c165b75356e0314bf0706f279c729f51e017a0e6e49996c7ec59f7a23d22b83239a60151512c65613bf84a0d7da336399ebc4aa0cafe75574d59780665a97fbfd11365c7545aa8f1abf4e5e12e8243334ef7286bb901000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000083020000820200832fefd882a410845506eb0796636f6f6c65737420626c6f636b206f6e20636861696ea0bd4472abb6659ebe3ee06ee4d7b72a00a9f4d001caca51342001075469aff49888a13a5a8c8f2bb1c4f90101f85f800a82c35094095e7baea6a6c7c4c2dfeb977efac326af552d870a801ba09bea4c4daac7c7c52e093e6a4c35dbbcf8856f1af7b059ba20253e70848d094fa08a8fae537ce25ed8cb5af9adac3f141af69bd515bd2ba031522df09b97dd72b1b89e01f89b01800a8301e24194095e7baea6a6c7c4c2dfeb977efac326af552d878080f838f7940000000000000000000000000000000000000001e1a0000000000000000000000000000000000000000000000000000000000000000001a03dbacc8d0259f2508625e97fdfc57cd85fdd16e5821bc2c10bdd1a52649e8335a0476e10695b183a87b0aa292a7f4b78ef0c3fbe62aa2c42c84e1d9c3da159ef14c0"
)

# https://etherscan.io/block/12814282
PRE_LONDON_BLOCK_HEADER = bytes.fromhex(
    "f90215a05b300df7c29668cf450f438f0d4bb5cb144a3601d47acfb6d091ea201a3dee95a01dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d493479445a36a8e118c37e4c47ef4ab827a7c9e579e11e2a01d30ede02573d06e994eadba6c3df3525f439d0e742b0fa19bfc7d77f208eeb1a02259f452d9fece6dc4e7995c89878e48d5ddcb9309a9c5f030afddb265fae44aa03fa026a1a42208ae7d52d16af1a4911eeda09b18afee8a0ba3cdfcea1f9dfd2bb90100b139e82e61a718e15a987ee1a440122f810a32a5dd2688c720493637afd589c68a1e4be6040096a6d5725b30437107940a34a0116810f91c2995a98c6264ec20694200b5f2017539c9a6534e00d441f11f5b456cecfd52b6bc4b74c188610182d06306488a56255253fcb1ca190b0c520e0e5556193c557612406890101989849b0088e9c750ea4093fd1d4a25f1a4c71c100a4589d0a56986edb94a68d60302479b24c3835a2133063364b4aa5b842571355e18244301782322875e3d1c8bd43f1944c3662e4163ac064de4af8e13041f2a72d5524eb85f730624e6fe31633be439b133791032c210c6d4e58450eaa0d5654c1c7b00f26fa26c98b04ad2968187188272920430da83c387ca83e3fbde83e3deed8460ec951c944d696e656420427920416e74506f6f6c20303037a063bb4bfb16a1329ea71e853d6553748db59b528ce284d1dff25398008d9a5ead881ebb2885d67db394"
)
PRE_LONDON_BLOCK_HASH = bytes.fromhex(
    "61eca4f3e431049b0f81cfc36562fb300647671acafb48899dd07dbef5725d75"
)

# London block header with new `base_fee_per_gas` field
# https://rinkeby.etherscan.io/block/8923781
LONDON_BLOCK_HEADER = bytes.fromhex(
    "f9025ea055bd57cbf3c2a6f17828f471dc971145377d85010909ee9aaf2951f30c7032a7a01dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347940000000000000000000000000000000000000000a0bf7e2e9d37b18cdd5ff37c552dddcd1930a948eaae42639fe844a61655825bbba0d82176068eeb8ac1894d752bd34b1591d79690cf2f5b9fbb85bcb0e14b114b68a0e741b5fb4f2e1149ccd78c180593d0bf0158d604a3dee039b4093bab6ed64b5fb901002000218400008000088000400000000828000200500180080000288000200022000010004610400880080000001001200c1008228027802a00800800002020010e08044000404000100028084400020002008102000800040020014080000000000000404600004020000090000008200002001008100200002000100000040012400102000401000401040885000005410404890200000000000304080008000200800400000040200010a050040004800000020048000000100486000910000210000280040000000200008000110000400800028800010081100001082002401000a8010000020000202000000080200020488010004802602801080000050283882a858401c950f5838278678460ec3d2eb861d883010a04846765746888676f312e31362e35856c696e757800000000000000865fe485f913e42b9dc3abefa331085c3340bd03aed1814c18c911419df78c1235feb53e73e9dc87ab2660d7ddb6c14b9c1628aff02bbb33630e26fab0051f1100a000000000000000000000000000000000000000000000000000000000000000008800000000000000000b"
)
LONDON_BLOCK_HASH = bytes.fromhex(
    "28dec8c2b357746bc3d77bee971c7c8a44fa6a0ab1b1d95007e04784b63038d5"
)
