/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.collections;

import codeintelligence.codeanalysis.utils.collections.MatcherLinkedHashSet;
import codeintelligence.codeanalysis.utils.graph.DefaultMatcher;
import codeintelligence.codeanalysis.utils.graph.Holder;
import codeintelligence.codeanalysis.utils.graph.Matcher;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MatcherLinkedHashMap<K, V>
implements Map<K, V> {
    public final Matcher<K> matcher;
    private final LinkedHashMap<Holder<K>, V> map;

    public MatcherLinkedHashMap() {
        this(16, new DefaultMatcher());
    }

    public MatcherLinkedHashMap(int capacity, Matcher<K> matcher) {
        this.map = new LinkedHashMap(capacity, 0.8f);
        this.matcher = matcher;
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(new Holder<K>(key, this.matcher), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.map.put(new Holder<K>(key, this.matcher), m.get(key));
        }
    }

    @Override
    public V get(Object key) {
        return this.map.get(new Holder<Object>(key, this.matcher));
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(new Holder<Object>(key, this.matcher));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(new Holder<Object>(key, this.matcher));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        MatcherLinkedHashSet<K> set = new MatcherLinkedHashSet<K>(this.map.size(), this.matcher);
        for (Holder<K> k : this.map.keySet()) {
            set.add(k.object);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>(this.map.size());
        for (Holder<K> k : this.map.keySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry(k.object, this.map.get(k)));
        }
        return entries;
    }
}

