# Generated by Django 3.2.15 on 2023-01-13 14:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('notifications', '0006_remove_all_sns_push_notification_setup'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='notification',
            name='aws_sns_id',
        ),
        migrations.RemoveField(
            model_name='notification',
            name='send_email',
        ),
        migrations.AddField(
            model_name='notification',
            name='description',
            field=models.CharField(blank=True, default='', help_text='Short version of the message, mainly for push notifications', max_length=500, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='notification',
            name='description_en',
            field=models.CharField(blank=True, default='', help_text='Short version of the message, mainly for push notifications', max_length=500, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='notification',
            name='description_is',
            field=models.CharField(blank=True, default='', help_text='Short version of the message, mainly for push notifications', max_length=500, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='notification',
            name='name',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250),
        ),
        migrations.AlterField(
            model_name='notification',
            name='name_en',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, null=True),
        ),
        migrations.AlterField(
            model_name='notification',
            name='name_is',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, null=True),
        ),
        migrations.CreateModel(
            name='UserDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('active', models.BooleanField(default=True, help_text='Inactive devices will not be sent notifications', verbose_name='Is active')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Creation date')),
                ('device_id', models.CharField(blank=True, db_index=True, help_text='Unique device identifier', max_length=255, null=True, verbose_name='Device ID')),
                ('registration_id', models.TextField(verbose_name='Registration token')),
                ('type', models.CharField(choices=[('ios', 'ios'), ('android', 'android'), ('web', 'web')], max_length=10)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_query_name='fcmdevice', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User device',
                'verbose_name_plural': 'User devices',
            },
        ),
        migrations.CreateModel(
            name='Topic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='Topic name')),
                ('name_is', models.CharField(max_length=100, null=True, unique=True, verbose_name='Topic name')),
                ('name_en', models.CharField(max_length=100, null=True, unique=True, verbose_name='Topic name')),
                ('description', models.CharField(blank=True, default='', max_length=400, verbose_name='Topic description')),
                ('description_is', models.CharField(blank=True, default='', max_length=400, null=True, verbose_name='Topic description')),
                ('description_en', models.CharField(blank=True, default='', max_length=400, null=True, verbose_name='Topic description')),
                ('subscribers', models.ManyToManyField(related_name='topics', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='notification',
            name='topic',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='notifications.topic', verbose_name='Push notification topic'),
        ),
    ]
