# AUTOGENERATED! DO NOT EDIT! File to edit: utils.ipynb (unless otherwise specified).

__all__ = ['softmax', 'calc_prob', 'one_hot', 'on_colab']

# Cell
import numpy as np

def softmax(x):
    e_x = np.exp(x - x.max(axis=-1, keepdims=True))
    return e_x / e_x.sum(axis=-1, keepdims=True)

# Cell
def calc_prob(n=1000, s=2.5, dim=3):
    "s = 'scale': how strongly to 'push' the points towards the ends"
    logits = (np.random.rand(n,dim)*2-1)*s
    prob = softmax(logits)
    targ = np.argmax(prob, axis=1)  # target values
    return prob, targ

# Cell
def one_hot(targs):
    """convert array of single target values to set of one-hot vectors"""
    out = np.zeros((targs.size, targs.max()+1))
    out[np.arange(targs.size),targs] = 1
    return out

# Cell
def on_colab():   # cf https://stackoverflow.com/questions/53581278/test-if-notebook-is-running-on-google-colab
    """Returns true if code is being executed on Colab, false otherwise"""
    try:
        return 'google.colab' in str(get_ipython())
    except NameError:    # no get_ipython, so definitely not on Colab
        return False