from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class LdpLabelRequest(Base):
    __slots__ = ()
    _SDM_NAME = 'ldpLabelRequest'
    _SDM_ATT_MAP = {
        'HeaderVersion': 'ldpLabelRequest.header.version-1',
        'HeaderPduLengthinOctets': 'ldpLabelRequest.header.pduLengthinOctets-2',
        'HeaderLsrID': 'ldpLabelRequest.header.lsrID-3',
        'HeaderLabelSpace': 'ldpLabelRequest.header.labelSpace-4',
        'HeaderUBit': 'ldpLabelRequest.header.uBit-5',
        'HeaderType': 'ldpLabelRequest.header.type-6',
        'HeaderLength': 'ldpLabelRequest.header.length-7',
        'HeaderMessageID': 'ldpLabelRequest.header.messageID-8',
        'FecTLVUBit': 'ldpLabelRequest.header.fecTLV.uBit-9',
        'FecTLVFBit': 'ldpLabelRequest.header.fecTLV.fBit-10',
        'FecTLVType': 'ldpLabelRequest.header.fecTLV.type-11',
        'FecTLVLength': 'ldpLabelRequest.header.fecTLV.length-12',
        'WildcardType': 'ldpLabelRequest.header.fecTLV.fecElement.wildcard.type-13',
        'PrefixType': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.type-14',
        'Ipv4PrefixAddressFamily': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv4Prefix.addressFamily-15',
        'Ipv4PrefixPrelen': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv4Prefix.prelen-16',
        'Ipv4PrefixPrefix': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv4Prefix.prefix-17',
        'Ipv6PrefixAddressFamily': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv6Prefix.addressFamily-18',
        'Ipv6PrefixPrelen': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv6Prefix.prelen-19',
        'Ipv6PrefixPrefix': 'ldpLabelRequest.header.fecTLV.fecElement.prefix.addressFamily.ipv6Prefix.prefix-20',
        'HostAddressType': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.type-21',
        'Ipv4HostAddressAddressFamily': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv4HostAddress.addressFamily-22',
        'Ipv4HostAddressHostAddressLength': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv4HostAddress.hostAddressLength-23',
        'Ipv4HostAddressHostAddress': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv4HostAddress.hostAddress-24',
        'Ipv6HostAddressAddressFamily': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv6HostAddress.addressFamily-25',
        'Ipv6HostAddressHostAddressLength': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv6HostAddress.hostAddressLength-26',
        'Ipv6HostAddressHostAddress': 'ldpLabelRequest.header.fecTLV.fecElement.hostAddress.addressFamily.ipv6HostAddress.hostAddress-27',
        'HopCountTLVUBit': 'ldpLabelRequest.header.optionalParameter.hopCountTLV.uBit-28',
        'HopCountTLVFBit': 'ldpLabelRequest.header.optionalParameter.hopCountTLV.fBit-29',
        'HopCountTLVType': 'ldpLabelRequest.header.optionalParameter.hopCountTLV.type-30',
        'HopCountTLVLength': 'ldpLabelRequest.header.optionalParameter.hopCountTLV.length-31',
        'HopCountTLVHopCount': 'ldpLabelRequest.header.optionalParameter.hopCountTLV.hopCount-32',
        'PathVectorTLVUBit': 'ldpLabelRequest.header.optionalParameter.pathVectorTLV.uBit-33',
        'PathVectorTLVFBit': 'ldpLabelRequest.header.optionalParameter.pathVectorTLV.fBit-34',
        'PathVectorTLVType': 'ldpLabelRequest.header.optionalParameter.pathVectorTLV.type-35',
        'PathVectorTLVLength': 'ldpLabelRequest.header.optionalParameter.pathVectorTLV.length-36',
        'PathVectorTLVLsrID': 'ldpLabelRequest.header.optionalParameter.pathVectorTLV.lsrID-37',
    }

    def __init__(self, parent, list_op=False):
        super(LdpLabelRequest, self).__init__(parent, list_op)

    @property
    def HeaderVersion(self):
        """
        Display Name: Version
        Default Value: 1
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderVersion']))

    @property
    def HeaderPduLengthinOctets(self):
        """
        Display Name: PDU length(in octets)
        Default Value: 0
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderPduLengthinOctets']))

    @property
    def HeaderLsrID(self):
        """
        Display Name: LSR ID
        Default Value: 0.0.0.0
        Value Format: iPv4
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderLsrID']))

    @property
    def HeaderLabelSpace(self):
        """
        Display Name: Label space
        Default Value: 0
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderLabelSpace']))

    @property
    def HeaderUBit(self):
        """
        Display Name: U bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Ignore entire message if unknown TLV, 0, Ignore only unknown TLV, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderUBit']))

    @property
    def HeaderType(self):
        """
        Display Name: Type
        Default Value: 0x0401
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderType']))

    @property
    def HeaderLength(self):
        """
        Display Name: Length
        Default Value: 0
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderLength']))

    @property
    def HeaderMessageID(self):
        """
        Display Name: Message ID
        Default Value: 0
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HeaderMessageID']))

    @property
    def FecTLVUBit(self):
        """
        Display Name: U bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Ignore entire message if unknown TLV, 0, Ignore only unknown TLV, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['FecTLVUBit']))

    @property
    def FecTLVFBit(self):
        """
        Display Name: F bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Do not forward, 0, Forward, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['FecTLVFBit']))

    @property
    def FecTLVType(self):
        """
        Display Name: Type
        Default Value: 0x0100
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['FecTLVType']))

    @property
    def FecTLVLength(self):
        """
        Display Name: Length
        Default Value: 1
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['FecTLVLength']))

    @property
    def WildcardType(self):
        """
        Display Name: Type
        Default Value: 0x01
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['WildcardType']))

    @property
    def PrefixType(self):
        """
        Display Name: Type
        Default Value: 0x02
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PrefixType']))

    @property
    def Ipv4PrefixAddressFamily(self):
        """
        Display Name: Address family
        Default Value: 1
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4PrefixAddressFamily']))

    @property
    def Ipv4PrefixPrelen(self):
        """
        Display Name: Prelen
        Default Value: 4
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4PrefixPrelen']))

    @property
    def Ipv4PrefixPrefix(self):
        """
        Display Name: Prefix
        Default Value: 0.0.0.0
        Value Format: iPv4
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4PrefixPrefix']))

    @property
    def Ipv6PrefixAddressFamily(self):
        """
        Display Name: Address family
        Default Value: 2
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6PrefixAddressFamily']))

    @property
    def Ipv6PrefixPrelen(self):
        """
        Display Name: Prelen
        Default Value: 16
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6PrefixPrelen']))

    @property
    def Ipv6PrefixPrefix(self):
        """
        Display Name: Prefix
        Default Value: 0
        Value Format: iPv6
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6PrefixPrefix']))

    @property
    def HostAddressType(self):
        """
        Display Name: Type
        Default Value: 0x03
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HostAddressType']))

    @property
    def Ipv4HostAddressAddressFamily(self):
        """
        Display Name: Address family
        Default Value: 1
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4HostAddressAddressFamily']))

    @property
    def Ipv4HostAddressHostAddressLength(self):
        """
        Display Name: Host address length
        Default Value: 4
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4HostAddressHostAddressLength']))

    @property
    def Ipv4HostAddressHostAddress(self):
        """
        Display Name: Host address
        Default Value: 0.0.0.0
        Value Format: iPv4
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv4HostAddressHostAddress']))

    @property
    def Ipv6HostAddressAddressFamily(self):
        """
        Display Name: Address family
        Default Value: 2
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6HostAddressAddressFamily']))

    @property
    def Ipv6HostAddressHostAddressLength(self):
        """
        Display Name: Host address length
        Default Value: 16
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6HostAddressHostAddressLength']))

    @property
    def Ipv6HostAddressHostAddress(self):
        """
        Display Name: Host address
        Default Value: 0
        Value Format: iPv6
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['Ipv6HostAddressHostAddress']))

    @property
    def HopCountTLVUBit(self):
        """
        Display Name: U bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Ignore entire message if unknown TLV, 0, Ignore only unknown TLV, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HopCountTLVUBit']))

    @property
    def HopCountTLVFBit(self):
        """
        Display Name: F bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Do not forward, 0, Forward, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HopCountTLVFBit']))

    @property
    def HopCountTLVType(self):
        """
        Display Name: Type
        Default Value: 0x0103
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HopCountTLVType']))

    @property
    def HopCountTLVLength(self):
        """
        Display Name: Length
        Default Value: 1
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HopCountTLVLength']))

    @property
    def HopCountTLVHopCount(self):
        """
        Display Name: Hop count
        Default Value: 0
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['HopCountTLVHopCount']))

    @property
    def PathVectorTLVUBit(self):
        """
        Display Name: U bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Ignore entire message if unknown TLV, 0, Ignore only unknown TLV, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PathVectorTLVUBit']))

    @property
    def PathVectorTLVFBit(self):
        """
        Display Name: F bit
        Default Value: 0
        Value Format: decimal
        Available enum values: Do not forward, 0, Forward, 1
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PathVectorTLVFBit']))

    @property
    def PathVectorTLVType(self):
        """
        Display Name: Type
        Default Value: 0x0104
        Value Format: hex
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PathVectorTLVType']))

    @property
    def PathVectorTLVLength(self):
        """
        Display Name: Length
        Default Value: 4
        Value Format: decimal
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PathVectorTLVLength']))

    @property
    def PathVectorTLVLsrID(self):
        """
        Display Name: LSR ID
        Default Value: 0.0.0.0
        Value Format: iPv4
        """
        from ixnetwork_restpy.multivalue import Multivalue
        return Multivalue(self, self._get_attribute(self._SDM_ATT_MAP['PathVectorTLVLsrID']))

    def add(self):
        return self._create(self._map_locals(self._SDM_ATT_MAP, locals()))
