country_map = {
    "Canada": "Canada",
    "United States": "United States",
    "Afghanistan": "Afghanistan",
    "Åland Islands": "Aland Islands",
    "Albania": "Albania",
    "Algeria": "Algeria",
    "American Samoa": "American Samoa",
    "Andorra": "Andorra",
    "Angola": "Angola",
    "Anguilla": "Anguilla",
    "Antarctica": "Antarctica",
    "Antigua and Barbuda": "Antigua and Barbuda",
    "Argentina": "Argentina",
    "Armenia": "Armenia",
    "Aruba": "Aruba",
    "Australia": "Australia",
    "Austria": "Austria",
    "Azerbaijan": "Azerbaijan",
    "Bahamas": "Bahamas",
    "Bahrain": "Bahrain",
    "Bangladesh": "Bangladesh",
    "Barbados": "Barbados",
    "Belarus": "Belarus",
    "Belgium": "Belgium",
    "Belize": "Belize",
    "Benin": "Benin",
    "Bermuda": "Bermuda",
    "Bhutan": "Bhutan",
    "Bolivia, Plurinational State of": "Bolivia",
    "Bonaire, Sint Eustatius and Saba": "Bonaire",
    "Bosnia and Herzegovina": "Bosnia and Herzegowina",
    "Botswana": "Botswana",
    "Bouvet Island": "Bouvet Island",
    "Brazil": "Brazil",
    "British Indian Ocean Territory": "British Indian Ocean Territory",
    "Brunei Darussalam": "Brunei Darussalam",
    "Bulgaria": "Bulgaria",
    "Burkina Faso": "Burkina Faso",
    "Burundi": "Burundi",
    "Cambodia": "Cambodia",
    "Cameroon": "Cameroon",
    "Cape Verde": "Cape Verde",
    "Cayman Islands": "Cayman Islands",
    "Central African Republic": "Central African Republic",
    "Chad": "Chad",
    "Chile": "Chile",
    "China": "China",
    "Christmas Island": "Christmas Island",
    "Cocos (Keeling) Islands": "Cocos (Keeling) Islands",
    "Colombia": "Colombia",
    "Comoros": "Comoros",
    "Congo": "Congo",
    "Congo, the Democratic Republic of the": "Democratic Congo",
    "Cook Islands": "Cook Islands",
    "Costa Rica": "Costa Rica",
    "Côte d'Ivoire": "Cote D'Ivoire",
    "Croatia": "Croatia",
    "Cuba": "Cuba",
    "Curaçao": "Curacao",
    "Cyprus": "Cyprus",
    "Czech Republic": "Czech Republic",
    "Denmark": "Denmark",
    "Djibouti": "Djibouti",
    "Dominica": "Dominica",
    "Dominican Republic": "Dominican Republic",
    "Ecuador": "Ecuador",
    "Egypt": "Egypt",
    "El Salvador": "El Salvador",
    "Equatorial Guinea": "Equatorial Guinea",
    "Eritrea": "Eritrea",
    "Estonia": "Estonia",
    "Ethiopia": "Ethiopia",
    "Falkland Islands (Malvinas)": "Falkland Islands (Malvinas)",
    "Faroe Islands": "Faroe Islands",
    "Fiji": "Fiji",
    "Finland": "Finland",
    "France": "France",
    "French Guiana": "French Guiana",
    "French Polynesia": "French Polynesia",
    "French Southern Territories": "French Southern Territories",
    "Gabon": "Gabon",
    "Gambia": "Gambia",
    "Georgia": "Georgia",
    "Germany": "Germany",
    "Ghana": "Ghana",
    "Gibraltar": "Gibraltar",
    "Greece": "Greece",
    "Greenland": "Greenland",
    "Grenada": "Grenada",
    "Guadeloupe": "Guadeloupe",
    "Guam": "Guam",
    "Guatemala": "Guatemala",
    "Guernsey": "Guernsey",
    "Guinea": "Guinea",
    "Guinea-Bissau": "Guinea-bissau",
    "Guyana": "Guyana",
    "Haiti": "Haiti",
    "Heard Island and McDonald Islands": "Heard and Mc Donald Islands",
    "Holy See (Vatican City State)": "Vatican City State (Holy See)",
    "Honduras": "Honduras",
    "Hong Kong": "Hong Kong",
    "Hungary": "Hungary",
    "Iceland": "Iceland",
    "India": "India",
    "Indonesia": "Indonesia",
    "Iran, Islamic Republic of": "Iran",
    "Iraq": "Iraq",
    "Ireland": "Ireland",
    "Isle of Man": "Isle of Man",
    "Israel": "Israel",
    "Italy": "Italy",
    "Jamaica": "Jamaica",
    "Japan": "Japan",
    "Jersey": "Jersey",
    "Jordan": "Jordan",
    "Kazakhstan": "Kazakhstan",
    "Kenya": "Kenya",
    "Kiribati": "Kiribati",
    "Korea, Democratic People's Republic of": "Korea, North",
    "Korea, Republic of": "Korea, South",
    "Kosovo": "Kosovo",
    "Kuwait": "Kuwait",
    "Kyrgyzstan": "Kyrgyzstan",
    "Lao People's Democratic Republic": "Lao People's Democratic Republic",
    "Latvia": "Latvia",
    "Lebanon": "Lebanon",
    "Lesotho": "Lesotho",
    "Liberia": "Liberia",
    "Libya": "Libyan Arab Jamahiriya",
    "Liechtenstein": "Liechtenstein",
    "Lithuania": "Lithuania",
    "Luxembourg": "Luxembourg",
    "Macao": "Macau",
    "Macedonia, the former Yugoslav Republic of": "Macedonia, The Former Yugoslav Republic of",
    "Madagascar": "Madagascar",
    "Malawi": "Malawi",
    "Malaysia": "Malaysia",
    "Maldives": "Maldives",
    "Mali": "Mali",
    "Malta": "Malta",
    "Marshall Islands": "Marshall Islands",
    "Martinique": "Martinique",
    "Mauritania": "Mauritania",
    "Mauritius": "Mauritius",
    "Mayotte": "Mayotte",
    "Mexico": "Mexico",
    "Micronesia, Federated States of": "Micronesia, Federated States of",
    "Moldova, Republic of": "Moldova, Republic of",
    "Monaco": "Monaco",
    "Mongolia": "Mongolia",
    "Montenegro": "Montenegro",
    "Montserrat": "Montserrat",
    "Morocco": "Morocco",
    "Mozambique": "Mozambique",
    "Myanmar": "Myanmar",
    "Namibia": "Namibia",
    "Nauru": "Nauru",
    "Nepal": "Nepal",
    "Netherlands": "Netherlands",
    "New Caledonia": "New Caledonia",
    "New Zealand": "New Zealand",
    "Nicaragua": "Nicaragua",
    "Niger": "Niger",
    "Nigeria": "Nigeria",
    "Niue": "Niue",
    "Norfolk Island": "Norfolk Island",
    "Northern Mariana Islands": "Northern Mariana Islands",
    "Norway": "Norway",
    "Oman": "Oman",
    "Pakistan": "Pakistan",
    "Palau": "Palau",
    "Palestinian Territory, Occupied": "Palestine",
    "Panama": "Panama",
    "Papua New Guinea": "Papua New Guinea",
    "Paraguay": "Paraguay",
    "Peru": "Peru",
    "Philippines": "Philippines",
    "Pitcairn": "Pitcairn",
    "Poland": "Poland",
    "Portugal": "Portugal",
    "Puerto Rico": "Puerto Rico",
    "Qatar": "Qatar",
    "Réunion": "Reunion",
    "Romania": "Romania",
    "Russian Federation": "Russian Federation",
    "Rwanda": "Rwanda",
    "Saint Barthélemy": "Saint Barthelemy",
    "Saint Helena, Ascension and Tristan da Cunha": "St. Helena",
    "Saint Kitts and Nevis": "Saint Kitts and Nevis",
    "Saint Lucia": "Saint Lucia",
    "Saint Martin (French part)": "Saint Martin (French part)",
    "Saint Pierre and Miquelon": "St. Pierre and Miquelon",
    "Saint Vincent and the Grenadines": "Saint Vincent and the Grenadines",
    "Samoa": "Samoa",
    "San Marino": "San Marino",
    "Sao Tome and Principe": "Sao Tome and Principe",
    "Saudi Arabia": "Saudi Arabia",
    "Senegal": "Senegal",
    "Serbia": "Serbia",
    "Seychelles": "Seychelles",
    "Sierra Leone": "Sierra Leone",
    "Singapore": "Singapore",
    "Sint Maarten (Dutch part)": "Sint Maarten (Dutch part)",
    "Slovakia": "Slovakia (Slovak Republic)",
    "Slovenia": "Slovenia",
    "Solomon Islands": "Solomon Islands",
    "Somalia": "Somalia",
    "South Africa": "South Africa",
    "South Georgia and the South Sandwich Islands": "South Georgia and the South Sandwich Islands",
    "South Sudan": "South Sudan",
    "Spain": "Spain",
    "Sri Lanka": "Sri Lanka",
    "Sudan": "Sudan",
    "Suriname": "Suriname",
    "Svalbard and Jan Mayen": "Svalbard and Jan Mayen Islands",
    "Swaziland": "Swaziland",
    "Sweden": "Sweden",
    "Switzerland": "Switzerland",
    "Syrian Arab Republic": "Syria",
    "Taiwan, Province of China": "Taiwan",
    "Tajikistan": "Tajikistan",
    "Tanzania, United Republic of": "Tanzania, United Republic of",
    "Thailand": "Thailand",
    "Timor-Leste": "East Timor",
    "Togo": "Togo",
    "Tokelau": "Tokelau",
    "Tonga": "Tonga",
    "Trinidad and Tobago": "Trinidad and Tobago",
    "Tunisia": "Tunisia",
    "Turkey": "Turkey",
    "Turkmenistan": "Turkmenistan",
    "Turks and Caicos Islands": "Turks and Caicos Islands",
    "Tuvalu": "Tuvalu",
    "Uganda": "Uganda",
    "Ukraine": "Ukraine",
    "United Arab Emirates": "United Arab Emirates",
    "United Kingdom": "United Kingdom",
    "United States Minor Outlying Islands": "United States Minor Outlying Islands",
    "Uruguay": "Uruguay",
    "Uzbekistan": "Uzbekistan",
    "Vanuatu": "Vanuatu",
    "Venezuela, Bolivarian Republic of": "Venezuela",
    "Viet Nam": "Vietnam",
    "Virgin Islands, British": "Virgin Islands (British)",
    "Virgin Islands, U.S.": "Virgin Islands (U.S.)",
    "Wallis and Futuna": "Wallis and Futuna Islands",
    "Western Sahara": "Western Sahara",
    "Yemen": "Yemen",
    "Zambia": "Zambia",
    "Zimbabwe": "Zimbabwe",
}

education_map = {
    "High school": "SSOL",
    "Less than high school": "SSOL",
    "Associate": "AD",
    "Diploma/Certificate": "DCNT",
    "Diploma/Certificate (trades)": "DCT",
    "Bachelor": "BD",
    "Post-graduate diploma": "PBD",
    "Master": "MD",
    "Doctor": "PHD",
}


def getEducation(edu_level, is_trade=None):
    return (
        education_map[edu_level + " (trades)"]
        if is_trade and edu_level == "Diploma/Certificate"
        else education_map[edu_level]
    )


eca_map = {
    "Comparative Education Service - University of Toronto School of Continuing Studies": "CES",
    "International Credential Assessment Service of Canada": "ICA",
    "World Education Services": "WES",
    "International Qualifications Assessment Service": "IQA",
    "International Credential Evaluation Service": "ICE",
    "Medical Council of Canada (for Doctors)": "MCC",
    "Pharmacy Examining Board of Canada (for Pharmacists)": "PEB",
}
