<!--
    Thank you for contributing to our project!
-->

## Description

<!--
    Please describe your changes here, especially focusing on why this PR makes
    ESMValCore better and what problem it solves.

    Before you start, please read our [contribution guidelines](https://docs.esmvaltool.org/projects/ESMValCore/en/latest/contributing.html).

    Please fill in the GitHub issue that is closed by this pull request, e.g. Closes #1903
-->

-   Closes #issue_number
-   Link to documentation:

***

## Before you get started

-   [ ] [☝ Create an issue](https://github.com/ESMValGroup/ESMValCore/issues) to discuss what you are going to do

## Checklist

-   [ ] PR has a descriptive title for the [changelog](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#branches-pull-requests-and-code-review)
-   [ ] Labels are assigned so they can be used in the [changelog](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#branches-pull-requests-and-code-review)
-   [ ] Code follows the [style guide](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#code-style)
-   [ ] [Documentation](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#documentation) is available for new functionality
-   [ ] YAML files pass [`pre-commit`](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#pre-commit) or [`yamllint`](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/community/introduction.html#yaml) checks
-   [ ] [Circle/CI tests pass](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#branches-pull-requests-and-code-review)
-   [ ] [Codacy code quality checks pass](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#branches-pull-requests-and-code-review)
-   [ ] [Documentation builds successfully](https://docs.esmvaltool.org/projects/esmvalcore/en/latest/contributing.html#branches-pull-requests-and-code-review) on readthedocs
-   [ ] [Unit tests](https://docs.esmvaltool.org/projects/esmvalcore/projects/esmvalcore/en/latest/contributing.html#contributing-to-the-esmvalcore-package) are available

If you make backwards incompatible changes to the recipe format:

-   [ ] Update [ESMValTool](https://github.com/esmvalgroup/esmvaltool) and link the pull request(s) in the description

***

To help with the number pull requests:

-   🙏 We kindly ask you to [review](https://docs.esmvaltool.org/en/latest/community/review.html#review-of-pull-requests) two other [open pull requests](https://github.com/ESMValGroup/ESMValTool/pulls) in this repository
