from typing import Any, Optional

class LayerMapError(Exception): ...
class InvalidString(LayerMapError): ...
class InvalidDecimal(LayerMapError): ...
class InvalidInteger(LayerMapError): ...
class MissingForeignKey(LayerMapError): ...

class LayerMapping:
    MULTI_TYPES: Any = ...
    FIELD_TYPES: Any = ...
    ds: Any = ...
    layer: Any = ...
    using: Any = ...
    spatial_backend: Any = ...
    mapping: Any = ...
    model: Any = ...
    geo_field: Any = ...
    source_srs: Any = ...
    transform: Any = ...
    encoding: Any = ...
    unique: Any = ...
    transaction_mode: Any = ...
    transaction_decorator: Any = ...
    def __init__(
        self,
        model: Any,
        data: Any,
        mapping: Any,
        layer: int = ...,
        source_srs: Optional[Any] = ...,
        encoding: str = ...,
        transaction_mode: str = ...,
        transform: bool = ...,
        unique: Optional[Any] = ...,
        using: Optional[Any] = ...,
    ) -> None: ...
    def check_fid_range(self, fid_range: Any): ...
    geom_field: bool = ...
    fields: Any = ...
    coord_dim: Any = ...
    def check_layer(self): ...
    def check_srs(self, source_srs: Any): ...
    def check_unique(self, unique: Any) -> None: ...
    def feature_kwargs(self, feat: Any): ...
    def unique_kwargs(self, kwargs: Any): ...
    def verify_ogr_field(self, ogr_field: Any, model_field: Any): ...
    def verify_fk(self, feat: Any, rel_model: Any, rel_mapping: Any): ...
    def verify_geom(self, geom: Any, model_field: Any): ...
    def coord_transform(self): ...
    def geometry_field(self): ...
    def make_multi(self, geom_type: Any, model_field: Any): ...
    def save(
        self,
        verbose: bool = ...,
        fid_range: bool = ...,
        step: bool = ...,
        progress: bool = ...,
        silent: bool = ...,
        stream: Any = ...,
        strict: bool = ...,
    ): ...
