# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['buildarr',
 'buildarr.cli',
 'buildarr.config',
 'buildarr.manager',
 'buildarr.plugins',
 'buildarr.plugins.dummy',
 'buildarr.plugins.dummy.config',
 'buildarr.plugins.sonarr',
 'buildarr.plugins.sonarr.config',
 'buildarr.plugins.sonarr.config.download_clients',
 'buildarr.plugins.sonarr.config.profiles']

package_data = \
{'': ['*']}

install_requires = \
['click-params>=0.4.0,<0.5.0',
 'click>=8.1.3,<9.0.0',
 'importlib-metadata>=6.0.0,<7.0.0',
 'json5>=0.9.10,<0.10.0',
 'pydantic[email]>=1.10.2,<2.0.0',
 'pyyaml>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'schedule>=1.1.0,<2.0.0',
 'stevedore>=4.1.1,<5.0.0',
 'typing-extensions>=4.4.0,<5.0.0',
 'watchdog>=2.2.0,<3.0.0']

entry_points = \
{'buildarr.plugins': ['dummy = buildarr.plugins.dummy.plugin:DummyPlugin',
                      'sonarr = buildarr.plugins.sonarr.plugin:SonarrPlugin'],
 'console_scripts': ['buildarr = buildarr.cli.main:main']}

setup_kwargs = {
    'name': 'buildarr',
    'version': '0.1.1',
    'description': 'Constructs and configures Arr PVR stacks',
    'long_description': '# Welcome to Buildarr!\n\n[![Docker Version](https://img.shields.io/docker/v/callum027/buildarr?sort=semver)](https://hub.docker.com/r/callum027/buildarr) [![PyPI](https://img.shields.io/pypi/v/buildarr)](https://pypi.org/project/buildarr) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/buildarr)  [![GitHub](https://img.shields.io/github/license/buildarr/buildarr)](https://github.com/buildarr/buildarr/blob/main/LICENSE) ![Pre-commit hooks](https://github.com/buildarr/buildarr/actions/workflows/pre-commit.yml/badge.svg) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\nThis is Buildarr, a solution to automating deployment and configuration of your *Arr stack.\n\nHave you spent many hours getting your setup for one or more linked Sonarr/Radarr/Prowlarr instances just right, only to have no way to reproduce this setup apart from UI screenshots and database backups?\n\nBuildarr aims to alleviate those concerns by using a static configuration file to store settings for all your *Arr applications, and automatically configure them as defined. It can just once using an ad-hoc user command, or as a service to keep your application configurations up to date. Buildarr runs idempotently, only making changes to your instance if they are required.\n\nIt can also automatically retrieve optimal configuration values from TRaSH-Guides for many things such as quality definitions and release profiles, so not only is there no need to manually input them into your configuration, Buildarr will also continually keep them up to date for you.\n\nThe full documentation for Buildarr is available [here](http://buildarr.github.io).\n\n## Similar projects\n\nBuildarr attempts to fulfill some of the needs of users of the following projects.\n\n* [Bobarr](https://github.com/iam4x/bobarr) - An all-in-one package containing Sonarr, Radarr, Jackett etc\n    * Still requires manual configuration of many components, and there is no way to store the configuration as code.\n* [Flemmarr](https://github.com/Flemmarr/Flemmarr) - Uses API parameters stored in YAML configuration files to push configuration changes to Sonarr, Radarr, Lidarr etc\n    * Requires users to comprehensively learn how the APIs of each application work, going through often poor documentation.\n    * Since the values are machine-oriented, configuration files are difficult to write and understand.\n    * Does not support idempotent updates ([at this time](https://github.com/Flemmarr/Flemmarr/pull/14)).\n* [Recyclarr](https://github.com/recyclarr/recyclarr) - Automatically syncs recommended TRaSH-Guides settings to Sonarr/Radarr instances\n    * Buildarr has support for this built-in, and in the case of Sonarr release profiles, supports the same filtering syntax.\n\n## Installation\n\nBuildarr is available on Docker Hub as a Docker image.\n\n```bash\n$ docker pull callum027/buildarr:latest\n```\n\nBuildarr can also be installed using `pip`. Python 3.8 or later is required. Windows is natively supported.\n\n```bash\n$ python3 -m venv buildarr-venv\n$ . buildarr-venv/bin/activate\n$ python3 -m pip install buildarr\n```\n\nYou can deploy Buildarr as a service within a [Docker Compose](https://docs.docker.com/compose) environment, or use configuration management tools such as [Ansible](https://www.ansible.com) to automatically deploy it.\n\nFor more information, check the [installation instructions](http://buildarr.github.io/installation).\n\n## Plugins\n\nBuildarr supports external plugins to allow additional applications to be supported. To allow for rapid development of both the plugin and the API, however, the one currently existing plugin, `buildarr-sonarr`, is vendored in as `buildarr.plugins.sonarr`.\n\nAt the time of this release the following plugins are available:\n\n* `buildarr-sonarr` - [Sonarr](https://sonarr.tv) PVR for TV shows (V3 only for now)\n\nFor more information on installing plugins and configuring the vendored plugins, check the [plugin documentation](http://buildarr.github.io/plugins).\n\n## Configuration\n\nBuildarr uses YAML as its configuration file format. By default, Buildarr looks for `buildarr.yml` in the current directory.\n\nIt contains not only the settings for Buildarr itself, but also the application instances to be managed. Multiple instances of the same application type can be defined (for example, a common use case would be separate Sonarr instances for HD TV shows, 4K TV shows, and anime).\n\nAny configuration on the remote instance not explicitly defined in the Buildarr configuration is not modified.\n\nFor more information on how Buildarr uses configuration and how to configure Buildarr itself, check the [configuration documentation](https://buildarr.github.io/configuration).\n\nHere is an example of a simple Buildarr configuration that changes some settings on a Sonarr instance:\n\n```yaml\n---\n# buildarr.yml\n# Buildarr example configuration file.\n\n# Buildarr configuration (all settings have sane default values)\nbuildarr:\n  watch_config: true\n  update_days:\n    - "monday"\n    - "tuesday"\n    - "wednesday"\n    - "thursday"\n    - "friday"\n    - "saturday"\n    - "sunday"\n  update_times:\n    - "03:00"\n\n# Sonarr instance configuration\nsonarr:\n  hostname: "localhost"\n  port: 8989\n  protocol: "http"\n  settings:\n    # General settings (all options supported except for changing the API key)\n    general:\n      host:\n        instance_name: "Sonarr (Buildarr Example)"\n```\n\nIf you have an already configured application instance, its configuration can be dumped. For example, to get the configuration of a Sonarr instance, this can be done using the following command (Buildarr will prompt for your API key):\n\n```bash\n$ docker run -it --rm callum027/buildarr:latest sonarr dump-config http://sonarr.example.com:8989\n```\n\nOnce you have this configuration, you can insert it into `buildarr.yml` and ensure this configuration is maintained.\n\n## Running Buildarr\n\nOnce you have a valid configuration file, you can try Buildarr on your local machine using the Docker image.\n\nThe following command will mount the current folder into the Docker container so `buildarr.yml` can be read, and start Buildarr in daemon mode.\n\n```bash\n$ docker run -d --name buildarr -v $(pwd):/config -e PUID=$(id -u) -e PGID=$(id -g) callum027/buildarr:latest\n```\n\nIf installed using `pip`, simply run the `buildarr` CLI command.\n\n```bash\n$ buildarr daemon\n```\n\nOn startup, Buildarr daemon will do an initial sync with the defined instances, updating their configuration immediately.\nAfter this initial run, Buildarr will wake up at the scheduled times to periodically run updates as required.\n\n```txt\n2023-02-11 13:43:48,890 buildarr:4308 buildarr.main [INFO] Buildarr version 0.1.0 (log level: INFO)\n2023-02-11 13:43:48,891 buildarr:4308 buildarr.main [INFO] Loading configuration file \'/config/buildarr.yml\'\n2023-02-11 13:43:48,898 buildarr:4308 buildarr.main [INFO] Finished loading configuration file\n2023-02-11 13:43:48,900 buildarr:4308 buildarr.main [INFO] Daemon configuration:\n2023-02-11 13:43:48,900 buildarr:4308 buildarr.main [INFO]  - Watch configuration files: Yes\n2023-02-11 13:43:48,900 buildarr:4308 buildarr.main [INFO]  - Configuration files to watch:\n2023-02-11 13:43:48,900 buildarr:4308 buildarr.main [INFO]    - /config/buildarr.yml\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]  - Update at:\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Monday 03:00\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Tuesday 03:00\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Wednesday 03:00\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Thursday 03:00\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Friday 03:00\n2023-02-11 13:43:48,901 buildarr:4308 buildarr.main [INFO]    - Saturday 03:00\n2023-02-11 13:43:48,902 buildarr:4308 buildarr.main [INFO]    - Sunday 03:00\n2023-02-11 13:43:48,902 buildarr:4308 buildarr.main [INFO] Applying initial configuration\n2023-02-11 13:43:48,904 buildarr:4308 buildarr.main [INFO] Plugins loaded: sonarr\n2023-02-11 13:43:48,906 buildarr:4308 buildarr.main [INFO] Using plugins: sonarr\n2023-02-11 13:43:48,907 buildarr:4308 buildarr.main [INFO] Loading secrets file from \'secrets.json\'\n2023-02-11 13:43:48,909 buildarr:4308 buildarr.main [INFO] Finished loading secrets file\n2023-02-11 13:43:48,910 buildarr:4308 buildarr.plugins.sonarr default [INFO] Checking and fetching secrets\n2023-02-11 13:43:48,910 buildarr:4308 buildarr.plugins.sonarr default [INFO] Finished checking and fetching secrets\n2023-02-11 13:43:48,910 buildarr:4308 buildarr.main [INFO] Saving updated secrets file to \'secrets.json\'\n2023-02-11 13:43:48,911 buildarr:4308 buildarr.main [INFO] Finished saving updated secrets file\n2023-02-11 13:43:48,914 buildarr:4308 buildarr.plugins.sonarr default [INFO] Getting remote configuration\n2023-02-11 13:43:49,870 buildarr:4308 buildarr.plugins.sonarr default [INFO] Finished getting remote configuration\n2023-02-11 13:43:49,914 buildarr:4308 buildarr.plugins.sonarr default [INFO] Updating remote configuration\n2023-02-11 13:43:49,954 buildarr:4308 buildarr.plugins.sonarr default [INFO] sonarr.settings.general.host.instance_name: \'Sonarr\' -> \'Sonarr (Buildarr Example)\'\n2023-02-11 13:43:50,177 buildarr:4308 buildarr.plugins.sonarr default [INFO] Remote configuration successfully updated\n2023-02-11 13:43:50,177 buildarr:4308 buildarr.plugins.sonarr default [INFO] Finished updating remote configuration\n2023-02-11 13:43:50,178 buildarr:4308 buildarr.main [INFO] Finished applying initial configuration\n2023-02-11 13:43:50,179 buildarr:4308 buildarr.main [INFO] Scheduling update jobs\n2023-02-11 13:43:50,180 buildarr:4308 buildarr.main [INFO] Finished scheduling update jobs\n2023-02-11 13:43:50,180 buildarr:4308 buildarr.main [INFO] The next run will be at 2023-02-12 03:00\n2023-02-11 13:43:50,181 buildarr:4308 buildarr.main [INFO] Setting up config file monitoring\n2023-02-11 13:43:50,183 buildarr:4308 buildarr.main [INFO] Finished setting up config file monitoring\n2023-02-11 13:43:50,183 buildarr:4308 buildarr.main [INFO] Setting up signal handlers\n2023-02-11 13:43:50,183 buildarr:4308 buildarr.main [INFO] Finished setting up signal handlers\n2023-02-11 13:43:50,184 buildarr:4308 buildarr.main [INFO] Buildarr ready.\n```\n\nFor more information on how to interfact with Buildarr, check the [usage documentation](https://buildarr.github.io/usage).\n\n## To-do list\n\n* Add a dry-run mode for testing configurations\n* Test updates for all available attributes in the existing Sonarr plugin\n* Unit tests and code coverage\n* Split Sonarr plugin to its own repository\n* Create plugins for the following applications:\n    * Sonarr V4\n    * Radarr\n    * Prowlarr\n    * Bazarr\n    * FlareSolverr\n    * Unmanic\n    * Tdarr (maybe)\n    * Unpackerr\n    * Lidarr\n* Instance linking (e.g. Prowlarr-to-Sonarr/Radarr) and dependency resolution\n* Stable plugin API between major versions\n* Auto-generation of Docker Compose environment files reflecting the Buildarr configuration\n\n## Contributions\n\nBuildarr is still early in development, and even currently implemented features still require testing and fixing. There are so many possible configurations to cover that I simply cannot feasibly test every feature at this time.\n\nIf you encounter an issue or error while using Buildarr, please do a Buildarr ad-hoc run with verbose log output by executing `buildarr --log-level DEBUG run` and making an issue on [our GitHub repository](https://github.com/buildarr/buildarr/issues/new) explaining the issue and attaching the output. (Please ensure that any API keys or other sensitive information are obfuscated before submitting.)\n\n```bash\n$ docker run -d --name buildarr -v $(pwd):/config -e PUID=$(id -u) -e PGID=$(id -g) callum027/buildarr:latest --log-level DEBUG run\n```\n\nFor developers looking to make a contribution to this project, thank you! Documentation of the internal APIs is still in the works, so for now, the best way to learn how Buildarr works is to clone the project and have a look at the comments and docstrings.\n\nPre-commit hooks are configured for this project. In this pre-commit hook, `black`, `flake8`, `isort` and `mypy` are run to automatically format source files, ensure grammatical correctness and variable type consistency.\n\nTo enable them, ensure the `pre-commit` Python package is installed in your local environment and run the following command:\n\n```bash\n$ pre-commit install\n```\n\nPoetry is used to manage the Python package definition and dependencies in this project.\n\nPull requests for Buildarr itself and the currently vendored plugins are welcome.\n\nIf you\'re looking to develop a new plugin for adding support for a new application, please develop it as a new package and configure entry points in your Python package definitions to allow Buildarr to load your plugin.\n\nSetuptools `setup.py` entry point definition example:\n```python\nfrom setuptools import setup\n\nsetup(\n    # ...,\n    entry_points={\n        "buildarr.plugins": [\n            "example = buildarr_example.plugin:ExamplePlugin",\n        ],\n    },\n)\n```\n\nSetuptools `setup.cfg` entry point definition example:\n```ini\n[options.entry_points]\nbuildarr.plugins =\n    example = buildarr_example.plugin:ExamplePlugin\n```\n\nSetuptools `pyproject.toml` entry point definition example:\n```toml\n[project.entry-points."buildarr.plugins"]\n"example" = "buildarr_example.plugin:ExamplePlugin"\n```\n\nPoetry plugin definition example:\n```toml\n[tool.poetry.plugins."buildarr.plugins"]\n"example" = "buildarr_example.plugin:ExamplePlugin"\n```\n',
    'author': 'Callum Dickinson',
    'author_email': 'callum.dickinson.nz@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
