/**
 * Utilities for figuring out what type the dtype string is.
 * NOTE: these should be identical to the Python utilities in mitosheet/sheet_functions/types/utils.py
 */
export function isBoolDtype(dtype) {
    return dtype == 'bool';
}
export function isIntDtype(dtype) {
    return dtype.includes('int');
}
export function isFloatDtype(dtype) {
    return dtype.includes('float');
}
export function isStringDtype(dtype) {
    return dtype == 'object' || dtype == 'str' || dtype == 'string';
}
export function isDatetimeDtype(dtype) {
    return dtype.includes('datetime');
}
export function isTimedeltaDtype(dtype) {
    return dtype.includes('timedelta');
}
export function isNumberDtype(dtype) {
    return isIntDtype(dtype) || isFloatDtype(dtype);
}
//# sourceMappingURL=dtypes.js.map