// Copyright (c) Mito
import React, { useState, useEffect } from 'react';
import "../../../../../css/taskpanes/ControlPanel/ColumnSummaryStatistics.css";
/*
    Displays the column summary statistics gotten from
    a call to .describe

    See examples here: https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.Series.describe.html
*/
function ColumnSummaryStatistics(props) {
    const [describe, setDescribe] = useState({});
    const [loading, setLoading] = useState(true);
    async function loadDescribe() {
        const loadedDescribe = await props.mitoAPI.getColumnDescribe(props.selectedSheetIndex, props.columnID);
        setDescribe(loadedDescribe);
        setLoading(false);
    }
    useEffect(() => {
        void loadDescribe();
    }, []);
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: 'text-header-3' },
            React.createElement("p", null, " Column Summary Statistics ")),
        React.createElement("div", { key: loading.toString() },
            !loading &&
                React.createElement("table", { className: 'column-describe-table-container' }, Object.keys(describe).map(key => {
                    return (React.createElement("tr", { className: 'column-describe-table-row', key: key },
                        React.createElement("th", null, key),
                        React.createElement("th", null, describe[key].substring(0, 15) + (describe[key].length > 15 ? '...' : ''))));
                })),
            loading &&
                React.createElement("p", null, "Column Summary statistics are loading..."))));
}
export default ColumnSummaryStatistics;
//# sourceMappingURL=ColumnSummaryStatistics.js.map