// Copyright (c) Mito
import React, { useEffect } from 'react';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
/*
    Displays a set of actions one can perform on a sheet tab, including
    deleting, duplicating, or renaming.
*/
export default function SheetTabActions(props) {
    // Log opening the sheet tab actions
    useEffect(() => {
        void props.mitoAPI.log('clicked_sheet_tab_actions', {
            sheet_index: props.sheetIndex
        });
    }, []);
    const onDelete = async () => {
        // If we are deleting the sheet index that is currently selected & it is not sheetIndex 0, update the selected sheet index
        if (props.sheetIndex === props.selectedSheetIndex && props.selectedSheetIndex !== 0) {
            props.setUIState(prevUIState => {
                return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: props.sheetIndex - 1 });
            });
        }
        // Close 
        props.closeOpenEditingPopups();
        await props.mitoAPI.editDataframeDelete(props.sheetIndex);
    };
    const onDuplicate = async () => {
        // Close 
        props.closeOpenEditingPopups();
        await props.mitoAPI.editDataframeDuplicate(props.sheetIndex);
    };
    /* Rename helper, which requires changes to the sheet tab itself */
    const onRename = () => {
        props.setIsRename(true);
    };
    return (React.createElement(Dropdown, { closeDropdown: () => props.setDisplayActions(false), width: 'small' },
        React.createElement(DropdownItem, { title: 'Delete', onClick: onDelete }),
        React.createElement(DropdownItem, { title: 'Duplicate', onClick: onDuplicate }),
        React.createElement(DropdownItem, { title: 'Rename', onClick: onRename })));
}
//# sourceMappingURL=SheetTabActions.js.map