// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
import SheetTabActions from './SheetTabActions';
import { classNames } from '../../utils/classNames';
import Input from '../elements/Input';
import { focusGrid } from '../endo/focusUtils';
// import icons
import SelectedSheetTabDropdownIcon from '../icons/SelectedSheetTabDropdownIcon';
import UnselectedSheetTabDropdownIcon from '../icons/UnselectedSheetTabDropdownIcon';
/*
    Component that displays a dataframe name at the bottom of the sheet, and
    furthermore renders the sheet actions if the sheet action dropdown is
    clicked.
*/
export default function SheetTab(props) {
    // We only set this as open if it the currOpenSheetTabActions
    const [displayActions, setDisplayActions] = useState(false);
    const [isRename, setIsRename] = useState(false);
    const [newDataframeName, setNewDataframeName] = useState(props.dfName);
    const isSelectedTab = props.selectedSheetIndex === props.sheetIndex;
    const selectedClass = isSelectedTab ? 'tab-selected' : '';
    // Make sure that if we change the df name that is displayed, we default to 
    // the right new dataframe name as well
    useEffect(() => {
        setNewDataframeName(props.dfName);
    }, [props.dfName]);
    const onRename = async () => {
        var _a;
        await props.mitoAPI.editDataframeRename(props.sheetIndex, newDataframeName);
        setDisplayActions(false);
        setIsRename(false);
        // Focus back on the grid
        const endoGridContainer = (_a = props.mitoContainerRef.current) === null || _a === void 0 ? void 0 : _a.querySelector('.endo-grid-container');
        focusGrid(endoGridContainer);
    };
    return (React.createElement("div", { className: classNames('tab', selectedClass), onClick: () => {
            props.setUIState(prevUIState => {
                return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: props.sheetIndex });
            });
        }, onDoubleClick: () => { setIsRename(true); } },
        React.createElement("div", { className: 'tab-content' },
            isRename &&
                React.createElement("form", { onSubmit: async (e) => { e.preventDefault(); await onRename(); }, onBlur: onRename },
                    React.createElement(Input, { value: newDataframeName, onChange: (e) => { setNewDataframeName(e.target.value); }, autoFocus: true })),
            !isRename &&
                React.createElement("p", { className: 'tab-sheet-name' }, props.dfName),
            React.createElement("div", { className: 'sheet-tab-dropdown-button-div', onClick: () => { setDisplayActions(true); } }, isSelectedTab ? React.createElement(SelectedSheetTabDropdownIcon, null) : React.createElement(UnselectedSheetTabDropdownIcon, null))),
        displayActions &&
            React.createElement(SheetTabActions, { setDisplayActions: setDisplayActions, setUIState: props.setUIState, closeOpenEditingPopups: props.closeOpenEditingPopups, setIsRename: setIsRename, dfName: props.dfName, selectedSheetIndex: props.selectedSheetIndex, sheetIndex: props.sheetIndex, mitoAPI: props.mitoAPI })));
}
//# sourceMappingURL=SheetTab.js.map