/*
Copyright (C) 2017 Ming-Shing Chen

This file is part of BitPolyMul.

BitPolyMul is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BitPolyMul is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BitPolyMul.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "libOTe/config.h"
#ifdef ENABLE_SILENTOT

#include "stdint.h"
#include "bpmDefines.h"
namespace bpm{

alignas(32) const uint64_t gfCantorto264[64*2] = {
 0x1, 0,
 0x19C9369F278ADC02, 0,
 0xA181E7D66F5FF794, 0,
 0x5DB84357CE785D08, 0,
 0xB973D466F5C9D0CA, 0,
 0x521AC889831A075E, 0,
 0x33CE8BEDDC8A656, 0,
 0xB5846C4E07B91010, 0,
 0x4087B8CBB37A32EC, 0,
 0xD0D3888C0AE17C, 0,
 0xAFD5AC70237F2222, 0,
 0xE3F5AF99CC3AAAF8, 0,
 0x5A1DB3B16A0B58B8, 0,
 0x9947C54FE7EE248, 0,
 0xE8EAF0E0068F544, 0,
 0xA2A113500B4B4F5A, 0,
 0xE96F9805D6CE0BB0, 0,
 0x53496F8B5C9EDD4C, 0,
 0xAD325CB6F4AC2A9E, 0,
 0x4A8DCF8BD7EDE826, 0,
 0xA3E9C552B6434210, 0,
 0x5FA92AD9C9BC7ED0, 0,
 0xA389F910CD7734DE, 0,
 0xE916F3DFCA4609D8, 0,
 0xF89578714BD28F96, 0,
 0x564DDA59237A3352, 0,
 0xAD33BC6CC75AED38, 0,
 0x57A3104FCD0E5F34, 0,
 0xB0F502E4CD60039A, 0,
 0xEB42E79F91F49F8C, 0,
 0x54E5BF3774B3F850, 0,
 0xB66864E6EC14B4D2, 0,
 0xED57CE778F0D6244, 0,
 0x523AAF9D6148BA24, 0,
 0xA8FCBFAAC14940C6, 0,
 0xE503EACFCEF77780, 0,
 0xF3746C7B5183A372, 0,
 0xEC50D77D2F416218, 0,
 0xF9CDF54569FE87E6, 0,
 0xE576269915705E2C, 0,
 0xEE2A197148FA8C72, 0,
 0x49E31453575F365A, 0,
 0xB86698D88ADD0BC0, 0,
 0x4F35FB218E7F37C0, 0,
 0xA306FEEA8A242832, 0,
 0x5E5F06A9DAEAD6E6, 0,
 0xBE13089ECC784EA0, 0,
 0xFE1A10738739C892, 0,
 0xE2266CEB0C5BC774, 0,
 0xF490E6ED40D1DD1A, 0,
 0xF3F5F515077E92F0, 0,
 0x467C20312E7EB0F0, 0,
 0xB06CAA4295D350C2, 0,
 0x5C5916D98A583C16, 0,
 0xA04DE5B4C7A1CEAC, 0,
 0x41430183D6E85EC0, 0,
 0xB361D8DABE3B3632, 0,
 0x4357375D88B88B56, 0,
 0xB057DCC8A19FBC9C, 0,
 0xF26E1791BE4B37C2, 0,
 0xE9F744031BFE63E4, 0,
 0xE50803875E9AB776, 0,
 0x44EE098F4D56753E, 0,
 0x9DC338F8399031B4, 0,
};




alignas(32) const uint64_t gfCantorto264_8R[(64/8)*256*2] = {
0x0,0,
0x1,0,
0x19c9369f278adc02,0,
0x19c9369f278adc03,0,
0xa181e7d66f5ff794,0,
0xa181e7d66f5ff795,0,
0xb848d14948d52b96,0,
0xb848d14948d52b97,0,
0x5db84357ce785d08,0,
0x5db84357ce785d09,0,
0x447175c8e9f2810a,0,
0x447175c8e9f2810b,0,
0xfc39a481a127aa9c,0,
0xfc39a481a127aa9d,0,
0xe5f0921e86ad769e,0,
0xe5f0921e86ad769f,0,
0xb973d466f5c9d0ca,0,
0xb973d466f5c9d0cb,0,
0xa0bae2f9d2430cc8,0,
0xa0bae2f9d2430cc9,0,
0x18f233b09a96275e,0,
0x18f233b09a96275f,0,
0x13b052fbd1cfb5c,0,
0x13b052fbd1cfb5d,0,
0xe4cb97313bb18dc2,0,
0xe4cb97313bb18dc3,0,
0xfd02a1ae1c3b51c0,0,
0xfd02a1ae1c3b51c1,0,
0x454a70e754ee7a56,0,
0x454a70e754ee7a57,0,
0x5c8346787364a654,0,
0x5c8346787364a655,0,
0x521ac889831a075e,0,
0x521ac889831a075f,0,
0x4bd3fe16a490db5c,0,
0x4bd3fe16a490db5d,0,
0xf39b2f5fec45f0ca,0,
0xf39b2f5fec45f0cb,0,
0xea5219c0cbcf2cc8,0,
0xea5219c0cbcf2cc9,0,
0xfa28bde4d625a56,0,
0xfa28bde4d625a57,0,
0x166bbd416ae88654,0,
0x166bbd416ae88655,0,
0xae236c08223dadc2,0,
0xae236c08223dadc3,0,
0xb7ea5a9705b771c0,0,
0xb7ea5a9705b771c1,0,
0xeb691cef76d3d794,0,
0xeb691cef76d3d795,0,
0xf2a02a7051590b96,0,
0xf2a02a7051590b97,0,
0x4ae8fb39198c2000,0,
0x4ae8fb39198c2001,0,
0x5321cda63e06fc02,0,
0x5321cda63e06fc03,0,
0xb6d15fb8b8ab8a9c,0,
0xb6d15fb8b8ab8a9d,0,
0xaf1869279f21569e,0,
0xaf1869279f21569f,0,
0x1750b86ed7f47d08,0,
0x1750b86ed7f47d09,0,
0xe998ef1f07ea10a,0,
0xe998ef1f07ea10b,0,
0x33ce8beddc8a656,0,
0x33ce8beddc8a657,0,
0x1af5de21fa427a54,0,
0x1af5de21fa427a55,0,
0xa2bd0f68b29751c2,0,
0xa2bd0f68b29751c3,0,
0xbb7439f7951d8dc0,0,
0xbb7439f7951d8dc1,0,
0x5e84abe913b0fb5e,0,
0x5e84abe913b0fb5f,0,
0x474d9d76343a275c,0,
0x474d9d76343a275d,0,
0xff054c3f7cef0cca,0,
0xff054c3f7cef0ccb,0,
0xe6cc7aa05b65d0c8,0,
0xe6cc7aa05b65d0c9,0,
0xba4f3cd82801769c,0,
0xba4f3cd82801769d,0,
0xa3860a470f8baa9e,0,
0xa3860a470f8baa9f,0,
0x1bcedb0e475e8108,0,
0x1bcedb0e475e8109,0,
0x207ed9160d45d0a,0,
0x207ed9160d45d0b,0,
0xe7f77f8fe6792b94,0,
0xe7f77f8fe6792b95,0,
0xfe3e4910c1f3f796,0,
0xfe3e4910c1f3f797,0,
0x467698598926dc00,0,
0x467698598926dc01,0,
0x5fbfaec6aeac0002,0,
0x5fbfaec6aeac0003,0,
0x512620375ed2a108,0,
0x512620375ed2a109,0,
0x48ef16a879587d0a,0,
0x48ef16a879587d0b,0,
0xf0a7c7e1318d569c,0,
0xf0a7c7e1318d569d,0,
0xe96ef17e16078a9e,0,
0xe96ef17e16078a9f,0,
0xc9e636090aafc00,0,
0xc9e636090aafc01,0,
0x155755ffb7202002,0,
0x155755ffb7202003,0,
0xad1f84b6fff50b94,0,
0xad1f84b6fff50b95,0,
0xb4d6b229d87fd796,0,
0xb4d6b229d87fd797,0,
0xe855f451ab1b71c2,0,
0xe855f451ab1b71c3,0,
0xf19cc2ce8c91adc0,0,
0xf19cc2ce8c91adc1,0,
0x49d41387c4448656,0,
0x49d41387c4448657,0,
0x501d2518e3ce5a54,0,
0x501d2518e3ce5a55,0,
0xb5edb70665632cca,0,
0xb5edb70665632ccb,0,
0xac24819942e9f0c8,0,
0xac24819942e9f0c9,0,
0x146c50d00a3cdb5e,0,
0x146c50d00a3cdb5f,0,
0xda5664f2db6075c,0,
0xda5664f2db6075d,0,
0xb5846c4e07b91010,0,
0xb5846c4e07b91011,0,
0xac4d5ad12033cc12,0,
0xac4d5ad12033cc13,0,
0x14058b9868e6e784,0,
0x14058b9868e6e785,0,
0xdccbd074f6c3b86,0,
0xdccbd074f6c3b87,0,
0xe83c2f19c9c14d18,0,
0xe83c2f19c9c14d19,0,
0xf1f51986ee4b911a,0,
0xf1f51986ee4b911b,0,
0x49bdc8cfa69eba8c,0,
0x49bdc8cfa69eba8d,0,
0x5074fe508114668e,0,
0x5074fe508114668f,0,
0xcf7b828f270c0da,0,
0xcf7b828f270c0db,0,
0x153e8eb7d5fa1cd8,0,
0x153e8eb7d5fa1cd9,0,
0xad765ffe9d2f374e,0,
0xad765ffe9d2f374f,0,
0xb4bf6961baa5eb4c,0,
0xb4bf6961baa5eb4d,0,
0x514ffb7f3c089dd2,0,
0x514ffb7f3c089dd3,0,
0x4886cde01b8241d0,0,
0x4886cde01b8241d1,0,
0xf0ce1ca953576a46,0,
0xf0ce1ca953576a47,0,
0xe9072a3674ddb644,0,
0xe9072a3674ddb645,0,
0xe79ea4c784a3174e,0,
0xe79ea4c784a3174f,0,
0xfe579258a329cb4c,0,
0xfe579258a329cb4d,0,
0x461f4311ebfce0da,0,
0x461f4311ebfce0db,0,
0x5fd6758ecc763cd8,0,
0x5fd6758ecc763cd9,0,
0xba26e7904adb4a46,0,
0xba26e7904adb4a47,0,
0xa3efd10f6d519644,0,
0xa3efd10f6d519645,0,
0x1ba700462584bdd2,0,
0x1ba700462584bdd3,0,
0x26e36d9020e61d0,0,
0x26e36d9020e61d1,0,
0x5eed70a1716ac784,0,
0x5eed70a1716ac785,0,
0x4724463e56e01b86,0,
0x4724463e56e01b87,0,
0xff6c97771e353010,0,
0xff6c97771e353011,0,
0xe6a5a1e839bfec12,0,
0xe6a5a1e839bfec13,0,
0x35533f6bf129a8c,0,
0x35533f6bf129a8d,0,
0x1a9c05699898468e,0,
0x1a9c05699898468f,0,
0xa2d4d420d04d6d18,0,
0xa2d4d420d04d6d19,0,
0xbb1de2bff7c7b11a,0,
0xbb1de2bff7c7b11b,0,
0xb6b884f0da71b646,0,
0xb6b884f0da71b647,0,
0xaf71b26ffdfb6a44,0,
0xaf71b26ffdfb6a45,0,
0x17396326b52e41d2,0,
0x17396326b52e41d3,0,
0xef055b992a49dd0,0,
0xef055b992a49dd1,0,
0xeb00c7a71409eb4e,0,
0xeb00c7a71409eb4f,0,
0xf2c9f1383383374c,0,
0xf2c9f1383383374d,0,
0x4a8120717b561cda,0,
0x4a8120717b561cdb,0,
0x534816ee5cdcc0d8,0,
0x534816ee5cdcc0d9,0,
0xfcb50962fb8668c,0,
0xfcb50962fb8668d,0,
0x160266090832ba8e,0,
0x160266090832ba8f,0,
0xae4ab74040e79118,0,
0xae4ab74040e79119,0,
0xb78381df676d4d1a,0,
0xb78381df676d4d1b,0,
0x527313c1e1c03b84,0,
0x527313c1e1c03b85,0,
0x4bba255ec64ae786,0,
0x4bba255ec64ae787,0,
0xf3f2f4178e9fcc10,0,
0xf3f2f4178e9fcc11,0,
0xea3bc288a9151012,0,
0xea3bc288a9151013,0,
0xe4a24c79596bb118,0,
0xe4a24c79596bb119,0,
0xfd6b7ae67ee16d1a,0,
0xfd6b7ae67ee16d1b,0,
0x4523abaf3634468c,0,
0x4523abaf3634468d,0,
0x5cea9d3011be9a8e,0,
0x5cea9d3011be9a8f,0,
0xb91a0f2e9713ec10,0,
0xb91a0f2e9713ec11,0,
0xa0d339b1b0993012,0,
0xa0d339b1b0993013,0,
0x189be8f8f84c1b84,0,
0x189be8f8f84c1b85,0,
0x152de67dfc6c786,0,
0x152de67dfc6c787,0,
0x5dd1981faca261d2,0,
0x5dd1981faca261d3,0,
0x4418ae808b28bdd0,0,
0x4418ae808b28bdd1,0,
0xfc507fc9c3fd9646,0,
0xfc507fc9c3fd9647,0,
0xe5994956e4774a44,0,
0xe5994956e4774a45,0,
0x69db4862da3cda,0,
0x69db4862da3cdb,0,
0x19a0edd74550e0d8,0,
0x19a0edd74550e0d9,0,
0xa1e83c9e0d85cb4e,0,
0xa1e83c9e0d85cb4f,0,
0xb8210a012a0f174c,0,
0xb8210a012a0f174d,0,
0x0,0,
0x4087b8cbb37a32ec,0,
0xd0d3888c0ae17c,0,
0x40576b433f70d390,0,
0xafd5ac70237f2222,0,
0xef5214bb900510ce,0,
0xaf057ff8af75c35e,0,
0xef82c7331c0ff1b2,0,
0xe3f5af99cc3aaaf8,0,
0xa37217527f409814,0,
0xe3257c1140304b84,0,
0xa3a2c4daf34a7968,0,
0x4c2003e9ef4588da,0,
0xca7bb225c3fba36,0,
0x4cf0d061634f69a6,0,
0xc7768aad0355b4a,0,
0x5a1db3b16a0b58b8,0,
0x1a9a0b7ad9716a54,0,
0x5acd6039e601b9c4,0,
0x1a4ad8f2557b8b28,0,
0xf5c81fc149747a9a,0,
0xb54fa70afa0e4876,0,
0xf518cc49c57e9be6,0,
0xb59f74827604a90a,0,
0xb9e81c28a631f240,0,
0xf96fa4e3154bc0ac,0,
0xb938cfa02a3b133c,0,
0xf9bf776b994121d0,0,
0x163db058854ed062,0,
0x56ba08933634e28e,0,
0x16ed63d00944311e,0,
0x566adb1bba3e03f2,0,
0x9947c54fe7ee248,0,
0x4913c49f4d04d0a4,0,
0x944afdc72740334,0,
0x49c31717c10e31d8,0,
0xa641d024dd01c06a,0,
0xe6c668ef6e7bf286,0,
0xa69103ac510b2116,0,
0xe616bb67e27113fa,0,
0xea61d3cd324448b0,0,
0xaae66b06813e7a5c,0,
0xeab10045be4ea9cc,0,
0xaa36b88e0d349b20,0,
0x45b47fbd113b6a92,0,
0x533c776a241587e,0,
0x4564ac359d318bee,0,
0x5e314fe2e4bb902,0,
0x5389cfe59475baf0,0,
0x130e772e270f881c,0,
0x53591c6d187f5b8c,0,
0x13dea4a6ab056960,0,
0xfc5c6395b70a98d2,0,
0xbcdbdb5e0470aa3e,0,
0xfc8cb01d3b0079ae,0,
0xbc0b08d6887a4b42,0,
0xb07c607c584f1008,0,
0xf0fbd8b7eb3522e4,0,
0xb0acb3f4d445f174,0,
0xf02b0b3f673fc398,0,
0x1fa9cc0c7b30322a,0,
0x5f2e74c7c84a00c6,0,
0x1f791f84f73ad356,0,
0x5ffea74f4440e1ba,0,
0xe8eaf0e0068f544,0,
0x4e0917c5b312c7a8,0,
0xe5e7c868c621438,0,
0x4ed9c44d3f1826d4,0,
0xa15b037e2317d766,0,
0xe1dcbbb5906de58a,0,
0xa18bd0f6af1d361a,0,
0xe10c683d1c6704f6,0,
0xed7b0097cc525fbc,0,
0xadfcb85c7f286d50,0,
0xedabd31f4058bec0,0,
0xad2c6bd4f3228c2c,0,
0x42aeace7ef2d7d9e,0,
0x229142c5c574f72,0,
0x427e7f6f63279ce2,0,
0x2f9c7a4d05dae0e,0,
0x54931cbf6a63adfc,0,
0x1414a474d9199f10,0,
0x5443cf37e6694c80,0,
0x14c477fc55137e6c,0,
0xfb46b0cf491c8fde,0,
0xbbc10804fa66bd32,0,
0xfb966347c5166ea2,0,
0xbb11db8c766c5c4e,0,
0xb766b326a6590704,0,
0xf7e10bed152335e8,0,
0xb7b660ae2a53e678,0,
0xf731d8659929d494,0,
0x18b31f5685262526,0,
0x5834a79d365c17ca,0,
0x1863ccde092cc45a,0,
0x58e47415ba56f6b6,0,
0x71ad35afe16170c,0,
0x479d6b914d6c25e0,0,
0x7ca00d2721cf670,0,
0x474db819c166c49c,0,
0xa8cf7f2add69352e,0,
0xe848c7e16e1307c2,0,
0xa81faca25163d452,0,
0xe8981469e219e6be,0,
0xe4ef7cc3322cbdf4,0,
0xa468c40881568f18,0,
0xe43faf4bbe265c88,0,
0xa4b817800d5c6e64,0,
0x4b3ad0b311539fd6,0,
0xbbd6878a229ad3a,0,
0x4bea033b9d597eaa,0,
0xb6dbbf02e234c46,0,
0x5d0760eb941d4fb4,0,
0x1d80d82027677d58,0,
0x5dd7b3631817aec8,0,
0x1d500ba8ab6d9c24,0,
0xf2d2cc9bb7626d96,0,
0xb255745004185f7a,0,
0xf2021f133b688cea,0,
0xb285a7d88812be06,0,
0xbef2cf725827e54c,0,
0xfe7577b9eb5dd7a0,0,
0xbe221cfad42d0430,0,
0xfea5a431675736dc,0,
0x112763027b58c76e,0,
0x51a0dbc9c822f582,0,
0x11f7b08af7522612,0,
0x51700841442814fe,0,
0xa2a113500b4b4f5a,0,
0xe226ab9bb8317db6,0,
0xa271c0d88741ae26,0,
0xe2f67813343b9cca,0,
0xd74bf2028346d78,0,
0x4df307eb9b4e5f94,0,
0xda46ca8a43e8c04,0,
0x4d23d4631744bee8,0,
0x4154bcc9c771e5a2,0,
0x1d30402740bd74e,0,
0x41846f414b7b04de,0,
0x103d78af8013632,0,
0xee8110b9e40ec780,0,
0xae06a8725774f56c,0,
0xee51c331680426fc,0,
0xaed67bfadb7e1410,0,
0xf8bca0e1614017e2,0,
0xb83b182ad23a250e,0,
0xf86c7369ed4af69e,0,
0xb8ebcba25e30c472,0,
0x57690c91423f35c0,0,
0x17eeb45af145072c,0,
0x57b9df19ce35d4bc,0,
0x173e67d27d4fe650,0,
0x1b490f78ad7abd1a,0,
0x5bceb7b31e008ff6,0,
0x1b99dcf021705c66,0,
0x5b1e643b920a6e8a,0,
0xb49ca3088e059f38,0,
0xf41b1bc33d7fadd4,0,
0xb44c7080020f7e44,0,
0xf4cbc84bb1754ca8,0,
0xab356f04f535ad12,0,
0xebb2d7cf464f9ffe,0,
0xabe5bc8c793f4c6e,0,
0xeb620447ca457e82,0,
0x4e0c374d64a8f30,0,
0x44677bbf6530bddc,0,
0x43010fc5a406e4c,0,
0x44b7a837e93a5ca0,0,
0x48c0c09d390f07ea,0,
0x84778568a753506,0,
0x48101315b505e696,0,
0x897abde067fd47a,0,
0xe7156ced1a7025c8,0,
0xa792d426a90a1724,0,
0xe7c5bf65967ac4b4,0,
0xa74207ae2500f658,0,
0xf128dcb59f3ef5aa,0,
0xb1af647e2c44c746,0,
0xf1f80f3d133414d6,0,
0xb17fb7f6a04e263a,0,
0x5efd70c5bc41d788,0,
0x1e7ac80e0f3be564,0,
0x5e2da34d304b36f4,0,
0x1eaa1b8683310418,0,
0x12dd732c53045f52,0,
0x525acbe7e07e6dbe,0,
0x120da0a4df0ebe2e,0,
0x528a186f6c748cc2,0,
0xbd08df5c707b7d70,0,
0xfd8f6797c3014f9c,0,
0xbdd80cd4fc719c0c,0,
0xfd5fb41f4f0baee0,0,
0xac2fbc5e0b23ba1e,0,
0xeca80495b85988f2,0,
0xacff6fd687295b62,0,
0xec78d71d3453698e,0,
0x3fa102e285c983c,0,
0x437da8e59b26aad0,0,
0x32ac3a6a4567940,0,
0x43ad7b6d172c4bac,0,
0x4fda13c7c71910e6,0,
0xf5dab0c7463220a,0,
0x4f0ac04f4b13f19a,0,
0xf8d7884f869c376,0,
0xe00fbfb7e46632c4,0,
0xa088077c571c0028,0,
0xe0df6c3f686cd3b8,0,
0xa058d4f4db16e154,0,
0xf6320fef6128e2a6,0,
0xb6b5b724d252d04a,0,
0xf6e2dc67ed2203da,0,
0xb66564ac5e583136,0,
0x59e7a39f4257c084,0,
0x19601b54f12df268,0,
0x59377017ce5d21f8,0,
0x19b0c8dc7d271314,0,
0x15c7a076ad12485e,0,
0x554018bd1e687ab2,0,
0x151773fe2118a922,0,
0x5590cb3592629bce,0,
0xba120c068e6d6a7c,0,
0xfa95b4cd3d175890,0,
0xbac2df8e02678b00,0,
0xfa456745b11db9ec,0,
0xa5bbc00af55d5856,0,
0xe53c78c146276aba,0,
0xa56b13827957b92a,0,
0xe5ecab49ca2d8bc6,0,
0xa6e6c7ad6227a74,0,
0x4ae9d4b165584898,0,
0xabebff25a289b08,0,
0x4a390739e952a9e4,0,
0x464e6f933967f2ae,0,
0x6c9d7588a1dc042,0,
0x469ebc1bb56d13d2,0,
0x61904d00617213e,0,
0xe99bc3e31a18d08c,0,
0xa91c7b28a962e260,0,
0xe94b106b961231f0,0,
0xa9cca8a02568031c,0,
0xffa673bb9f5600ee,0,
0xbf21cb702c2c3202,0,
0xff76a033135ce192,0,
0xbff118f8a026d37e,0,
0x5073dfcbbc2922cc,0,
0x10f467000f531020,0,
0x50a30c433023c3b0,0,
0x1024b4888359f15c,0,
0x1c53dc22536caa16,0,
0x5cd464e9e01698fa,0,
0x1c830faadf664b6a,0,
0x5c04b7616c1c7986,0,
0xb386705270138834,0,
0xf301c899c369bad8,0,
0xb356a3dafc196948,0,
0xf3d11b114f635ba4,0,
0x0,0,
0xe96f9805d6ce0bb0,0,
0x53496f8b5c9edd4c,0,
0xba26f78e8a50d6fc,0,
0xad325cb6f4ac2a9e,0,
0x445dc4b32262212e,0,
0xfe7b333da832f7d2,0,
0x1714ab387efcfc62,0,
0x4a8dcf8bd7ede826,0,
0xa3e2578e0123e396,0,
0x19c4a0008b73356a,0,
0xf0ab38055dbd3eda,0,
0xe7bf933d2341c2b8,0,
0xed00b38f58fc908,0,
0xb4f6fcb67fdf1ff4,0,
0x5d9964b3a9111444,0,
0xa3e9c552b6434210,0,
0x4a865d57608d49a0,0,
0xf0a0aad9eadd9f5c,0,
0x19cf32dc3c1394ec,0,
0xedb99e442ef688e,0,
0xe7b401e19421633e,0,
0x5d92f66f1e71b5c2,0,
0xb4fd6e6ac8bfbe72,0,
0xe9640ad961aeaa36,0,
0xb92dcb760a186,0,
0xba2d65523d30777a,0,
0x5342fd57ebfe7cca,0,
0x4456566f950280a8,0,
0xad39ce6a43cc8b18,0,
0x171f39e4c99c5de4,0,
0xfe70a1e11f525654,0,
0x5fa92ad9c9bc7ed0,0,
0xb6c6b2dc1f727560,0,
0xce045529522a39c,0,
0xe58fdd5743eca82c,0,
0xf29b766f3d10544e,0,
0x1bf4ee6aebde5ffe,0,
0xa1d219e4618e8902,0,
0x48bd81e1b74082b2,0,
0x1524e5521e5196f6,0,
0xfc4b7d57c89f9d46,0,
0x466d8ad942cf4bba,0,
0xaf0212dc9401400a,0,
0xb816b9e4eafdbc68,0,
0x517921e13c33b7d8,0,
0xeb5fd66fb6636124,0,
0x2304e6a60ad6a94,0,
0xfc40ef8b7fff3cc0,0,
0x152f778ea9313770,0,
0xaf0980002361e18c,0,
0x46661805f5afea3c,0,
0x5172b33d8b53165e,0,
0xb81d2b385d9d1dee,0,
0x23bdcb6d7cdcb12,0,
0xeb5444b30103c0a2,0,
0xb6cd2000a812d4e6,0,
0x5fa2b8057edcdf56,0,
0xe5844f8bf48c09aa,0,
0xcebd78e2242021a,0,
0x1bff7cb65cbefe78,0,
0xf290e4b38a70f5c8,0,
0x48b6133d00202334,0,
0xa1d98b38d6ee2884,0,
0xa389f910cd7734de,0,
0x4ae661151bb93f6e,0,
0xf0c0969b91e9e992,0,
0x19af0e9e4727e222,0,
0xebba5a639db1e40,0,
0xe7d43da3ef1515f0,0,
0x5df2ca2d6545c30c,0,
0xb49d5228b38bc8bc,0,
0xe904369b1a9adcf8,0,
0x6bae9ecc54d748,0,
0xba4d5910460401b4,0,
0x5322c11590ca0a04,0,
0x44366a2dee36f666,0,
0xad59f22838f8fdd6,0,
0x177f05a6b2a82b2a,0,
0xfe109da36466209a,0,
0x603c427b3476ce,0,
0xe90fa447adfa7d7e,0,
0x532953c927aaab82,0,
0xba46cbccf164a032,0,
0xad5260f48f985c50,0,
0x443df8f1595657e0,0,
0xfe1b0f7fd306811c,0,
0x1774977a05c88aac,0,
0x4aedf3c9acd99ee8,0,
0xa3826bcc7a179558,0,
0x19a49c42f04743a4,0,
0xf0cb044726894814,0,
0xe7dfaf7f5875b476,0,
0xeb0377a8ebbbfc6,0,
0xb496c0f404eb693a,0,
0x5df958f1d225628a,0,
0xfc20d3c904cb4a0e,0,
0x154f4bccd20541be,0,
0xaf69bc4258559742,0,
0x460624478e9b9cf2,0,
0x51128f7ff0676090,0,
0xb87d177a26a96b20,0,
0x25be0f4acf9bddc,0,
0xeb3478f17a37b66c,0,
0xb6ad1c42d326a228,0,
0x5fc2844705e8a998,0,
0xe5e473c98fb87f64,0,
0xc8bebcc597674d4,0,
0x1b9f40f4278a88b6,0,
0xf2f0d8f1f1448306,0,
0x48d62f7f7b1455fa,0,
0xa1b9b77aadda5e4a,0,
0x5fc9169bb288081e,0,
0xb6a68e9e644603ae,0,
0xc807910ee16d552,0,
0xe5efe11538d8dee2,0,
0xf2fb4a2d46242280,0,
0x1b94d22890ea2930,0,
0xa1b225a61abaffcc,0,
0x48ddbda3cc74f47c,0,
0x1544d9106565e038,0,
0xfc2b4115b3abeb88,0,
0x460db69b39fb3d74,0,
0xaf622e9eef3536c4,0,
0xb87685a691c9caa6,0,
0x51191da34707c116,0,
0xeb3fea2dcd5717ea,0,
0x25072281b991c5a,0,
0xe916f3dfca4609d8,0,
0x796bda1c880268,0,
0xba5f9c5496d8d494,0,
0x533004514016df24,0,
0x4424af693eea2346,0,
0xad4b376ce82428f6,0,
0x176dc0e26274fe0a,0,
0xfe0258e7b4baf5ba,0,
0xa39b3c541dabe1fe,0,
0x4af4a451cb65ea4e,0,
0xf0d253df41353cb2,0,
0x19bdcbda97fb3702,0,
0xea960e2e907cb60,0,
0xe7c6f8e73fc9c0d0,0,
0x5de00f69b599162c,0,
0xb48f976c63571d9c,0,
0x4aff368d7c054bc8,0,
0xa390ae88aacb4078,0,
0x19b65906209b9684,0,
0xf0d9c103f6559d34,0,
0xe7cd6a3b88a96156,0,
0xea2f23e5e676ae6,0,
0xb48405b0d437bc1a,0,
0x5deb9db502f9b7aa,0,
0x72f906abe8a3ee,0,
0xe91d61037d26a85e,0,
0x533b968df7767ea2,0,
0xba540e8821b87512,0,
0xad40a5b05f448970,0,
0x442f3db5898a82c0,0,
0xfe09ca3b03da543c,0,
0x1766523ed5145f8c,0,
0xb6bfd90603fa7708,0,
0x5fd04103d5347cb8,0,
0xe5f6b68d5f64aa44,0,
0xc992e8889aaa1f4,0,
0x1b8d85b0f7565d96,0,
0xf2e21db521985626,0,
0x48c4ea3babc880da,0,
0xa1ab723e7d068b6a,0,
0xfc32168dd4179f2e,0,
0x155d8e8802d9949e,0,
0xaf7b790688894262,0,
0x4614e1035e4749d2,0,
0x51004a3b20bbb5b0,0,
0xb86fd23ef675be00,0,
0x24925b07c2568fc,0,
0xeb26bdb5aaeb634c,0,
0x15561c54b5b93518,0,
0xfc39845163773ea8,0,
0x461f73dfe927e854,0,
0xaf70ebda3fe9e3e4,0,
0xb86440e241151f86,0,
0x510bd8e797db1436,0,
0xeb2d2f691d8bc2ca,0,
0x242b76ccb45c97a,0,
0x5fdbd3df6254dd3e,0,
0xb6b44bdab49ad68e,0,
0xc92bc543eca0072,0,
0xe5fd2451e8040bc2,0,
0xf2e98f6996f8f7a0,0,
0x1b86176c4036fc10,0,
0xa1a0e0e2ca662aec,0,
0x48cf78e71ca8215c,0,
0x4a9f0acf07313d06,0,
0xa3f092cad1ff36b6,0,
0x19d665445bafe04a,0,
0xf0b9fd418d61ebfa,0,
0xe7ad5679f39d1798,0,
0xec2ce7c25531c28,0,
0xb4e439f2af03cad4,0,
0x5d8ba1f779cdc164,0,
0x12c544d0dcd520,0,
0xe97d5d410612de90,0,
0x535baacf8c42086c,0,
0xba3432ca5a8c03dc,0,
0xad2099f22470ffbe,0,
0x444f01f7f2bef40e,0,
0xfe69f67978ee22f2,0,
0x17066e7cae202942,0,
0xe976cf9db1727f16,0,
0x19579867bc74a6,0,
0xba3fa016edeca25a,0,
0x535038133b22a9ea,0,
0x4444932b45de5588,0,
0xad2b0b2e93105e38,0,
0x170dfca0194088c4,0,
0xfe6264a5cf8e8374,0,
0xa3fb0016669f9730,0,
0x4a949813b0519c80,0,
0xf0b26f9d3a014a7c,0,
0x19ddf798eccf41cc,0,
0xec95ca09233bdae,0,
0xe7a6c4a544fdb61e,0,
0x5d80332bcead60e2,0,
0xb4efab2e18636b52,0,
0x15362016ce8d43d6,0,
0xfc59b81318434866,0,
0x467f4f9d92139e9a,0,
0xaf10d79844dd952a,0,
0xb8047ca03a216948,0,
0x516be4a5ecef62f8,0,
0xeb4d132b66bfb404,0,
0x2228b2eb071bfb4,0,
0x5fbbef9d1960abf0,0,
0xb6d47798cfaea040,0,
0xcf2801645fe76bc,0,
0xe59d181393307d0c,0,
0xf289b32bedcc816e,0,
0x1be62b2e3b028ade,0,
0xa1c0dca0b1525c22,0,
0x48af44a5679c5792,0,
0xb6dfe54478ce01c6,0,
0x5fb07d41ae000a76,0,
0xe5968acf2450dc8a,0,
0xcf912caf29ed73a,0,
0x1bedb9f28c622b58,0,
0xf28221f75aac20e8,0,
0x48a4d679d0fcf614,0,
0xa1cb4e7c0632fda4,0,
0xfc522acfaf23e9e0,0,
0x153db2ca79ede250,0,
0xaf1b4544f3bd34ac,0,
0x4674dd4125733f1c,0,
0x516076795b8fc37e,0,
0xb80fee7c8d41c8ce,0,
0x22919f207111e32,0,
0xeb4681f7d1df1582,0,
0x0,0,
0xf89578714bd28f96,0,
0x564dda59237a3352,0,
0xaed8a22868a8bcc4,0,
0xad33bc6cc75aed38,0,
0x55a6c41d8c8862ae,0,
0xfb7e6635e420de6a,0,
0x3eb1e44aff251fc,0,
0x57a3104fcd0e5f34,0,
0xaf36683e86dcd0a2,0,
0x1eeca16ee746c66,0,
0xf97bb267a5a6e3f0,0,
0xfa90ac230a54b20c,0,
0x205d45241863d9a,0,
0xacdd767a292e815e,0,
0x54480e0b62fc0ec8,0,
0xb0f502e4cd60039a,0,
0x48607a9586b28c0c,0,
0xe6b8d8bdee1a30c8,0,
0x1e2da0cca5c8bf5e,0,
0x1dc6be880a3aeea2,0,
0xe553c6f941e86134,0,
0x4b8b64d12940ddf0,0,
0xb31e1ca062925266,0,
0xe75612ab006e5cae,0,
0x1fc36ada4bbcd338,0,
0xb11bc8f223146ffc,0,
0x498eb08368c6e06a,0,
0x4a65aec7c734b196,0,
0xb2f0d6b68ce63e00,0,
0x1c28749ee44e82c4,0,
0xe4bd0cefaf9c0d52,0,
0xeb42e79f91f49f8c,0,
0x13d79feeda26101a,0,
0xbd0f3dc6b28eacde,0,
0x459a45b7f95c2348,0,
0x46715bf356ae72b4,0,
0xbee423821d7cfd22,0,
0x103c81aa75d441e6,0,
0xe8a9f9db3e06ce70,0,
0xbce1f7d05cfac0b8,0,
0x44748fa117284f2e,0,
0xeaac2d897f80f3ea,0,
0x123955f834527c7c,0,
0x11d24bbc9ba02d80,0,
0xe94733cdd072a216,0,
0x479f91e5b8da1ed2,0,
0xbf0ae994f3089144,0,
0x5bb7e57b5c949c16,0,
0xa3229d0a17461380,0,
0xdfa3f227feeaf44,0,
0xf56f4753343c20d2,0,
0xf68459179bce712e,0,
0xe112166d01cfeb8,0,
0xa0c9834eb8b4427c,0,
0x585cfb3ff366cdea,0,
0xc14f534919ac322,0,
0xf4818d45da484cb4,0,
0x5a592f6db2e0f070,0,
0xa2cc571cf9327fe6,0,
0xa127495856c02e1a,0,
0x59b231291d12a18c,0,
0xf76a930175ba1d48,0,
0xfffeb703e6892de,0,
0x54e5bf3774b3f850,0,
0xac70c7463f6177c6,0,
0x2a8656e57c9cb02,0,
0xfa3d1d1f1c1b4494,0,
0xf9d6035bb3e91568,0,
0x1437b2af83b9afe,0,
0xaf9bd9029093263a,0,
0x570ea173db41a9ac,0,
0x346af78b9bda764,0,
0xfbd3d709f26f28f2,0,
0x550b75219ac79436,0,
0xad9e0d50d1151ba0,0,
0xae7513147ee74a5c,0,
0x56e06b653535c5ca,0,
0xf838c94d5d9d790e,0,
0xadb13c164ff698,0,
0xe410bdd3b9d3fbca,0,
0x1c85c5a2f201745c,0,
0xb25d678a9aa9c898,0,
0x4ac81ffbd17b470e,0,
0x492301bf7e8916f2,0,
0xb1b679ce355b9964,0,
0x1f6edbe65df325a0,0,
0xe7fba3971621aa36,0,
0xb3b3ad9c74dda4fe,0,
0x4b26d5ed3f0f2b68,0,
0xe5fe77c557a797ac,0,
0x1d6b0fb41c75183a,0,
0x1e8011f0b38749c6,0,
0xe6156981f855c650,0,
0x48cdcba990fd7a94,0,
0xb058b3d8db2ff502,0,
0xbfa758a8e54767dc,0,
0x473220d9ae95e84a,0,
0xe9ea82f1c63d548e,0,
0x117ffa808defdb18,0,
0x1294e4c4221d8ae4,0,
0xea019cb569cf0572,0,
0x44d93e9d0167b9b6,0,
0xbc4c46ec4ab53620,0,
0xe80448e7284938e8,0,
0x10913096639bb77e,0,
0xbe4992be0b330bba,0,
0x46dceacf40e1842c,0,
0x4537f48bef13d5d0,0,
0xbda28cfaa4c15a46,0,
0x137a2ed2cc69e682,0,
0xebef56a387bb6914,0,
0xf525a4c28276446,0,
0xf7c7223d63f5ebd0,0,
0x591f80150b5d5714,0,
0xa18af864408fd882,0,
0xa261e620ef7d897e,0,
0x5af49e51a4af06e8,0,
0xf42c3c79cc07ba2c,0,
0xcb9440887d535ba,0,
0x58f14a03e5293b72,0,
0xa0643272aefbb4e4,0,
0xebc905ac6530820,0,
0xf629e82b8d8187b6,0,
0xf5c2f66f2273d64a,0,
0xd578e1e69a159dc,0,
0xa38f2c360109e518,0,
0x5b1a54474adb6a8e,0,
0xb66864e6ec14b4d2,0,
0x4efd1c97a7c63b44,0,
0xe025bebfcf6e8780,0,
0x18b0c6ce84bc0816,0,
0x1b5bd88a2b4e59ea,0,
0xe3cea0fb609cd67c,0,
0x4d1602d308346ab8,0,
0xb5837aa243e6e52e,0,
0xe1cb74a9211aebe6,0,
0x195e0cd86ac86470,0,
0xb786aef00260d8b4,0,
0x4f13d68149b25722,0,
0x4cf8c8c5e64006de,0,
0xb46db0b4ad928948,0,
0x1ab5129cc53a358c,0,
0xe2206aed8ee8ba1a,0,
0x69d66022174b748,0,
0xfe081e736aa638de,0,
0x50d0bc5b020e841a,0,
0xa845c42a49dc0b8c,0,
0xabaeda6ee62e5a70,0,
0x533ba21fadfcd5e6,0,
0xfde30037c5546922,0,
0x57678468e86e6b4,0,
0x513e764dec7ae87c,0,
0xa9ab0e3ca7a867ea,0,
0x773ac14cf00db2e,0,
0xffe6d46584d254b8,0,
0xfc0dca212b200544,0,
0x498b25060f28ad2,0,
0xaa401078085a3616,0,
0x52d568094388b980,0,
0x5d2a83797de02b5e,0,
0xa5bffb083632a4c8,0,
0xb6759205e9a180c,0,
0xf3f221511548979a,0,
0xf0193f15babac666,0,
0x88c4764f16849f0,0,
0xa654e54c99c0f534,0,
0x5ec19d3dd2127aa2,0,
0xa899336b0ee746a,0,
0xf21ceb47fb3cfbfc,0,
0x5cc4496f93944738,0,
0xa451311ed846c8ae,0,
0xa7ba2f5a77b49952,0,
0x5f2f572b3c6616c4,0,
0xf1f7f50354ceaa00,0,
0x9628d721f1c2596,0,
0xeddf819db08028c4,0,
0x154af9ecfb52a752,0,
0xbb925bc493fa1b96,0,
0x430723b5d8289400,0,
0x40ec3df177dac5fc,0,
0xb87945803c084a6a,0,
0x16a1e7a854a0f6ae,0,
0xee349fd91f727938,0,
0xba7c91d27d8e77f0,0,
0x42e9e9a3365cf866,0,
0xec314b8b5ef444a2,0,
0x14a433fa1526cb34,0,
0x174f2dbebad49ac8,0,
0xefda55cff106155e,0,
0x4102f7e799aea99a,0,
0xb9978f96d27c260c,0,
0xe28ddbd198a74c82,0,
0x1a18a3a0d375c314,0,
0xb4c00188bbdd7fd0,0,
0x4c5579f9f00ff046,0,
0x4fbe67bd5ffda1ba,0,
0xb72b1fcc142f2e2c,0,
0x19f3bde47c8792e8,0,
0xe166c59537551d7e,0,
0xb52ecb9e55a913b6,0,
0x4dbbb3ef1e7b9c20,0,
0xe36311c776d320e4,0,
0x1bf669b63d01af72,0,
0x181d77f292f3fe8e,0,
0xe0880f83d9217118,0,
0x4e50adabb189cddc,0,
0xb6c5d5dafa5b424a,0,
0x5278d93555c74f18,0,
0xaaeda1441e15c08e,0,
0x435036c76bd7c4a,0,
0xfca07b1d3d6ff3dc,0,
0xff4b6559929da220,0,
0x7de1d28d94f2db6,0,
0xa906bf00b1e79172,0,
0x5193c771fa351ee4,0,
0x5dbc97a98c9102c,0,
0xfd4eb10bd31b9fba,0,
0x53961323bbb3237e,0,
0xab036b52f061ace8,0,
0xa8e875165f93fd14,0,
0x507d0d6714417282,0,
0xfea5af4f7ce9ce46,0,
0x630d73e373b41d0,0,
0x9cf3c4e0953d30e,0,
0xf15a443f42815c98,0,
0x5f82e6172a29e05c,0,
0xa7179e6661fb6fca,0,
0xa4fc8022ce093e36,0,
0x5c69f85385dbb1a0,0,
0xf2b15a7bed730d64,0,
0xa24220aa6a182f2,0,
0x5e6c2c01c45d8c3a,0,
0xa6f954708f8f03ac,0,
0x821f658e727bf68,0,
0xf0b48e29acf530fe,0,
0xf35f906d03076102,0,
0xbcae81c48d5ee94,0,
0xa5124a34207d5250,0,
0x5d8732456bafddc6,0,
0xb93a3eaac433d094,0,
0x41af46db8fe15f02,0,
0xef77e4f3e749e3c6,0,
0x17e29c82ac9b6c50,0,
0x140982c603693dac,0,
0xec9cfab748bbb23a,0,
0x4244589f20130efe,0,
0xbad120ee6bc18168,0,
0xee992ee5093d8fa0,0,
0x160c569442ef0036,0,
0xb8d4f4bc2a47bcf2,0,
0x40418ccd61953364,0,
0x43aa9289ce676298,0,
0xbb3feaf885b5ed0e,0,
0x15e748d0ed1d51ca,0,
0xed7230a1a6cfde5c,0,
0x0,0,
0xed57ce778f0d6244,0,
0x523aaf9d6148ba24,0,
0xbf6d61eaee45d860,0,
0xa8fcbfaac14940c6,0,
0x45ab71dd4e442282,0,
0xfac61037a001fae2,0,
0x1791de402f0c98a6,0,
0xe503eacfcef77780,0,
0x85424b841fa15c4,0,
0xb7394552afbfcda4,0,
0x5a6e8b2520b2afe0,0,
0x4dff55650fbe3746,0,
0xa0a89b1280b35502,0,
0x1fc5faf86ef68d62,0,
0xf292348fe1fbef26,0,
0xf3746c7b5183a372,0,
0x1e23a20cde8ec136,0,
0xa14ec3e630cb1956,0,
0x4c190d91bfc67b12,0,
0x5b88d3d190cae3b4,0,
0xb6df1da61fc781f0,0,
0x9b27c4cf1825990,0,
0xe4e5b23b7e8f3bd4,0,
0x167786b49f74d4f2,0,
0xfb2048c31079b6b6,0,
0x444d2929fe3c6ed6,0,
0xa91ae75e71310c92,0,
0xbe8b391e5e3d9434,0,
0x53dcf769d130f670,0,
0xecb196833f752e10,0,
0x1e658f4b0784c54,0,
0xec50d77d2f416218,0,
0x107190aa04c005c,0,
0xbe6a78e04e09d83c,0,
0x533db697c104ba78,0,
0x44ac68d7ee0822de,0,
0xa9fba6a06105409a,0,
0x1696c74a8f4098fa,0,
0xfbc1093d004dfabe,0,
0x9533db2e1b61598,0,
0xe404f3c56ebb77dc,0,
0x5b69922f80feafbc,0,
0xb63e5c580ff3cdf8,0,
0xa1af821820ff555e,0,
0x4cf84c6faff2371a,0,
0xf3952d8541b7ef7a,0,
0x1ec2e3f2ceba8d3e,0,
0x1f24bb067ec2c16a,0,
0xf2737571f1cfa32e,0,
0x4d1e149b1f8a7b4e,0,
0xa049daec9087190a,0,
0xb7d804acbf8b81ac,0,
0x5a8fcadb3086e3e8,0,
0xe5e2ab31dec33b88,0,
0x8b5654651ce59cc,0,
0xfa2751c9b035b6ea,0,
0x17709fbe3f38d4ae,0,
0xa81dfe54d17d0cce,0,
0x454a30235e706e8a,0,
0x52dbee63717cf62c,0,
0xbf8c2014fe719468,0,
0xe141fe10344c08,0,
0xedb68f899f392e4c,0,
0xf9cdf54569fe87e6,0,
0x149a3b32e6f3e5a2,0,
0xabf75ad808b63dc2,0,
0x46a094af87bb5f86,0,
0x51314aefa8b7c720,0,
0xbc66849827baa564,0,
0x30be572c9ff7d04,0,
0xee5c2b0546f21f40,0,
0x1cce1f8aa709f066,0,
0xf199d1fd28049222,0,
0x4ef4b017c6414a42,0,
0xa3a37e60494c2806,0,
0xb432a0206640b0a0,0,
0x59656e57e94dd2e4,0,
0xe6080fbd07080a84,0,
0xb5fc1ca880568c0,0,
0xab9993e387d2494,0,
0xe7ee5749b77046d0,0,
0x588336a359359eb0,0,
0xb5d4f8d4d638fcf4,0,
0xa2452694f9346452,0,
0x4f12e8e376390616,0,
0xf07f8909987cde76,0,
0x1d28477e1771bc32,0,
0xefba73f1f68a5314,0,
0x2edbd8679873150,0,
0xbd80dc6c97c2e930,0,
0x50d7121b18cf8b74,0,
0x4746cc5b37c313d2,0,
0xaa11022cb8ce7196,0,
0x157c63c6568ba9f6,0,
0xf82badb1d986cbb2,0,
0x159d223846bfe5fe,0,
0xf8caec4fc9b287ba,0,
0x47a78da527f75fda,0,
0xaaf043d2a8fa3d9e,0,
0xbd619d9287f6a538,0,
0x503653e508fbc77c,0,
0xef5b320fe6be1f1c,0,
0x20cfc7869b37d58,0,
0xf09ec8f78848927e,0,
0x1dc906800745f03a,0,
0xa2a4676ae900285a,0,
0x4ff3a91d660d4a1e,0,
0x5862775d4901d2b8,0,
0xb535b92ac60cb0fc,0,
0xa58d8c02849689c,0,
0xe70f16b7a7440ad8,0,
0xe6e94e43173c468c,0,
0xbbe8034983124c8,0,
0xb4d3e1de7674fca8,0,
0x59842fa9f9799eec,0,
0x4e15f1e9d675064a,0,
0xa3423f9e5978640e,0,
0x1c2f5e74b73dbc6e,0,
0xf17890033830de2a,0,
0x3eaa48cd9cb310c,0,
0xeebd6afb56c65348,0,
0x51d00b11b8838b28,0,
0xbc87c566378ee96c,0,
0xab161b26188271ca,0,
0x4641d551978f138e,0,
0xf92cb4bb79cacbee,0,
0x147b7accf6c7a9aa,0,
0xe576269915705e2c,0,
0x821e8ee9a7d3c68,0,
0xb74c89047438e408,0,
0x5a1b4773fb35864c,0,
0x4d8a9933d4391eea,0,
0xa0dd57445b347cae,0,
0x1fb036aeb571a4ce,0,
0xf2e7f8d93a7cc68a,0,
0x75cc56db8729ac,0,
0xed220221548a4be8,0,
0x524f63cbbacf9388,0,
0xbf18adbc35c2f1cc,0,
0xa88973fc1ace696a,0,
0x45debd8b95c30b2e,0,
0xfab3dc617b86d34e,0,
0x17e41216f48bb10a,0,
0x16024ae244f3fd5e,0,
0xfb558495cbfe9f1a,0,
0x4438e57f25bb477a,0,
0xa96f2b08aab6253e,0,
0xbefef54885babd98,0,
0x53a93b3f0ab7dfdc,0,
0xecc45ad5e4f207bc,0,
0x19394a26bff65f8,0,
0xf301a02d8a048ade,0,
0x1e566e5a0509e89a,0,
0xa13b0fb0eb4c30fa,0,
0x4c6cc1c7644152be,0,
0x5bfd1f874b4dca18,0,
0xb6aad1f0c440a85c,0,
0x9c7b01a2a05703c,0,
0xe4907e6da5081278,0,
0x926f1e43a313c34,0,
0xe4713f93b53c5e70,0,
0x5b1c5e795b798610,0,
0xb64b900ed474e454,0,
0xa1da4e4efb787cf2,0,
0x4c8d803974751eb6,0,
0xf3e0e1d39a30c6d6,0,
0x1eb72fa4153da492,0,
0xec251b2bf4c64bb4,0,
0x172d55c7bcb29f0,0,
0xbe1fb4b6958ef190,0,
0x53487ac11a8393d4,0,
0x44d9a481358f0b72,0,
0xa98e6af6ba826936,0,
0x16e30b1c54c7b156,0,
0xfbb4c56bdbcad312,0,
0xfa529d9f6bb29f46,0,
0x170553e8e4bffd02,0,
0xa86832020afa2562,0,
0x453ffc7585f74726,0,
0x52ae2235aafbdf80,0,
0xbff9ec4225f6bdc4,0,
0x948da8cbb365a4,0,
0xedc343df44be07e0,0,
0x1f517750a545e8c6,0,
0xf206b9272a488a82,0,
0x4d6bd8cdc40d52e2,0,
0xa03c16ba4b0030a6,0,
0xb7adc8fa640ca800,0,
0x5afa068deb01ca44,0,
0xe597676705441224,0,
0x8c0a9108a497060,0,
0x1cbbd3dc7c8ed9ca,0,
0xf1ec1dabf383bb8e,0,
0x4e817c411dc663ee,0,
0xa3d6b23692cb01aa,0,
0xb4476c76bdc7990c,0,
0x5910a20132cafb48,0,
0xe67dc3ebdc8f2328,0,
0xb2a0d9c5382416c,0,
0xf9b83913b279ae4a,0,
0x14eff7643d74cc0e,0,
0xab82968ed331146e,0,
0x46d558f95c3c762a,0,
0x514486b97330ee8c,0,
0xbc1348cefc3d8cc8,0,
0x37e2924127854a8,0,
0xee29e7539d7536ec,0,
0xefcfbfa72d0d7ab8,0,
0x29871d0a20018fc,0,
0xbdf5103a4c45c09c,0,
0x50a2de4dc348a2d8,0,
0x4733000dec443a7e,0,
0xaa64ce7a6349583a,0,
0x1509af908d0c805a,0,
0xf85e61e70201e21e,0,
0xacc5568e3fa0d38,0,
0xe79b9b1f6cf76f7c,0,
0x58f6faf582b2b71c,0,
0xb5a134820dbfd558,0,
0xa230eac222b34dfe,0,
0x4f6724b5adbe2fba,0,
0xf00a455f43fbf7da,0,
0x1d5d8b28ccf6959e,0,
0xf0eb04a153cfbbd2,0,
0x1dbccad6dcc2d996,0,
0xa2d1ab3c328701f6,0,
0x4f86654bbd8a63b2,0,
0x5817bb0b9286fb14,0,
0xb540757c1d8b9950,0,
0xa2d1496f3ce4130,0,
0xe77adae17cc32374,0,
0x15e8ee6e9d38cc52,0,
0xf8bf20191235ae16,0,
0x47d241f3fc707676,0,
0xaa858f84737d1432,0,
0xbd1451c45c718c94,0,
0x50439fb3d37ceed0,0,
0xef2efe593d3936b0,0,
0x279302eb23454f4,0,
0x39f68da024c18a0,0,
0xeec8a6ad8d417ae4,0,
0x51a5c7476304a284,0,
0xbcf20930ec09c0c0,0,
0xab63d770c3055866,0,
0x463419074c083a22,0,
0xf95978eda24de242,0,
0x140eb69a2d408006,0,
0xe69c8215ccbb6f20,0,
0xbcb4c6243b60d64,0,
0xb4a62d88adf3d504,0,
0x59f1e3ff22feb740,0,
0x4e603dbf0df22fe6,0,
0xa337f3c882ff4da2,0,
0x1c5a92226cba95c2,0,
0xf10d5c55e3b7f786,0,
0x0,0,
0xee2a197148fa8c72,0,
0x49e31453575f365a,0,
0xa7c90d221fa5ba28,0,
0xb86698d88add0bc0,0,
0x564c81a9c22787b2,0,
0xf1858c8bdd823d9a,0,
0x1faf95fa9578b1e8,0,
0x4f35fb218e7f37c0,0,
0xa11fe250c685bbb2,0,
0x6d6ef72d920019a,0,
0xe8fcf60391da8de8,0,
0xf75363f904a23c00,0,
0x19797a884c58b072,0,
0xbeb077aa53fd0a5a,0,
0x509a6edb1b078628,0,
0xa306feea8a242832,0,
0x4d2ce79bc2dea440,0,
0xeae5eab9dd7b1e68,0,
0x4cff3c89581921a,0,
0x1b60663200f923f2,0,
0xf54a7f434803af80,0,
0x5283726157a615a8,0,
0xbca96b101f5c99da,0,
0xec3305cb045b1ff2,0,
0x2191cba4ca19380,0,
0xa5d01198530429a8,0,
0x4bfa08e91bfea5da,0,
0x54559d138e861432,0,
0xba7f8462c67c9840,0,
0x1db68940d9d92268,0,
0xf39c90319123ae1a,0,
0x5e5f06a9daead6e6,0,
0xb0751fd892105a94,0,
0x17bc12fa8db5e0bc,0,
0xf9960b8bc54f6cce,0,
0xe6399e715037dd26,0,
0x813870018cd5154,0,
0xafda8a220768eb7c,0,
0x41f093534f92670e,0,
0x116afd885495e126,0,
0xff40e4f91c6f6d54,0,
0x5889e9db03cad77c,0,
0xb6a3f0aa4b305b0e,0,
0xa90c6550de48eae6,0,
0x47267c2196b26694,0,
0xe0ef71038917dcbc,0,
0xec56872c1ed50ce,0,
0xfd59f84350cefed4,0,
0x1373e132183472a6,0,
0xb4baec100791c88e,0,
0x5a90f5614f6b44fc,0,
0x453f609bda13f514,0,
0xab1579ea92e97966,0,
0xcdc74c88d4cc34e,0,
0xe2f66db9c5b64f3c,0,
0xb26c0362deb1c914,0,
0x5c461a13964b4566,0,
0xfb8f173189eeff4e,0,
0x15a50e40c114733c,0,
0xa0a9bba546cc2d4,0,
0xe42082cb1c964ea6,0,
0x43e98fe90333f48e,0,
0xadc396984bc978fc,0,
0xbe13089ecc784ea0,0,
0x503911ef8482c2d2,0,
0xf7f01ccd9b2778fa,0,
0x19da05bcd3ddf488,0,
0x675904646a54560,0,
0xe85f89370e5fc912,0,
0x4f96841511fa733a,0,
0xa1bc9d645900ff48,0,
0xf126f3bf42077960,0,
0x1f0ceace0afdf512,0,
0xb8c5e7ec15584f3a,0,
0x56effe9d5da2c348,0,
0x49406b67c8da72a0,0,
0xa76a72168020fed2,0,
0xa37f349f8544fa,0,
0xee896645d77fc888,0,
0x1d15f674465c6692,0,
0xf33fef050ea6eae0,0,
0x54f6e227110350c8,0,
0xbadcfb5659f9dcba,0,
0xa5736eaccc816d52,0,
0x4b5977dd847be120,0,
0xec907aff9bde5b08,0,
0x2ba638ed324d77a,0,
0x52200d55c8235152,0,
0xbc0a142480d9dd20,0,
0x1bc319069f7c6708,0,
0xf5e90077d786eb7a,0,
0xea46958d42fe5a92,0,
0x46c8cfc0a04d6e0,0,
0xa3a581de15a16cc8,0,
0x4d8f98af5d5be0ba,0,
0xe04c0e3716929846,0,
0xe6617465e681434,0,
0xa9af1a6441cdae1c,0,
0x478503150937226e,0,
0x582a96ef9c4f9386,0,
0xb6008f9ed4b51ff4,0,
0x11c982bccb10a5dc,0,
0xffe39bcd83ea29ae,0,
0xaf79f51698edaf86,0,
0x4153ec67d01723f4,0,
0xe69ae145cfb299dc,0,
0x8b0f834874815ae,0,
0x171f6dce1230a446,0,
0xf93574bf5aca2834,0,
0x5efc799d456f921c,0,
0xb0d660ec0d951e6e,0,
0x434af0dd9cb6b074,0,
0xad60e9acd44c3c06,0,
0xaa9e48ecbe9862e,0,
0xe483fdff83130a5c,0,
0xfb2c6805166bbbb4,0,
0x150671745e9137c6,0,
0xb2cf7c5641348dee,0,
0x5ce5652709ce019c,0,
0xc7f0bfc12c987b4,0,
0xe255128d5a330bc6,0,
0x459c1faf4596b1ee,0,
0xabb606de0d6c3d9c,0,
0xb419932498148c74,0,
0x5a338a55d0ee0006,0,
0xfdfa8777cf4bba2e,0,
0x13d09e0687b1365c,0,
0xfe1a10738739c892,0,
0x10300902cfc344e0,0,
0xb7f90420d066fec8,0,
0x59d31d51989c72ba,0,
0x467c88ab0de4c352,0,
0xa85691da451e4f20,0,
0xf9f9cf85abbf508,0,
0xe1b585891241797a,0,
0xb12feb520946ff52,0,
0x5f05f22341bc7320,0,
0xf8ccff015e19c908,0,
0x16e6e67016e3457a,0,
0x949738a839bf492,0,
0xe7636afbcb6178e0,0,
0x40aa67d9d4c4c2c8,0,
0xae807ea89c3e4eba,0,
0x5d1cee990d1de0a0,0,
0xb336f7e845e76cd2,0,
0x14fffaca5a42d6fa,0,
0xfad5e3bb12b85a88,0,
0xe57a764187c0eb60,0,
0xb506f30cf3a6712,0,
0xac996212d09fdd3a,0,
0x42b37b6398655148,0,
0x122915b88362d760,0,
0xfc030cc9cb985b12,0,
0x5bca01ebd43de13a,0,
0xb5e0189a9cc76d48,0,
0xaa4f8d6009bfdca0,0,
0x44659411414550d2,0,
0xe3ac99335ee0eafa,0,
0xd868042161a6688,0,
0xa04516da5dd31e74,0,
0x4e6f0fab15299206,0,
0xe9a602890a8c282e,0,
0x78c1bf84276a45c,0,
0x18238e02d70e15b4,0,
0xf60997739ff499c6,0,
0x51c09a51805123ee,0,
0xbfea8320c8abaf9c,0,
0xef70edfbd3ac29b4,0,
0x15af48a9b56a5c6,0,
0xa693f9a884f31fee,0,
0x48b9e0d9cc09939c,0,
0x5716752359712274,0,
0xb93c6c52118bae06,0,
0x1ef561700e2e142e,0,
0xf0df780146d4985c,0,
0x343e830d7f73646,0,
0xed69f1419f0dba34,0,
0x4aa0fc6380a8001c,0,
0xa48ae512c8528c6e,0,
0xbb2570e85d2a3d86,0,
0x550f699915d0b1f4,0,
0xf2c664bb0a750bdc,0,
0x1cec7dca428f87ae,0,
0x4c76131159880186,0,
0xa25c0a6011728df4,0,
0x59507420ed737dc,0,
0xebbf1e33462dbbae,0,
0xf4108bc9d3550a46,0,
0x1a3a92b89baf8634,0,
0xbdf39f9a840a3c1c,0,
0x53d986ebccf0b06e,0,
0x400918ed4b418632,0,
0xae23019c03bb0a40,0,
0x9ea0cbe1c1eb068,0,
0xe7c015cf54e43c1a,0,
0xf86f8035c19c8df2,0,
0x1645994489660180,0,
0xb18c946696c3bba8,0,
0x5fa68d17de3937da,0,
0xf3ce3ccc53eb1f2,0,
0xe116fabd8dc43d80,0,
0x46dff79f926187a8,0,
0xa8f5eeeeda9b0bda,0,
0xb75a7b144fe3ba32,0,
0x5970626507193640,0,
0xfeb96f4718bc8c68,0,
0x109376365046001a,0,
0xe30fe607c165ae00,0,
0xd25ff76899f2272,0,
0xaaecf254963a985a,0,
0x44c6eb25dec01428,0,
0x5b697edf4bb8a5c0,0,
0xb54367ae034229b2,0,
0x128a6a8c1ce7939a,0,
0xfca073fd541d1fe8,0,
0xac3a1d264f1a99c0,0,
0x4210045707e015b2,0,
0xe5d909751845af9a,0,
0xbf3100450bf23e8,0,
0x145c85fec5c79200,0,
0xfa769c8f8d3d1e72,0,
0x5dbf91ad9298a45a,0,
0xb39588dcda622828,0,
0x1e561e4491ab50d4,0,
0xf07c0735d951dca6,0,
0x57b50a17c6f4668e,0,
0xb99f13668e0eeafc,0,
0xa630869c1b765b14,0,
0x481a9fed538cd766,0,
0xefd392cf4c296d4e,0,
0x1f98bbe04d3e13c,0,
0x5163e5651fd46714,0,
0xbf49fc14572eeb66,0,
0x1880f136488b514e,0,
0xf6aae8470071dd3c,0,
0xe9057dbd95096cd4,0,
0x72f64ccddf3e0a6,0,
0xa0e669eec2565a8e,0,
0x4ecc709f8aacd6fc,0,
0xbd50e0ae1b8f78e6,0,
0x537af9df5375f494,0,
0xf4b3f4fd4cd04ebc,0,
0x1a99ed8c042ac2ce,0,
0x536787691527326,0,
0xeb1c6107d9a8ff54,0,
0x4cd56c25c60d457c,0,
0xa2ff75548ef7c90e,0,
0xf2651b8f95f04f26,0,
0x1c4f02fedd0ac354,0,
0xbb860fdcc2af797c,0,
0x55ac16ad8a55f50e,0,
0x4a0383571f2d44e6,0,
0xa4299a2657d7c894,0,
0x3e09704487272bc,0,
0xedca8e750088fece,0,
0x0,0,
0xe2266ceb0c5bc774,0,
0xf490e6ed40d1dd1a,0,
0x16b68a064c8a1a6e,0,
0xf3f5f515077e92f0,0,
0x11d399fe0b255584,0,
0x76513f847af4fea,0,
0xe5437f134bf4889e,0,
0x467c20312e7eb0f0,0,
0xa45a4cda22257784,0,
0xb2ecc6dc6eaf6dea,0,
0x50caaa3762f4aa9e,0,
0xb589d52429002200,0,
0x57afb9cf255be574,0,
0x411933c969d1ff1a,0,
0xa33f5f22658a386e,0,
0xb06caa4295d350c2,0,
0x524ac6a9998897b6,0,
0x44fc4cafd5028dd8,0,
0xa6da2044d9594aac,0,
0x43995f5792adc232,0,
0xa1bf33bc9ef60546,0,
0xb709b9bad27c1f28,0,
0x552fd551de27d85c,0,
0xf6108a73bbade032,0,
0x1436e698b7f62746,0,
0x2806c9efb7c3d28,0,
0xe0a60075f727fa5c,0,
0x5e57f66bcd372c2,0,
0xe7c3138db088b5b6,0,
0xf175998bfc02afd8,0,
0x1353f560f05968ac,0,
0x5c5916d98a583c16,0,
0xbe7f7a328603fb62,0,
0xa8c9f034ca89e10c,0,
0x4aef9cdfc6d22678,0,
0xaface3cc8d26aee6,0,
0x4d8a8f27817d6992,0,
0x5b3c0521cdf773fc,0,
0xb91a69cac1acb488,0,
0x1a2536e8a4268ce6,0,
0xf8035a03a87d4b92,0,
0xeeb5d005e4f751fc,0,
0xc93bceee8ac9688,0,
0xe9d0c3fda3581e16,0,
0xbf6af16af03d962,0,
0x1d402510e389c30c,0,
0xff6649fbefd20478,0,
0xec35bc9b1f8b6cd4,0,
0xe13d07013d0aba0,0,
0x18a55a765f5ab1ce,0,
0xfa83369d530176ba,0,
0x1fc0498e18f5fe24,0,
0xfde6256514ae3950,0,
0xeb50af635824233e,0,
0x976c388547fe44a,0,
0xaa499caa31f5dc24,0,
0x486ff0413dae1b50,0,
0x5ed97a477124013e,0,
0xbcff16ac7d7fc64a,0,
0x59bc69bf368b4ed4,0,
0xbb9a05543ad089a0,0,
0xad2c8f52765a93ce,0,
0x4f0ae3b97a0154ba,0,
0xa04de5b4c7a1ceac,0,
0x426b895fcbfa09d8,0,
0x54dd0359877013b6,0,
0xb6fb6fb28b2bd4c2,0,
0x53b810a1c0df5c5c,0,
0xb19e7c4acc849b28,0,
0xa728f64c800e8146,0,
0x450e9aa78c554632,0,
0xe631c585e9df7e5c,0,
0x417a96ee584b928,0,
0x12a12368a90ea346,0,
0xf0874f83a5556432,0,
0x15c43090eea1ecac,0,
0xf7e25c7be2fa2bd8,0,
0xe154d67dae7031b6,0,
0x372ba96a22bf6c2,0,
0x10214ff652729e6e,0,
0xf207231d5e29591a,0,
0xe4b1a91b12a34374,0,
0x697c5f01ef88400,0,
0xe3d4bae3550c0c9e,0,
0x1f2d6085957cbea,0,
0x17445c0e15ddd184,0,
0xf56230e5198616f0,0,
0x565d6fc77c0c2e9e,0,
0xb47b032c7057e9ea,0,
0xa2cd892a3cddf384,0,
0x40ebe5c1308634f0,0,
0xa5a89ad27b72bc6e,0,
0x478ef63977297b1a,0,
0x51387c3f3ba36174,0,
0xb31e10d437f8a600,0,
0xfc14f36d4df9f2ba,0,
0x1e329f8641a235ce,0,
0x88415800d282fa0,0,
0xeaa2796b0173e8d4,0,
0xfe106784a87604a,0,
0xedc76a9346dca73e,0,
0xfb71e0950a56bd50,0,
0x19578c7e060d7a24,0,
0xba68d35c6387424a,0,
0x584ebfb76fdc853e,0,
0x4ef835b123569f50,0,
0xacde595a2f0d5824,0,
0x499d264964f9d0ba,0,
0xabbb4aa268a217ce,0,
0xbd0dc0a424280da0,0,
0x5f2bac4f2873cad4,0,
0x4c78592fd82aa278,0,
0xae5e35c4d471650c,0,
0xb8e8bfc298fb7f62,0,
0x5aced32994a0b816,0,
0xbf8dac3adf543088,0,
0x5dabc0d1d30ff7fc,0,
0x4b1d4ad79f85ed92,0,
0xa93b263c93de2ae6,0,
0xa04791ef6541288,0,
0xe82215f5fa0fd5fc,0,
0xfe949ff3b685cf92,0,
0x1cb2f318bade08e6,0,
0xf9f18c0bf12a8078,0,
0x1bd7e0e0fd71470c,0,
0xd616ae6b1fb5d62,0,
0xef47060dbda09a16,0,
0x41430183d6e85ec0,0,
0xa3656d68dab399b4,0,
0xb5d3e76e963983da,0,
0x57f58b859a6244ae,0,
0xb2b6f496d196cc30,0,
0x5090987dddcd0b44,0,
0x4626127b9147112a,0,
0xa4007e909d1cd65e,0,
0x73f21b2f896ee30,0,
0xe5194d59f4cd2944,0,
0xf3afc75fb847332a,0,
0x1189abb4b41cf45e,0,
0xf4cad4a7ffe87cc0,0,
0x16ecb84cf3b3bbb4,0,
0x5a324abf39a1da,0,
0xe27c5ea1b36266ae,0,
0xf12fabc1433b0e02,0,
0x1309c72a4f60c976,0,
0x5bf4d2c03ead318,0,
0xe79921c70fb1146c,0,
0x2da5ed444459cf2,0,
0xe0fc323f481e5b86,0,
0xf64ab839049441e8,0,
0x146cd4d208cf869c,0,
0xb7538bf06d45bef2,0,
0x5575e71b611e7986,0,
0x43c36d1d2d9463e8,0,
0xa1e501f621cfa49c,0,
0x44a67ee56a3b2c02,0,
0xa680120e6660eb76,0,
0xb03698082aeaf118,0,
0x5210f4e326b1366c,0,
0x1d1a175a5cb062d6,0,
0xff3c7bb150eba5a2,0,
0xe98af1b71c61bfcc,0,
0xbac9d5c103a78b8,0,
0xeeefe24f5bcef026,0,
0xcc98ea457953752,0,
0x1a7f04a21b1f2d3c,0,
0xf85968491744ea48,0,
0x5b66376b72ced226,0,
0xb9405b807e951552,0,
0xaff6d186321f0f3c,0,
0x4dd0bd6d3e44c848,0,
0xa893c27e75b040d6,0,
0x4ab5ae9579eb87a2,0,
0x5c03249335619dcc,0,
0xbe254878393a5ab8,0,
0xad76bd18c9633214,0,
0x4f50d1f3c538f560,0,
0x59e65bf589b2ef0e,0,
0xbbc0371e85e9287a,0,
0x5e83480dce1da0e4,0,
0xbca524e6c2466790,0,
0xaa13aee08ecc7dfe,0,
0x4835c20b8297ba8a,0,
0xeb0a9d29e71d82e4,0,
0x92cf1c2eb464590,0,
0x1f9a7bc4a7cc5ffe,0,
0xfdbc172fab97988a,0,
0x18ff683ce0631014,0,
0xfad904d7ec38d760,0,
0xec6f8ed1a0b2cd0e,0,
0xe49e23aace90a7a,0,
0xe10ee4371149906c,0,
0x32888dc1d125718,0,
0x159e02da51984d76,0,
0xf7b86e315dc38a02,0,
0x12fb11221637029c,0,
0xf0dd7dc91a6cc5e8,0,
0xe66bf7cf56e6df86,0,
0x44d9b245abd18f2,0,
0xa772c4063f37209c,0,
0x4554a8ed336ce7e8,0,
0x53e222eb7fe6fd86,0,
0xb1c44e0073bd3af2,0,
0x548731133849b26c,0,
0xb6a15df834127518,0,
0xa017d7fe78986f76,0,
0x4231bb1574c3a802,0,
0x51624e75849ac0ae,0,
0xb344229e88c107da,0,
0xa5f2a898c44b1db4,0,
0x47d4c473c810dac0,0,
0xa297bb6083e4525e,0,
0x40b1d78b8fbf952a,0,
0x56075d8dc3358f44,0,
0xb4213166cf6e4830,0,
0x171e6e44aae4705e,0,
0xf53802afa6bfb72a,0,
0xe38e88a9ea35ad44,0,
0x1a8e442e66e6a30,0,
0xe4eb9b51ad9ae2ae,0,
0x6cdf7baa1c125da,0,
0x107b7dbced4b3fb4,0,
0xf25d1157e110f8c0,0,
0xbd57f2ee9b11ac7a,0,
0x5f719e05974a6b0e,0,
0x49c71403dbc07160,0,
0xabe178e8d79bb614,0,
0x4ea207fb9c6f3e8a,0,
0xac846b109034f9fe,0,
0xba32e116dcbee390,0,
0x58148dfdd0e524e4,0,
0xfb2bd2dfb56f1c8a,0,
0x190dbe34b934dbfe,0,
0xfbb3432f5bec190,0,
0xed9d58d9f9e506e4,0,
0x8de27cab2118e7a,0,
0xeaf84b21be4a490e,0,
0xfc4ec127f2c05360,0,
0x1e68adccfe9b9414,0,
0xd3b58ac0ec2fcb8,0,
0xef1d344702993bcc,0,
0xf9abbe414e1321a2,0,
0x1b8dd2aa4248e6d6,0,
0xfeceadb909bc6e48,0,
0x1ce8c15205e7a93c,0,
0xa5e4b54496db352,0,
0xe87827bf45367426,0,
0x4b47789d20bc4c48,0,
0xa96114762ce78b3c,0,
0xbfd79e70606d9152,0,
0x5df1f29b6c365626,0,
0xb8b28d8827c2deb8,0,
0x5a94e1632b9919cc,0,
0x4c226b65671303a2,0,
0xae04078e6b48c4d6,0,
0x0,0,
0xb361d8dabe3b3632,0,
0x4357375d88b88b56,0,
0xf036ef873683bd64,0,
0xb057dcc8a19fbc9c,0,
0x33604121fa48aae,0,
0xf300eb95292737ca,0,
0x4061334f971c01f8,0,
0xf26e1791be4b37c2,0,
0x410fcf4b007001f0,0,
0xb13920cc36f3bc94,0,
0x258f81688c88aa6,0,
0x4239cb591fd48b5e,0,
0xf1581383a1efbd6c,0,
0x16efc04976c0008,0,
0xb20f24de2957363a,0,
0xe9f744031bfe63e4,0,
0x5a969cd9a5c555d6,0,
0xaaa0735e9346e8b2,0,
0x19c1ab842d7dde80,0,
0x59a098cbba61df78,0,
0xeac14011045ae94a,0,
0x1af7af9632d9542e,0,
0xa996774c8ce2621c,0,
0x1b995392a5b55426,0,
0xa8f88b481b8e6214,0,
0x58ce64cf2d0ddf70,0,
0xebafbc159336e942,0,
0xabce8f5a042ae8ba,0,
0x18af5780ba11de88,0,
0xe899b8078c9263ec,0,
0x5bf860dd32a955de,0,
0xe50803875e9ab776,0,
0x5669db5de0a18144,0,
0xa65f34dad6223c20,0,
0x153eec0068190a12,0,
0x555fdf4fff050bea,0,
0xe63e0795413e3dd8,0,
0x1608e81277bd80bc,0,
0xa56930c8c986b68e,0,
0x17661416e0d180b4,0,
0xa407cccc5eeab686,0,
0x5431234b68690be2,0,
0xe750fb91d6523dd0,0,
0xa731c8de414e3c28,0,
0x14501004ff750a1a,0,
0xe466ff83c9f6b77e,0,
0x5707275977cd814c,0,
0xcff47844564d492,0,
0xbf9e9f5efb5fe2a0,0,
0x4fa870d9cddc5fc4,0,
0xfcc9a80373e769f6,0,
0xbca89b4ce4fb680e,0,
0xfc943965ac05e3c,0,
0xffffac116c43e358,0,
0x4c9e74cbd278d56a,0,
0xfe915015fb2fe350,0,
0x4df088cf4514d562,0,
0xbdc6674873976806,0,
0xea7bf92cdac5e34,0,
0x4ec68cdd5ab05fcc,0,
0xfda75407e48b69fe,0,
0xd91bb80d208d49a,0,
0xbef0635a6c33e2a8,0,
0x44ee098f4d56753e,0,
0xf78fd155f36d430c,0,
0x7b93ed2c5eefe68,0,
0xb4d8e6087bd5c85a,0,
0xf4b9d547ecc9c9a2,0,
0x47d80d9d52f2ff90,0,
0xb7eee21a647142f4,0,
0x48f3ac0da4a74c6,0,
0xb6801e1ef31d42fc,0,
0x5e1c6c44d2674ce,0,
0xf5d729437ba5c9aa,0,
0x46b6f199c59eff98,0,
0x6d7c2d65282fe60,0,
0xb5b61a0cecb9c852,0,
0x4580f58bda3a7536,0,
0xf6e12d5164014304,0,
0xad194d8c56a816da,0,
0x1e789556e89320e8,0,
0xee4e7ad1de109d8c,0,
0x5d2fa20b602babbe,0,
0x1d4e9144f737aa46,0,
0xae2f499e490c9c74,0,
0x5e19a6197f8f2110,0,
0xed787ec3c1b41722,0,
0x5f775a1de8e32118,0,
0xec1682c756d8172a,0,
0x1c206d40605baa4e,0,
0xaf41b59ade609c7c,0,
0xef2086d5497c9d84,0,
0x5c415e0ff747abb6,0,
0xac77b188c1c416d2,0,
0x1f1669527fff20e0,0,
0xa1e60a0813ccc248,0,
0x1287d2d2adf7f47a,0,
0xe2b13d559b74491e,0,
0x51d0e58f254f7f2c,0,
0x11b1d6c0b2537ed4,0,
0xa2d00e1a0c6848e6,0,
0x52e6e19d3aebf582,0,
0xe187394784d0c3b0,0,
0x53881d99ad87f58a,0,
0xe0e9c54313bcc3b8,0,
0x10df2ac4253f7edc,0,
0xa3bef21e9b0448ee,0,
0xe3dfc1510c184916,0,
0x50be198bb2237f24,0,
0xa088f60c84a0c240,0,
0x13e92ed63a9bf472,0,
0x48114e0b0832a1ac,0,
0xfb7096d1b609979e,0,
0xb467956808a2afa,0,
0xb827a18c3eb11cc8,0,
0xf84692c3a9ad1d30,0,
0x4b274a1917962b02,0,
0xbb11a59e21159666,0,
0x8707d449f2ea054,0,
0xba7f599ab679966e,0,
0x91e81400842a05c,0,
0xf9286ec73ec11d38,0,
0x4a49b61d80fa2b0a,0,
0xa28855217e62af2,0,
0xb9495d88a9dd1cc0,0,
0x497fb20f9f5ea1a4,0,
0xfa1e6ad521659796,0,
0x9dc338f8399031b4,0,
0x2ea2e02287ab0786,0,
0xde940fa5b128bae2,0,
0x6df5d77f0f138cd0,0,
0x2d94e430980f8d28,0,
0x9ef53cea2634bb1a,0,
0x6ec3d36d10b7067e,0,
0xdda20bb7ae8c304c,0,
0x6fad2f6987db0676,0,
0xdcccf7b339e03044,0,
0x2cfa18340f638d20,0,
0x9f9bc0eeb158bb12,0,
0xdffaf3a12644baea,0,
0x6c9b2b7b987f8cd8,0,
0x9cadc4fcaefc31bc,0,
0x2fcc1c2610c7078e,0,
0x74347cfb226e5250,0,
0xc755a4219c556462,0,
0x37634ba6aad6d906,0,
0x8402937c14edef34,0,
0xc463a03383f1eecc,0,
0x770278e93dcad8fe,0,
0x8734976e0b49659a,0,
0x34554fb4b57253a8,0,
0x865a6b6a9c256592,0,
0x353bb3b0221e53a0,0,
0xc50d5c37149deec4,0,
0x766c84edaaa6d8f6,0,
0x360db7a23dbad90e,0,
0x856c6f788381ef3c,0,
0x755a80ffb5025258,0,
0xc63b58250b39646a,0,
0x78cb3b7f670a86c2,0,
0xcbaae3a5d931b0f0,0,
0x3b9c0c22efb20d94,0,
0x88fdd4f851893ba6,0,
0xc89ce7b7c6953a5e,0,
0x7bfd3f6d78ae0c6c,0,
0x8bcbd0ea4e2db108,0,
0x38aa0830f016873a,0,
0x8aa52ceed941b100,0,
0x39c4f434677a8732,0,
0xc9f21bb351f93a56,0,
0x7a93c369efc20c64,0,
0x3af2f02678de0d9c,0,
0x899328fcc6e53bae,0,
0x79a5c77bf06686ca,0,
0xcac41fa14e5db0f8,0,
0x913c7f7c7cf4e526,0,
0x225da7a6c2cfd314,0,
0xd26b4821f44c6e70,0,
0x610a90fb4a775842,0,
0x216ba3b4dd6b59ba,0,
0x920a7b6e63506f88,0,
0x623c94e955d3d2ec,0,
0xd15d4c33ebe8e4de,0,
0x635268edc2bfd2e4,0,
0xd033b0377c84e4d6,0,
0x20055fb04a0759b2,0,
0x9364876af43c6f80,0,
0xd305b42563206e78,0,
0x60646cffdd1b584a,0,
0x90528378eb98e52e,0,
0x23335ba255a3d31c,0,
0xd92d317774c6448a,0,
0x6a4ce9adcafd72b8,0,
0x9a7a062afc7ecfdc,0,
0x291bdef04245f9ee,0,
0x697aedbfd559f816,0,
0xda1b35656b62ce24,0,
0x2a2ddae25de17340,0,
0x994c0238e3da4572,0,
0x2b4326e6ca8d7348,0,
0x9822fe3c74b6457a,0,
0x681411bb4235f81e,0,
0xdb75c961fc0ece2c,0,
0x9b14fa2e6b12cfd4,0,
0x287522f4d529f9e6,0,
0xd843cd73e3aa4482,0,
0x6b2215a95d9172b0,0,
0x30da75746f38276e,0,
0x83bbadaed103115c,0,
0x738d4229e780ac38,0,
0xc0ec9af359bb9a0a,0,
0x808da9bccea79bf2,0,
0x33ec7166709cadc0,0,
0xc3da9ee1461f10a4,0,
0x70bb463bf8242696,0,
0xc2b462e5d17310ac,0,
0x71d5ba3f6f48269e,0,
0x81e355b859cb9bfa,0,
0x32828d62e7f0adc8,0,
0x72e3be2d70ecac30,0,
0xc18266f7ced79a02,0,
0x31b48970f8542766,0,
0x82d551aa466f1154,0,
0x3c2532f02a5cf3fc,0,
0x8f44ea2a9467c5ce,0,
0x7f7205ada2e478aa,0,
0xcc13dd771cdf4e98,0,
0x8c72ee388bc34f60,0,
0x3f1336e235f87952,0,
0xcf25d965037bc436,0,
0x7c4401bfbd40f204,0,
0xce4b25619417c43e,0,
0x7d2afdbb2a2cf20c,0,
0x8d1c123c1caf4f68,0,
0x3e7dcae6a294795a,0,
0x7e1cf9a9358878a2,0,
0xcd7d21738bb34e90,0,
0x3d4bcef4bd30f3f4,0,
0x8e2a162e030bc5c6,0,
0xd5d276f331a29018,0,
0x66b3ae298f99a62a,0,
0x968541aeb91a1b4e,0,
0x25e4997407212d7c,0,
0x6585aa3b903d2c84,0,
0xd6e472e12e061ab6,0,
0x26d29d661885a7d2,0,
0x95b345bca6be91e0,0,
0x27bc61628fe9a7da,0,
0x94ddb9b831d291e8,0,
0x64eb563f07512c8c,0,
0xd78a8ee5b96a1abe,0,
0x97ebbdaa2e761b46,0,
0x248a6570904d2d74,0,
0xd4bc8af7a6ce9010,0,
0x67dd522d18f5a622,0,
};
}

#endif