# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyarchi',
 'pyarchi.data_objects',
 'pyarchi.initial_detection',
 'pyarchi.masks_creation',
 'pyarchi.output_creation',
 'pyarchi.proof_concept',
 'pyarchi.routines',
 'pyarchi.star_track',
 'pyarchi.utils',
 'pyarchi.utils.data_export',
 'pyarchi.utils.factors_handler',
 'pyarchi.utils.image_processing',
 'pyarchi.utils.misc',
 'pyarchi.utils.noise_metrics',
 'pyarchi.utils.optimization']

package_data = \
{'': ['*']}

install_requires = \
['astropy>=4.0,<5.0',
 'imageio>=2.8.0,<3.0.0',
 'matplotlib>=3.1.2,<4.0.0',
 'opencv-python>=4.1.2,<5.0.0',
 'pyyaml>=5.3,<6.0',
 'scipy>=1.4.1,<2.0.0']

setup_kwargs = {
    'name': 'pyarchi',
    'version': '1.1',
    'description': "Photometry for CHEOPS's background stars",
    'long_description': '[![Documentation Status](https://readthedocs.org/projects/archi/badge/?version=latest)](https://archi.readthedocs.io/en/latest/?badge=latest)  [![PyPI version fury.io](https://badge.fury.io/py/pyarchi.svg)](https://pypi.org/project/pyarchi/) [![PyPI pyversions](https://img.shields.io/pypi/pyversions/pyarchi.svg)](https://pypi.org/project/pyarchi/) [![DOI:10.1093/mnras/staa1443](https://zenodo.org/badge/DOI/10.1007/978-3-319-76207-4_15.svg)](https://doi.org/10.1093/mnras/staa1443)\n\n# ARCHI - An expansion to the CHEOPS mission official pipeline\n\nCHEOPS mission, one of ESA\'s mission has been launched in December 2019. \n\nThe official pipeline released for this mission only works for the\ntarget star, thus leaving a lot of information  left to explore. Furthermore, the presence of background stars in our images\ncan mimic astrophysical signals in the target star. \n\n\nWe felt that there was a need for a pipeline capable of analysing those stars and thus, built archi, a pipeline\nbuilt on top of the DRP, to analyse those stars. Archi has been tested with simulated data, showing proper behaviour.\nON the target star we found photometric precisions either equal or slightly better than the DRP. For the background stars we found photometric preicision 2 to 3 times higher than the target star.\n\n# How to install archi \n\nThe pipeline is written in Python3, and most features should work on all versions. However, so far, it was only tested on python 3.6, 3.7 and 3.8\n\nTo install, simply do :\n\n    pip install pyarchi\n\n# How to use the library \n\nA proper introduction to the library, alongside documentation of the multiple functions and interfaces can be found [here](https://archi.readthedocs.io/en/latest/)\n\nIf you use the pipeline, cite the article \n\n    @article{Silva_2020,\n       title={ARCHI: pipeline for light curve extraction of CHEOPS background stars},\n       ISSN={1365-2966},\n       url={http://dx.doi.org/10.1093/mnras/staa1443},\n       DOI={10.1093/mnras/staa1443},\n       journal={Monthly Notices of the Royal Astronomical Society},\n       publisher={Oxford University Press (OUP)},\n       author={Silva, André M and Sousa, Sérgio G and Santos, Nuno and Demangeon, Olivier D S and Silva, Pedro and Hoyer, S and Guterman, P and Deleuil, Magali and Ehrenreich, David},\n       year={2020},\n       month={May}\n    }\n\n# Known Problems\n\n\n [1] There is no correction for cross-contamination between stars\n \n [2] If we have data in the entire 200*200 region (not expected to happen) and using the "dynam" mask for the background stars it might "hit" one of the edges of the image. In such case, larger masks will not increase in the direction in which the edge is reached. However, the mask can still grow towards the other directions, leading to masks significantly larger than the original star. In such cases, we recommend to manually change the mask size on the "optimized factors" file.\n',
    'author': 'Kamuish',
    'author_email': 'amiguel@astro.up.pt',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Kamuish/archi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
