# -*- coding: utf-8 -*-
# ----  AUTO-GENERATED BY redox_lib_gen. DO NOT MODIFY MANUALLY!!  ---- #

from typing import List, Union

from pydantic import Field

from ..abstract_base import RedoxAbstractModel
from ..field_types import Number


class AchievementStatus(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Actor(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class AdditionalDate(RedoxAbstractModel):
    DateTime: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class AdditionalInfo(RedoxAbstractModel):
    DecisionSupport: "DecisionSupport" = Field(None)
    Link: Union[str, None] = Field(None)


class AdditionalStaff(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    Duration: Union[Number, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Role: "Role" = Field(None)
    StartDateTime: Union[str, None] = Field(None)


class AdditionalUnsignedOrder(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Questions: List["Question"] = Field(None)
    Title: Union[str, None] = Field(None)


class Address(RedoxAbstractModel):
    City: Union[str, None] = Field(None)
    Country: Union[str, None] = Field(None)
    County: Union[str, None] = Field(None)
    State: Union[str, None] = Field(None)
    StreetAddress: Union[str, None] = Field(None)
    Use: Union[str, None] = Field(None)
    ZIP: Union[str, None] = Field(None)


class AdjudicatedProcedure(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSet: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)
    Name: Union[str, None] = Field(None)


class AdjudicatedService(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)


class Adjustment(RedoxAbstractModel):
    Amount: Union[str, None] = Field(None)
    Quantity: Union[str, None] = Field(None)
    Reason: Union[str, None] = Field(None)
    ReasonGroup: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class AdministeringProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Administration(RedoxAbstractModel):
    AdministeringProvider: "AdministeringProvider" = Field(None)
    EndDate: Union[str, None] = Field(None)
    Medication: "Medication" = Field(...)
    OrderedBy: "OrderedBy" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: str = Field(...)
    VerifiedBy: "VerifiedBy" = Field(None)


class AdmissionDiagnosis(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    IsNegativeIndicator: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: "Status" = Field(None)


class AdmittingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class AdvanceDirective(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Custodians: List["Custodian"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    ExternalReference: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Type: "Type" = Field(None)
    VerifiedBy: List["VerifiedBy"] = Field(None)


class Advisory(RedoxAbstractModel):
    AdditionalInfo: List["AdditionalInfo"] = Field(None)
    AdditionalUnsignedOrders: List["AdditionalUnsignedOrder"] = Field(None)
    Description: Union[str, None] = Field(None)
    Errors: List["Error"] = Field(None)
    Notes: List["Note"] = Field(None)
    RemovableUnsignedOrders: List["RemovableUnsignedOrder"] = Field(None)
    Session: str = Field(...)
    ShowAlert: Union[bool, None] = Field(None)


class Allergy(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comment: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    Criticality: "Criticality" = Field(None)
    EndDate: Union[str, None] = Field(None)
    IsNegativeIndicator: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    OnsetDateTime: Union[str, None] = Field(None)
    Reaction: List["Reaction"] = Field(None)
    Severity: "Severity" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union["Status", str, None] = Field(None)
    Substance: "Substance" = Field(None)
    Type: "Type" = Field(None)


class AltCode(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Answer(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comment: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class AppointmentInfo(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Assessment(RedoxAbstractModel):
    Diagnoses: List["Diagnosis"] = Field(None)


class Assignee(RedoxAbstractModel):
    ContentType: Union[str, None] = Field(None)
    Learner: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Readiness: Union[str, None] = Field(None)
    Response: Union[str, None] = Field(None)


class Assignment(RedoxAbstractModel):
    ActionDateTime: Union[str, None] = Field(None)
    ActionStatus: Union[str, None] = Field(None)
    Assignees: List["Assignee"] = Field(None)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    CreatedDateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    InstanceID: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Topic: "Topic" = Field(None)


class AttendingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Attributes(RedoxAbstractModel):
    Actor: "Actor" = Field(None)
    PurposeOfUse: List["PurposeOfUse"] = Field(None)
    Roles: List["Role"] = Field(None)
    Transaction: Union[str, None] = Field(None)
    UseCases: List["UseCase"] = Field(None)
    Version: "Version" = Field(None)


class Authenticator(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Author(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Type: Union[str, None] = Field(None)


class Authorization(RedoxAbstractModel):
    AdditionalDates: List["AdditionalDate"] = Field(None)
    AdmissionSource: Union[str, None] = Field(None)
    AdmissionType: Union[str, None] = Field(None)
    AlternateID: Union[str, None] = Field(None)
    AuthorizedTreatmentCount: Union[str, None] = Field(None)
    Category: Union[str, None] = Field(None)
    CertificationCode: Union[str, None] = Field(None)
    Company: "Company" = Field(None)
    DateTime: Union[str, None] = Field(None)
    Decision: Union[str, None] = Field(None)
    DecisionReason: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    EffectiveDate: Union[str, None] = Field(None)
    EventDate: Union[str, None] = Field(None)
    ExpirationDate: Union[str, None] = Field(None)
    ExpirationDateTime: Union[str, None] = Field(None)
    IssueDate: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Number: Union[str, None] = Field(None)
    Plan: "Plan" = Field(None)
    Providers: List["Provider"] = Field(None)
    Quantity: "Quantity" = Field(None)
    ReimbursementLimit: Union[str, None] = Field(None)
    RelatedCause: Union[str, None] = Field(None)
    Request: "Request" = Field(None)
    RequestedTreatmentCount: Union[str, None] = Field(None)
    RequestedTreatmentUnits: Union[str, None] = Field(None)
    ServiceLevel: Union[str, None] = Field(None)
    ServiceLocation: Union[str, None] = Field(None)
    ServiceType: Union[str, None] = Field(None)
    Services: List["Service"] = Field(None)
    Type: Union[str, None] = Field(None)


class AuthorizingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Availability(RedoxAbstractModel):
    AvailableEndTime: Union[str, None] = Field(None)
    AvailableStartTime: Union[str, None] = Field(None)
    Days: List[str] = Field(None)


class AvailableSlot(RedoxAbstractModel):
    DateTime: str = Field(...)
    Duration: Number = Field(...)
    ID: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    Notes: List[str] = Field(None)
    Provider: "Provider" = Field(None)
    Reason: Union[str, None] = Field(None)


class BillingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddress: Union[str, None] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    OrganizationName: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Specialty: "Specialty" = Field(None)
    TIN: Union[str, None] = Field(None)


class BodySite(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class CareTeam(RedoxAbstractModel):
    Encounter: "Encounter" = Field(None)
    Members: List["Member"] = Field(None)
    Name: Union[str, None] = Field(None)
    Organization: "Organization" = Field(None)
    Status: Union[str, None] = Field(None)
    Types: List["Type"] = Field(None)


class Category(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    CertaintyScore: Number = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Chargeable(RedoxAbstractModel):
    Amount: Union[Number, None] = Field(None)
    Code: str = Field(...)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Quantity: Union[str, None] = Field(None)


class Claim(RedoxAbstractModel):
    AdditionalDates: List["AdditionalDate"] = Field(None)
    Adjustments: List["Adjustment"] = Field(None)
    BenefitsAssignmentCode: Union[bool, None] = Field(None)
    ChargedAmount: Union[str, None] = Field(None)
    ControlNumber: Union[str, None] = Field(None)
    CopayAmount: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    DiagnosisRelatedGroup: Union[str, None] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IsProviderSignatureOnFile: Union[bool, None] = Field(None)
    IsReleaseOfInformationOnFile: Union[bool, None] = Field(None)
    Lines: List["Line"] = Field(None)
    Number: Union[str, None] = Field(None)
    PatientResponsibilityAmount: Union[str, None] = Field(None)
    PaymentAmount: Union[str, None] = Field(None)
    Procedures: List["Procedure"] = Field(None)
    ProviderAcceptanceCode: Union[str, None] = Field(None)
    Providers: List["Provider"] = Field(None)
    ReceivedDate: Union[str, None] = Field(None)
    ReferenceNumbers: List["ReferenceNumber"] = Field(None)
    ServiceDateTime: Union[str, None] = Field(None)
    ServiceEndDateTime: Union[str, None] = Field(None)
    Services: List["Service"] = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    SubmissionNumber: Union[str, None] = Field(None)
    TotalAmount: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    Visit: "Visit" = Field(None)


class ClinicalInfo(RedoxAbstractModel):
    Abbreviation: Union[str, None] = Field(None)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    CompletionDateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    RelatedGroupID: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)
    ValueType: Union[str, None] = Field(None)


class Code(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    MatchPriority: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Variants: List["Variant"] = Field(None)


class CodedValue(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Comment(RedoxAbstractModel):
    Text: Union[str, None] = Field(None)


class Company(RedoxAbstractModel):
    Address: "Address" = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: Union[str, None] = Field(None)


class Completion(RedoxAbstractModel):
    EndDateTime: Union[str, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)


class Component(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comments: Union[str, None] = Field(None)
    Dose: "Dose" = Field(None)
    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Concept(RedoxAbstractModel):
    CertaintyScore: Number = Field(...)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Condition(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Confidentiality(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class ConnectionType(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Consent(RedoxAbstractModel):
    EffectiveDate: Union[str, None] = Field(None)
    Notification: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class ConsultingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Contact(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Purpose: Union[str, None] = Field(None)
    RelationToPatient: Union[str, None] = Field(None)
    Roles: List[str] = Field(None)


class Coordinator(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Criticality(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Custodian(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: Union[str, None] = Field(None)
    FirstName: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    LastName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Telecom: List["Telecom"] = Field(None)
    Type: "Type" = Field(None)


class Cycle(RedoxAbstractModel):
    Days: List["Day"] = Field(None)
    Description: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)


class Day(RedoxAbstractModel):
    ActivityDateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    EarliestDateTime: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LatestDateTime: Union[str, None] = Field(None)
    Procedures: List["Procedure"] = Field(None)


class DecisionSupport(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Demographics(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Addresses: List["Address"] = Field(None)
    Citizenship: List[str] = Field(None)
    Credentials: List[str] = Field(None)
    DOB: Union[str, None] = Field(None)
    DeathDateTime: Union[str, None] = Field(None)
    EmailAddresses: Union[List["EmailAddress"], List[str]] = Field(None)
    EthnicGroupCodes: List["EthnicGroupCode"] = Field(None)
    Ethnicity: Union[str, None] = Field(None)
    FirstName: Union[str, None] = Field(None)
    IsDeceased: Union[bool, None] = Field(None)
    IsHispanic: Union[bool, None] = Field(None)
    Language: Union[str, None] = Field(None)
    Languages: List[str] = Field(None)
    LastName: Union[str, None] = Field(None)
    MaritalStatus: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Race: Union[str, None] = Field(None)
    RaceCodes: List["RaceCode"] = Field(None)
    Religion: Union[str, None] = Field(None)
    SSN: Union[str, None] = Field(None)
    Sex: Union[str, None] = Field(None)


class Department(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class DepartmentIdentifier(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)


class Design(RedoxAbstractModel):
    Phase: Union[str, None] = Field(None)
    Purpose: Union[str, None] = Field(None)


class Destination(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Device(RedoxAbstractModel):
    ID: str = Field(...)


class Diagnosis(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codes: List["Code"] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    DocumentedDateTime: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    IsNegativeIndicator: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: "Status" = Field(None)
    Type: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class DischargeDiagnosis(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    IsNegativeIndicator: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: "Status" = Field(None)


class DischargeDisposition(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class DischargeLocation(RedoxAbstractModel):
    Department: Union[str, None] = Field(None)
    DepartmentIdentifiers: List["DepartmentIdentifier"] = Field(None)
    Facility: Union[str, None] = Field(None)
    FacilityIdentifiers: List["FacilityIdentifier"] = Field(None)
    Room: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class DischargeMedication(RedoxAbstractModel):
    Dose: "Dose" = Field(None)
    EndDate: Union[str, None] = Field(None)
    FreeTextSig: Union[str, None] = Field(None)
    Frequency: "Frequency" = Field(None)
    Indications: List["Indication"] = Field(None)
    IsPRN: Union[bool, None] = Field(None)
    NumberOfRefillsRemaining: Union[Number, None] = Field(None)
    Prescription: Union[bool, None] = Field(None)
    Product: "Product" = Field(None)
    Rate: "Rate" = Field(None)
    Route: "Route" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    SupplyOrder: "SupplyOrder" = Field(None)


class DischargeStatus(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Dispense(RedoxAbstractModel):
    Amount: Union[Number, None] = Field(None)
    Units: Union[str, None] = Field(None)


class Document(RedoxAbstractModel):
    Author: "Author" = Field(None)
    Confidentiality: "Confidentiality" = Field(None)
    Custodian: "Custodian" = Field(None)
    DateTime: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    FileType: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Locale: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Title: Union[str, None] = Field(None)
    Type: Union["Type", str, None] = Field(None)
    TypeCode: "TypeCode" = Field(None)
    Types: List["Type"] = Field(None)
    Visit: "Visit" = Field(None)


class Dose(RedoxAbstractModel):
    Quantity: Union[Number, str, None] = Field(None)
    Units: Union[str, None] = Field(None)


class Drug(RedoxAbstractModel):
    NDC: Union[str, None] = Field(None)
    PrescriptionID: Union[str, None] = Field(None)
    Quantity: "Quantity" = Field(None)


class Education(RedoxAbstractModel):
    ActionDateTime: Union[str, None] = Field(None)
    ActionStatus: Union[str, None] = Field(None)
    Assignments: List["Assignment"] = Field(None)
    CreatedDateTime: Union[str, None] = Field(None)
    InstanceID: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Subject: "Subject" = Field(...)


class Eligibility(RedoxAbstractModel):
    Gender: Union[str, None] = Field(None)
    MaximumAge: Union[Number, None] = Field(None)
    MinimumAge: Union[Number, None] = Field(None)


class EmailAddress(RedoxAbstractModel):
    Address: Union[str, None] = Field(None)


class Employer(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: Union[str, None] = Field(None)


class Encounter(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Diagnosis: List["Diagnosis"] = Field(None)
    DischargeDisposition: "DischargeDisposition" = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Locations: List["Location"] = Field(None)
    Name: Union[str, None] = Field(None)
    Providers: List["Provider"] = Field(None)
    ReasonForVisit: List["ReasonForVisit"] = Field(None)
    Status: Union[str, None] = Field(None)
    Type: "Type" = Field(None)


class Endpoint(RedoxAbstractModel):
    Address: Union[str, None] = Field(None)
    Attributes: "Attributes" = Field(None)
    ConnectionType: "ConnectionType" = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    MIMEType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Enrollment(RedoxAbstractModel):
    Coordinators: List["Coordinator"] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    SubjectStatus: Union[str, None] = Field(None)


class EnteredBy(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Entry(RedoxAbstractModel):
    Category: "Category" = Field(...)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Concept: "Concept" = Field(None)
    Description: Union[str, None] = Field(None)
    EntryID: Union[str, None] = Field(None)
    Error: "Error" = Field(None)
    Normalization: List["Normalization"] = Field(None)
    Status: str = Field(None)
    Submitted: "Submitted" = Field(None)
    Text: "Text" = Field(None)
    Transaction: "Transaction" = Field(None)


class Equipment(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Duration: Union[Number, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)


class Error(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Message: Union[str, None] = Field(None)


class EthnicGroupCode(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class ExtendedProperty(RedoxAbstractModel):
    Category: Union[str, None] = Field(None)
    Properties: List["Property"] = Field(None)


class FacilityIdentifier(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)


class FamilyHistory(RedoxAbstractModel):
    Problems: List["Problem"] = Field(None)
    Relation: "Relation" = Field(None)


class Frequency(RedoxAbstractModel):
    EventCode: Union[str, None] = Field(None)
    InstitutionSpecified: Union[bool, None] = Field(None)
    Period: Union[Number, str, None] = Field(None)
    PeriodMax: Union[str, None] = Field(None)
    Unit: Union[str, None] = Field(None)


class FunctionalStatus(RedoxAbstractModel):
    Observations: List["Observation"] = Field(None)
    Supplies: List["Supply"] = Field(None)


class Goal(RedoxAbstractModel):
    AchievementStatus: "AchievementStatus" = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    CodedValue: "CodedValue" = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Milestones: List["Milestone"] = Field(None)
    Name: Union[str, None] = Field(None)
    Priority: "Priority" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Guarantor(RedoxAbstractModel):
    Address: "Address" = Field(None)
    DOB: Union[str, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    Employer: "Employer" = Field(None)
    FirstName: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    Number: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    RelationToPatient: Union[str, None] = Field(None)
    SSN: Union[str, None] = Field(None)
    Sex: Union[str, None] = Field(None)
    Spouse: "Spouse" = Field(None)
    Type: Union[str, None] = Field(None)


class Header(RedoxAbstractModel):
    DirectAddressFrom: Union[str, None] = Field(None)
    DirectAddressTo: Union[str, None] = Field(None)
    Document: "Document" = Field(None)
    PCP: "PCP" = Field(None)
    Patient: "Patient" = Field(None)


class HealthConcern(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Category: "Category" = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    ConcernType: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Interpretation: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    TargetSite: "TargetSite" = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class HealthStatus(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Identifier(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    System: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Immunization(RedoxAbstractModel):
    DateTime: Union[str, None] = Field(None)
    Dose: "Dose" = Field(None)
    Product: "Product" = Field(None)
    Route: "Route" = Field(None)
    Status: Union[str, None] = Field(None)


class Indication(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Instruction(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Text: Union[str, None] = Field(None)


class Insurance(RedoxAbstractModel):
    AgreementType: Union[str, None] = Field(None)
    Company: "Company" = Field(None)
    CoverageType: Union[str, None] = Field(None)
    EffectiveDate: Union[str, None] = Field(None)
    ExpirationDate: Union[str, None] = Field(None)
    GroupName: Union[str, None] = Field(None)
    GroupNumber: Union[str, None] = Field(None)
    Insured: "Insured" = Field(None)
    MemberNumber: Union[str, None] = Field(None)
    Plan: "Plan" = Field(None)
    PolicyNumber: Union[str, None] = Field(None)
    Priority: Union[str, None] = Field(None)


class Insured(RedoxAbstractModel):
    Address: "Address" = Field(None)
    DOB: Union[str, None] = Field(None)
    FirstName: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    Relationship: Union[str, None] = Field(None)
    SSN: Union[str, None] = Field(None)
    Sex: Union[str, None] = Field(None)


class Item(RedoxAbstractModel):
    ContainsLatex: Union[bool, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(...)
    IsChargeable: Union[bool, None] = Field(None)
    Location: "Location" = Field(None)
    LotNumber: Union[str, None] = Field(None)
    Notes: Union[str, None] = Field(None)
    OrderingProvider: "OrderingProvider" = Field(None)
    Price: Union[Number, None] = Field(None)
    Procedure: "Procedure" = Field(None)
    Quantity: Union[Number, None] = Field(None)
    SerialNumber: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    UsedQuantity: Union[Number, None] = Field(None)
    Vendor: "Vendor" = Field(None)
    WastedQuantity: Union[Number, None] = Field(None)


class LastUpdated(RedoxAbstractModel):
    EndDateTime: Union[str, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)


class LexicalReference(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    DefaultCode: Union[str, None] = Field(None)
    DefaultName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Line(RedoxAbstractModel):
    Amount: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    ID: Union[str, None] = Field(None)
    IsEmergency: Union[bool, None] = Field(None)
    Notes: Union[str, None] = Field(None)
    Procedure: "Procedure" = Field(None)
    RevenueCode: Union[str, None] = Field(None)
    ServiceDateTime: Union[str, None] = Field(None)
    ServiceEndDateTime: Union[str, None] = Field(None)
    UnitCount: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)


class Location(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Bed: Union[str, None] = Field(None)
    Bin: Union[str, None] = Field(None)
    Department: Union[str, None] = Field(None)
    DepartmentIdentifiers: List["DepartmentIdentifier"] = Field(None)
    Description: Union[str, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    Facility: Union[str, None] = Field(None)
    FacilityIdentifiers: List["FacilityIdentifier"] = Field(None)
    ID: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Room: Union[str, None] = Field(None)
    SpecialtyDepartment: "SpecialtyDepartment" = Field(None)
    Status: Union[str, None] = Field(None)
    Telecom: List["Telecom"] = Field(None)
    Type: Union["Type", str, None] = Field(None)


class Log(RedoxAbstractModel):
    AttemptID: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)


class Manufacturer(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Match(RedoxAbstractModel):
    Codes: List["Code"] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class Media(RedoxAbstractModel):
    Authenticated: Union[str, None] = Field(None)
    Authenticator: "Authenticator" = Field(None)
    Availability: str = Field(...)
    CreationDateTime: Union[str, None] = Field(None)
    DirectAddressFrom: Union[str, None] = Field(None)
    DirectAddressTo: Union[str, None] = Field(None)
    DocumentDescription: Union[str, None] = Field(None)
    DocumentID: str = Field(...)
    DocumentType: str = Field(...)
    FileContents: str = Field(None)
    FileName: str = Field(...)
    FileType: str = Field(...)
    Notifications: List["Notification"] = Field(None)
    OriginalDocumentID: str = Field(None)
    Provider: "Provider" = Field(...)
    ServiceDateTime: Union[str, None] = Field(None)


class MedicalEquipment(RedoxAbstractModel):
    Comments: List["Comment"] = Field(None)
    Procedure: "Procedure" = Field(None)
    Product: "Product" = Field(None)
    Quantity: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class Medication(RedoxAbstractModel):
    Components: List["Component"] = Field(None)
    Dispense: "Dispense" = Field(None)
    Dose: "Dose" = Field(None)
    EndDate: Union[str, None] = Field(None)
    FreeTextSig: Union[str, None] = Field(None)
    Frequency: "Frequency" = Field(None)
    Indications: List["Indication"] = Field(None)
    IsPRN: Union[bool, None] = Field(None)
    LotNumber: Union[str, None] = Field(None)
    NumberOfRefillsRemaining: Union[Number, None] = Field(None)
    Order: "Order" = Field(None)
    Prescription: Union[bool, None] = Field(None)
    Product: "Product" = Field(None)
    Rate: "Rate" = Field(None)
    Route: "Route" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    SupplyOrder: "SupplyOrder" = Field(None)


class MedicationAdministration(RedoxAbstractModel):
    Dose: "Dose" = Field(None)
    EndDate: Union[str, None] = Field(None)
    Frequency: "Frequency" = Field(None)
    Product: "Product" = Field(None)
    Rate: "Rate" = Field(None)
    Route: "Route" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class MedicationsAdministered(RedoxAbstractModel):
    Dose: "Dose" = Field(None)
    EndDate: Union[str, None] = Field(None)
    Frequency: "Frequency" = Field(None)
    Product: "Product" = Field(None)
    Rate: "Rate" = Field(None)
    ReasonNotGiven: Union[str, None] = Field(None)
    Route: "Route" = Field(None)
    StartDate: Union[str, None] = Field(None)


class Medium(RedoxAbstractModel):
    CreationDateTime: Union[str, None] = Field(None)
    DocumentDescription: Union[str, None] = Field(None)
    DocumentID: Union[str, None] = Field(None)
    DocumentType: Union[str, None] = Field(None)
    FileContents: Union[str, None] = Field(None)
    FileName: Union[str, None] = Field(None)
    FileType: Union[str, None] = Field(None)
    Patient: "Patient" = Field(None)
    ServiceDateTime: Union[str, None] = Field(None)
    Visit: "Visit" = Field(None)


class Member(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    FirstName: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    Roles: List["Role"] = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    Telecom: List["Telecom"] = Field(None)


class Message(RedoxAbstractModel):
    ID: Union[Number, None] = Field(None)


class Meta(RedoxAbstractModel):
    BatchID: Union[str, None] = Field(None)
    CanceledEvent: Union[str, None] = Field(None)
    CurrentBatch: Union[str, None] = Field(None)
    DataModel: str = Field(...)
    Destinations: List["Destination"] = Field(None)
    EventDateTime: Union[str, None] = Field(None)
    EventType: str = Field(...)
    FacilityCode: Union[str, None] = Field(None)
    IsIncomplete: Union[bool, None] = Field(None)
    Logs: List["Log"] = Field(None)
    Message: "Message" = Field(None)
    SessionBaseURL: Union[str, None] = Field(None)
    SessionID: Union[str, None] = Field(None)
    Source: "Source" = Field(None)
    Test: Union[bool, None] = Field(None)
    TotalBatches: Union[str, None] = Field(None)
    Transmission: "Transmission" = Field(None)


class Milestone(RedoxAbstractModel):
    AchievementStatus: "AchievementStatus" = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    CodedValue: "CodedValue" = Field(None)
    DateTime: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Priority: "Priority" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class MixtureComponent(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeType: Union[str, None] = Field(None)
    Dose: "Dose" = Field(None)


class NDC(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class NameSearch(RedoxAbstractModel):
    SearchType: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Normalization(RedoxAbstractModel):
    LexicalReference: "LexicalReference" = Field(None)
    Matches: List["Match"] = Field(None)
    Score: "Score" = Field(None)


class Note(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Authenticator: "Authenticator" = Field(None)
    Availability: Union[str, None] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Components: List["Component"] = Field(None)
    ContentType: Union[str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Display: Union[str, None] = Field(None)
    DocumentDescription: Union[str, None] = Field(None)
    DocumentID: Union[str, None] = Field(None)
    DocumentType: Union[str, None] = Field(None)
    DocumentationDateTime: Union[str, None] = Field(None)
    Encounter: "Encounter" = Field(None)
    FileContents: Union[str, None] = Field(None)
    FileName: Union[str, None] = Field(None)
    FileType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Notifications: List["Notification"] = Field(None)
    OriginalDocumentID: str = Field(None)
    Patient: "Patient" = Field(None)
    Provider: "Provider" = Field(None)
    ServiceDateTime: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Text: Union[str, None] = Field(None)
    Visit: "Visit" = Field(None)


class NoteSection(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List["Note"] = Field(None)
    Text: Union[str, None] = Field(None)
    Title: Union[str, None] = Field(None)


class Notification(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Observation(RedoxAbstractModel):
    AbnormalFlag: Union[str, None] = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    CodedValue: "CodedValue" = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Interpretation: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Observer: "Observer" = Field(None)
    ReferenceRange: "ReferenceRange" = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    TargetSite: "TargetSite" = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union["Value", str, None] = Field(None)
    ValueText: Union[str, None] = Field(None)
    ValueType: Union[str, None] = Field(None)


class ObservationMethod(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Observer(RedoxAbstractModel):
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)


class Order(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    ApplicationOrderID: Union[str, None] = Field(None)
    ClinicalInfo: List["ClinicalInfo"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    CollectionDateTime: Union[str, None] = Field(None)
    Comments: Union[str, None] = Field(None)
    CompletionDateTime: Union[str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    EHRID: Union[str, None] = Field(None)
    EnteredBy: "EnteredBy" = Field(None)
    Expiration: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Indications: List["Indication"] = Field(None)
    LastUpdated: Union[str, None] = Field(None)
    Medication: "Medication" = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    OrderingFacility: "OrderingFacility" = Field(None)
    Patient: "Patient" = Field(None)
    Pharmacy: "Pharmacy" = Field(None)
    Priority: Union[str, None] = Field(None)
    Procedure: "Procedure" = Field(None)
    Provider: "Provider" = Field(None)
    ResponseFlag: Union[str, None] = Field(None)
    ResultCopyProviders: List["ResultCopyProvider"] = Field(None)
    Results: List["Result"] = Field(None)
    ResultsStatus: Union[str, None] = Field(None)
    Specimen: "Specimen" = Field(None)
    Status: Union[str, None] = Field(None)
    TransactionDateTime: Union[str, None] = Field(None)
    VerifiedBy: "VerifiedBy" = Field(None)
    Visit: "Visit" = Field(None)


class OrderedBy(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class OrderingFacility(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: Union[str, None] = Field(None)


class OrderingProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Organization(RedoxAbstractModel):
    Active: bool = Field(None)
    Address: "Address" = Field(None)
    Aliases: List[str] = Field(None)
    Contacts: List["Contact"] = Field(None)
    DestinationID: Union[str, None] = Field(None)
    Endpoints: List["Endpoint"] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    IsActive: Union[str, None] = Field(None)
    ManagingOrg: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    PartOf: "PartOf" = Field(None)
    Telecom: List["Telecom"] = Field(None)
    Type: Union["Type", str, None] = Field(None)


class PCP(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Type: Union[str, None] = Field(None)


class Paging(RedoxAbstractModel):
    Count: Union[Number, None] = Field(None)
    Index: Union[Number, None] = Field(None)


class PartOf(RedoxAbstractModel):
    Identifier: "Identifier" = Field(None)


class Patient(RedoxAbstractModel):
    Allergies: List["Allergy"] = Field(None)
    Claims: List["Claim"] = Field(None)
    Consent: "Consent" = Field(None)
    Contacts: List["Contact"] = Field(None)
    Demographics: "Demographics" = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    Guarantor: "Guarantor" = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Insurances: List["Insurance"] = Field(None)
    IsPregnant: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Organization: "Organization" = Field(None)
    PCP: "PCP" = Field(None)
    PreviousIdentifiers: List["PreviousIdentifier"] = Field(None)
    RelationToSubscriber: Union[str, None] = Field(None)
    Vaccinations: List["Vaccination"] = Field(None)
    Visits: List["Visit"] = Field(None)
    Weight: Union[str, None] = Field(None)


class Payee(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddress: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Payer(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddress: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Payment(RedoxAbstractModel):
    Claim: "Claim" = Field(None)
    Claims: List["Claim"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Patient: "Patient" = Field(None)


class Performer(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Pharmacy(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class PhoneNumber(RedoxAbstractModel):
    Business: Union[str, None] = Field(None)
    Fax: Union[str, None] = Field(None)
    Home: Union[str, None] = Field(None)
    Mobile: Union[str, None] = Field(None)
    Office: Union[str, None] = Field(None)
    Work: Union[str, None] = Field(None)


class Plan(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class PlanOfCare(RedoxAbstractModel):
    Encounters: List["Encounter"] = Field(None)
    MedicationAdministration: List["MedicationAdministration"] = Field(None)
    Orders: List["Order"] = Field(None)
    Procedures: List["Procedure"] = Field(None)
    Services: List["Service"] = Field(None)
    Supplies: List["Supply"] = Field(None)


class Position(RedoxAbstractModel):
    BeginOffset: Number = Field(...)
    EndOffset: Number = Field(...)


class PotentialMatch(RedoxAbstractModel):
    Contacts: List["Contact"] = Field(None)
    Demographics: "Demographics" = Field(None)
    Guarantor: "Guarantor" = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Insurances: List["Insurance"] = Field(None)
    Notes: List[str] = Field(None)
    PCP: "PCP" = Field(None)


class Pregnancy(RedoxAbstractModel):
    Comments: List["Comment"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    EstimatedDelivery: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)


class PreviousIdentifier(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)


class PreviousLocation(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Bed: Union[str, None] = Field(None)
    Department: Union[str, None] = Field(None)
    DepartmentIdentifiers: List["DepartmentIdentifier"] = Field(None)
    Facility: Union[str, None] = Field(None)
    FacilityIdentifiers: List["FacilityIdentifier"] = Field(None)
    Room: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class PrimaryResultsInterpreter(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class PrincipalInvestigator(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Priority(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Problem(RedoxAbstractModel):
    AgeAtOnset: Union[str, None] = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Category: "Category" = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comment: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    HealthStatus: "HealthStatus" = Field(None)
    IsCauseOfDeath: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: "Status" = Field(None)
    Type: "Type" = Field(None)


class Procedure(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Authorization: "Authorization" = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSet: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Duration: Number = Field(None)
    Modifier: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    PerformedDateTime: Union[str, None] = Field(None)
    Performers: List["Performer"] = Field(None)
    ProcedureInfo: List["ProcedureInfo"] = Field(None)
    Quantity: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    StatusReason: Union[str, None] = Field(None)
    TargetSite: "TargetSite" = Field(None)
    Units: Union[str, None] = Field(None)


class ProcedureInfo(RedoxAbstractModel):
    Description: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Procedures(RedoxAbstractModel):
    Observations: List["Observation"] = Field(None)
    Procedures: List["Procedure"] = Field(None)
    Services: List["Service"] = Field(None)


class Producer(RedoxAbstractModel):
    Address: "Address" = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Product(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    BrandName: Union[str, None] = Field(None)
    CatalogNumber: Union[str, None] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    DeviceID: Union[str, None] = Field(None)
    DistinctID: Union[str, None] = Field(None)
    ExpirationDate: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Issuer: Union[str, None] = Field(None)
    LotNumber: Union[str, None] = Field(None)
    ManufactureDate: Union[str, None] = Field(None)
    Manufacturer: Union["Manufacturer", str, None] = Field(None)
    ManufacturerName: Union[str, None] = Field(None)
    ModelNumber: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    SafetyObservations: List["SafetyObservation"] = Field(None)
    SerialNumber: Union[str, None] = Field(None)
    Status: "Status" = Field(None)


class Property(RedoxAbstractModel):
    Property: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Protocol(RedoxAbstractModel):
    Cycles: List["Cycle"] = Field(None)
    Description: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)


class Provider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    ContactInfo: Union[str, None] = Field(None)
    Credentials: List[str] = Field(None)
    Demographics: "Demographics" = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    IsActive: bool = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    MiddleName: Union[str, None] = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Qualifications: List["Qualification"] = Field(None)
    Role: Union["Role", str, None] = Field(None)
    Roles: List["Role"] = Field(None)
    Specialty: "Specialty" = Field(None)
    Type: Union[str, None] = Field(None)


class PurposeOfUse(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Qualification(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    StartDate: Union[str, None] = Field(None)


class Quantity(RedoxAbstractModel):
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Question(RedoxAbstractModel):
    Answer: "Answer" = Field(None)
    Answers: List["Answer"] = Field(None)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Question: "Question" = Field(None)


class RaceCode(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class RadiusSearch(RedoxAbstractModel):
    Radius: Union[str, None] = Field(None)
    ZipCode: Union[str, None] = Field(None)


class Rate(RedoxAbstractModel):
    Quantity: Union[Number, str, None] = Field(None)
    Units: Union[str, None] = Field(None)


class Reaction(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Severity: "Severity" = Field(None)
    Text: Union[str, None] = Field(None)


class ReasonForVisit(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Category: "Category" = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Receiver(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddress: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class ReferenceNumber(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class ReferenceRange(RedoxAbstractModel):
    High: Union[Number, str, None] = Field(None)
    Low: Union[Number, str, None] = Field(None)
    Text: Union[str, None] = Field(None)


class Referral(RedoxAbstractModel):
    AlternateID: Union[str, None] = Field(None)
    Authorization: "Authorization" = Field(None)
    Category: Union[str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    DepartmentSpecialty: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    ExpirationDateTime: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Priority: Union[str, None] = Field(None)
    Procedures: List["Procedure"] = Field(None)
    ProcessDateTime: Union[str, None] = Field(None)
    ProviderSpecialty: Union[str, None] = Field(None)
    Providers: List["Provider"] = Field(None)
    Reason: Union[str, None] = Field(None)
    RelatedCause: Union[str, None] = Field(None)
    RequestType: Union[str, None] = Field(None)
    ServiceLocation: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    StatusReason: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    Visit: "Visit" = Field(None)


class ReferringProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Relation(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Demographics: "Demographics" = Field(None)
    IsDeceased: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)


class RemovableUnsignedOrder(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Title: Union[str, None] = Field(None)


class Request(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)


class ResolvedProblem(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Category: "Category" = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comment: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Status: "Status" = Field(None)


class Result(RedoxAbstractModel):
    AbnormalFlag: Union[str, None] = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    CompletionDateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Encounter: "Encounter" = Field(None)
    FileType: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    ObservationMethod: "ObservationMethod" = Field(None)
    Observations: List["Observation"] = Field(None)
    Performer: "Performer" = Field(None)
    PrimaryResultsInterpreter: "PrimaryResultsInterpreter" = Field(None)
    Producer: "Producer" = Field(None)
    ReferenceRange: "ReferenceRange" = Field(None)
    RelatedGroupID: Union[str, None] = Field(None)
    Specimen: "Specimen" = Field(None)
    Status: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)
    ValueType: Union[str, None] = Field(None)


class ResultCopyProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Role(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Availability: List["Availability"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Locations: List["Location"] = Field(None)
    Name: Union[str, None] = Field(None)
    Organization: "Organization" = Field(None)
    Services: List["Service"] = Field(None)
    Specialties: List["Specialty"] = Field(None)
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Route(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class SafetyObservation(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Score(RedoxAbstractModel):
    Description: Union[str, None] = Field(None)
    Value: Union[Number, None] = Field(None)


class Service(RedoxAbstractModel):
    AdjudicatedProcedure: "AdjudicatedProcedure" = Field(None)
    AdjudicatedService: "AdjudicatedService" = Field(None)
    Adjustments: List["Adjustment"] = Field(None)
    AllowedAmount: Union[str, None] = Field(None)
    AltCodes: List["AltCode"] = Field(None)
    Amount: Union[str, None] = Field(None)
    AuthorizationNumber: Union[str, None] = Field(None)
    ChargedAmount: Union[str, None] = Field(None)
    ChargedUnits: Union[str, None] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Decision: Union[str, None] = Field(None)
    DecisionReason: Union[str, None] = Field(None)
    DeductibleAmount: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    Drug: "Drug" = Field(None)
    EffectiveDate: Union[str, None] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    ExpirationDate: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    IsEmergency: Union[bool, None] = Field(None)
    IssueDate: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)
    Name: Union[str, None] = Field(None)
    Notes: Union[List[str], str, None] = Field(None)
    PaymentAmount: Union[str, None] = Field(None)
    PaymentUnits: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Quantity: "Quantity" = Field(None)
    ReferenceNumbers: List["ReferenceNumber"] = Field(None)
    RevenueCode: Union[str, None] = Field(None)
    ServiceDate: Union[str, None] = Field(None)
    ServiceDateTime: Union[str, None] = Field(None)
    ServiceEndDateTime: Union[str, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    SubmittedProcedure: "SubmittedProcedure" = Field(None)
    SubmittedService: "SubmittedService" = Field(None)
    Type: Union[str, None] = Field(None)


class Session(RedoxAbstractModel):
    Questions: List["Question"] = Field(None)


class Severity(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Site(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Slot(RedoxAbstractModel):
    DateTime: str = Field(...)
    Duration: Number = Field(...)
    ID: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    Provider: "Provider" = Field(None)
    Reason: Union[str, None] = Field(None)


class SocialHistory(RedoxAbstractModel):
    Observations: List["Observation"] = Field(None)
    Pregnancy: List["Pregnancy"] = Field(None)
    TobaccoUse: List["TobaccoUse"] = Field(None)


class Source(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Specialty(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)


class SpecialtyDepartment(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Specimen(RedoxAbstractModel):
    BodySite: Union[str, None] = Field(None)
    CollectionDateTime: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Identifiers: List[str] = Field(None)
    Source: Union["Source", str, None] = Field(None)
    TargetSite: "TargetSite" = Field(None)


class Sponsor(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Spouse(RedoxAbstractModel):
    FirstName: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)


class Status(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Study(RedoxAbstractModel):
    Conditions: List["Condition"] = Field(None)
    Coordinators: List["Coordinator"] = Field(None)
    Description: Union[str, None] = Field(None)
    Design: "Design" = Field(None)
    Eligibility: "Eligibility" = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Location: "Location" = Field(None)
    PrincipalInvestigator: "PrincipalInvestigator" = Field(None)
    Sponsor: "Sponsor" = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Title: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class Subject(RedoxAbstractModel):
    Code: str = Field(...)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Submission(RedoxAbstractModel):
    BillingProvider: "BillingProvider" = Field(None)
    Subscribers: List["Subscriber"] = Field(None)


class Submitted(RedoxAbstractModel):
    Category: str = Field(...)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    EntryID: Union[str, None] = Field(None)


class SubmittedProcedure(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSet: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)
    Name: Union[str, None] = Field(None)


class SubmittedService(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Modifiers: List[str] = Field(None)


class Submitter(RedoxAbstractModel):
    Address: "Address" = Field(None)
    EmailAddress: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Name: Union[str, None] = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Subscriber(RedoxAbstractModel):
    Address: "Address" = Field(None)
    DOB: Union[str, None] = Field(None)
    Demographics: "Demographics" = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(None)
    Insurance: "Insurance" = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    OrganizationName: Union[str, None] = Field(None)
    Patients: List["Patient"] = Field(None)
    RelationToPatient: Union[str, None] = Field(None)
    ResponsibilityLevel: Union[str, None] = Field(None)
    Sex: Union[str, None] = Field(None)


class Substance(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Supply(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class SupplyOrder(RedoxAbstractModel):
    EndDate: Union[str, None] = Field(None)
    NumberOfRefillsRemaining: Union[Number, None] = Field(None)
    Quantity: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)


class SurgeryStaff(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    Duration: Union[Number, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)
    Role: "Role" = Field(None)
    StartDateTime: Union[str, None] = Field(None)


class SurgicalCase(RedoxAbstractModel):
    Number: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class SurgicalInfo(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class TargetSite(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Task(RedoxAbstractModel):
    ID: Union[str, None] = Field(None)
    Message: Union[str, None] = Field(None)
    Status: str = Field(None)


class Telecom(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Use: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Text(RedoxAbstractModel):
    Contents: Union[str, None] = Field(None)
    Position: "Position" = Field(None)


class TobaccoUse(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Comments: List["Comment"] = Field(None)
    EndDate: Union[str, None] = Field(None)
    IsSmokingStatus: Union[bool, None] = Field(None)
    Name: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)


class Topic(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class Transaction(RedoxAbstractModel):
    Chargeable: "Chargeable" = Field(None)
    CreditOrDebit: Union[str, None] = Field(None)
    DateTimeOfService: str = Field(None)
    Department: "Department" = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    NDC: "NDC" = Field(None)
    OrderID: Union[str, None] = Field(None)
    OrderingProviders: List["OrderingProvider"] = Field(None)
    PaymentDateTime: Union[str, None] = Field(None)
    PaymentMethod: Union[str, None] = Field(None)
    Payments: List["Payment"] = Field(None)
    Performers: List["Performer"] = Field(None)
    Procedure: "Procedure" = Field(None)
    Receiver: "Receiver" = Field(None)
    Submissions: List["Submission"] = Field(None)
    Submitter: "Submitter" = Field(None)
    Task: "Task" = Field(None)
    TotalPaymentAmount: Union[str, None] = Field(None)
    TrackingNumber: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)
    VendorID: str = Field(None)


class Transmission(RedoxAbstractModel):
    ID: Union[Number, None] = Field(None)


class Type(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class TypeCode(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class UnsignedMedicationOrder(RedoxAbstractModel):
    Dose: "Dose" = Field(None)
    EndDate: Union[str, None] = Field(None)
    Frequency: "Frequency" = Field(None)
    Identifiers: List["Identifier"] = Field(...)
    MixtureComponents: List["MixtureComponent"] = Field(None)
    MixtureType: Union[str, None] = Field(None)
    Mode: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Priority: Union[str, None] = Field(None)
    Product: "Product" = Field(None)
    Questions: List["Question"] = Field(None)
    Route: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)


class UnsignedProcedureOrder(RedoxAbstractModel):
    BodySite: "BodySite" = Field(None)
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    EndDate: Union[str, None] = Field(None)
    Identifiers: List["Identifier"] = Field(...)
    Mode: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    Questions: List["Question"] = Field(None)
    ScheduledDate: Union[str, None] = Field(None)
    StartDate: Union[str, None] = Field(None)


class UseCase(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Vaccination(RedoxAbstractModel):
    Action: str = Field(None)
    ClinicalInfo: List["ClinicalInfo"] = Field(None)
    DateTime: Union[str, None] = Field(None)
    Dose: "Dose" = Field(None)
    Location: "Location" = Field(None)
    Notes: List[str] = Field(None)
    Order: "Order" = Field(None)
    Product: "Product" = Field(None)
    Provider: "Provider" = Field(None)
    RefusalReason: Union[str, None] = Field(None)
    Route: "Route" = Field(None)
    Site: "Site" = Field(None)


class Value(RedoxAbstractModel):
    AltCodes: List["AltCode"] = Field(None)
    Code: Union[str, None] = Field(None)
    CodeSystem: Union[str, None] = Field(None)
    CodeSystemName: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class Variant(RedoxAbstractModel):
    ExtendedProperties: List["ExtendedProperty"] = Field(None)
    Title: Union[str, None] = Field(None)
    TitleStatus: Union[str, None] = Field(None)
    TitleType: Union[str, None] = Field(None)


class Vendor(RedoxAbstractModel):
    CatalogNumber: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class VerifiedBy(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: Union[List[str], str, None] = Field(None)
    DateTime: Union[str, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class Version(RedoxAbstractModel):
    System: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)


class Visit(RedoxAbstractModel):
    AccountNumber: Union[str, None] = Field(None)
    AdditionalStaff: List["AdditionalStaff"] = Field(None)
    AdmittingProvider: "AdmittingProvider" = Field(None)
    AppointmentInfo: List["AppointmentInfo"] = Field(None)
    AttendingProvider: "AttendingProvider" = Field(None)
    AttendingProviders: List["AttendingProvider"] = Field(None)
    Balance: Union[Number, None] = Field(None)
    CancelDateTime: Union[str, None] = Field(None)
    CancelReason: Union[str, None] = Field(None)
    ConsultingProvider: "ConsultingProvider" = Field(None)
    DateTime: Union[str, None] = Field(None)
    Diagnoses: List["Diagnosis"] = Field(None)
    DiagnosisRelatedGroup: Union[Number, None] = Field(None)
    DiagnosisRelatedGroupType: Union[Number, None] = Field(None)
    DischargeDateTime: Union[str, None] = Field(None)
    DischargeDisposition: "DischargeDisposition" = Field(None)
    DischargeLocation: "DischargeLocation" = Field(None)
    DischargeStatus: "DischargeStatus" = Field(None)
    Duration: Union[Number, None] = Field(None)
    EndDateTime: Union[str, None] = Field(None)
    Equipment: List["Equipment"] = Field(None)
    Guarantor: "Guarantor" = Field(None)
    ID: Union[str, None] = Field(None)
    Instructions: List[str] = Field(None)
    Insurances: List["Insurance"] = Field(None)
    LastUpdated: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    Locations: List["Location"] = Field(None)
    NoShowReason: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    OldDateTime: Union[str, None] = Field(None)
    OldVisitNumber: Union[str, None] = Field(None)
    Patient: "Patient" = Field(None)
    PatientClass: Union[str, None] = Field(None)
    Patients: List["Patient"] = Field(None)
    PreviousLocation: "PreviousLocation" = Field(None)
    Procedures: List["Procedure"] = Field(None)
    Reason: Union[str, None] = Field(None)
    Reasons: List[str] = Field(None)
    ReferringProvider: "ReferringProvider" = Field(None)
    ScheduledDateTime: Union[str, None] = Field(None)
    StartDateTime: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)
    Type: Union["Type", str, None] = Field(None)
    VisitDateTime: Union[str, None] = Field(None)
    VisitNumber: Union[str, None] = Field(None)
    VisitPreference: List["VisitPreference"] = Field(None)
    VisitProvider: "VisitProvider" = Field(None)
    VisitType: List["VisitType"] = Field(None)


class VisitPreference(RedoxAbstractModel):
    Day: List[str] = Field(None)
    Duration: Union[str, None] = Field(None)
    DurationUnit: Union[str, None] = Field(None)
    Time: List[str] = Field(None)


class VisitProvider(RedoxAbstractModel):
    Address: "Address" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "Location" = Field(None)
    PhoneNumber: "PhoneNumber" = Field(None)


class VisitType(RedoxAbstractModel):
    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)


class VitalSign(RedoxAbstractModel):
    DateTime: Union[str, None] = Field(None)
    Observations: List["Observation"] = Field(None)


AdditionalInfo.update_forward_refs()
AdditionalStaff.update_forward_refs()
AdditionalUnsignedOrder.update_forward_refs()
AdministeringProvider.update_forward_refs()
Administration.update_forward_refs()
AdmissionDiagnosis.update_forward_refs()
AdmittingProvider.update_forward_refs()
AdvanceDirective.update_forward_refs()
Advisory.update_forward_refs()
Allergy.update_forward_refs()
Assessment.update_forward_refs()
Assignment.update_forward_refs()
AttendingProvider.update_forward_refs()
Attributes.update_forward_refs()
Authenticator.update_forward_refs()
Author.update_forward_refs()
Authorization.update_forward_refs()
AuthorizingProvider.update_forward_refs()
AvailableSlot.update_forward_refs()
BillingProvider.update_forward_refs()
CareTeam.update_forward_refs()
Category.update_forward_refs()
Claim.update_forward_refs()
Code.update_forward_refs()
CodedValue.update_forward_refs()
Company.update_forward_refs()
Component.update_forward_refs()
Condition.update_forward_refs()
ConsultingProvider.update_forward_refs()
Contact.update_forward_refs()
Coordinator.update_forward_refs()
Custodian.update_forward_refs()
Cycle.update_forward_refs()
Day.update_forward_refs()
Demographics.update_forward_refs()
Diagnosis.update_forward_refs()
DischargeDiagnosis.update_forward_refs()
DischargeDisposition.update_forward_refs()
DischargeLocation.update_forward_refs()
DischargeMedication.update_forward_refs()
Document.update_forward_refs()
Drug.update_forward_refs()
Education.update_forward_refs()
Employer.update_forward_refs()
Encounter.update_forward_refs()
Endpoint.update_forward_refs()
Enrollment.update_forward_refs()
EnteredBy.update_forward_refs()
Entry.update_forward_refs()
ExtendedProperty.update_forward_refs()
FamilyHistory.update_forward_refs()
FunctionalStatus.update_forward_refs()
Goal.update_forward_refs()
Guarantor.update_forward_refs()
Header.update_forward_refs()
HealthConcern.update_forward_refs()
HealthStatus.update_forward_refs()
Immunization.update_forward_refs()
Indication.update_forward_refs()
Instruction.update_forward_refs()
Insurance.update_forward_refs()
Insured.update_forward_refs()
Item.update_forward_refs()
Line.update_forward_refs()
Location.update_forward_refs()
Match.update_forward_refs()
Media.update_forward_refs()
MedicalEquipment.update_forward_refs()
Medication.update_forward_refs()
MedicationAdministration.update_forward_refs()
MedicationsAdministered.update_forward_refs()
Medium.update_forward_refs()
Member.update_forward_refs()
Meta.update_forward_refs()
Milestone.update_forward_refs()
MixtureComponent.update_forward_refs()
Normalization.update_forward_refs()
Note.update_forward_refs()
NoteSection.update_forward_refs()
Notification.update_forward_refs()
Observation.update_forward_refs()
Order.update_forward_refs()
OrderedBy.update_forward_refs()
OrderingFacility.update_forward_refs()
OrderingProvider.update_forward_refs()
Organization.update_forward_refs()
PartOf.update_forward_refs()
Patient.update_forward_refs()
Payee.update_forward_refs()
Payer.update_forward_refs()
Payment.update_forward_refs()
PCP.update_forward_refs()
Performer.update_forward_refs()
Pharmacy.update_forward_refs()
PlanOfCare.update_forward_refs()
PotentialMatch.update_forward_refs()
Pregnancy.update_forward_refs()
PreviousLocation.update_forward_refs()
PrimaryResultsInterpreter.update_forward_refs()
PrincipalInvestigator.update_forward_refs()
Problem.update_forward_refs()
Procedure.update_forward_refs()
Procedures.update_forward_refs()
Producer.update_forward_refs()
Product.update_forward_refs()
Protocol.update_forward_refs()
Provider.update_forward_refs()
Qualification.update_forward_refs()
Question.update_forward_refs()
Reaction.update_forward_refs()
ReasonForVisit.update_forward_refs()
Receiver.update_forward_refs()
Referral.update_forward_refs()
ReferringProvider.update_forward_refs()
Relation.update_forward_refs()
ResolvedProblem.update_forward_refs()
Result.update_forward_refs()
ResultCopyProvider.update_forward_refs()
Role.update_forward_refs()
Route.update_forward_refs()
SafetyObservation.update_forward_refs()
Service.update_forward_refs()
Session.update_forward_refs()
Slot.update_forward_refs()
SocialHistory.update_forward_refs()
Specimen.update_forward_refs()
Study.update_forward_refs()
Submission.update_forward_refs()
Submitter.update_forward_refs()
Subscriber.update_forward_refs()
Substance.update_forward_refs()
Supply.update_forward_refs()
SurgeryStaff.update_forward_refs()
TargetSite.update_forward_refs()
Text.update_forward_refs()
TobaccoUse.update_forward_refs()
Transaction.update_forward_refs()
Type.update_forward_refs()
UnsignedMedicationOrder.update_forward_refs()
UnsignedProcedureOrder.update_forward_refs()
Vaccination.update_forward_refs()
Value.update_forward_refs()
Variant.update_forward_refs()
VerifiedBy.update_forward_refs()
Visit.update_forward_refs()
VisitProvider.update_forward_refs()
VitalSign.update_forward_refs()
