# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flask_jeroboam']

package_data = \
{'': ['*']}

install_requires = \
['Flask>=2.1.3,<3.0.0', 'pydantic>=1.9.1,<2.0.0']

setup_kwargs = {
    'name': 'flask-jeroboam',
    'version': '0.0.1a0',
    'description': 'Bringing FastAPI Developer experience to Flask.',
    'long_description': '<p align="center">\n\n# Flask-Jeroboam\n\n[![PyPI](https://img.shields.io/pypi/v/flask-jeroboam.svg)][pypi_]\n[![Python Version](https://img.shields.io/pypi/pyversions/flask-jeroboam)][python version]\n[![License](https://img.shields.io/pypi/l/flask-jeroboam)][license]\n[![Commit](https://img.shields.io/github/last-commit/jcbianic/flask-jeroboam)][commit]\n\n[![Read the documentation at https://flask-jeroboam.readthedocs.io/](https://img.shields.io/readthedocs/flask-jeroboam/latest.svg?label=Read%20the%20Docs)][read the docs]\n[![Maintainability](https://api.codeclimate.com/v1/badges/181b7355cee7b1316893/maintainability)](https://codeclimate.com/github/jcbianic/flask-jeroboam/maintainability)\n[![Test Coverage](https://api.codeclimate.com/v1/badges/181b7355cee7b1316893/test_coverage)](https://codeclimate.com/github/jcbianic/flask-jeroboam/test_coverage)\n[![Tests](https://github.com/jcbianic/flask-jeroboam/workflows/Tests/badge.svg)][tests]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/flask-jeroboam/\n[status]: https://pypi.org/project/flask-jeroboam/\n[python version]: https://pypi.org/project/flask-jeroboam\n[read the docs]: https://flask-jeroboam.readthedocs.io/\n[tests]: https://github.com/jcbianic/flask-jeroboam/actions?workflow=Tests\n[codecov]: https://app.codecov.io/gh/jcbianic/flask-jeroboam\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n[commit]: https://img.shields.io/github/last-commit/jcbianic/flask-jeroboam\n\n</p>\n\n## Project Description\n\nFlask-Jeroboam is a thin layer on top of Flask to make request parsing, response serialization and auto-documentation as smooth and easy as in FastAPI.\n\n## Motivation\n\n[FastAPI] has been rapidly gaining ground in Python Web Development since its inception in late 2018 ([1][survey]). Besides impressive performance improvement , it brings a very compelling API for request parsing and response serialisation that speed up API development by catering for Developer Experience.\n\nWhile it is often compared to [Flask], ([1][ref#1], [2][ref#2] and [3][ref#3]), the comparaison feels a bit unfair. FastAPI is, in the words of its creator[@tiangolo] a thin layer on top of [Starlette], a _lightweight ASGI framework/toolkit, ... for building async web services in Python_ and [Pydantic]. To some extend, Flask is more related to Starlette than it is to [FastAPI].\n\nAlthough there are some excellent Flask extensions dealing with request parsing, response serialisation, and auto-documentation, I wanted something closer to [FastAPI]\'s DX. Hence **Flask - Jeroboam**.\n\n[survey]: https://lp.jetbrains.com/python-developers-survey-2021/#FrameworksLibraries\n[ref#1]: https://testdriven.io/blog/moving-from-flask-to-fastapi/\n[ref#2]: https://developer.vonage.com/blog/21/08/10/the-ultimate-face-off-flask-vs-fastapi\n[ref#3]: https://towardsdatascience.com/understanding-flask-vs-fastapi-web-framework-fe12bb58ee75\n\n## Who is it inteded for\n\nFor devs who are fond of FastAPI but have perfectly good reasons to stick to Flask, including:\n\n- a large code base build with Flask (although migration could be undertaken)\n- being confortable with Flask and not needing the performance of Starlette\n- depending on Flask eco-system\n\n## Features\n\nFlask-Jeroboam will provide the following features :\n\n- OpenAPI Auto-Documentation based on endpoint type annotations\n- Request parsing with pydantic\n- Response serialization facilitation with pydantic\n\nDependency Injection as featured in FastAPI feels like something you don\'t need in Flask.\n\n## Installation\n\nYou can install _flask-jeroboam_ via [pip], or [poetry] from [PyPI]:\n\n```console\n$ pip install flask-jeroboam\n```\n\nor better yet with poetry:\n\n```console\n$ poetry add flask-jeroboam\n```\n\n## Example Usage\n\nOur goal is to implement an API similar, if not equivalent, to the one you have with FastAPI. Because we think it\'s an excellent standard.\n\nFirst you would need to replace your existing flask.Blueprint with a flask-jeroboam.ApiBlueprint. Note that APIBlueprint are just regular Blueprint with a extra features, but they should not break any endpoint defined the _flask way_.\n\n```python\nfrom flask-jeroboam import APIBlueprint\n\nrouter = APIBlueprint("wines", __name__)\n\n@router.get("/wines", response_model=serializers.WineList)\n@jwt_required()\ndef read_example(wines_in: parsers.WineList):\n    wines = crud.get_wines(wines_in, db.session)\n    return {"items": wines}\n```\n\n## License\n\nDistributed under the terms of the [MIT license][license],\n**Flask-Jeroboam** is free and open source software.\n\n## Issues\n\nIf you encounter any problems,\nplease [file an issue] along with a detailed description.\n\n## Credits\n\nThe main inspiration of this project comes from [@tiangolo]\'s [FastAPI].\n\nThe heavy-lifting if performed by [Flask] and [pydantic].\n\nThe project was generated from [@cjolowicz]\'s [Hypermodern Python Cookiecutter] template.\n\n[@cjolowicz]: https://github.com/cjolowicz\n[@tiangolo]: https://github.com/tiangolo\n[fastapi]: https://fastapi.tiangolo.com/\n[starlette]: https://www.starlette.io/\n[flask]: https://flask.palletsprojects.com/\n[pydantic]: https://pydantic-docs.helpmanual.io/\n[pypi]: https://pypi.org/\n[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n[file an issue]: https://github.com/jcbianic/flask-jeroboam/issues\n[pip]: https://pip.pypa.io/\n\n<!-- github-only -->\n\n[license]: https://github.com/jcbianic/flask-jeroboam/blob/main/LICENSE\n[contributor guide]: https://github.com/jcbianic/flask-jeroboam/blob/main/CONTRIBUTING.md\n[command-line reference]: https://flask-jeroboam.readthedocs.io/en/latest/usage.html\n',
    'author': 'Jean-Christophe Bianic',
    'author_email': 'jc.bianic@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jcbianic/flask-jeroboam',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
