"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterLogicalId = exports.formatFailure = exports.formatAllMatches = exports.matchSection = void 0;
const match_1 = require("../match");
const matcher_1 = require("../matcher");
function matchSection(section, props) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let matching = {};
    let count = 0;
    eachEntryInSection(section, (logicalId, entry) => {
        const result = matcher.test(entry);
        result.finished();
        if (!result.hasFailed()) {
            matching[logicalId] = entry;
        }
        else {
            count++;
            if (closestResult === undefined || closestResult.failCount > result.failCount) {
                closestResult = result;
            }
        }
    });
    if (Object.keys(matching).length > 0) {
        return { match: true, matches: matching };
    }
    else {
        return { match: false, closestResult, analyzedCount: count };
    }
}
exports.matchSection = matchSection;
function eachEntryInSection(section, cb) {
    for (const logicalId of Object.keys(section !== null && section !== void 0 ? section : {})) {
        const resource = section[logicalId];
        cb(logicalId, resource);
    }
}
function formatAllMatches(matches) {
    return [
        leftPad(JSON.stringify(matches, undefined, 2)),
    ].join('\n');
}
exports.formatAllMatches = formatAllMatches;
function formatFailure(closestResult) {
    return [
        'The closest result is:',
        leftPad(JSON.stringify(closestResult.target, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
exports.formatFailure = formatFailure;
function leftPad(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
function filterLogicalId(section, logicalId) {
    // default signal for all logicalIds is '*'
    if (logicalId === '*')
        return section;
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([k, _]) => k === logicalId)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
exports.filterLogicalId = filterLogicalId;
//# sourceMappingURL=data:application/json;base64,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