# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pymlpipe', 'pymlpipe.legacy', 'pymlpipe.samples', 'pymlpipe.utils']

package_data = \
{'': ['*'],
 'pymlpipe': ['.git/*',
              '.git/hooks/*',
              '.git/info/*',
              '.git/logs/*',
              '.git/logs/refs/heads/*',
              '.git/logs/refs/remotes/origin/*',
              '.git/objects/00/*',
              '.git/objects/09/*',
              '.git/objects/0c/*',
              '.git/objects/0e/*',
              '.git/objects/10/*',
              '.git/objects/13/*',
              '.git/objects/21/*',
              '.git/objects/23/*',
              '.git/objects/32/*',
              '.git/objects/33/*',
              '.git/objects/35/*',
              '.git/objects/37/*',
              '.git/objects/39/*',
              '.git/objects/3b/*',
              '.git/objects/41/*',
              '.git/objects/44/*',
              '.git/objects/51/*',
              '.git/objects/53/*',
              '.git/objects/5c/*',
              '.git/objects/5e/*',
              '.git/objects/61/*',
              '.git/objects/63/*',
              '.git/objects/66/*',
              '.git/objects/68/*',
              '.git/objects/69/*',
              '.git/objects/6e/*',
              '.git/objects/79/*',
              '.git/objects/7e/*',
              '.git/objects/90/*',
              '.git/objects/9e/*',
              '.git/objects/a3/*',
              '.git/objects/a7/*',
              '.git/objects/aa/*',
              '.git/objects/ab/*',
              '.git/objects/b2/*',
              '.git/objects/bb/*',
              '.git/objects/cd/*',
              '.git/objects/ce/*',
              '.git/objects/d0/*',
              '.git/objects/d9/*',
              '.git/objects/db/*',
              '.git/objects/dc/*',
              '.git/objects/de/*',
              '.git/objects/e7/*',
              '.git/objects/e9/*',
              '.git/objects/f3/*',
              '.git/objects/f5/*',
              '.git/objects/pack/*',
              '.git/refs/heads/*',
              '.git/refs/remotes/origin/*',
              'static/*',
              'templates/*']}

install_requires = \
['Flask-API>=3.0.post1,<4.0',
 'Flask>=2.1.2,<3.0.0',
 'PyYAML>=6.0,<7.0',
 'catboost>=1.1.1,<2.0.0',
 'cloudpickle>=2.2.1,<3.0.0',
 'lightgbm>=3.3.5,<4.0.0',
 'matplotlib==3.6.3',
 'pandas>=1.4.3,<2.0.0',
 'shap>=0.41.0,<0.42.0',
 'sklearn>=0.0,<0.1',
 'torch>=1.12.0,<2.0.0',
 'tqdm>=4.64.1,<5.0.0',
 'xgboost>=1.7.3,<2.0.0']

entry_points = \
{'console_scripts': ['pymlpipeserver = pymlpipe.queue:start_server',
                     'pymlpipeui = pymlpipe.pymlpipeUI:start_ui']}

setup_kwargs = {
    'name': 'pymlpipe',
    'version': '0.2.9',
    'description': 'PyMLpipe is a Python library for ease Machine Learning Model monitering and Deployment.',
    'long_description': '\n![alt text](https://github.com/neelindresh/pymlpipe/blob/main/static/logo.svg?raw=true)\n\n[![Downloads](https://static.pepy.tech/personalized-badge/pymlpipe?period=total&units=international_system&left_color=black&right_color=green&left_text=Downloads)](https://pepy.tech/project/pymlpipe)\n[![Downloads](https://pepy.tech/badge/pymlpipe/month)](https://pepy.tech/project/pymlpipe)\n![alt text](https://badgen.net/badge/version/0.2.6/red?icon=github)\n![](https://badgen.net/pypi/python/black)\n![](https://badgen.net/badge/pypi/0.2.6/orange?icon=pypi)\n![](https://badgen.net/pypi/license/pip)\n# PyMLpipe\n\nPyMLpipe is a Python library for ease Machine Learning Model monitoring and Deployment.\n\n* Simple\n* Intuative\n* Easy to use\n\nPlease Find the Full [documentation](https://neelindresh.github.io/pymlpipe.documentation.io/) here!\n\n## Installation\n\nUse the package manager [pip](https://pypi.org/project/pymlpipe/) to install PyMLpipe.\n\n```bash\npip install pymlpipe\n```\nor\n```bash\npip3 install pymlpipe\n```\n## Frame Work Supports\n- [X] Scikit-Learn\n- [X] XGBoost\n- [X] LightGBM\n- [X] Pytorch\n- [ ] Tensorflow\n- [ ] Keras\n\n\n\n## Tutorial (Scikit-Learn|XGBoost|LightGBM)\n\n* Load the python package\n\n```python\nfrom pymlpipe.tabular import PyMLPipe\n```\n\n* Initiate the `PyMLPipe` class\n\n```python\nmlp=PyMLPipe()\n```\n\n* Set an Experiment Name `[Optional]`-Default experiment name is `\'0\'`\n\n```python\nmlp.set_experiment("IrisDataV2")\n```\n\n* Set a version `[Optional]`-Default there is no version\n\n```python\nmlp.set_version(0.1)\n```\n\n* Initiate the context manager - This is create a unique ID for each model run. \n    -  when `.run()` is used - Automatic  unique ID is generated \n    - you can also provide `runid` argument in the `.run()` this will the use the given `runid` for next storing.\n\n```python\nwith mlp.run():\n```\nOr\n\n```python\nwith mlp.run(runid=\'mlopstest\'):\n```\n\n*  Set a Tag `[Optional]` by using `set_tag()`-Default there is no tags\n\n```python\n mlp.set_tag(\'tag\')\n```\nOr \n\n*  Set multiple Tags `[Optional]` by using `set_tags()`-Default there is no tags\n```python\nmlp.set_tags(["Classification","test run","logisticRegression"])\n\n```\n\n*  Set Metrics values `[Optional]` by using `log_matric(metric_name,metric_value)`-Default there is no metrics\nThis will help in comparing performance of different models and model versions\n```python\nmlp.log_metric("Accuracy", accuracy_score(testy,predictions))\n\n\nmlp.log_metric("Accuracy", .92)\n\n```\n\n*  Set multiple Metrics values `[Optional]` by using `log_matrics({metric_name:metric_value})`-Default there is no metrics\n```python\nmlp.log_metrics(\n    {\n        "Accuracy": accuracy_score(testy,predictions),\n        "Precision": precision_score(testy,predictions,average=\'macro\'),\n        "Recall", recall_score(testy,predictions,average=\'macro\'),\n    }\n)\n\n\nmlp.log_metrics(\n    {\n        "Accuracy": .92,\n        "Precision": .87,\n        "Recall", .98,\n    }\n)\n\n\n```\n   \n*  Save an artifact `[Optional]` - You can save training/testing/validation/dev/prod data for monitoring and comparison\n    - This will also help in generating `DATA SCHEMA`\n    - `register_artifact()` -takes 3 arguments \n        - name of artifact\n        - Pandas Dataframe\n        - type of artifact - `[training, testing, validation, dev, prod]`\n    - You can also use `register_artifact_with_path()` - This will save the artifact from the disk. \n        - Path for the file\n        - type of artifact - `[training, testing, validation, dev, prod]`\n\n```python\n    mlp.register_artifact("train.csv", trainx)\n\n    mlp.register_artifact("train.csv", trainx)\n```\n* Register Model `[Optional]` - You can register the model. This will help in Quick deployment\n\n```python\n   mlp.scikit_learn.register_model("logistic regression", model)\n```\n\n## Quick Start (Scikit-Learn|XGBoost|LightGBM)\n\n```python\nfrom sklearn.datasets import  load_iris\nimport pandas as pd\nfrom sklearn.model_selection import train_test_split\nfrom sklearn.linear_model import LogisticRegression\nfrom sklearn.metrics import accuracy_score,precision_score,recall_score,f1_score\n#import PyMLPipe from tabular \nfrom pymlpipe.tabular import PyMLPipe\n\n\n# Initiate the class\nmlp=PyMLPipe()\n# Set experiment name\nmlp.set_experiment("IrisDataV2")\n# Set Version name\nmlp.set_version(0.2)\n\niris_data=load_iris()\ndata=iris_data["data"]\ntarget=iris_data["target"]\ndf=pd.DataFrame(data,columns=iris_data["feature_names"])\ntrainx,testx,trainy,testy=train_test_split(df,target)\n\n\n# to start monitering use mlp.run()\nwith mlp.run():\n    # set tags\n    mlp.set_tags(["Classification","test run","logisticRegression"])\n    model=LogisticRegression()\n    model.fit(trainx, trainy)\n    predictions=model.predict(testx)\n    # log performace metrics\n    mlp.log_metric("Accuracy", accuracy_score(testy,predictions))\n    mlp.log_metric("Precision", precision_score(testy,predictions,average=\'macro\'))\n    mlp.log_metric("Recall", recall_score(testy,predictions,average=\'macro\'))\n    mlp.log_metric("F1", f1_score(testy,predictions,average=\'macro\'))\n\n    # Save train data and test data\n    mlp.register_artifact("train", trainx)\n    mlp.register_artifact("test", testx,artifact_type="testing")\n    # Save the model\n    mlp.scikit_learn.register_model("logistic regression", model)\n\n```\n\n## Launch UI\n\nTo start the UI \n\n```bash\npymlpipeui \n```\nor \n```python\nfrom pymlpipe.pymlpipeUI import start_ui\n\n\nstart_ui(host=\'0.0.0.0\', port=8085)\n```\n#### Sample UI\n\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/development/static/Screenshot%202022-07-04%20at%201.42.35%20PM.png?raw=true)\n\n---\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/development/static/Screenshot%202022-07-04%20at%201.42.52%20PM.png?raw=true)\n\n---\n#### One Click Deployment -click the deploy button to deploy the model and get a endpoint\n\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/development/static/Screenshot%202022-07-04%20at%201.43.03%20PM.png?raw=true)\n\n---\n\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/development/static/Screenshot%202022-07-04%20at%201.43.52%20PM.png?raw=true)\n\n---\n\n## Send the data to the Prediction end point in the format\n\n - Each list is a row of data\n```python\n{\n        "data":[\n            [\n                5.6,\n                3.0,\n                4.5,\n                1.5\n            ],\n            [\n                5.6,\n                3.0,\n                4.5,\n                1.5\n            ]\n        ]\n    }\n```\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/development/static/Screenshot%202022-07-04%20at%201.44.05%20PM.png?raw=true)\n\n---\n## Tutorial (Pytorch)\n#### The previous methods can be used as it is. New methods are shown below \n* Log continious Metrics `.log_metrics_continious(dict)--> dict of metrics`\\\n- logs the metrics in a continious manner for each epoch \n\n```pytorch\nmlp.log_metrics_continious({\n    "accuracy": .9,\n    "precision": .8,\n    "recall": .7\n})\n```\n\n* To register a pytorch model use `.pytorch.register_model(modelname, modelobject)`\n    - this will Save the model in a .pt file as a `torch.jit` format for serveing and prediction\n\n```python\n    mlp.pytorch.register_model("pytorch_example1", model)\n\n```\n* To register a pytorch model use `.pytorch.register_model_with_runtime(modelname, modelobject, train_data_sample)`\n\n    - `train_data_sample`- is a sample of input data. it can be random numbers but needs tensor dimension\n    - This method is `preferred` as in `future releases` this models can be then converted to other formats as well ex: "onnx", "hd5"\n\n```python\n    mlp.pytorch.register_model_with_runtime("pytorch_example1", model, train_x)\n\n```\n\n## Quick Start (Pytorch)\n```python\nimport torch\nimport pandas as pd\nfrom sklearn.preprocessing import LabelEncoder\nfrom sklearn.model_selection import train_test_split\nfrom sklearn.metrics import accuracy_score,f1_score\nfrom pymlpipe.tabular import PyMLPipe\ndf=pd.read_csv("train.csv")\nencoders=["area_code","state","international_plan","voice_mail_plan","churn"]\n\nfor i in encoders:\n    le=LabelEncoder()\n    df[i]=le.fit_transform(df[i])\n    \n    \ntrainy=df["churn"]\ntrainx=df[[\'state\', \'account_length\', \'area_code\', \'international_plan\',\n       \'voice_mail_plan\', \'number_vmail_messages\', \'total_day_minutes\',\n       \'total_day_calls\', \'total_day_charge\', \'total_eve_minutes\',\n       \'total_eve_calls\', \'total_eve_charge\', \'total_night_minutes\',\n       \'total_night_calls\', \'total_night_charge\', \'total_intl_minutes\',\n       \'total_intl_calls\', \'total_intl_charge\',\n       \'number_customer_service_calls\']]\n\n\nclass Model(torch.nn.Module):\n    def __init__(self,col_size):\n        super().__init__()\n        # using sequencial\n        self.seq=torch.nn.Sequential(\n            torch.nn.Linear(col_size,15),\n            torch.nn.ReLU(),\n            torch.nn.Linear(15,10),\n            torch.nn.ReLU(),\n            torch.nn.Linear(10,1)\n        )\n        #using torch layers\n        \'\'\'\n        self.linear_layer_1=torch.nn.Linear(col_size,15)\n        self.relu_1=torch.nn.ReLU()\n        self.linear_layer_2=torch.nn.Linear(15,10)\n        self.relu_2=torch.nn.ReLU()\n        self.linear_layer_3=torch.nn.Linear(10,1)\n        \n        \'\'\'\n        \n        \n    def forward(self,x):\n        out=self.seq(x)\n        \'\'\'\n        out=self.relu_1(self.linear_layer_1(x))\n        out=self.relu_12self.linear_layer_3(out))\n        out=self.linear_layer_3(out)\n        \'\'\'\n        \n        return torch.sigmoid(out)\n        \nmodel=Model(len(trainx.columns))\n\ntrain_x,test_x,train_y,test_y=train_test_split(trainx,trainy)\n\ntrain_x=torch.from_numpy(train_x.values)\ntrain_x=train_x.type(torch.FloatTensor)\ntrain_y=torch.from_numpy(train_y.values)\ntrain_y=train_y.type(torch.FloatTensor)\n\ntest_x=torch.from_numpy(test_x.values)\ntest_x=test_x.type(torch.FloatTensor)\ntest_y=torch.from_numpy(test_y.values)\ntest_y=test_y.type(torch.FloatTensor)\n\n\noptimizer=torch.optim.SGD(model.parameters(),lr=0.001)\n\ncriterion=torch.nn.BCELoss()\n\n\ndef validate(model,testx,testy):\n    prediction=model(testx)\n    prediction=torch.where(prediction>.5,1,0)\n    accu=accuracy_score(prediction.detach().numpy(),test_y.unsqueeze(1).detach().numpy())\n    f1=f1_score(prediction.detach().numpy(),test_y.unsqueeze(1).detach().numpy())\n    return {"accuracy":accu,"f1":f1}\n\n\nepochs=100\nbatch_size=1000\n\nmlp=PyMLPipe()\nmlp.set_experiment("Pytorch")\nmlp.set_version(0.2)\n\nwith mlp.run():\n    mlp.register_artifact("churndata.csv",df)\n    mlp.log_params({\n        "lr":0.01,\n        "optimizer":"SGD",\n        "loss_fuction":"BCEloss"\n    })\n    for epoch in range(epochs):\n        loss_batch=0\n        for batch in range(1000,5000,1000):\n            optimizer.zero_grad()\n            train_data=train_x[batch-1000:batch]\n            output=model(train_data)\n            loss=criterion(output,train_y[batch-1000:batch].unsqueeze(1))\n            loss.backward()\n            optimizer.step()\n            loss_batch+=loss.item()\n\n        metrics=validate(model,test_x,test_y)\n        metrics["loss"]=loss_batch\n        metrics["epoch"]=epoch\n        mlp.log_metrics_continious(metrics)\n    mlp.pytorch.register_model("pytorch_example1", model)\n        \n```\n\n## UI for Pytorch Models\n![alt text](https://github.com/neelindresh/pymlpipe/blob/dev/static/Screenshot%202022-07-16%20at%208.03.29%20PM.png?raw=true)\n\n###### Visualize the Model details \n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/dev/static/Screenshot%202022-07-16%20at%208.03.50%20PM.png?raw=true)\n\n###### Visualize the Model Architecture\n\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/dev/static/Screenshot%202022-07-16%20at%208.04.00%20PM.png?raw=true)\n\n###### View Training Logs \n\n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/dev/static/Screenshot%202022-07-16%20at%208.04.08%20PM.png?raw=true)\n\n###### Visualize Training Logs \n\n![alt text](https://github.com/neelindresh/pymlpipe/blob/dev/static/Screenshot%202022-07-16%20at%208.04.21%20PM.png?raw=true)\n\n\n### Sample input for prediction\n`GET REQUEST` - to get info for the model\n    - `info` : Contains model information\n    - `request_body`: Sample post Request \n```python\n{\n    "info": {\n        "experiment_id": "Pytorch",\n        "model_deployment_number": "51c186ddd125386c",\n        "model_mode": "non_runtime",\n        "model_type": "torch",\n        "model_url": "/predict/51c186ddd125386c",\n        "run_id": "3fffe458-9676-4bc7-a6c0-a3b4cf38e277",\n        "status": "running"\n    },\n    "request_body": {\n        "data": [\n            [\n                42.0,\n                120.0,\n                1.0,\n                0.0,\n                0.0,\n                0.0,\n                185.7,\n                133.0,\n                31.57,\n                235.1,\n                149.0,\n                19.98,\n                256.4,\n                78.0,\n                11.54,\n                16.9,\n                6.0,\n                4.56,\n                0.0\n            ]\n        ],\n        "dtype": "float"\n    }\n}\n```\n\nFor `POST REQUEST` \n    -`data`--> list: contains data rows for prediction supports both batch prediction and single instance  ex: data --> [ [ 0,1,2,3],[3,4,56 ] ]  \n    -`dtype`--> str: for type conversion converts the data into required data type tensor\n\n\n```\n {\n        "data": [\n            [\n                42.0,\n                120.0,\n                1.0,\n                0.0,\n                0.0,\n                0.0,\n                185.7,\n                133.0,\n                31.57,\n                235.1,\n                149.0,\n                19.98,\n                256.4,\n                78.0,\n                11.54,\n                16.9,\n                6.0,\n                4.56,\n                0.0\n            ]\n        ],\n        "dtype": "float"\n    }\n```\n\n---\n\n## Contributing\nPull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.\n\nPlease make sure to update tests as appropriate.\n\n## License\n[MIT](https://choosealicense.com/licenses/mit/)',
    'author': 'Indresh Bhattacharya',
    'author_email': 'indresh2neel@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/neelindresh/pymlpipe',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.10',
}


setup(**setup_kwargs)
