import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::EC2::CapacityReservation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 * @external
 */
export interface CfnCapacityReservationProps {
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     * @external
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     * @external
     */
    readonly instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     * @external
     */
    readonly instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     * @external
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     * @external
     */
    readonly endDate?: string;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     * @external
     */
    readonly endDateType?: string;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     * @external
     */
    readonly ephemeralStorage?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     * @external
     */
    readonly instanceMatchCriteria?: string;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     * @external
     */
    readonly tagSpecifications?: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     * @external
     */
    readonly tenancy?: string;
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservation
 */
export declare class CfnCapacityReservation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CapacityReservation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCapacityReservation;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute AvailableInstanceCount
     */
    readonly attrAvailableInstanceCount: number;
    /**
     * @external
     * @cloudformationAttribute InstanceType
     */
    readonly attrInstanceType: string;
    /**
     * @external
     * @cloudformationAttribute Tenancy
     */
    readonly attrTenancy: string;
    /**
     * @external
     * @cloudformationAttribute TotalInstanceCount
     */
    readonly attrTotalInstanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     * @external
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     * @external
     */
    instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     * @external
     */
    instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     * @external
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     * @external
     */
    endDate: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     * @external
     */
    endDateType: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     * @external
     */
    ephemeralStorage: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     * @external
     */
    instanceMatchCriteria: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     * @external
     */
    tagSpecifications: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     * @external
     */
    tenancy: string | undefined;
    /**
     * Create a new `AWS::EC2::CapacityReservation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCapacityReservationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservation
 */
export declare namespace CfnCapacityReservation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html
     * @external
     */
    interface TagSpecificationProperty {
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-resourcetype
         * @external
         */
        readonly resourceType?: string;
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::CarrierGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
 * @external
 */
export interface CfnCarrierGatewayProps {
    /**
     * `AWS::EC2::CarrierGateway.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::CarrierGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
     * @external
     */
    readonly tags?: CfnCarrierGateway.TagsProperty;
}
/**
 * A CloudFormation `AWS::EC2::CarrierGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
 * @external
 * @cloudformationResource AWS::EC2::CarrierGateway
 */
export declare class CfnCarrierGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CarrierGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCarrierGateway;
    /**
     * @external
     * @cloudformationAttribute CarrierGatewayId
     */
    readonly attrCarrierGatewayId: string;
    /**
     * @external
     * @cloudformationAttribute OwnerId
     */
    readonly attrOwnerId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::EC2::CarrierGateway.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::CarrierGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::CarrierGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCarrierGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::CarrierGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
 * @external
 * @cloudformationResource AWS::EC2::CarrierGateway
 */
export declare namespace CfnCarrierGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-carriergateway-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnCarrierGateway.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-carriergateway-tags.html#cfn-ec2-carriergateway-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnAuthorizationRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 * @external
 */
export interface CfnClientVpnAuthorizationRuleProps {
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     * @external
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     * @external
     */
    readonly targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     * @external
     */
    readonly accessGroupId?: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     * @external
     */
    readonly authorizeAllGroups?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnAuthorizationRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnAuthorizationRule
 */
export declare class CfnClientVpnAuthorizationRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnAuthorizationRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnAuthorizationRule;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     * @external
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     * @external
     */
    targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     * @external
     */
    accessGroupId: string | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     * @external
     */
    authorizeAllGroups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnAuthorizationRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnAuthorizationRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 */
export interface CfnClientVpnEndpointProps {
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     * @external
     */
    readonly authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     * @external
     */
    readonly clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     * @external
     */
    readonly connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     * @external
     */
    readonly serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientConnectOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientconnectoptions
     * @external
     */
    readonly clientConnectOptions?: CfnClientVpnEndpoint.ClientConnectOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     * @external
     */
    readonly dnsServers?: string[];
    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::ClientVpnEndpoint.SelfServicePortal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-selfserviceportal
     * @external
     */
    readonly selfServicePortal?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     * @external
     */
    readonly splitTunnel?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     * @external
     */
    readonly tagSpecifications?: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     * @external
     */
    readonly transportProtocol?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     * @external
     */
    readonly vpcId?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     * @external
     */
    readonly vpnPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare class CfnClientVpnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnEndpoint;
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     * @external
     */
    authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     * @external
     */
    clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     * @external
     */
    connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     * @external
     */
    serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientConnectOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientconnectoptions
     * @external
     */
    clientConnectOptions: CfnClientVpnEndpoint.ClientConnectOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     * @external
     */
    dnsServers: string[] | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SelfServicePortal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-selfserviceportal
     * @external
     */
    selfServicePortal: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     * @external
     */
    splitTunnel: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     * @external
     */
    tagSpecifications: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     * @external
     */
    transportProtocol: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     * @external
     */
    vpcId: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     * @external
     */
    vpnPort: number | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
     * @external
     */
    interface CertificateAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
         * @external
         */
        readonly clientRootCertificateChainArn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
     * @external
     */
    interface ClientAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
         * @external
         */
        readonly activeDirectory?: CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.FederatedAuthentication`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-federatedauthentication
         * @external
         */
        readonly federatedAuthentication?: CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
         * @external
         */
        readonly mutualAuthentication?: CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html
     * @external
     */
    interface ClientConnectOptionsProperty {
        /**
         * `CfnClientVpnEndpoint.ClientConnectOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html#cfn-ec2-clientvpnendpoint-clientconnectoptions-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientConnectOptionsProperty.LambdaFunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html#cfn-ec2-clientvpnendpoint-clientconnectoptions-lambdafunctionarn
         * @external
         */
        readonly lambdaFunctionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
     * @external
     */
    interface ConnectionLogOptionsProperty {
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
         * @external
         */
        readonly cloudwatchLogGroup?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
         * @external
         */
        readonly cloudwatchLogStream?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
     * @external
     */
    interface DirectoryServiceAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
         * @external
         */
        readonly directoryId: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html
     * @external
     */
    interface FederatedAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SAMLProviderArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html#cfn-ec2-clientvpnendpoint-federatedauthenticationrequest-samlproviderarn
         * @external
         */
        readonly samlProviderArn: string;
        /**
         * `CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SelfServiceSAMLProviderArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html#cfn-ec2-clientvpnendpoint-federatedauthenticationrequest-selfservicesamlproviderarn
         * @external
         */
        readonly selfServiceSamlProviderArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
     * @external
     */
    interface TagSpecificationProperty {
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
         * @external
         */
        readonly resourceType: string;
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
         * @external
         */
        readonly tags: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 * @external
 */
export interface CfnClientVpnRouteProps {
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     * @external
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     * @external
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     * @external
     */
    readonly targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnRoute
 */
export declare class CfnClientVpnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnRoute;
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     * @external
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     * @external
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     * @external
     */
    targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnTargetNetworkAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 * @external
 */
export interface CfnClientVpnTargetNetworkAssociationProps {
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     * @external
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     * @external
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnTargetNetworkAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnTargetNetworkAssociation
 */
export declare class CfnClientVpnTargetNetworkAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnTargetNetworkAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnTargetNetworkAssociation;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     * @external
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     * @external
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::ClientVpnTargetNetworkAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnTargetNetworkAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::CustomerGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 * @external
 */
export interface CfnCustomerGatewayProps {
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     * @external
     */
    readonly bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     * @external
     */
    readonly ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::CustomerGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 * @external
 * @cloudformationResource AWS::EC2::CustomerGateway
 */
export declare class CfnCustomerGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CustomerGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCustomerGateway;
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     * @external
     */
    bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     * @external
     */
    ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     * @external
     */
    type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::CustomerGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomerGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::DHCPOptions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
 * @external
 */
export interface CfnDHCPOptionsProps {
    /**
     * `AWS::EC2::DHCPOptions.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
     * @external
     */
    readonly domainName?: string;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
     * @external
     */
    readonly domainNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
     * @external
     */
    readonly netbiosNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
     * @external
     */
    readonly netbiosNodeType?: number;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
     * @external
     */
    readonly ntpServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::DHCPOptions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
 * @external
 * @cloudformationResource AWS::EC2::DHCPOptions
 */
export declare class CfnDHCPOptions extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::DHCPOptions";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDHCPOptions;
    /**
     * `AWS::EC2::DHCPOptions.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
     * @external
     */
    domainName: string | undefined;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
     * @external
     */
    domainNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
     * @external
     */
    netbiosNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
     * @external
     */
    netbiosNodeType: number | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
     * @external
     */
    ntpServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::DHCPOptions`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDHCPOptionsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 */
export interface CfnEC2FleetProps {
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     * @external
     */
    readonly launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     * @external
     */
    readonly targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     * @external
     */
    readonly excessCapacityTerminationPolicy?: string;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     * @external
     */
    readonly onDemandOptions?: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     * @external
     */
    readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     * @external
     */
    readonly spotOptions?: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     * @external
     */
    readonly tagSpecifications?: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     * @external
     */
    readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     * @external
     */
    readonly type?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     * @external
     */
    readonly validFrom?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     * @external
     */
    readonly validUntil?: string;
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare class CfnEC2Fleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EC2Fleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEC2Fleet;
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     * @external
     */
    launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     * @external
     */
    targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     * @external
     */
    excessCapacityTerminationPolicy: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     * @external
     */
    onDemandOptions: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     * @external
     */
    replaceUnhealthyInstances: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     * @external
     */
    spotOptions: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     * @external
     */
    tagSpecifications: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     * @external
     */
    terminateInstancesWithExpiration: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     * @external
     */
    type: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     * @external
     */
    validFrom: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     * @external
     */
    validUntil: string | undefined;
    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEC2FleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html
     * @external
     */
    interface CapacityReservationOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html#cfn-ec2-ec2fleet-capacityreservationoptionsrequest-usagestrategy
         * @external
         */
        readonly usageStrategy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
     * @external
     */
    interface FleetLaunchTemplateConfigRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
         * @external
         */
        readonly launchTemplateSpecification?: CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
         * @external
         */
        readonly overrides?: Array<CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
     * @external
     */
    interface FleetLaunchTemplateOverridesRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
         * @external
         */
        readonly maxPrice?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-placement
         * @external
         */
        readonly placement?: CfnEC2Fleet.PlacementProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
         * @external
         */
        readonly priority?: number;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
         * @external
         */
        readonly subnetId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
         * @external
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
     * @external
     */
    interface FleetLaunchTemplateSpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
     * @external
     */
    interface OnDemandOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
         * @external
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-capacityreservationoptions
         * @external
         */
        readonly capacityReservationOptions?: CfnEC2Fleet.CapacityReservationOptionsRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-maxtotalprice
         * @external
         */
        readonly maxTotalPrice?: string;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-mintargetcapacity
         * @external
         */
        readonly minTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleavailabilityzone
         * @external
         */
        readonly singleAvailabilityZone?: boolean | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleinstancetype
         * @external
         */
        readonly singleInstanceType?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html
     * @external
     */
    interface PlacementProperty {
        /**
         * `CfnEC2Fleet.PlacementProperty.Affinity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-affinity
         * @external
         */
        readonly affinity?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.GroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-groupname
         * @external
         */
        readonly groupName?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.HostId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostid
         * @external
         */
        readonly hostId?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.HostResourceGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostresourcegrouparn
         * @external
         */
        readonly hostResourceGroupArn?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.PartitionNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-partitionnumber
         * @external
         */
        readonly partitionNumber?: number;
        /**
         * `CfnEC2Fleet.PlacementProperty.SpreadDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-spreaddomain
         * @external
         */
        readonly spreadDomain?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.Tenancy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-tenancy
         * @external
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
     * @external
     */
    interface SpotOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
         * @external
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
         * @external
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
         * @external
         */
        readonly instancePoolsToUseCount?: number;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maxtotalprice
         * @external
         */
        readonly maxTotalPrice?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-mintargetcapacity
         * @external
         */
        readonly minTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleavailabilityzone
         * @external
         */
        readonly singleAvailabilityZone?: boolean | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleinstancetype
         * @external
         */
        readonly singleInstanceType?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
     * @external
     */
    interface TagSpecificationProperty {
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
         * @external
         */
        readonly resourceType?: string;
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 */
export declare namespace CfnEC2Fleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
     * @external
     */
    interface TargetCapacitySpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
         * @external
         */
        readonly defaultTargetCapacityType?: string;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
         * @external
         */
        readonly onDemandTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
         * @external
         */
        readonly spotTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
         * @external
         */
        readonly totalTargetCapacity: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::EIP`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 * @external
 */
export interface CfnEIPProps {
    /**
     * `AWS::EC2::EIP.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     * @external
     */
    readonly domain?: string;
    /**
     * `AWS::EC2::EIP.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     * @external
     */
    readonly publicIpv4Pool?: string;
    /**
     * `AWS::EC2::EIP.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::EIP`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 * @external
 * @cloudformationResource AWS::EC2::EIP
 */
export declare class CfnEIP extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIP";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEIP;
    /**
     * @external
     * @cloudformationAttribute AllocationId
     */
    readonly attrAllocationId: string;
    /**
     * `AWS::EC2::EIP.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     * @external
     */
    domain: string | undefined;
    /**
     * `AWS::EC2::EIP.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     * @external
     */
    publicIpv4Pool: string | undefined;
    /**
     * `AWS::EC2::EIP.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::EIP`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EIPAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 * @external
 */
export interface CfnEIPAssociationProps {
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     * @external
     */
    readonly allocationId?: string;
    /**
     * `AWS::EC2::EIPAssociation.EIP`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     * @external
     */
    readonly eip?: string;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     * @external
     */
    readonly privateIpAddress?: string;
}
/**
 * A CloudFormation `AWS::EC2::EIPAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 * @external
 * @cloudformationResource AWS::EC2::EIPAssociation
 */
export declare class CfnEIPAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIPAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEIPAssociation;
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     * @external
     */
    allocationId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.EIP`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     * @external
     */
    eip: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     * @external
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     * @external
     */
    privateIpAddress: string | undefined;
    /**
     * Create a new `AWS::EC2::EIPAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EgressOnlyInternetGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 * @external
 */
export interface CfnEgressOnlyInternetGatewayProps {
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     * @external
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::EgressOnlyInternetGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 * @external
 * @cloudformationResource AWS::EC2::EgressOnlyInternetGateway
 */
export declare class CfnEgressOnlyInternetGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EgressOnlyInternetGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEgressOnlyInternetGateway;
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     * @external
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::EgressOnlyInternetGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEgressOnlyInternetGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::FlowLog`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 * @external
 */
export interface CfnFlowLogProps {
    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     * @external
     */
    readonly resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     * @external
     */
    readonly resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     * @external
     */
    readonly trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     * @external
     */
    readonly deliverLogsPermissionArn?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     * @external
     */
    readonly logDestination?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     * @external
     */
    readonly logDestinationType?: string;
    /**
     * `AWS::EC2::FlowLog.LogFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
     * @external
     */
    readonly logFormat?: string;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     * @external
     */
    readonly logGroupName?: string;
    /**
     * `AWS::EC2::FlowLog.MaxAggregationInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
     * @external
     */
    readonly maxAggregationInterval?: number;
    /**
     * `AWS::EC2::FlowLog.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::FlowLog`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 * @external
 * @cloudformationResource AWS::EC2::FlowLog
 */
export declare class CfnFlowLog extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::FlowLog";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowLog;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     * @external
     */
    resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     * @external
     */
    resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     * @external
     */
    trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     * @external
     */
    deliverLogsPermissionArn: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     * @external
     */
    logDestination: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     * @external
     */
    logDestinationType: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
     * @external
     */
    logFormat: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     * @external
     */
    logGroupName: string | undefined;
    /**
     * `AWS::EC2::FlowLog.MaxAggregationInterval`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
     * @external
     */
    maxAggregationInterval: number | undefined;
    /**
     * `AWS::EC2::FlowLog.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::FlowLog`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowLogProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::GatewayRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
 * @external
 */
export interface CfnGatewayRouteTableAssociationProps {
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.GatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
     * @external
     */
    readonly gatewayId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
     * @external
     */
    readonly routeTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::GatewayRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
 * @external
 * @cloudformationResource AWS::EC2::GatewayRouteTableAssociation
 */
export declare class CfnGatewayRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::GatewayRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGatewayRouteTableAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.GatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
     * @external
     */
    gatewayId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
     * @external
     */
    routeTableId: string;
    /**
     * Create a new `AWS::EC2::GatewayRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayRouteTableAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Host`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 * @external
 */
export interface CfnHostProps {
    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     * @external
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     * @external
     */
    readonly autoPlacement?: string;
    /**
     * `AWS::EC2::Host.HostRecovery`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     * @external
     */
    readonly hostRecovery?: string;
}
/**
 * A CloudFormation `AWS::EC2::Host`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 * @external
 * @cloudformationResource AWS::EC2::Host
 */
export declare class CfnHost extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Host";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHost;
    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     * @external
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     * @external
     */
    autoPlacement: string | undefined;
    /**
     * `AWS::EC2::Host.HostRecovery`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     * @external
     */
    hostRecovery: string | undefined;
    /**
     * Create a new `AWS::EC2::Host`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 */
export interface CfnInstanceProps {
    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     * @external
     */
    readonly additionalInfo?: string;
    /**
     * `AWS::EC2::Instance.Affinity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     * @external
     */
    readonly affinity?: string;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     * @external
     */
    readonly blockDeviceMappings?: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CpuOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     * @external
     */
    readonly cpuOptions?: CfnInstance.CpuOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     * @external
     */
    readonly creditSpecification?: CfnInstance.CreditSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     * @external
     */
    readonly disableApiTermination?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     * @external
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     * @external
     */
    readonly elasticGpuSpecifications?: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     * @external
     */
    readonly elasticInferenceAccelerators?: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.EnclaveOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-enclaveoptions
     * @external
     */
    readonly enclaveOptions?: CfnInstance.EnclaveOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.HibernationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
     * @external
     */
    readonly hibernationOptions?: CfnInstance.HibernationOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.HostId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     * @external
     */
    readonly hostId?: string;
    /**
     * `AWS::EC2::Instance.HostResourceGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
     * @external
     */
    readonly hostResourceGroupArn?: string;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     * @external
     */
    readonly iamInstanceProfile?: string;
    /**
     * `AWS::EC2::Instance.ImageId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     * @external
     */
    readonly imageId?: string;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     * @external
     */
    readonly instanceInitiatedShutdownBehavior?: string;
    /**
     * `AWS::EC2::Instance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     * @external
     */
    readonly instanceType?: string;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     * @external
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     * @external
     */
    readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.KernelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     * @external
     */
    readonly kernelId?: string;
    /**
     * `AWS::EC2::Instance.KeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     * @external
     */
    readonly keyName?: string;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     * @external
     */
    readonly launchTemplate?: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     * @external
     */
    readonly licenseSpecifications?: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.Monitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     * @external
     */
    readonly monitoring?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     * @external
     */
    readonly networkInterfaces?: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     * @external
     */
    readonly placementGroupName?: string;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     * @external
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::Instance.RamdiskId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     * @external
     */
    readonly ramdiskId?: string;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     * @external
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     * @external
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     * @external
     */
    readonly ssmAssociations?: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::EC2::Instance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Instance.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     * @external
     */
    readonly tenancy?: string;
    /**
     * `AWS::EC2::Instance.UserData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     * @external
     */
    readonly userData?: string;
    /**
     * `AWS::EC2::Instance.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     * @external
     */
    readonly volumes?: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare class CfnInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Instance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInstance;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute PrivateDnsName
     */
    readonly attrPrivateDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PrivateIp
     */
    readonly attrPrivateIp: string;
    /**
     * @external
     * @cloudformationAttribute PublicDnsName
     */
    readonly attrPublicDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PublicIp
     */
    readonly attrPublicIp: string;
    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     * @external
     */
    additionalInfo: string | undefined;
    /**
     * `AWS::EC2::Instance.Affinity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     * @external
     */
    affinity: string | undefined;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     * @external
     */
    blockDeviceMappings: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CpuOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     * @external
     */
    cpuOptions: CfnInstance.CpuOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     * @external
     */
    creditSpecification: CfnInstance.CreditSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     * @external
     */
    disableApiTermination: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     * @external
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     * @external
     */
    elasticGpuSpecifications: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     * @external
     */
    elasticInferenceAccelerators: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.EnclaveOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-enclaveoptions
     * @external
     */
    enclaveOptions: CfnInstance.EnclaveOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.HibernationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
     * @external
     */
    hibernationOptions: CfnInstance.HibernationOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.HostId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     * @external
     */
    hostId: string | undefined;
    /**
     * `AWS::EC2::Instance.HostResourceGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
     * @external
     */
    hostResourceGroupArn: string | undefined;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     * @external
     */
    iamInstanceProfile: string | undefined;
    /**
     * `AWS::EC2::Instance.ImageId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     * @external
     */
    imageId: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     * @external
     */
    instanceInitiatedShutdownBehavior: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     * @external
     */
    instanceType: string | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     * @external
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     * @external
     */
    ipv6Addresses: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.KernelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     * @external
     */
    kernelId: string | undefined;
    /**
     * `AWS::EC2::Instance.KeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     * @external
     */
    keyName: string | undefined;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     * @external
     */
    launchTemplate: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     * @external
     */
    licenseSpecifications: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.Monitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     * @external
     */
    monitoring: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     * @external
     */
    networkInterfaces: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     * @external
     */
    placementGroupName: string | undefined;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     * @external
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::Instance.RamdiskId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     * @external
     */
    ramdiskId: string | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     * @external
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     * @external
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     * @external
     */
    ssmAssociations: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::EC2::Instance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Instance.Tenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     * @external
     */
    tenancy: string | undefined;
    /**
     * `AWS::EC2::Instance.UserData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     * @external
     */
    userData: string | undefined;
    /**
     * `AWS::EC2::Instance.Volumes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     * @external
     */
    volumes: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::Instance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     * @external
     */
    interface AssociationParameterProperty {
        /**
         * `CfnInstance.AssociationParameterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnInstance.AssociationParameterProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         * @external
         */
        readonly value: string[];
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     * @external
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         * @external
         */
        readonly deviceName: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         * @external
         */
        readonly ebs?: CfnInstance.EbsProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         * @external
         */
        readonly noDevice?: CfnInstance.NoDeviceProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html
     * @external
     */
    interface CpuOptionsProperty {
        /**
         * `CfnInstance.CpuOptionsProperty.CoreCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-corecount
         * @external
         */
        readonly coreCount?: number;
        /**
         * `CfnInstance.CpuOptionsProperty.ThreadsPerCore`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-threadspercore
         * @external
         */
        readonly threadsPerCore?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     * @external
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnInstance.CreditSpecificationProperty.CPUCredits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         * @external
         */
        readonly cpuCredits?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     * @external
     */
    interface EbsProperty {
        /**
         * `CfnInstance.EbsProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnInstance.EbsProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-instance-ebs-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnInstance.EbsProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnInstance.EbsProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnInstance.EbsProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     * @external
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnInstance.ElasticGpuSpecificationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     * @external
     */
    interface ElasticInferenceAcceleratorProperty {
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-count
         * @external
         */
        readonly count?: number;
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-enclaveoptions.html
     * @external
     */
    interface EnclaveOptionsProperty {
        /**
         * `CfnInstance.EnclaveOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-enclaveoptions.html#cfn-ec2-instance-enclaveoptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html
     * @external
     */
    interface HibernationOptionsProperty {
        /**
         * `CfnInstance.HibernationOptionsProperty.Configured`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html#cfn-ec2-instance-hibernationoptions-configured
         * @external
         */
        readonly configured?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     * @external
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         * @external
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     * @external
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     * @external
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         * @external
         */
        readonly licenseConfigurationArn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     * @external
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         * @external
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         * @external
         */
        readonly deviceIndex: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.GroupSet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         * @external
         */
        readonly groupSet?: string[];
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         * @external
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         * @external
         */
        readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         * @external
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         * @external
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         * @external
         */
        readonly privateIpAddresses?: Array<CfnInstance.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         * @external
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         * @external
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     * @external
     */
    interface NoDeviceProperty {
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     * @external
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         * @external
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         * @external
         */
        readonly privateIpAddress: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     * @external
     */
    interface SsmAssociationProperty {
        /**
         * `CfnInstance.SsmAssociationProperty.AssociationParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         * @external
         */
        readonly associationParameters?: Array<CfnInstance.AssociationParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.SsmAssociationProperty.DocumentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         * @external
         */
        readonly documentName: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 * @external
 * @cloudformationResource AWS::EC2::Instance
 */
export declare namespace CfnInstance {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     * @external
     */
    interface VolumeProperty {
        /**
         * `CfnInstance.VolumeProperty.Device`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         * @external
         */
        readonly device: string;
        /**
         * `CfnInstance.VolumeProperty.VolumeId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         * @external
         */
        readonly volumeId: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::InternetGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 * @external
 */
export interface CfnInternetGatewayProps {
    /**
     * `AWS::EC2::InternetGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::InternetGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 * @external
 * @cloudformationResource AWS::EC2::InternetGateway
 */
export declare class CfnInternetGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::InternetGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInternetGateway;
    /**
     * `AWS::EC2::InternetGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::InternetGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInternetGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 */
export interface CfnLaunchTemplateProps {
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     * @external
     */
    readonly launchTemplateData?: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     * @external
     */
    readonly launchTemplateName?: string;
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare class CfnLaunchTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LaunchTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchTemplate;
    /**
     * @external
     * @cloudformationAttribute DefaultVersionNumber
     */
    readonly attrDefaultVersionNumber: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionNumber
     */
    readonly attrLatestVersionNumber: string;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     * @external
     */
    launchTemplateData: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     * @external
     */
    launchTemplateName: string | undefined;
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLaunchTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     * @external
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         * @external
         */
        readonly deviceName?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         * @external
         */
        readonly ebs?: CfnLaunchTemplate.EbsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         * @external
         */
        readonly noDevice?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     * @external
     */
    interface CapacityReservationSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         * @external
         */
        readonly capacityReservationPreference?: string;
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         * @external
         */
        readonly capacityReservationTarget?: CfnLaunchTemplate.CapacityReservationTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     * @external
     */
    interface CapacityReservationTargetProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         * @external
         */
        readonly capacityReservationId?: string;
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationResourceGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationresourcegrouparn
         * @external
         */
        readonly capacityReservationResourceGroupArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     * @external
     */
    interface CpuOptionsProperty {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         * @external
         */
        readonly coreCount?: number;
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         * @external
         */
        readonly threadsPerCore?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     * @external
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         * @external
         */
        readonly cpuCredits?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     * @external
     */
    interface EbsProperty {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     * @external
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html
     * @external
     */
    interface EnclaveOptionsProperty {
        /**
         * `CfnLaunchTemplate.EnclaveOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     * @external
     */
    interface HibernationOptionsProperty {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         * @external
         */
        readonly configured?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     * @external
     */
    interface IamInstanceProfileProperty {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     * @external
     */
    interface InstanceMarketOptionsProperty {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         * @external
         */
        readonly marketType?: string;
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         * @external
         */
        readonly spotOptions?: CfnLaunchTemplate.SpotOptionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     * @external
     */
    interface Ipv6AddProperty {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         * @external
         */
        readonly ipv6Address?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     * @external
     */
    interface LaunchTemplateDataProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         * @external
         */
        readonly blockDeviceMappings?: Array<CfnLaunchTemplate.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         * @external
         */
        readonly capacityReservationSpecification?: CfnLaunchTemplate.CapacityReservationSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         * @external
         */
        readonly cpuOptions?: CfnLaunchTemplate.CpuOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         * @external
         */
        readonly creditSpecification?: CfnLaunchTemplate.CreditSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         * @external
         */
        readonly disableApiTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         * @external
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         * @external
         */
        readonly elasticGpuSpecifications?: Array<CfnLaunchTemplate.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         * @external
         */
        readonly elasticInferenceAccelerators?: Array<CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EnclaveOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions
         * @external
         */
        readonly enclaveOptions?: CfnLaunchTemplate.EnclaveOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         * @external
         */
        readonly hibernationOptions?: CfnLaunchTemplate.HibernationOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         * @external
         */
        readonly iamInstanceProfile?: CfnLaunchTemplate.IamInstanceProfileProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         * @external
         */
        readonly imageId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         * @external
         */
        readonly instanceInitiatedShutdownBehavior?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         * @external
         */
        readonly instanceMarketOptions?: CfnLaunchTemplate.InstanceMarketOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         * @external
         */
        readonly kernelId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         * @external
         */
        readonly keyName?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         * @external
         */
        readonly licenseSpecifications?: Array<CfnLaunchTemplate.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions
         * @external
         */
        readonly metadataOptions?: CfnLaunchTemplate.MetadataOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         * @external
         */
        readonly monitoring?: CfnLaunchTemplate.MonitoringProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         * @external
         */
        readonly networkInterfaces?: Array<CfnLaunchTemplate.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         * @external
         */
        readonly placement?: CfnLaunchTemplate.PlacementProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         * @external
         */
        readonly ramDiskId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         * @external
         */
        readonly securityGroups?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         * @external
         */
        readonly tagSpecifications?: Array<CfnLaunchTemplate.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         * @external
         */
        readonly userData?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     * @external
     */
    interface LaunchTemplateElasticInferenceAcceleratorProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-count
         * @external
         */
        readonly count?: number;
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     * @external
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         * @external
         */
        readonly licenseConfigurationArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
     * @external
     */
    interface MetadataOptionsProperty {
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint
         * @external
         */
        readonly httpEndpoint?: string;
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit
         * @external
         */
        readonly httpPutResponseHopLimit?: number;
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens
         * @external
         */
        readonly httpTokens?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     * @external
     */
    interface MonitoringProperty {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     * @external
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatecarrieripaddress
         * @external
         */
        readonly associateCarrierIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         * @external
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         * @external
         */
        readonly deviceIndex?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         * @external
         */
        readonly groups?: string[];
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         * @external
         */
        readonly interfaceType?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         * @external
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         * @external
         */
        readonly ipv6Addresses?: Array<CfnLaunchTemplate.Ipv6AddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkCardIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkcardindex
         * @external
         */
        readonly networkCardIndex?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         * @external
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         * @external
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         * @external
         */
        readonly privateIpAddresses?: Array<CfnLaunchTemplate.PrivateIpAddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         * @external
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         * @external
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     * @external
     */
    interface PlacementProperty {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         * @external
         */
        readonly affinity?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         * @external
         */
        readonly groupName?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         * @external
         */
        readonly hostId?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostresourcegrouparn
         * @external
         */
        readonly hostResourceGroupArn?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.PartitionNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-partitionnumber
         * @external
         */
        readonly partitionNumber?: number;
        /**
         * `CfnLaunchTemplate.PlacementProperty.SpreadDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-spreaddomain
         * @external
         */
        readonly spreadDomain?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         * @external
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     * @external
     */
    interface PrivateIpAddProperty {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         * @external
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         * @external
         */
        readonly privateIpAddress?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     * @external
     */
    interface SpotOptionsProperty {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
         * @external
         */
        readonly blockDurationMinutes?: number;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         * @external
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         * @external
         */
        readonly maxPrice?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         * @external
         */
        readonly spotInstanceType?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
         * @external
         */
        readonly validUntil?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     * @external
     */
    interface TagSpecificationProperty {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         * @external
         */
        readonly resourceType?: string;
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::LocalGatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
 * @external
 */
export interface CfnLocalGatewayRouteProps {
    /**
     * `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
     * @external
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
     * @external
     */
    readonly localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
     * @external
     */
    readonly localGatewayVirtualInterfaceGroupId: string;
}
/**
 * A CloudFormation `AWS::EC2::LocalGatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
 * @external
 * @cloudformationResource AWS::EC2::LocalGatewayRoute
 */
export declare class CfnLocalGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LocalGatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocalGatewayRoute;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
     * @external
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
     * @external
     */
    localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
     * @external
     */
    localGatewayVirtualInterfaceGroupId: string;
    /**
     * Create a new `AWS::EC2::LocalGatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocalGatewayRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
 * @external
 */
export interface CfnLocalGatewayRouteTableVPCAssociationProps {
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
     * @external
     */
    readonly localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
     * @external
     */
    readonly tags?: CfnLocalGatewayRouteTableVPCAssociation.TagsProperty;
}
/**
 * A CloudFormation `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
 * @external
 * @cloudformationResource AWS::EC2::LocalGatewayRouteTableVPCAssociation
 */
export declare class CfnLocalGatewayRouteTableVPCAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LocalGatewayRouteTableVPCAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocalGatewayRouteTableVPCAssociation;
    /**
     * @external
     * @cloudformationAttribute LocalGatewayId
     */
    readonly attrLocalGatewayId: string;
    /**
     * @external
     * @cloudformationAttribute LocalGatewayRouteTableVpcAssociationId
     */
    readonly attrLocalGatewayRouteTableVpcAssociationId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
     * @external
     */
    localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocalGatewayRouteTableVPCAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
 * @external
 * @cloudformationResource AWS::EC2::LocalGatewayRouteTableVPCAssociation
 */
export declare namespace CfnLocalGatewayRouteTableVPCAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-localgatewayroutetablevpcassociation-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnLocalGatewayRouteTableVPCAssociation.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-localgatewayroutetablevpcassociation-tags.html#cfn-ec2-localgatewayroutetablevpcassociation-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::NatGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 * @external
 */
export interface CfnNatGatewayProps {
    /**
     * `AWS::EC2::NatGateway.AllocationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     * @external
     */
    readonly allocationId: string;
    /**
     * `AWS::EC2::NatGateway.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     * @external
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NatGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NatGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 * @external
 * @cloudformationResource AWS::EC2::NatGateway
 */
export declare class CfnNatGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NatGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNatGateway;
    /**
     * `AWS::EC2::NatGateway.AllocationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     * @external
     */
    allocationId: string;
    /**
     * `AWS::EC2::NatGateway.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     * @external
     */
    subnetId: string;
    /**
     * `AWS::EC2::NatGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NatGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNatGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAcl`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
 * @external
 */
export interface CfnNetworkAclProps {
    /**
     * `AWS::EC2::NetworkAcl.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkAcl`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkAcl
 */
export declare class CfnNetworkAcl extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAcl";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkAcl;
    /**
     * `AWS::EC2::NetworkAcl.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkAcl`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAclEntry`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 * @external
 */
export interface CfnNetworkAclEntryProps {
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
     * @external
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
     * @external
     */
    readonly protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
     * @external
     */
    readonly ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
     * @external
     */
    readonly ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
     * @external
     */
    readonly cidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
     * @external
     */
    readonly egress?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
     * @external
     */
    readonly icmp?: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     * @external
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
     * @external
     */
    readonly portRange?: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 */
export declare class CfnNetworkAclEntry extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAclEntry";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkAclEntry;
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
     * @external
     */
    networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
     * @external
     */
    protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
     * @external
     */
    ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
     * @external
     */
    ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
     * @external
     */
    cidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
     * @external
     */
    egress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
     * @external
     */
    icmp: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     * @external
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
     * @external
     */
    portRange: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkAclEntry`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclEntryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 */
export declare namespace CfnNetworkAclEntry {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
     * @external
     */
    interface IcmpProperty {
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Code`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         * @external
         */
        readonly code?: number;
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         * @external
         */
        readonly type?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 */
export declare namespace CfnNetworkAclEntry {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
     * @external
     */
    interface PortRangeProperty {
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.From`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         * @external
         */
        readonly from?: number;
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.To`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         * @external
         */
        readonly to?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 */
export interface CfnNetworkInsightsAnalysisProps {
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.NetworkInsightsPathId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid
     * @external
     */
    readonly networkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.FilterInArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns
     * @external
     */
    readonly filterInArns?: string[];
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.StatusMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-statusmessage
     * @external
     */
    readonly statusMessage?: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare class CfnNetworkInsightsAnalysis extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInsightsAnalysis";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInsightsAnalysis;
    /**
     * @external
     * @cloudformationAttribute AlternatePathHints
     */
    readonly attrAlternatePathHints: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Explanations
     */
    readonly attrExplanations: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ForwardPathComponents
     */
    readonly attrForwardPathComponents: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsAnalysisArn
     */
    readonly attrNetworkInsightsAnalysisArn: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsAnalysisId
     */
    readonly attrNetworkInsightsAnalysisId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkPathFound
     */
    readonly attrNetworkPathFound: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ReturnPathComponents
     */
    readonly attrReturnPathComponents: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute StartDate
     */
    readonly attrStartDate: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.NetworkInsightsPathId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid
     * @external
     */
    networkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.FilterInArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns
     * @external
     */
    filterInArns: string[] | undefined;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.StatusMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-statusmessage
     * @external
     */
    statusMessage: string | undefined;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInsightsAnalysis`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInsightsAnalysisProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html
     * @external
     */
    interface AlternatePathHintProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AlternatePathHintProperty.ComponentArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentarn
         * @external
         */
        readonly componentArn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AlternatePathHintProperty.ComponentId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentid
         * @external
         */
        readonly componentId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html
     * @external
     */
    interface AnalysisAclRuleProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Cidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-cidr
         * @external
         */
        readonly cidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Egress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-egress
         * @external
         */
        readonly egress?: boolean | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.PortRange`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-portrange
         * @external
         */
        readonly portRange?: CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.RuleAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-ruleaction
         * @external
         */
        readonly ruleAction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.RuleNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-rulenumber
         * @external
         */
        readonly ruleNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html
     * @external
     */
    interface AnalysisComponentProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisComponentProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-arn
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisComponentProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html
     * @external
     */
    interface AnalysisLoadBalancerListenerProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty.InstancePort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-instanceport
         * @external
         */
        readonly instancePort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty.LoadBalancerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-loadbalancerport
         * @external
         */
        readonly loadBalancerPort?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html
     * @external
     */
    interface AnalysisLoadBalancerTargetProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-address
         * @external
         */
        readonly address?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Instance`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-instance
         * @external
         */
        readonly instance?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-port
         * @external
         */
        readonly port?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html
     * @external
     */
    interface AnalysisPacketHeaderProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.DestinationAddresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationaddresses
         * @external
         */
        readonly destinationAddresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.DestinationPortRanges`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationportranges
         * @external
         */
        readonly destinationPortRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.SourceAddresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceaddresses
         * @external
         */
        readonly sourceAddresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.SourcePortRanges`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceportranges
         * @external
         */
        readonly sourcePortRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html
     * @external
     */
    interface AnalysisRouteTableRouteProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.NatGatewayId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-natgatewayid
         * @external
         */
        readonly natGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.NetworkInterfaceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-networkinterfaceid
         * @external
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.Origin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-origin
         * @external
         */
        readonly origin?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.TransitGatewayId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-transitgatewayid
         * @external
         */
        readonly transitGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.VpcPeeringConnectionId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-vpcpeeringconnectionid
         * @external
         */
        readonly vpcPeeringConnectionId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.destinationCidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationcidr
         * @external
         */
        readonly destinationCidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.destinationPrefixListId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationprefixlistid
         * @external
         */
        readonly destinationPrefixListId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.egressOnlyInternetGatewayId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-egressonlyinternetgatewayid
         * @external
         */
        readonly egressOnlyInternetGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.gatewayId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-gatewayid
         * @external
         */
        readonly gatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.instanceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-instanceid
         * @external
         */
        readonly instanceId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html
     * @external
     */
    interface AnalysisSecurityGroupRuleProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Cidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-cidr
         * @external
         */
        readonly cidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Direction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-direction
         * @external
         */
        readonly direction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.PortRange`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-portrange
         * @external
         */
        readonly portRange?: CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.PrefixListId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-prefixlistid
         * @external
         */
        readonly prefixListId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.SecurityGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-securitygroupid
         * @external
         */
        readonly securityGroupId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html
     * @external
     */
    interface ExplanationProperty {
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Acl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-acl
         * @external
         */
        readonly acl?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AclRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-aclrule
         * @external
         */
        readonly aclRule?: CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-address
         * @external
         */
        readonly address?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Addresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-addresses
         * @external
         */
        readonly addresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AttachedTo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-attachedto
         * @external
         */
        readonly attachedTo?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AvailabilityZones`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-availabilityzones
         * @external
         */
        readonly availabilityZones?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Cidrs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-cidrs
         * @external
         */
        readonly cidrs?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ClassicLoadBalancerListener`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-classicloadbalancerlistener
         * @external
         */
        readonly classicLoadBalancerListener?: CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Component`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-component
         * @external
         */
        readonly component?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.CustomerGateway`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-customergateway
         * @external
         */
        readonly customerGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destination
         * @external
         */
        readonly destination?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.DestinationVpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destinationvpc
         * @external
         */
        readonly destinationVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Direction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-direction
         * @external
         */
        readonly direction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ElasticLoadBalancerListener`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-elasticloadbalancerlistener
         * @external
         */
        readonly elasticLoadBalancerListener?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ExplanationCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-explanationcode
         * @external
         */
        readonly explanationCode?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.IngressRouteTable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-ingressroutetable
         * @external
         */
        readonly ingressRouteTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.InternetGateway`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-internetgateway
         * @external
         */
        readonly internetGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerarn
         * @external
         */
        readonly loadBalancerArn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerListenerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerlistenerport
         * @external
         */
        readonly loadBalancerListenerPort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTarget`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertarget
         * @external
         */
        readonly loadBalancerTarget?: CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroup
         * @external
         */
        readonly loadBalancerTargetGroup?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroups
         * @external
         */
        readonly loadBalancerTargetGroups?: Array<CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetport
         * @external
         */
        readonly loadBalancerTargetPort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.MissingComponent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-missingcomponent
         * @external
         */
        readonly missingComponent?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.NatGateway`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-natgateway
         * @external
         */
        readonly natGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.NetworkInterface`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-networkinterface
         * @external
         */
        readonly networkInterface?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PacketField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-packetfield
         * @external
         */
        readonly packetField?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PortRanges`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-portranges
         * @external
         */
        readonly portRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PrefixList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-prefixlist
         * @external
         */
        readonly prefixList?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Protocols`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-protocols
         * @external
         */
        readonly protocols?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.RouteTable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetable
         * @external
         */
        readonly routeTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.RouteTableRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetableroute
         * @external
         */
        readonly routeTableRoute?: CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroup
         * @external
         */
        readonly securityGroup?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroupRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygrouprule
         * @external
         */
        readonly securityGroupRule?: CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroups
         * @external
         */
        readonly securityGroups?: Array<CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SourceVpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-sourcevpc
         * @external
         */
        readonly sourceVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-state
         * @external
         */
        readonly state?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Subnet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnet
         * @external
         */
        readonly subnet?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SubnetRouteTable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnetroutetable
         * @external
         */
        readonly subnetRouteTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Vpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpc
         * @external
         */
        readonly vpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpcPeeringConnection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcpeeringconnection
         * @external
         */
        readonly vpcPeeringConnection?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpnConnection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpnconnection
         * @external
         */
        readonly vpnConnection?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpnGateway`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpngateway
         * @external
         */
        readonly vpnGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.vpcEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcendpoint
         * @external
         */
        readonly vpcEndpoint?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html
     * @external
     */
    interface PathComponentProperty {
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.AclRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-aclrule
         * @external
         */
        readonly aclRule?: CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Component`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-component
         * @external
         */
        readonly component?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.DestinationVpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-destinationvpc
         * @external
         */
        readonly destinationVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.InboundHeader`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-inboundheader
         * @external
         */
        readonly inboundHeader?: CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.OutboundHeader`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-outboundheader
         * @external
         */
        readonly outboundHeader?: CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.RouteTableRoute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-routetableroute
         * @external
         */
        readonly routeTableRoute?: CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SecurityGroupRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-securitygrouprule
         * @external
         */
        readonly securityGroupRule?: CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SequenceNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sequencenumber
         * @external
         */
        readonly sequenceNumber?: number;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SourceVpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sourcevpc
         * @external
         */
        readonly sourceVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Subnet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-subnet
         * @external
         */
        readonly subnet?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Vpc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-vpc
         * @external
         */
        readonly vpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html
     * @external
     */
    interface PortRangeProperty {
        /**
         * `CfnNetworkInsightsAnalysis.PortRangeProperty.From`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-from
         * @external
         */
        readonly from?: number;
        /**
         * `CfnNetworkInsightsAnalysis.PortRangeProperty.To`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-to
         * @external
         */
        readonly to?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInsightsPath`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html
 * @external
 */
export interface CfnNetworkInsightsPathProps {
    /**
     * `AWS::EC2::NetworkInsightsPath.Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination
     * @external
     */
    readonly destination: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol
     * @external
     */
    readonly protocol: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source
     * @external
     */
    readonly source: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip
     * @external
     */
    readonly destinationIp?: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport
     * @external
     */
    readonly destinationPort?: number;
    /**
     * `AWS::EC2::NetworkInsightsPath.SourceIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip
     * @external
     */
    readonly sourceIp?: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsPath`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsPath
 */
export declare class CfnNetworkInsightsPath extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInsightsPath";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInsightsPath;
    /**
     * @external
     * @cloudformationAttribute CreatedDate
     */
    readonly attrCreatedDate: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsPathArn
     */
    readonly attrNetworkInsightsPathArn: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsPathId
     */
    readonly attrNetworkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination
     * @external
     */
    destination: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol
     * @external
     */
    protocol: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source
     * @external
     */
    source: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip
     * @external
     */
    destinationIp: string | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport
     * @external
     */
    destinationPort: number | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.SourceIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip
     * @external
     */
    sourceIp: string | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInsightsPath`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInsightsPathProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 * @external
 */
export interface CfnNetworkInterfaceProps {
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     * @external
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     * @external
     */
    readonly groupSet?: string[];
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     * @external
     */
    readonly interfaceType?: string;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     * @external
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     * @external
     */
    readonly ipv6Addresses?: Array<CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     * @external
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     * @external
     */
    readonly privateIpAddresses?: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     * @external
     */
    readonly secondaryPrivateIpAddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     * @external
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 */
export declare class CfnNetworkInterface extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterface";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterface;
    /**
     * @external
     * @cloudformationAttribute PrimaryPrivateIpAddress
     */
    readonly attrPrimaryPrivateIpAddress: string;
    /**
     * @external
     * @cloudformationAttribute SecondaryPrivateIpAddresses
     */
    readonly attrSecondaryPrivateIpAddresses: string[];
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     * @external
     */
    subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     * @external
     */
    groupSet: string[] | undefined;
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     * @external
     */
    interfaceType: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     * @external
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     * @external
     */
    ipv6Addresses: Array<CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     * @external
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     * @external
     */
    privateIpAddresses: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     * @external
     */
    secondaryPrivateIpAddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     * @external
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInterface`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 */
export declare namespace CfnNetworkInterface {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
     * @external
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         * @external
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 */
export declare namespace CfnNetworkInterface {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     * @external
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         * @external
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         * @external
         */
        readonly privateIpAddress: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfaceAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 * @external
 */
export interface CfnNetworkInterfaceAttachmentProps {
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     * @external
     */
    readonly deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     * @external
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     * @external
     */
    readonly deleteOnTermination?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfaceAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterfaceAttachment
 */
export declare class CfnNetworkInterfaceAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfaceAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterfaceAttachment;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     * @external
     */
    deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     * @external
     */
    instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     * @external
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     * @external
     */
    deleteOnTermination: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkInterfaceAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfacePermission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 * @external
 */
export interface CfnNetworkInterfacePermissionProps {
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     * @external
     */
    readonly awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     * @external
     */
    readonly permission: string;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfacePermission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterfacePermission
 */
export declare class CfnNetworkInterfacePermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfacePermission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterfacePermission;
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     * @external
     */
    awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     * @external
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     * @external
     */
    permission: string;
    /**
     * Create a new `AWS::EC2::NetworkInterfacePermission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfacePermissionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::PlacementGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 * @external
 */
export interface CfnPlacementGroupProps {
    /**
     * `AWS::EC2::PlacementGroup.Strategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     * @external
     */
    readonly strategy?: string;
}
/**
 * A CloudFormation `AWS::EC2::PlacementGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 * @external
 * @cloudformationResource AWS::EC2::PlacementGroup
 */
export declare class CfnPlacementGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::PlacementGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPlacementGroup;
    /**
     * `AWS::EC2::PlacementGroup.Strategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     * @external
     */
    strategy: string | undefined;
    /**
     * Create a new `AWS::EC2::PlacementGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnPlacementGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::PrefixList`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 * @external
 */
export interface CfnPrefixListProps {
    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     * @external
     */
    readonly addressFamily: string;
    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     * @external
     */
    readonly maxEntries: number;
    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     * @external
     */
    readonly prefixListName: string;
    /**
     * `AWS::EC2::PrefixList.Entries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     * @external
     */
    readonly entries?: Array<CfnPrefixList.EntryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::PrefixList.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::PrefixList`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 * @external
 * @cloudformationResource AWS::EC2::PrefixList
 */
export declare class CfnPrefixList extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::PrefixList";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPrefixList;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute OwnerId
     */
    readonly attrOwnerId: string;
    /**
     * @external
     * @cloudformationAttribute PrefixListId
     */
    readonly attrPrefixListId: string;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: number;
    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     * @external
     */
    addressFamily: string;
    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     * @external
     */
    maxEntries: number;
    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     * @external
     */
    prefixListName: string;
    /**
     * `AWS::EC2::PrefixList.Entries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     * @external
     */
    entries: Array<CfnPrefixList.EntryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::PrefixList.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::PrefixList`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPrefixListProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::PrefixList`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 * @external
 * @cloudformationResource AWS::EC2::PrefixList
 */
export declare namespace CfnPrefixList {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html
     * @external
     */
    interface EntryProperty {
        /**
         * `CfnPrefixList.EntryProperty.Cidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-cidr
         * @external
         */
        readonly cidr: string;
        /**
         * `CfnPrefixList.EntryProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-description
         * @external
         */
        readonly description?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 * @external
 */
export interface CfnRouteProps {
    /**
     * `AWS::EC2::Route.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     * @external
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::Route.CarrierGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid
     * @external
     */
    readonly carrierGatewayId?: string;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     * @external
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     * @external
     */
    readonly destinationIpv6CidrBlock?: string;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     * @external
     */
    readonly egressOnlyInternetGatewayId?: string;
    /**
     * `AWS::EC2::Route.GatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     * @external
     */
    readonly gatewayId?: string;
    /**
     * `AWS::EC2::Route.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     * @external
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::Route.LocalGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid
     * @external
     */
    readonly localGatewayId?: string;
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     * @external
     */
    readonly natGatewayId?: string;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     * @external
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::Route.VpcEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid
     * @external
     */
    readonly vpcEndpointId?: string;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     * @external
     */
    readonly vpcPeeringConnectionId?: string;
}
/**
 * A CloudFormation `AWS::EC2::Route`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 * @external
 * @cloudformationResource AWS::EC2::Route
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoute;
    /**
     * `AWS::EC2::Route.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     * @external
     */
    routeTableId: string;
    /**
     * `AWS::EC2::Route.CarrierGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid
     * @external
     */
    carrierGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     * @external
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     * @external
     */
    destinationIpv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     * @external
     */
    egressOnlyInternetGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.GatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     * @external
     */
    gatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     * @external
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::Route.LocalGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid
     * @external
     */
    localGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     * @external
     */
    natGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     * @external
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     * @external
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.VpcEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid
     * @external
     */
    vpcEndpointId: string | undefined;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     * @external
     */
    vpcPeeringConnectionId: string | undefined;
    /**
     * Create a new `AWS::EC2::Route`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::RouteTable`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
 * @external
 */
export interface CfnRouteTableProps {
    /**
     * `AWS::EC2::RouteTable.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::RouteTable`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
 * @external
 * @cloudformationResource AWS::EC2::RouteTable
 */
export declare class CfnRouteTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::RouteTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRouteTable;
    /**
     * `AWS::EC2::RouteTable.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::RouteTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 * @external
 */
export interface CfnSecurityGroupProps {
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     * @external
     */
    readonly groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     * @external
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     * @external
     */
    readonly securityGroupEgress?: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     * @external
     */
    readonly securityGroupIngress?: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     * @external
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 */
export declare class CfnSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroup;
    /**
     * @external
     * @cloudformationAttribute GroupId
     */
    readonly attrGroupId: string;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     * @external
     */
    groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     * @external
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     * @external
     */
    securityGroupEgress: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     * @external
     */
    securityGroupIngress: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     * @external
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 */
export declare namespace CfnSecurityGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     * @external
     */
    interface EgressProperty {
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         * @external
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         * @external
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         * @external
         */
        readonly destinationPrefixListId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         * @external
         */
        readonly destinationSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         * @external
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         * @external
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         * @external
         */
        readonly toPort?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 */
export declare namespace CfnSecurityGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     * @external
     */
    interface IngressProperty {
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         * @external
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         * @external
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         * @external
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         * @external
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         * @external
         */
        readonly sourcePrefixListId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         * @external
         */
        readonly sourceSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         * @external
         */
        readonly sourceSecurityGroupName?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         * @external
         */
        readonly sourceSecurityGroupOwnerId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         * @external
         */
        readonly toPort?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupEgress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 * @external
 */
export interface CfnSecurityGroupEgressProps {
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     * @external
     */
    readonly groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     * @external
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     * @external
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     * @external
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     * @external
     */
    readonly destinationPrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     * @external
     */
    readonly destinationSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     * @external
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     * @external
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupEgress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroupEgress
 */
export declare class CfnSecurityGroupEgress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupEgress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroupEgress;
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     * @external
     */
    groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     * @external
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     * @external
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     * @external
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     * @external
     */
    destinationPrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     * @external
     */
    destinationSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     * @external
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     * @external
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupEgress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupEgressProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 * @external
 */
export interface CfnSecurityGroupIngressProps {
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     * @external
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     * @external
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     * @external
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     * @external
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     * @external
     */
    readonly groupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     * @external
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     * @external
     */
    readonly sourcePrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     * @external
     */
    readonly sourceSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     * @external
     */
    readonly sourceSecurityGroupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     * @external
     */
    readonly sourceSecurityGroupOwnerId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     * @external
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroupIngress
 */
export declare class CfnSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroupIngress;
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     * @external
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     * @external
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     * @external
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     * @external
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     * @external
     */
    groupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     * @external
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     * @external
     */
    sourcePrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     * @external
     */
    sourceSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     * @external
     */
    sourceSecurityGroupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     * @external
     */
    sourceSecurityGroupOwnerId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     * @external
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupIngressProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 */
export interface CfnSpotFleetProps {
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     * @external
     */
    readonly spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare class CfnSpotFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SpotFleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSpotFleet;
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     * @external
     */
    spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::EC2::SpotFleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSpotFleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     * @external
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         * @external
         */
        readonly deviceName: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         * @external
         */
        readonly ebs?: CfnSpotFleet.EbsBlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         * @external
         */
        readonly noDevice?: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     * @external
     */
    interface ClassicLoadBalancerProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     * @external
     */
    interface ClassicLoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         * @external
         */
        readonly classicLoadBalancers: Array<CfnSpotFleet.ClassicLoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     * @external
     */
    interface EbsBlockDeviceProperty {
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     * @external
     */
    interface FleetLaunchTemplateSpecificationProperty {
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         * @external
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     * @external
     */
    interface GroupIdentifierProperty {
        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         * @external
         */
        readonly groupId: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     * @external
     */
    interface IamInstanceProfileSpecificationProperty {
        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         * @external
         */
        readonly arn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     * @external
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         * @external
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     * @external
     */
    interface InstanceNetworkInterfaceSpecificationProperty {
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         * @external
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         * @external
         */
        readonly deviceIndex?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         * @external
         */
        readonly groups?: string[];
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         * @external
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         * @external
         */
        readonly ipv6Addresses?: Array<CfnSpotFleet.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         * @external
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         * @external
         */
        readonly privateIpAddresses?: Array<CfnSpotFleet.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         * @external
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         * @external
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     * @external
     */
    interface LaunchTemplateConfigProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         * @external
         */
        readonly launchTemplateSpecification?: CfnSpotFleet.FleetLaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         * @external
         */
        readonly overrides?: Array<CfnSpotFleet.LaunchTemplateOverridesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     * @external
     */
    interface LaunchTemplateOverridesProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-priority
         * @external
         */
        readonly priority?: number;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         * @external
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         * @external
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         * @external
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     * @external
     */
    interface LoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         * @external
         */
        readonly classicLoadBalancersConfig?: CfnSpotFleet.ClassicLoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         * @external
         */
        readonly targetGroupsConfig?: CfnSpotFleet.TargetGroupsConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     * @external
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         * @external
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         * @external
         */
        readonly privateIpAddress: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotcapacityrebalance.html
     * @external
     */
    interface SpotCapacityRebalanceProperty {
        /**
         * `CfnSpotFleet.SpotCapacityRebalanceProperty.ReplacementStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotcapacityrebalance.html#cfn-ec2-spotfleet-spotcapacityrebalance-replacementstrategy
         * @external
         */
        readonly replacementStrategy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     * @external
     */
    interface SpotFleetLaunchSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         * @external
         */
        readonly blockDeviceMappings?: Array<CfnSpotFleet.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         * @external
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         * @external
         */
        readonly iamInstanceProfile?: CfnSpotFleet.IamInstanceProfileSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         * @external
         */
        readonly imageId: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         * @external
         */
        readonly kernelId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         * @external
         */
        readonly keyName?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         * @external
         */
        readonly monitoring?: CfnSpotFleet.SpotFleetMonitoringProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         * @external
         */
        readonly networkInterfaces?: Array<CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         * @external
         */
        readonly placement?: CfnSpotFleet.SpotPlacementProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         * @external
         */
        readonly ramdiskId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         * @external
         */
        readonly securityGroups?: Array<CfnSpotFleet.GroupIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         * @external
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         * @external
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         * @external
         */
        readonly tagSpecifications?: Array<CfnSpotFleet.SpotFleetTagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         * @external
         */
        readonly userData?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         * @external
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     * @external
     */
    interface SpotFleetMonitoringProperty {
        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     * @external
     */
    interface SpotFleetRequestConfigDataProperty {
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         * @external
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         * @external
         */
        readonly excessCapacityTerminationPolicy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         * @external
         */
        readonly iamFleetRole: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         * @external
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstancePoolsToUseCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instancepoolstousecount
         * @external
         */
        readonly instancePoolsToUseCount?: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         * @external
         */
        readonly launchSpecifications?: Array<CfnSpotFleet.SpotFleetLaunchSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         * @external
         */
        readonly launchTemplateConfigs?: Array<CfnSpotFleet.LaunchTemplateConfigProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         * @external
         */
        readonly loadBalancersConfig?: CfnSpotFleet.LoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandAllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandallocationstrategy
         * @external
         */
        readonly onDemandAllocationStrategy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandMaxTotalPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandmaxtotalprice
         * @external
         */
        readonly onDemandMaxTotalPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandTargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandtargetcapacity
         * @external
         */
        readonly onDemandTargetCapacity?: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         * @external
         */
        readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotMaintenanceStrategies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotmaintenancestrategies
         * @external
         */
        readonly spotMaintenanceStrategies?: CfnSpotFleet.SpotMaintenanceStrategiesProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotMaxTotalPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotmaxtotalprice
         * @external
         */
        readonly spotMaxTotalPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         * @external
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         * @external
         */
        readonly targetCapacity: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         * @external
         */
        readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         * @external
         */
        readonly validFrom?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         * @external
         */
        readonly validUntil?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     * @external
     */
    interface SpotFleetTagSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         * @external
         */
        readonly resourceType?: string;
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotmaintenancestrategies.html
     * @external
     */
    interface SpotMaintenanceStrategiesProperty {
        /**
         * `CfnSpotFleet.SpotMaintenanceStrategiesProperty.CapacityRebalance`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotmaintenancestrategies.html#cfn-ec2-spotfleet-spotmaintenancestrategies-capacityrebalance
         * @external
         */
        readonly capacityRebalance?: CfnSpotFleet.SpotCapacityRebalanceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     * @external
     */
    interface SpotPlacementProperty {
        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         * @external
         */
        readonly groupName?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         * @external
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     * @external
     */
    interface TargetGroupProperty {
        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         * @external
         */
        readonly arn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 */
export declare namespace CfnSpotFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     * @external
     */
    interface TargetGroupsConfigProperty {
        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         * @external
         */
        readonly targetGroups: Array<CfnSpotFleet.TargetGroupProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::EC2::Subnet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 * @external
 */
export interface CfnSubnetProps {
    /**
     * `AWS::EC2::Subnet.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     * @external
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     * @external
     */
    readonly assignIpv6AddressOnCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     * @external
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     * @external
     */
    readonly mapPublicIpOnLaunch?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.OutpostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn
     * @external
     */
    readonly outpostArn?: string;
    /**
     * `AWS::EC2::Subnet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::Subnet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 * @external
 * @cloudformationResource AWS::EC2::Subnet
 */
export declare class CfnSubnet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Subnet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnet;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * @external
     * @cloudformationAttribute NetworkAclAssociationId
     */
    readonly attrNetworkAclAssociationId: string;
    /**
     * @external
     * @cloudformationAttribute OutpostArn
     */
    readonly attrOutpostArn: string;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::Subnet.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     * @external
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     * @external
     */
    assignIpv6AddressOnCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     * @external
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     * @external
     */
    mapPublicIpOnLaunch: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.OutpostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn
     * @external
     */
    outpostArn: string | undefined;
    /**
     * `AWS::EC2::Subnet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::Subnet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetCidrBlock`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 * @external
 */
export interface CfnSubnetCidrBlockProps {
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     * @external
     */
    readonly ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     * @external
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetCidrBlock`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 * @external
 * @cloudformationResource AWS::EC2::SubnetCidrBlock
 */
export declare class CfnSubnetCidrBlock extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetCidrBlock";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetCidrBlock;
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     * @external
     */
    ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     * @external
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetCidrBlock`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetCidrBlockProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetNetworkAclAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 * @external
 */
export interface CfnSubnetNetworkAclAssociationProps {
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     * @external
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     * @external
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetNetworkAclAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 * @external
 * @cloudformationResource AWS::EC2::SubnetNetworkAclAssociation
 */
export declare class CfnSubnetNetworkAclAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetNetworkAclAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetNetworkAclAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     * @external
     */
    networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     * @external
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetNetworkAclAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetNetworkAclAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 * @external
 */
export interface CfnSubnetRouteTableAssociationProps {
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     * @external
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     * @external
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 * @external
 * @cloudformationResource AWS::EC2::SubnetRouteTableAssociation
 */
export declare class CfnSubnetRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetRouteTableAssociation;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     * @external
     */
    routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     * @external
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetRouteTableAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorFilter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
 * @external
 */
export interface CfnTrafficMirrorFilterProps {
    /**
     * `AWS::EC2::TrafficMirrorFilter.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorFilter.NetworkServices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
     * @external
     */
    readonly networkServices?: string[];
    /**
     * `AWS::EC2::TrafficMirrorFilter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilter`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilter
 */
export declare class CfnTrafficMirrorFilter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorFilter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorFilter;
    /**
     * `AWS::EC2::TrafficMirrorFilter.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilter.NetworkServices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
     * @external
     */
    networkServices: string[] | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilter.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TrafficMirrorFilter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTrafficMirrorFilterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 * @external
 */
export interface CfnTrafficMirrorFilterRuleProps {
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
     * @external
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
     * @external
     */
    readonly ruleAction: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
     * @external
     */
    readonly ruleNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
     * @external
     */
    readonly sourceCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
     * @external
     */
    readonly trafficDirection: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
     * @external
     */
    readonly trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
     * @external
     */
    readonly destinationPortRange?: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
     * @external
     */
    readonly protocol?: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
     * @external
     */
    readonly sourcePortRange?: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilterRule
 */
export declare class CfnTrafficMirrorFilterRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorFilterRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorFilterRule;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
     * @external
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
     * @external
     */
    ruleAction: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
     * @external
     */
    ruleNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
     * @external
     */
    sourceCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
     * @external
     */
    trafficDirection: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
     * @external
     */
    trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
     * @external
     */
    destinationPortRange: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
     * @external
     */
    protocol: number | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
     * @external
     */
    sourcePortRange: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::TrafficMirrorFilterRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrafficMirrorFilterRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilterRule
 */
export declare namespace CfnTrafficMirrorFilterRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html
     * @external
     */
    interface TrafficMirrorPortRangeProperty {
        /**
         * `CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-fromport
         * @external
         */
        readonly fromPort: number;
        /**
         * `CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-toport
         * @external
         */
        readonly toPort: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorSession`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
 * @external
 */
export interface CfnTrafficMirrorSessionProps {
    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
     * @external
     */
    readonly sessionNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
     * @external
     */
    readonly trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
     * @external
     */
    readonly trafficMirrorTargetId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
     * @external
     */
    readonly packetLength?: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
     * @external
     */
    readonly virtualNetworkId?: number;
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorSession`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorSession
 */
export declare class CfnTrafficMirrorSession extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorSession";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorSession;
    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
     * @external
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
     * @external
     */
    sessionNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
     * @external
     */
    trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
     * @external
     */
    trafficMirrorTargetId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
     * @external
     */
    packetLength: number | undefined;
    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
     * @external
     */
    virtualNetworkId: number | undefined;
    /**
     * Create a new `AWS::EC2::TrafficMirrorSession`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrafficMirrorSessionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
 * @external
 */
export interface CfnTrafficMirrorTargetProps {
    /**
     * `AWS::EC2::TrafficMirrorTarget.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
     * @external
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
     * @external
     */
    readonly networkLoadBalancerArn?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorTarget
 */
export declare class CfnTrafficMirrorTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorTarget;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
     * @external
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
     * @external
     */
    networkLoadBalancerArn: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TrafficMirrorTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTrafficMirrorTargetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 * @external
 */
export interface CfnTransitGatewayProps {
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     * @external
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     * @external
     */
    readonly autoAcceptSharedAttachments?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     * @external
     */
    readonly defaultRouteTableAssociation?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     * @external
     */
    readonly defaultRouteTablePropagation?: string;
    /**
     * `AWS::EC2::TransitGateway.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     * @external
     */
    readonly dnsSupport?: string;
    /**
     * `AWS::EC2::TransitGateway.MulticastSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
     * @external
     */
    readonly multicastSupport?: string;
    /**
     * `AWS::EC2::TransitGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     * @external
     */
    readonly vpnEcmpSupport?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGateway
 */
export declare class CfnTransitGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGateway;
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     * @external
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     * @external
     */
    autoAcceptSharedAttachments: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     * @external
     */
    defaultRouteTableAssociation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     * @external
     */
    defaultRouteTablePropagation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     * @external
     */
    dnsSupport: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.MulticastSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
     * @external
     */
    multicastSupport: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     * @external
     */
    vpnEcmpSupport: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTransitGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 * @external
 */
export interface CfnTransitGatewayAttachmentProps {
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     * @external
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayAttachment
 */
export declare class CfnTransitGatewayAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayAttachment;
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     * @external
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 * @external
 */
export interface CfnTransitGatewayRouteProps {
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     * @external
     */
    readonly transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     * @external
     */
    readonly blackhole?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     * @external
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     * @external
     */
    readonly transitGatewayAttachmentId?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRoute
 */
export declare class CfnTransitGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRoute;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     * @external
     */
    transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     * @external
     */
    blackhole: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     * @external
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     * @external
     */
    transitGatewayAttachmentId: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTable`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 * @external
 */
export interface CfnTransitGatewayRouteTableProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     * @external
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTable`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTable
 */
export declare class CfnTransitGatewayRouteTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTable;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     * @external
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 * @external
 */
export interface CfnTransitGatewayRouteTableAssociationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     * @external
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     * @external
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTableAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTableAssociation
 */
export declare class CfnTransitGatewayRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTableAssociation;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     * @external
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     * @external
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTablePropagation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 * @external
 */
export interface CfnTransitGatewayRouteTablePropagationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     * @external
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     * @external
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTablePropagation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTablePropagation
 */
export declare class CfnTransitGatewayRouteTablePropagation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTablePropagation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTablePropagation;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     * @external
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     * @external
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTablePropagation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTablePropagationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPC`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 * @external
 */
export interface CfnVPCProps {
    /**
     * `AWS::EC2::VPC.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     * @external
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     * @external
     */
    readonly enableDnsHostnames?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     * @external
     */
    readonly enableDnsSupport?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     * @external
     */
    readonly instanceTenancy?: string;
    /**
     * `AWS::EC2::VPC.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPC`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 * @external
 * @cloudformationResource AWS::EC2::VPC
 */
export declare class CfnVPC extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPC";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPC;
    /**
     * @external
     * @cloudformationAttribute CidrBlock
     */
    readonly attrCidrBlock: string;
    /**
     * @external
     * @cloudformationAttribute CidrBlockAssociations
     */
    readonly attrCidrBlockAssociations: string[];
    /**
     * @external
     * @cloudformationAttribute DefaultNetworkAcl
     */
    readonly attrDefaultNetworkAcl: string;
    /**
     * @external
     * @cloudformationAttribute DefaultSecurityGroup
     */
    readonly attrDefaultSecurityGroup: string;
    /**
     * @external
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * `AWS::EC2::VPC.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     * @external
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     * @external
     */
    enableDnsHostnames: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     * @external
     */
    enableDnsSupport: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     * @external
     */
    instanceTenancy: string | undefined;
    /**
     * `AWS::EC2::VPC.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPC`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCCidrBlock`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 * @external
 */
export interface CfnVPCCidrBlockProps {
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     * @external
     */
    readonly amazonProvidedIpv6CidrBlock?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     * @external
     */
    readonly cidrBlock?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCCidrBlock`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 * @external
 * @cloudformationResource AWS::EC2::VPCCidrBlock
 */
export declare class CfnVPCCidrBlock extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCCidrBlock";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCCidrBlock;
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     * @external
     */
    amazonProvidedIpv6CidrBlock: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     * @external
     */
    cidrBlock: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCCidrBlock`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCCidrBlockProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCDHCPOptionsAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
 * @external
 */
export interface CfnVPCDHCPOptionsAssociationProps {
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     * @external
     */
    readonly dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     * @external
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCDHCPOptionsAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
 * @external
 * @cloudformationResource AWS::EC2::VPCDHCPOptionsAssociation
 */
export declare class CfnVPCDHCPOptionsAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCDHCPOptionsAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCDHCPOptionsAssociation;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     * @external
     */
    dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     * @external
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::VPCDHCPOptionsAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCDHCPOptionsAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 * @external
 */
export interface CfnVPCEndpointProps {
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     * @external
     */
    readonly serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     * @external
     */
    readonly policyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     * @external
     */
    readonly privateDnsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     * @external
     */
    readonly routeTableIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     * @external
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     * @external
     */
    readonly vpcEndpointType?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpoint
 */
export declare class CfnVPCEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpoint;
    /**
     * @external
     * @cloudformationAttribute CreationTimestamp
     */
    readonly attrCreationTimestamp: string;
    /**
     * @external
     * @cloudformationAttribute DnsEntries
     */
    readonly attrDnsEntries: string[];
    /**
     * @external
     * @cloudformationAttribute NetworkInterfaceIds
     */
    readonly attrNetworkInterfaceIds: string[];
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     * @external
     */
    serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     * @external
     */
    policyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     * @external
     */
    privateDnsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     * @external
     */
    routeTableIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     * @external
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     * @external
     */
    vpcEndpointType: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointConnectionNotification`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 * @external
 */
export interface CfnVPCEndpointConnectionNotificationProps {
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     * @external
     */
    readonly connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     * @external
     */
    readonly connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     * @external
     */
    readonly serviceId?: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     * @external
     */
    readonly vpcEndpointId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointConnectionNotification`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointConnectionNotification
 */
export declare class CfnVPCEndpointConnectionNotification extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointConnectionNotification";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointConnectionNotification;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     * @external
     */
    connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     * @external
     */
    connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     * @external
     */
    serviceId: string | undefined;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     * @external
     */
    vpcEndpointId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointConnectionNotification`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointConnectionNotificationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 * @external
 */
export interface CfnVPCEndpointServiceProps {
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     * @external
     */
    readonly acceptanceRequired?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpointService.GatewayLoadBalancerArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-gatewayloadbalancerarns
     * @external
     */
    readonly gatewayLoadBalancerArns?: string[];
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     * @external
     */
    readonly networkLoadBalancerArns?: string[];
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointService`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointService
 */
export declare class CfnVPCEndpointService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointService";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointService;
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     * @external
     */
    acceptanceRequired: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpointService.GatewayLoadBalancerArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-gatewayloadbalancerarns
     * @external
     */
    gatewayLoadBalancerArns: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     * @external
     */
    networkLoadBalancerArns: string[] | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointService`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnVPCEndpointServiceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 * @external
 */
export interface CfnVPCEndpointServicePermissionsProps {
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     * @external
     */
    readonly serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     * @external
     */
    readonly allowedPrincipals?: string[];
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointServicePermissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointServicePermissions
 */
export declare class CfnVPCEndpointServicePermissions extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointServicePermissions";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointServicePermissions;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     * @external
     */
    serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     * @external
     */
    allowedPrincipals: string[] | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointServicePermissions`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointServicePermissionsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCGatewayAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 * @external
 */
export interface CfnVPCGatewayAttachmentProps {
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     * @external
     */
    readonly internetGatewayId?: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     * @external
     */
    readonly vpnGatewayId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCGatewayAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 * @external
 * @cloudformationResource AWS::EC2::VPCGatewayAttachment
 */
export declare class CfnVPCGatewayAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCGatewayAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCGatewayAttachment;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     * @external
     */
    internetGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     * @external
     */
    vpnGatewayId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCGatewayAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCPeeringConnection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 * @external
 */
export interface CfnVPCPeeringConnectionProps {
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     * @external
     */
    readonly peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     * @external
     */
    readonly peerOwnerId?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     * @external
     */
    readonly peerRegion?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     * @external
     */
    readonly peerRoleArn?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPCPeeringConnection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 * @external
 * @cloudformationResource AWS::EC2::VPCPeeringConnection
 */
export declare class CfnVPCPeeringConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCPeeringConnection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCPeeringConnection;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     * @external
     */
    peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     * @external
     */
    peerOwnerId: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     * @external
     */
    peerRegion: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     * @external
     */
    peerRoleArn: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPCPeeringConnection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCPeeringConnectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNConnection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 * @external
 */
export interface CfnVPNConnectionProps {
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     * @external
     */
    readonly customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     * @external
     */
    readonly staticRoutesOnly?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPNConnection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     * @external
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     * @external
     */
    readonly vpnGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     * @external
     */
    readonly vpnTunnelOptionsSpecifications?: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 * @external
 * @cloudformationResource AWS::EC2::VPNConnection
 */
export declare class CfnVPNConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNConnection;
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     * @external
     */
    customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     * @external
     */
    type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     * @external
     */
    staticRoutesOnly: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPNConnection.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     * @external
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     * @external
     */
    vpnGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     * @external
     */
    vpnTunnelOptionsSpecifications: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::VPNConnection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 * @external
 * @cloudformationResource AWS::EC2::VPNConnection
 */
export declare namespace CfnVPNConnection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     * @external
     */
    interface VpnTunnelOptionsSpecificationProperty {
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.PreSharedKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         * @external
         */
        readonly preSharedKey?: string;
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         * @external
         */
        readonly tunnelInsideCidr?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::VPNConnectionRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 * @external
 */
export interface CfnVPNConnectionRouteProps {
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     * @external
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     * @external
     */
    readonly vpnConnectionId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnectionRoute`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 * @external
 * @cloudformationResource AWS::EC2::VPNConnectionRoute
 */
export declare class CfnVPNConnectionRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnectionRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNConnectionRoute;
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     * @external
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     * @external
     */
    vpnConnectionId: string;
    /**
     * Create a new `AWS::EC2::VPNConnectionRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionRouteProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 * @external
 */
export interface CfnVPNGatewayProps {
    /**
     * `AWS::EC2::VPNGateway.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     * @external
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::VPNGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPNGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 * @external
 * @cloudformationResource AWS::EC2::VPNGateway
 */
export declare class CfnVPNGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNGateway;
    /**
     * `AWS::EC2::VPNGateway.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     * @external
     */
    type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     * @external
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::VPNGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPNGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGatewayRoutePropagation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 * @external
 */
export interface CfnVPNGatewayRoutePropagationProps {
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     * @external
     */
    readonly routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     * @external
     */
    readonly vpnGatewayId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNGatewayRoutePropagation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 * @external
 * @cloudformationResource AWS::EC2::VPNGatewayRoutePropagation
 */
export declare class CfnVPNGatewayRoutePropagation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGatewayRoutePropagation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNGatewayRoutePropagation;
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     * @external
     */
    routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     * @external
     */
    vpnGatewayId: string;
    /**
     * Create a new `AWS::EC2::VPNGatewayRoutePropagation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayRoutePropagationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Volume`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 * @external
 */
export interface CfnVolumeProps {
    /**
     * `AWS::EC2::Volume.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     * @external
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     * @external
     */
    readonly autoEnableIo?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Encrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     * @external
     */
    readonly encrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Iops`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     * @external
     */
    readonly iops?: number;
    /**
     * `AWS::EC2::Volume.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::EC2::Volume.MultiAttachEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-multiattachenabled
     * @external
     */
    readonly multiAttachEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.OutpostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-outpostarn
     * @external
     */
    readonly outpostArn?: string;
    /**
     * `AWS::EC2::Volume.Size`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     * @external
     */
    readonly size?: number;
    /**
     * `AWS::EC2::Volume.SnapshotId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     * @external
     */
    readonly snapshotId?: string;
    /**
     * `AWS::EC2::Volume.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Volume.Throughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-throughput
     * @external
     */
    readonly throughput?: number;
    /**
     * `AWS::EC2::Volume.VolumeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     * @external
     */
    readonly volumeType?: string;
}
/**
 * A CloudFormation `AWS::EC2::Volume`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 * @external
 * @cloudformationResource AWS::EC2::Volume
 */
export declare class CfnVolume extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Volume";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVolume;
    /**
     * `AWS::EC2::Volume.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     * @external
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     * @external
     */
    autoEnableIo: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Encrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     * @external
     */
    encrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Iops`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     * @external
     */
    iops: number | undefined;
    /**
     * `AWS::EC2::Volume.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::EC2::Volume.MultiAttachEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-multiattachenabled
     * @external
     */
    multiAttachEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.OutpostArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-outpostarn
     * @external
     */
    outpostArn: string | undefined;
    /**
     * `AWS::EC2::Volume.Size`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     * @external
     */
    size: number | undefined;
    /**
     * `AWS::EC2::Volume.SnapshotId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     * @external
     */
    snapshotId: string | undefined;
    /**
     * `AWS::EC2::Volume.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Volume.Throughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-throughput
     * @external
     */
    throughput: number | undefined;
    /**
     * `AWS::EC2::Volume.VolumeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     * @external
     */
    volumeType: string | undefined;
    /**
     * Create a new `AWS::EC2::Volume`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VolumeAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 * @external
 */
export interface CfnVolumeAttachmentProps {
    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     * @external
     */
    readonly device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     * @external
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     * @external
     */
    readonly volumeId: string;
}
/**
 * A CloudFormation `AWS::EC2::VolumeAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 * @external
 * @cloudformationResource AWS::EC2::VolumeAttachment
 */
export declare class CfnVolumeAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VolumeAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVolumeAttachment;
    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     * @external
     */
    device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     * @external
     */
    instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     * @external
     */
    volumeId: string;
    /**
     * Create a new `AWS::EC2::VolumeAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
