# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.request_type_model import RequestTypeModel
from testit_api_client.models.web_hook_event_type_model import WebHookEventTypeModel
from typing import Optional, Set
from typing_extensions import Self

class WebHookModel(BaseModel):
    """
    WebHookModel
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the webhook")
    event_type: WebHookEventTypeModel = Field(description="Type of event which triggers the webhook", alias="eventType")
    description: Optional[StrictStr] = Field(default=None, description="Description of the webhook")
    url: StrictStr = Field(description="Url to which the webhook sends request")
    request_type: RequestTypeModel = Field(description="Method which the webhook uses", alias="requestType")
    should_send_body: StrictBool = Field(description="Indicates if the webhook sends body", alias="shouldSendBody")
    headers: Optional[Dict[str, StrictStr]] = Field(default=None, description="Collection of headers which the webhook sends")
    query_parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="Collection of query parameters which the webhook sends", alias="queryParameters")
    is_enabled: StrictBool = Field(description="Indicates if the webhook is active", alias="isEnabled")
    should_send_custom_body: StrictBool = Field(description="Indicates if the webhook sends custom body", alias="shouldSendCustomBody")
    custom_body: Optional[StrictStr] = Field(default=None, description="Custom body of the webhook", alias="customBody")
    custom_body_media_type: Optional[StrictStr] = Field(default=None, description="MIME type of body of the webhook", alias="customBodyMediaType")
    should_replace_parameters: StrictBool = Field(description="Indicates if the webhook injects parameters", alias="shouldReplaceParameters")
    should_escape_parameters: StrictBool = Field(description="Indicates if the webhook escapes invalid characters in parameters", alias="shouldEscapeParameters")
    created_date: datetime = Field(description="Creation date of the webhook", alias="createdDate")
    created_by_id: StrictStr = Field(description="Unique ID of user who created the webhook", alias="createdById")
    modified_date: Optional[datetime] = Field(default=None, description="Last modification date of the webhook", alias="modifiedDate")
    modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of user who modified the webhook last time", alias="modifiedById")
    project_id: StrictStr = Field(description="Unique ID of project where the webhook is located", alias="projectId")
    id: StrictStr = Field(description="Unique ID of the entity")
    is_deleted: StrictBool = Field(description="Indicates if the entity is deleted", alias="isDeleted")
    __properties: ClassVar[List[str]] = ["name", "eventType", "description", "url", "requestType", "shouldSendBody", "headers", "queryParameters", "isEnabled", "shouldSendCustomBody", "customBody", "customBodyMediaType", "shouldReplaceParameters", "shouldEscapeParameters", "createdDate", "createdById", "modifiedDate", "modifiedById", "projectId", "id", "isDeleted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebHookModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if headers (nullable) is None
        # and model_fields_set contains the field
        if self.headers is None and "headers" in self.model_fields_set:
            _dict['headers'] = None

        # set to None if query_parameters (nullable) is None
        # and model_fields_set contains the field
        if self.query_parameters is None and "query_parameters" in self.model_fields_set:
            _dict['queryParameters'] = None

        # set to None if custom_body (nullable) is None
        # and model_fields_set contains the field
        if self.custom_body is None and "custom_body" in self.model_fields_set:
            _dict['customBody'] = None

        # set to None if custom_body_media_type (nullable) is None
        # and model_fields_set contains the field
        if self.custom_body_media_type is None and "custom_body_media_type" in self.model_fields_set:
            _dict['customBodyMediaType'] = None

        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebHookModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "eventType": obj.get("eventType"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "requestType": obj.get("requestType"),
            "shouldSendBody": obj.get("shouldSendBody"),
            "headers": obj.get("headers"),
            "queryParameters": obj.get("queryParameters"),
            "isEnabled": obj.get("isEnabled"),
            "shouldSendCustomBody": obj.get("shouldSendCustomBody"),
            "customBody": obj.get("customBody"),
            "customBodyMediaType": obj.get("customBodyMediaType"),
            "shouldReplaceParameters": obj.get("shouldReplaceParameters"),
            "shouldEscapeParameters": obj.get("shouldEscapeParameters"),
            "createdDate": obj.get("createdDate"),
            "createdById": obj.get("createdById"),
            "modifiedDate": obj.get("modifiedDate"),
            "modifiedById": obj.get("modifiedById"),
            "projectId": obj.get("projectId"),
            "id": obj.get("id"),
            "isDeleted": obj.get("isDeleted")
        })
        return _obj


