# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.request_type_model import RequestTypeModel
from testit_api_client.models.web_hook_event_type_model import WebHookEventTypeModel
from typing import Optional, Set
from typing_extensions import Self

class WebHookLogModel(BaseModel):
    """
    WebHookLogModel
    """ # noqa: E501
    web_hook_name: StrictStr = Field(alias="webHookName")
    event_type: WebHookEventTypeModel = Field(alias="eventType")
    web_hook_id: StrictStr = Field(alias="webHookId")
    request_body: Optional[StrictStr] = Field(default=None, alias="requestBody")
    request_meta: Optional[StrictStr] = Field(default=None, alias="requestMeta")
    response_status_code: StrictInt = Field(alias="responseStatusCode")
    response_body: Optional[StrictStr] = Field(default=None, alias="responseBody")
    response_meta: Optional[StrictStr] = Field(default=None, alias="responseMeta")
    project_id: StrictStr = Field(alias="projectId")
    url: StrictStr
    request_type: RequestTypeModel = Field(alias="requestType")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    id: StrictStr = Field(description="Unique ID of the entity")
    is_deleted: StrictBool = Field(description="Indicates if the entity is deleted", alias="isDeleted")
    __properties: ClassVar[List[str]] = ["webHookName", "eventType", "webHookId", "requestBody", "requestMeta", "responseStatusCode", "responseBody", "responseMeta", "projectId", "url", "requestType", "createdDate", "modifiedDate", "createdById", "modifiedById", "id", "isDeleted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebHookLogModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if request_body (nullable) is None
        # and model_fields_set contains the field
        if self.request_body is None and "request_body" in self.model_fields_set:
            _dict['requestBody'] = None

        # set to None if request_meta (nullable) is None
        # and model_fields_set contains the field
        if self.request_meta is None and "request_meta" in self.model_fields_set:
            _dict['requestMeta'] = None

        # set to None if response_body (nullable) is None
        # and model_fields_set contains the field
        if self.response_body is None and "response_body" in self.model_fields_set:
            _dict['responseBody'] = None

        # set to None if response_meta (nullable) is None
        # and model_fields_set contains the field
        if self.response_meta is None and "response_meta" in self.model_fields_set:
            _dict['responseMeta'] = None

        # set to None if created_date (nullable) is None
        # and model_fields_set contains the field
        if self.created_date is None and "created_date" in self.model_fields_set:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebHookLogModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webHookName": obj.get("webHookName"),
            "eventType": obj.get("eventType"),
            "webHookId": obj.get("webHookId"),
            "requestBody": obj.get("requestBody"),
            "requestMeta": obj.get("requestMeta"),
            "responseStatusCode": obj.get("responseStatusCode"),
            "responseBody": obj.get("responseBody"),
            "responseMeta": obj.get("responseMeta"),
            "projectId": obj.get("projectId"),
            "url": obj.get("url"),
            "requestType": obj.get("requestType"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "id": obj.get("id"),
            "isDeleted": obj.get("isDeleted")
        })
        return _obj


