# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.test_suite_type import TestSuiteType
from testit_api_client.models.work_item_select_model import WorkItemSelectModel
from typing import Optional, Set
from typing_extensions import Self

class TestSuiteTestPlanApiModel(BaseModel):
    """
    TestSuiteTestPlanApiModel
    """ # noqa: E501
    name: Annotated[str, Field(min_length=0, strict=True, max_length=255)] = Field(description="Test suite nane")
    configuration_ids: Optional[List[StrictStr]] = Field(default=None, description="Configuration identifiers. Empty configurations means using default configurations", alias="configurationIds")
    type: Optional[TestSuiteType] = Field(default=None, description="Type of the test suite")
    save_structure: Optional[StrictBool] = Field(default=None, description="Indicates if the test suite retains section tree structure", alias="saveStructure")
    work_items_selector: WorkItemSelectModel = Field(description="Model containing options to filter work items", alias="workItemsSelector")
    __properties: ClassVar[List[str]] = ["name", "configurationIds", "type", "saveStructure", "workItemsSelector"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestSuiteTestPlanApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of work_items_selector
        if self.work_items_selector:
            _dict['workItemsSelector'] = self.work_items_selector.to_dict()
        # set to None if configuration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.configuration_ids is None and "configuration_ids" in self.model_fields_set:
            _dict['configurationIds'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if save_structure (nullable) is None
        # and model_fields_set contains the field
        if self.save_structure is None and "save_structure" in self.model_fields_set:
            _dict['saveStructure'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestSuiteTestPlanApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "configurationIds": obj.get("configurationIds"),
            "type": obj.get("type"),
            "saveStructure": obj.get("saveStructure"),
            "workItemsSelector": WorkItemSelectModel.from_dict(obj["workItemsSelector"]) if obj.get("workItemsSelector") is not None else None
        })
        return _obj


