# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.link_post_model import LinkPostModel
from testit_api_client.models.test_run_test_results_select_model import TestRunTestResultsSelectModel
from typing import Optional, Set
from typing_extensions import Self

class TestRunTestResultsPartialBulkSetModel(BaseModel):
    """
    TestRunTestResultsPartialBulkSetModel
    """ # noqa: E501
    selector: Optional[TestRunTestResultsSelectModel] = Field(default=None, description="Object with filters and extraction parameters")
    result_reason_ids: Optional[List[StrictStr]] = Field(default=None, description="Unique IDs of result reasons to be assigned to test results", alias="resultReasonIds")
    links: Optional[List[LinkPostModel]] = Field(default=None, description="Collection of links to be assigned to test results")
    comment: Optional[StrictStr] = Field(default=None, description="Comment to be added to test results")
    attachment_ids: Optional[List[StrictStr]] = Field(default=None, description="Unique IDs of files to be attached to test results", alias="attachmentIds")
    __properties: ClassVar[List[str]] = ["selector", "resultReasonIds", "links", "comment", "attachmentIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestRunTestResultsPartialBulkSetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of selector
        if self.selector:
            _dict['selector'] = self.selector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # set to None if selector (nullable) is None
        # and model_fields_set contains the field
        if self.selector is None and "selector" in self.model_fields_set:
            _dict['selector'] = None

        # set to None if result_reason_ids (nullable) is None
        # and model_fields_set contains the field
        if self.result_reason_ids is None and "result_reason_ids" in self.model_fields_set:
            _dict['resultReasonIds'] = None

        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if attachment_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attachment_ids is None and "attachment_ids" in self.model_fields_set:
            _dict['attachmentIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestRunTestResultsPartialBulkSetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "selector": TestRunTestResultsSelectModel.from_dict(obj["selector"]) if obj.get("selector") is not None else None,
            "resultReasonIds": obj.get("resultReasonIds"),
            "links": [LinkPostModel.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "comment": obj.get("comment"),
            "attachmentIds": obj.get("attachmentIds")
        })
        return _obj


