# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.configuration_short_api_result import ConfigurationShortApiResult
from testit_api_client.models.test_results_statistics_api_result import TestResultsStatisticsApiResult
from testit_api_client.models.test_run_state import TestRunState
from testit_api_client.models.test_status_api_result import TestStatusApiResult
from typing import Optional, Set
from typing_extensions import Self

class TestRunShortApiResult(BaseModel):
    """
    TestRunShortApiResult
    """ # noqa: E501
    id: StrictStr = Field(description="Unique ID of the test run")
    name: StrictStr = Field(description="Name of the test run")
    state: TestRunState = Field(description="Current state of the test run")
    status: TestStatusApiResult = Field(description="Current status of the test run")
    created_date: datetime = Field(description="Date when the test run was created", alias="createdDate")
    started_date: Optional[datetime] = Field(default=None, description="Date when the test run was started", alias="startedDate")
    completed_date: Optional[datetime] = Field(default=None, description="Completion date of the test run", alias="completedDate")
    created_by_id: StrictStr = Field(description="Unique ID of user who created the test run", alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of user who modified the test run last time", alias="modifiedById")
    is_deleted: StrictBool = Field(description="Is the test run is deleted", alias="isDeleted")
    auto_tests_count: StrictInt = Field(description="Number of AutoTests run in the test run", alias="autoTestsCount")
    statistics: TestResultsStatisticsApiResult = Field(description="Statistics of the test run")
    test_results_configurations: List[ConfigurationShortApiResult] = Field(description="Test results configurations", alias="testResultsConfigurations")
    __properties: ClassVar[List[str]] = ["id", "name", "state", "status", "createdDate", "startedDate", "completedDate", "createdById", "modifiedById", "isDeleted", "autoTestsCount", "statistics", "testResultsConfigurations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestRunShortApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in test_results_configurations (list)
        _items = []
        if self.test_results_configurations:
            for _item_test_results_configurations in self.test_results_configurations:
                if _item_test_results_configurations:
                    _items.append(_item_test_results_configurations.to_dict())
            _dict['testResultsConfigurations'] = _items
        # set to None if started_date (nullable) is None
        # and model_fields_set contains the field
        if self.started_date is None and "started_date" in self.model_fields_set:
            _dict['startedDate'] = None

        # set to None if completed_date (nullable) is None
        # and model_fields_set contains the field
        if self.completed_date is None and "completed_date" in self.model_fields_set:
            _dict['completedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestRunShortApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "state": obj.get("state"),
            "status": TestStatusApiResult.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "createdDate": obj.get("createdDate"),
            "startedDate": obj.get("startedDate"),
            "completedDate": obj.get("completedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "isDeleted": obj.get("isDeleted"),
            "autoTestsCount": obj.get("autoTestsCount"),
            "statistics": TestResultsStatisticsApiResult.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "testResultsConfigurations": [ConfigurationShortApiResult.from_dict(_item) for _item in obj["testResultsConfigurations"]] if obj.get("testResultsConfigurations") is not None else None
        })
        return _obj


