# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.attachment_put_model_auto_test_step_results_model import AttachmentPutModelAutoTestStepResultsModel
from testit_api_client.models.attachment_update_request import AttachmentUpdateRequest
from testit_api_client.models.link import Link
from testit_api_client.models.step_result import StepResult
from testit_api_client.models.test_result_outcome import TestResultOutcome
from testit_api_client.models.test_result_step_comment_update_request import TestResultStepCommentUpdateRequest
from typing import Optional, Set
from typing_extensions import Self

class TestResultUpdateV2Request(BaseModel):
    """
    TestResultUpdateV2Request
    """ # noqa: E501
    failure_class_ids: Optional[List[StrictStr]] = Field(default=None, alias="failureClassIds")
    outcome: Optional[TestResultOutcome] = None
    status_code: Optional[StrictStr] = Field(default=None, alias="statusCode")
    comment: Optional[StrictStr] = None
    links: Optional[List[Link]] = None
    step_results: Optional[List[StepResult]] = Field(default=None, alias="stepResults")
    attachments: Optional[List[AttachmentUpdateRequest]] = None
    duration_in_ms: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="durationInMs")
    duration: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    step_comments: Optional[List[TestResultStepCommentUpdateRequest]] = Field(default=None, alias="stepComments")
    setup_results: Optional[List[AttachmentPutModelAutoTestStepResultsModel]] = Field(default=None, alias="setupResults")
    teardown_results: Optional[List[AttachmentPutModelAutoTestStepResultsModel]] = Field(default=None, alias="teardownResults")
    message: Optional[StrictStr] = None
    trace: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["failureClassIds", "outcome", "statusCode", "comment", "links", "stepResults", "attachments", "durationInMs", "duration", "stepComments", "setupResults", "teardownResults", "message", "trace"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultUpdateV2Request from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_results (list)
        _items = []
        if self.step_results:
            for _item_step_results in self.step_results:
                if _item_step_results:
                    _items.append(_item_step_results.to_dict())
            _dict['stepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_comments (list)
        _items = []
        if self.step_comments:
            for _item_step_comments in self.step_comments:
                if _item_step_comments:
                    _items.append(_item_step_comments.to_dict())
            _dict['stepComments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup_results (list)
        _items = []
        if self.setup_results:
            for _item_setup_results in self.setup_results:
                if _item_setup_results:
                    _items.append(_item_setup_results.to_dict())
            _dict['setupResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown_results (list)
        _items = []
        if self.teardown_results:
            for _item_teardown_results in self.teardown_results:
                if _item_teardown_results:
                    _items.append(_item_teardown_results.to_dict())
            _dict['teardownResults'] = _items
        # set to None if failure_class_ids (nullable) is None
        # and model_fields_set contains the field
        if self.failure_class_ids is None and "failure_class_ids" in self.model_fields_set:
            _dict['failureClassIds'] = None

        # set to None if outcome (nullable) is None
        # and model_fields_set contains the field
        if self.outcome is None and "outcome" in self.model_fields_set:
            _dict['outcome'] = None

        # set to None if status_code (nullable) is None
        # and model_fields_set contains the field
        if self.status_code is None and "status_code" in self.model_fields_set:
            _dict['statusCode'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if step_results (nullable) is None
        # and model_fields_set contains the field
        if self.step_results is None and "step_results" in self.model_fields_set:
            _dict['stepResults'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        # set to None if duration_in_ms (nullable) is None
        # and model_fields_set contains the field
        if self.duration_in_ms is None and "duration_in_ms" in self.model_fields_set:
            _dict['durationInMs'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if step_comments (nullable) is None
        # and model_fields_set contains the field
        if self.step_comments is None and "step_comments" in self.model_fields_set:
            _dict['stepComments'] = None

        # set to None if setup_results (nullable) is None
        # and model_fields_set contains the field
        if self.setup_results is None and "setup_results" in self.model_fields_set:
            _dict['setupResults'] = None

        # set to None if teardown_results (nullable) is None
        # and model_fields_set contains the field
        if self.teardown_results is None and "teardown_results" in self.model_fields_set:
            _dict['teardownResults'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if trace (nullable) is None
        # and model_fields_set contains the field
        if self.trace is None and "trace" in self.model_fields_set:
            _dict['trace'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultUpdateV2Request from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "failureClassIds": obj.get("failureClassIds"),
            "outcome": obj.get("outcome"),
            "statusCode": obj.get("statusCode"),
            "comment": obj.get("comment"),
            "links": [Link.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "stepResults": [StepResult.from_dict(_item) for _item in obj["stepResults"]] if obj.get("stepResults") is not None else None,
            "attachments": [AttachmentUpdateRequest.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "durationInMs": obj.get("durationInMs"),
            "duration": obj.get("duration"),
            "stepComments": [TestResultStepCommentUpdateRequest.from_dict(_item) for _item in obj["stepComments"]] if obj.get("stepComments") is not None else None,
            "setupResults": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj["setupResults"]] if obj.get("setupResults") is not None else None,
            "teardownResults": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj["teardownResults"]] if obj.get("teardownResults") is not None else None,
            "message": obj.get("message"),
            "trace": obj.get("trace")
        })
        return _obj


