# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.auto_test_short_model import AutoTestShortModel
from testit_api_client.models.test_point_put_model import TestPointPutModel
from typing import Optional, Set
from typing_extensions import Self

class TestResultShortModel(BaseModel):
    """
    TestResultShortModel
    """ # noqa: E501
    id: StrictStr
    outcome: StrictStr
    traces: Optional[StrictStr] = None
    failure_type: StrictStr = Field(alias="failureType")
    message: Optional[StrictStr] = None
    test_point: Optional[TestPointPutModel] = Field(default=None, alias="testPoint")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    auto_test: Optional[AutoTestShortModel] = Field(default=None, alias="autoTest")
    attachments: Optional[List[AttachmentModel]] = None
    __properties: ClassVar[List[str]] = ["id", "outcome", "traces", "failureType", "message", "testPoint", "createdDate", "autoTest", "attachments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultShortModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of test_point
        if self.test_point:
            _dict['testPoint'] = self.test_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_test
        if self.auto_test:
            _dict['autoTest'] = self.auto_test.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # set to None if traces (nullable) is None
        # and model_fields_set contains the field
        if self.traces is None and "traces" in self.model_fields_set:
            _dict['traces'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if test_point (nullable) is None
        # and model_fields_set contains the field
        if self.test_point is None and "test_point" in self.model_fields_set:
            _dict['testPoint'] = None

        # set to None if created_date (nullable) is None
        # and model_fields_set contains the field
        if self.created_date is None and "created_date" in self.model_fields_set:
            _dict['createdDate'] = None

        # set to None if auto_test (nullable) is None
        # and model_fields_set contains the field
        if self.auto_test is None and "auto_test" in self.model_fields_set:
            _dict['autoTest'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultShortModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "outcome": obj.get("outcome"),
            "traces": obj.get("traces"),
            "failureType": obj.get("failureType"),
            "message": obj.get("message"),
            "testPoint": TestPointPutModel.from_dict(obj["testPoint"]) if obj.get("testPoint") is not None else None,
            "createdDate": obj.get("createdDate"),
            "autoTest": AutoTestShortModel.from_dict(obj["autoTest"]) if obj.get("autoTest") is not None else None,
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None
        })
        return _obj


