# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.iteration_model import IterationModel
from testit_api_client.models.last_test_result_model import LastTestResultModel
from testit_api_client.models.test_status_api_result import TestStatusApiResult
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from typing import Optional, Set
from typing_extensions import Self

class TestPointWithLastResultResponseModel(BaseModel):
    """
    TestPointWithLastResultResponseModel
    """ # noqa: E501
    id: StrictStr
    work_item_name: Optional[StrictStr] = Field(default=None, alias="workItemName")
    is_automated: StrictBool = Field(alias="isAutomated")
    tester_id: Optional[StrictStr] = Field(default=None, alias="testerId")
    work_item_id: StrictStr = Field(alias="workItemId")
    configuration_id: Optional[StrictStr] = Field(default=None, alias="configurationId")
    test_suite_id: StrictStr = Field(alias="testSuiteId")
    last_test_result: Optional[LastTestResultModel] = Field(default=None, alias="lastTestResult")
    status: Optional[StrictStr] = None
    status_model: Optional[TestStatusApiResult] = Field(default=None, alias="statusModel")
    work_item_global_id: Optional[StrictInt] = Field(default=None, alias="workItemGlobalId")
    work_item_entity_type_name: Optional[StrictStr] = Field(default=None, alias="workItemEntityTypeName")
    section_id: StrictStr = Field(alias="sectionId")
    section_name: Optional[StrictStr] = Field(default=None, alias="sectionName")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    attributes: Optional[Dict[str, Any]] = None
    tag_names: Optional[List[StrictStr]] = Field(default=None, alias="tagNames")
    duration: StrictInt
    priority: WorkItemPriorityModel
    test_suite_name_bread_crumbs: Optional[List[StrictStr]] = Field(default=None, alias="testSuiteNameBreadCrumbs")
    group_count: Optional[StrictInt] = Field(default=None, alias="groupCount")
    iteration: Optional[IterationModel] = None
    __properties: ClassVar[List[str]] = ["id", "workItemName", "isAutomated", "testerId", "workItemId", "configurationId", "testSuiteId", "lastTestResult", "status", "statusModel", "workItemGlobalId", "workItemEntityTypeName", "sectionId", "sectionName", "createdDate", "modifiedDate", "createdById", "modifiedById", "attributes", "tagNames", "duration", "priority", "testSuiteNameBreadCrumbs", "groupCount", "iteration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestPointWithLastResultResponseModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_test_result
        if self.last_test_result:
            _dict['lastTestResult'] = self.last_test_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_model
        if self.status_model:
            _dict['statusModel'] = self.status_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of iteration
        if self.iteration:
            _dict['iteration'] = self.iteration.to_dict()
        # set to None if work_item_name (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_name is None and "work_item_name" in self.model_fields_set:
            _dict['workItemName'] = None

        # set to None if tester_id (nullable) is None
        # and model_fields_set contains the field
        if self.tester_id is None and "tester_id" in self.model_fields_set:
            _dict['testerId'] = None

        # set to None if configuration_id (nullable) is None
        # and model_fields_set contains the field
        if self.configuration_id is None and "configuration_id" in self.model_fields_set:
            _dict['configurationId'] = None

        # set to None if last_test_result (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result is None and "last_test_result" in self.model_fields_set:
            _dict['lastTestResult'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if status_model (nullable) is None
        # and model_fields_set contains the field
        if self.status_model is None and "status_model" in self.model_fields_set:
            _dict['statusModel'] = None

        # set to None if work_item_global_id (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_global_id is None and "work_item_global_id" in self.model_fields_set:
            _dict['workItemGlobalId'] = None

        # set to None if work_item_entity_type_name (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_entity_type_name is None and "work_item_entity_type_name" in self.model_fields_set:
            _dict['workItemEntityTypeName'] = None

        # set to None if section_name (nullable) is None
        # and model_fields_set contains the field
        if self.section_name is None and "section_name" in self.model_fields_set:
            _dict['sectionName'] = None

        # set to None if created_date (nullable) is None
        # and model_fields_set contains the field
        if self.created_date is None and "created_date" in self.model_fields_set:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        # set to None if attributes (nullable) is None
        # and model_fields_set contains the field
        if self.attributes is None and "attributes" in self.model_fields_set:
            _dict['attributes'] = None

        # set to None if tag_names (nullable) is None
        # and model_fields_set contains the field
        if self.tag_names is None and "tag_names" in self.model_fields_set:
            _dict['tagNames'] = None

        # set to None if test_suite_name_bread_crumbs (nullable) is None
        # and model_fields_set contains the field
        if self.test_suite_name_bread_crumbs is None and "test_suite_name_bread_crumbs" in self.model_fields_set:
            _dict['testSuiteNameBreadCrumbs'] = None

        # set to None if group_count (nullable) is None
        # and model_fields_set contains the field
        if self.group_count is None and "group_count" in self.model_fields_set:
            _dict['groupCount'] = None

        # set to None if iteration (nullable) is None
        # and model_fields_set contains the field
        if self.iteration is None and "iteration" in self.model_fields_set:
            _dict['iteration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestPointWithLastResultResponseModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "workItemName": obj.get("workItemName"),
            "isAutomated": obj.get("isAutomated"),
            "testerId": obj.get("testerId"),
            "workItemId": obj.get("workItemId"),
            "configurationId": obj.get("configurationId"),
            "testSuiteId": obj.get("testSuiteId"),
            "lastTestResult": LastTestResultModel.from_dict(obj["lastTestResult"]) if obj.get("lastTestResult") is not None else None,
            "status": obj.get("status"),
            "statusModel": TestStatusApiResult.from_dict(obj["statusModel"]) if obj.get("statusModel") is not None else None,
            "workItemGlobalId": obj.get("workItemGlobalId"),
            "workItemEntityTypeName": obj.get("workItemEntityTypeName"),
            "sectionId": obj.get("sectionId"),
            "sectionName": obj.get("sectionName"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "attributes": obj.get("attributes"),
            "tagNames": obj.get("tagNames"),
            "duration": obj.get("duration"),
            "priority": obj.get("priority"),
            "testSuiteNameBreadCrumbs": obj.get("testSuiteNameBreadCrumbs"),
            "groupCount": obj.get("groupCount"),
            "iteration": IterationModel.from_dict(obj["iteration"]) if obj.get("iteration") is not None else None
        })
        return _obj


