# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.last_test_result_model import LastTestResultModel
from testit_api_client.models.test_point_status import TestPointStatus
from testit_api_client.models.test_status_api_result import TestStatusApiResult
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_state import WorkItemState
from typing import Optional, Set
from typing_extensions import Self

class TestPointShortResponseModel(BaseModel):
    """
    TestPointShortResponseModel
    """ # noqa: E501
    id: StrictStr = Field(description="Unique ID of the test point")
    created_date: datetime = Field(description="Creation date of the test point", alias="createdDate")
    created_by_id: StrictStr = Field(description="Unique ID of the test point creator", alias="createdById")
    modified_date: Optional[datetime] = Field(default=None, description="Last modification date of the test point", alias="modifiedDate")
    modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the test point last editor", alias="modifiedById")
    tester_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the test point assigned user", alias="testerId")
    parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="Collection of the test point parameters")
    attributes: Dict[str, Any] = Field(description="Collection of attributes of work item the test point represents")
    tags: List[StrictStr] = Field(description="Collection of the test point tags")
    links: List[StrictStr] = Field(description="Collection of the test point links")
    test_suite_id: StrictStr = Field(description="Unique ID of test suite the test point assigned to", alias="testSuiteId")
    test_suite_name: StrictStr = Field(description="Name of the test suite", alias="testSuiteName")
    work_item_id: StrictStr = Field(description="Unique ID of work item the test point represents", alias="workItemId")
    work_item_global_id: StrictInt = Field(description="Global ID of work item the test point represents", alias="workItemGlobalId")
    work_item_version_id: StrictStr = Field(description="Unique ID of work item version the test point represents", alias="workItemVersionId")
    work_item_version_number: StrictInt = Field(description="Number of work item version the test point represents", alias="workItemVersionNumber")
    work_item_median_duration: Optional[StrictInt] = Field(default=None, description="Median duration of work item the test point represents", alias="workItemMedianDuration")
    status: TestPointStatus = Field(description="Status of the test point")
    status_model: TestStatusApiResult = Field(description="Status of the test point", alias="statusModel")
    priority: WorkItemPriorityModel = Field(description="Priority of the test point")
    is_automated: StrictBool = Field(description="Indicates if the test point represents an autotest", alias="isAutomated")
    name: StrictStr = Field(description="Name of the test point")
    configuration_id: StrictStr = Field(description="Unique ID of the test point configuration", alias="configurationId")
    duration: StrictInt = Field(description="Duration of the test point")
    section_id: StrictStr = Field(description="Unique ID of section where work item the test point represents is located", alias="sectionId")
    section_name: Optional[StrictStr] = Field(default=None, description="Name of section where work item the test point represents is located", alias="sectionName")
    project_id: StrictStr = Field(description="Unique ID of the test point project", alias="projectId")
    last_test_result: Optional[LastTestResultModel] = Field(default=None, description="Model of the test point last test result", alias="lastTestResult")
    iteration_id: StrictStr = Field(description="Unique ID of work item iteration the test point represents", alias="iterationId")
    work_item_state: WorkItemState = Field(description="Work item state", alias="workItemState")
    work_item_created_by_id: StrictStr = Field(description="Unique ID of the work item creator", alias="workItemCreatedById")
    work_item_created_date: datetime = Field(description="Creation date of work item", alias="workItemCreatedDate")
    work_item_modified_by_id: Optional[StrictStr] = Field(default=None, description="Unique ID of the work item last editor", alias="workItemModifiedById")
    work_item_modified_date: Optional[datetime] = Field(default=None, description="Modified date of work item", alias="workItemModifiedDate")
    __properties: ClassVar[List[str]] = ["id", "createdDate", "createdById", "modifiedDate", "modifiedById", "testerId", "parameters", "attributes", "tags", "links", "testSuiteId", "testSuiteName", "workItemId", "workItemGlobalId", "workItemVersionId", "workItemVersionNumber", "workItemMedianDuration", "status", "statusModel", "priority", "isAutomated", "name", "configurationId", "duration", "sectionId", "sectionName", "projectId", "lastTestResult", "iterationId", "workItemState", "workItemCreatedById", "workItemCreatedDate", "workItemModifiedById", "workItemModifiedDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestPointShortResponseModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status_model
        if self.status_model:
            _dict['statusModel'] = self.status_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_test_result
        if self.last_test_result:
            _dict['lastTestResult'] = self.last_test_result.to_dict()
        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        # set to None if tester_id (nullable) is None
        # and model_fields_set contains the field
        if self.tester_id is None and "tester_id" in self.model_fields_set:
            _dict['testerId'] = None

        # set to None if parameters (nullable) is None
        # and model_fields_set contains the field
        if self.parameters is None and "parameters" in self.model_fields_set:
            _dict['parameters'] = None

        # set to None if work_item_median_duration (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_median_duration is None and "work_item_median_duration" in self.model_fields_set:
            _dict['workItemMedianDuration'] = None

        # set to None if section_name (nullable) is None
        # and model_fields_set contains the field
        if self.section_name is None and "section_name" in self.model_fields_set:
            _dict['sectionName'] = None

        # set to None if last_test_result (nullable) is None
        # and model_fields_set contains the field
        if self.last_test_result is None and "last_test_result" in self.model_fields_set:
            _dict['lastTestResult'] = None

        # set to None if work_item_modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_modified_by_id is None and "work_item_modified_by_id" in self.model_fields_set:
            _dict['workItemModifiedById'] = None

        # set to None if work_item_modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_modified_date is None and "work_item_modified_date" in self.model_fields_set:
            _dict['workItemModifiedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestPointShortResponseModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdDate": obj.get("createdDate"),
            "createdById": obj.get("createdById"),
            "modifiedDate": obj.get("modifiedDate"),
            "modifiedById": obj.get("modifiedById"),
            "testerId": obj.get("testerId"),
            "parameters": obj.get("parameters"),
            "attributes": obj.get("attributes"),
            "tags": obj.get("tags"),
            "links": obj.get("links"),
            "testSuiteId": obj.get("testSuiteId"),
            "testSuiteName": obj.get("testSuiteName"),
            "workItemId": obj.get("workItemId"),
            "workItemGlobalId": obj.get("workItemGlobalId"),
            "workItemVersionId": obj.get("workItemVersionId"),
            "workItemVersionNumber": obj.get("workItemVersionNumber"),
            "workItemMedianDuration": obj.get("workItemMedianDuration"),
            "status": obj.get("status"),
            "statusModel": TestStatusApiResult.from_dict(obj["statusModel"]) if obj.get("statusModel") is not None else None,
            "priority": obj.get("priority"),
            "isAutomated": obj.get("isAutomated"),
            "name": obj.get("name"),
            "configurationId": obj.get("configurationId"),
            "duration": obj.get("duration"),
            "sectionId": obj.get("sectionId"),
            "sectionName": obj.get("sectionName"),
            "projectId": obj.get("projectId"),
            "lastTestResult": LastTestResultModel.from_dict(obj["lastTestResult"]) if obj.get("lastTestResult") is not None else None,
            "iterationId": obj.get("iterationId"),
            "workItemState": obj.get("workItemState"),
            "workItemCreatedById": obj.get("workItemCreatedById"),
            "workItemCreatedDate": obj.get("workItemCreatedDate"),
            "workItemModifiedById": obj.get("workItemModifiedById"),
            "workItemModifiedDate": obj.get("workItemModifiedDate")
        })
        return _obj


