# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.test_result_short_model import TestResultShortModel
from typing import Optional, Set
from typing_extensions import Self

class TestPointResultModel(BaseModel):
    """
    TestPointResultModel
    """ # noqa: E501
    test_point_id: Optional[StrictStr] = Field(default=None, alias="testPointId")
    aggregated_outcome: Optional[StrictStr] = Field(default=None, alias="aggregatedOutcome")
    work_item_global_id: Optional[StrictInt] = Field(default=None, alias="workItemGlobalId")
    work_item_name: Optional[StrictStr] = Field(default=None, alias="workItemName")
    configuration_name: Optional[StrictStr] = Field(default=None, alias="configurationName")
    test_results: Optional[List[TestResultShortModel]] = Field(default=None, alias="testResults")
    attachments: Optional[List[AttachmentModel]] = None
    __properties: ClassVar[List[str]] = ["testPointId", "aggregatedOutcome", "workItemGlobalId", "workItemName", "configurationName", "testResults", "attachments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestPointResultModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in test_results (list)
        _items = []
        if self.test_results:
            for _item_test_results in self.test_results:
                if _item_test_results:
                    _items.append(_item_test_results.to_dict())
            _dict['testResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # set to None if test_point_id (nullable) is None
        # and model_fields_set contains the field
        if self.test_point_id is None and "test_point_id" in self.model_fields_set:
            _dict['testPointId'] = None

        # set to None if aggregated_outcome (nullable) is None
        # and model_fields_set contains the field
        if self.aggregated_outcome is None and "aggregated_outcome" in self.model_fields_set:
            _dict['aggregatedOutcome'] = None

        # set to None if work_item_global_id (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_global_id is None and "work_item_global_id" in self.model_fields_set:
            _dict['workItemGlobalId'] = None

        # set to None if work_item_name (nullable) is None
        # and model_fields_set contains the field
        if self.work_item_name is None and "work_item_name" in self.model_fields_set:
            _dict['workItemName'] = None

        # set to None if configuration_name (nullable) is None
        # and model_fields_set contains the field
        if self.configuration_name is None and "configuration_name" in self.model_fields_set:
            _dict['configurationName'] = None

        # set to None if test_results (nullable) is None
        # and model_fields_set contains the field
        if self.test_results is None and "test_results" in self.model_fields_set:
            _dict['testResults'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestPointResultModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "testPointId": obj.get("testPointId"),
            "aggregatedOutcome": obj.get("aggregatedOutcome"),
            "workItemGlobalId": obj.get("workItemGlobalId"),
            "workItemName": obj.get("workItemName"),
            "configurationName": obj.get("configurationName"),
            "testResults": [TestResultShortModel.from_dict(_item) for _item in obj["testResults"]] if obj.get("testResults") is not None else None,
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None
        })
        return _obj


