# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.shared_step_result import SharedStepResult
from testit_api_client.models.step_comment import StepComment
from typing import Optional, Set
from typing_extensions import Self

class StepResult(BaseModel):
    """
    StepResult
    """ # noqa: E501
    step_id: StrictStr = Field(alias="stepId")
    outcome: StrictStr
    shared_step_version_id: Optional[StrictStr] = Field(default=None, alias="sharedStepVersionId")
    shared_step_results: Optional[List[SharedStepResult]] = Field(default=None, alias="sharedStepResults")
    comment: Optional[StepComment] = None
    __properties: ClassVar[List[str]] = ["stepId", "outcome", "sharedStepVersionId", "sharedStepResults", "comment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StepResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shared_step_results (list)
        _items = []
        if self.shared_step_results:
            for _item_shared_step_results in self.shared_step_results:
                if _item_shared_step_results:
                    _items.append(_item_shared_step_results.to_dict())
            _dict['sharedStepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of comment
        if self.comment:
            _dict['comment'] = self.comment.to_dict()
        # set to None if shared_step_version_id (nullable) is None
        # and model_fields_set contains the field
        if self.shared_step_version_id is None and "shared_step_version_id" in self.model_fields_set:
            _dict['sharedStepVersionId'] = None

        # set to None if shared_step_results (nullable) is None
        # and model_fields_set contains the field
        if self.shared_step_results is None and "shared_step_results" in self.model_fields_set:
            _dict['sharedStepResults'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StepResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "stepId": obj.get("stepId"),
            "outcome": obj.get("outcome"),
            "sharedStepVersionId": obj.get("sharedStepVersionId"),
            "sharedStepResults": [SharedStepResult.from_dict(_item) for _item in obj["sharedStepResults"]] if obj.get("sharedStepResults") is not None else None,
            "comment": StepComment.from_dict(obj["comment"]) if obj.get("comment") is not None else None
        })
        return _obj


