# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.step_model import StepModel
from typing import Optional, Set
from typing_extensions import Self

class SectionWithStepsModel(BaseModel):
    """
    SectionWithStepsModel
    """ # noqa: E501
    attachments: Optional[List[AttachmentModel]] = None
    precondition_steps: Optional[List[StepModel]] = Field(default=None, alias="preconditionSteps")
    postcondition_steps: Optional[List[StepModel]] = Field(default=None, alias="postconditionSteps")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    is_deleted: StrictBool = Field(alias="isDeleted")
    id: StrictStr
    created_date: datetime = Field(alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    name: Annotated[str, Field(min_length=1, strict=True)]
    __properties: ClassVar[List[str]] = ["attachments", "preconditionSteps", "postconditionSteps", "projectId", "parentId", "isDeleted", "id", "createdDate", "modifiedDate", "createdById", "modifiedById", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SectionWithStepsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in precondition_steps (list)
        _items = []
        if self.precondition_steps:
            for _item_precondition_steps in self.precondition_steps:
                if _item_precondition_steps:
                    _items.append(_item_precondition_steps.to_dict())
            _dict['preconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in postcondition_steps (list)
        _items = []
        if self.postcondition_steps:
            for _item_postcondition_steps in self.postcondition_steps:
                if _item_postcondition_steps:
                    _items.append(_item_postcondition_steps.to_dict())
            _dict['postconditionSteps'] = _items
        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        # set to None if precondition_steps (nullable) is None
        # and model_fields_set contains the field
        if self.precondition_steps is None and "precondition_steps" in self.model_fields_set:
            _dict['preconditionSteps'] = None

        # set to None if postcondition_steps (nullable) is None
        # and model_fields_set contains the field
        if self.postcondition_steps is None and "postcondition_steps" in self.model_fields_set:
            _dict['postconditionSteps'] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict['projectId'] = None

        # set to None if parent_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_id is None and "parent_id" in self.model_fields_set:
            _dict['parentId'] = None

        # set to None if modified_date (nullable) is None
        # and model_fields_set contains the field
        if self.modified_date is None and "modified_date" in self.model_fields_set:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by_id is None and "modified_by_id" in self.model_fields_set:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SectionWithStepsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "preconditionSteps": [StepModel.from_dict(_item) for _item in obj["preconditionSteps"]] if obj.get("preconditionSteps") is not None else None,
            "postconditionSteps": [StepModel.from_dict(_item) for _item in obj["postconditionSteps"]] if obj.get("postconditionSteps") is not None else None,
            "projectId": obj.get("projectId"),
            "parentId": obj.get("parentId"),
            "isDeleted": obj.get("isDeleted"),
            "id": obj.get("id"),
            "createdDate": obj.get("createdDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "createdById": obj.get("createdById"),
            "modifiedById": obj.get("modifiedById"),
            "name": obj.get("name")
        })
        return _obj


