# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from testit_api_client.models.auto_test_model import AutoTestModel
from testit_api_client.models.configuration_model import ConfigurationModel
from testit_api_client.models.public_test_point_model import PublicTestPointModel
from typing import Optional, Set
from typing_extensions import Self

class PublicTestRunModel(BaseModel):
    """
    PublicTestRunModel
    """ # noqa: E501
    test_run_id: StrictStr = Field(alias="testRunId")
    test_plan_id: Optional[StrictStr] = Field(default=None, alias="testPlanId")
    test_plan_global_id: StrictInt = Field(alias="testPlanGlobalId")
    name: StrictStr
    product_name: Optional[StrictStr] = Field(default=None, alias="productName")
    build: Optional[StrictStr] = None
    configurations: List[ConfigurationModel]
    auto_tests: List[AutoTestModel] = Field(alias="autoTests")
    test_points: List[PublicTestPointModel] = Field(alias="testPoints")
    status: StrictStr
    custom_parameters: Optional[Dict[str, StrictStr]] = Field(default=None, alias="customParameters")
    test_run_description: Optional[StrictStr] = Field(default=None, alias="testRunDescription")
    __properties: ClassVar[List[str]] = ["testRunId", "testPlanId", "testPlanGlobalId", "name", "productName", "build", "configurations", "autoTests", "testPoints", "status", "customParameters", "testRunDescription"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicTestRunModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in configurations (list)
        _items = []
        if self.configurations:
            for _item_configurations in self.configurations:
                if _item_configurations:
                    _items.append(_item_configurations.to_dict())
            _dict['configurations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in auto_tests (list)
        _items = []
        if self.auto_tests:
            for _item_auto_tests in self.auto_tests:
                if _item_auto_tests:
                    _items.append(_item_auto_tests.to_dict())
            _dict['autoTests'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in test_points (list)
        _items = []
        if self.test_points:
            for _item_test_points in self.test_points:
                if _item_test_points:
                    _items.append(_item_test_points.to_dict())
            _dict['testPoints'] = _items
        # set to None if test_plan_id (nullable) is None
        # and model_fields_set contains the field
        if self.test_plan_id is None and "test_plan_id" in self.model_fields_set:
            _dict['testPlanId'] = None

        # set to None if product_name (nullable) is None
        # and model_fields_set contains the field
        if self.product_name is None and "product_name" in self.model_fields_set:
            _dict['productName'] = None

        # set to None if build (nullable) is None
        # and model_fields_set contains the field
        if self.build is None and "build" in self.model_fields_set:
            _dict['build'] = None

        # set to None if custom_parameters (nullable) is None
        # and model_fields_set contains the field
        if self.custom_parameters is None and "custom_parameters" in self.model_fields_set:
            _dict['customParameters'] = None

        # set to None if test_run_description (nullable) is None
        # and model_fields_set contains the field
        if self.test_run_description is None and "test_run_description" in self.model_fields_set:
            _dict['testRunDescription'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicTestRunModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "testRunId": obj.get("testRunId"),
            "testPlanId": obj.get("testPlanId"),
            "testPlanGlobalId": obj.get("testPlanGlobalId"),
            "name": obj.get("name"),
            "productName": obj.get("productName"),
            "build": obj.get("build"),
            "configurations": [ConfigurationModel.from_dict(_item) for _item in obj["configurations"]] if obj.get("configurations") is not None else None,
            "autoTests": [AutoTestModel.from_dict(_item) for _item in obj["autoTests"]] if obj.get("autoTests") is not None else None,
            "testPoints": [PublicTestPointModel.from_dict(_item) for _item in obj["testPoints"]] if obj.get("testPoints") is not None else None,
            "status": obj.get("status"),
            "customParameters": obj.get("customParameters"),
            "testRunDescription": obj.get("testRunDescription")
        })
        return _obj


